/*
 * Decompiled with CFR 0.152.
 */
package scalac.symtab.classfile;

import ch.epfl.lamp.compiler.msil.Assembly;
import ch.epfl.lamp.compiler.msil.MemberInfo;
import ch.epfl.lamp.compiler.msil.Type;
import java.io.File;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import scala.tools.util.ClassPath;
import scalac.CompilerCommand;
import scalac.symtab.Symbol;
import scalac.symtab.SymbolNameWriter;
import scalac.util.Debug;

public final class CLRTypes {
    private static CLRTypes instance;
    public final Type BYTE;
    public final Type UBYTE;
    public final Type CHAR;
    public final Type SHORT;
    public final Type USHORT;
    public final Type INT;
    public final Type UINT;
    public final Type LONG;
    public final Type ULONG;
    public final Type FLOAT;
    public final Type DOUBLE;
    public final Type BOOLEAN;
    public final Type VOID;
    public final Type ENUM;
    public final Type OBJECT;
    public final Type STRING;
    public final Type STRING_ARRAY;
    public final Type SCALA_SYMTAB_ATTR;
    public final Type PICO_META_ATTR;
    private final SymbolNameWriter snw = new SymbolNameWriter();
    private Type[] types;
    private final CompilerCommand args;
    private final Map syms2members = new HashMap();
    private final Map members2syms = new HashMap();
    private final List assemblies = new LinkedList();
    private final Set assemrefs = new LinkedHashSet();
    private Symbol pakage;
    private Map typesMap;
    private Set namespacesSet;
    private static final /* synthetic */ boolean $assertionsDisabled;

    public static CLRTypes instance() {
        if (!$assertionsDisabled && instance == null) {
            throw new AssertionError();
        }
        return instance;
    }

    public static void init(CompilerCommand compilerCommand) {
        instance = new CLRTypes(compilerCommand);
    }

    private CLRTypes(CompilerCommand compilerCommand) {
        Object object;
        this.args = compilerCommand;
        ClassPath.addFilesInPath(this.assemrefs, compilerCommand.assemrefs.value);
        Assembly assembly = this.findAssembly("mscorlib.dll");
        Type.initMSCORLIB((Assembly)assembly);
        this.findAssembly("vjscor.dll");
        this.findAssembly("vjslib.dll");
        this.findAssembly("scala.dll");
        this.findAllAssemblies();
        this.BYTE = this.getType("System.SByte");
        this.UBYTE = this.getType("System.Byte");
        this.CHAR = this.getType("System.Char");
        this.SHORT = this.getType("System.Int16");
        this.USHORT = this.getType("System.UInt16");
        this.INT = this.getType("System.Int32");
        this.UINT = this.getType("System.UInt32");
        this.LONG = this.getType("System.Int64");
        this.ULONG = this.getType("System.UInt64");
        this.FLOAT = this.getType("System.Single");
        this.DOUBLE = this.getType("System.Double");
        this.BOOLEAN = this.getType("System.Boolean");
        this.VOID = this.getType("System.Void");
        this.ENUM = this.getType("System.Enum");
        this.OBJECT = this.getType("System.Object");
        this.STRING = this.getType("System.String");
        this.STRING_ARRAY = this.getType("System.String[]");
        this.SCALA_SYMTAB_ATTR = Type.GetType((String)"scala.runtime.SymtabAttribute");
        this.PICO_META_ATTR = Type.GetType((String)"scala.runtime.MetaAttribute");
        if (!$assertionsDisabled && this.PICO_META_ATTR == null) {
            throw new AssertionError();
        }
        Type[] typeArray = Type.EmptyTypes;
        Iterator iterator = this.assemblies.iterator();
        while (iterator.hasNext()) {
            object = ((Assembly)iterator.next()).GetTypes();
            int n = 0;
            for (int i = 0; i < ((Type[])object).length; ++i) {
                if (object[i].DeclaringType != null) continue;
                object[n++] = object[i];
            }
            Type[] typeArray2 = new Type[typeArray.length + n];
            System.arraycopy(typeArray, 0, typeArray2, 0, typeArray.length);
            System.arraycopy(object, 0, typeArray2, typeArray.length, n);
            typeArray = typeArray2;
        }
        object = new 2();
        Arrays.sort(typeArray, object);
        this.types = typeArray;
    }

    public void map(Symbol symbol, MemberInfo memberInfo) {
        this.syms2members.put(symbol, memberInfo);
        this.members2syms.put(memberInfo, symbol);
    }

    public MemberInfo getMember(Symbol symbol) {
        return (MemberInfo)this.syms2members.get(symbol);
    }

    public Symbol getSymbol(MemberInfo memberInfo) {
        return (Symbol)this.members2syms.get(memberInfo);
    }

    public Type getType(String string) {
        Type type = Type.GetType((String)string);
        return type;
    }

    public Type mkArrayType(Type type) {
        return this.getType(String.valueOf(String.valueOf(type.FullName)).concat("[]"));
    }

    private Assembly findAssembly(String string) {
        File file;
        File file2;
        Object object;
        Iterator iterator = this.assemrefs.iterator();
        while (iterator.hasNext()) {
            object = (File)iterator.next();
            if (!((File)object).getName().equals(string) || (file2 = Assembly.LoadFrom((String)((File)object).getPath())) == null) continue;
            iterator.remove();
            this.assemblies.add(file2);
            return file2;
        }
        object = this.assemrefs.iterator();
        while (object.hasNext()) {
            Assembly assembly;
            file2 = (File)object.next();
            if (!file2.isDirectory() || !(file = new File(file2, string)).exists() || (assembly = Assembly.LoadFrom((String)file.getPath())) == null) continue;
            this.assemblies.add(assembly);
            return assembly;
        }
        file2 = new File(".", string);
        if (file2.exists() && (file = Assembly.LoadFrom((String)file2.getPath())) != null) {
            this.assemblies.add(file);
            return file;
        }
        this.args.reporter().error(null, String.valueOf(String.valueOf("cannot find assembly ".concat(String.valueOf(String.valueOf(string))))).concat("; use the -r option to specify its location"));
        throw Debug.abort();
    }

    private void findAllAssemblies() {
        Iterator iterator = this.assemrefs.iterator();
        while (iterator.hasNext()) {
            Assembly assembly;
            File file = (File)iterator.next();
            if (file.isFile() && (assembly = Assembly.LoadFrom((String)file.getPath())) != null) {
                this.assemblies.add(assembly);
            }
            iterator.remove();
        }
        if (!$assertionsDisabled && !this.assemrefs.isEmpty()) {
            throw new AssertionError();
        }
    }

    private int findFirst(String string) {
        int n = 0;
        int n2 = this.types.length - 1;
        while (n < n2) {
            int n3 = (n + n2) / 2;
            int n4 = this.types[n3].FullName.compareTo(string);
            if (n4 < 0) {
                n = n3 + 1;
                continue;
            }
            n2 = n3;
        }
        return this.types[n].FullName.startsWith(string) ? n : this.types.length;
    }

    private void enumerateMembers(Symbol symbol) {
        if (this.pakage == symbol) {
            return;
        }
        this.pakage = symbol;
        this.typesMap = new HashMap();
        this.namespacesSet = new LinkedHashSet();
        String string = symbol.isRoot() ? "" : String.valueOf(String.valueOf(this.snw.toString(symbol))).concat(".");
        int n = string.length();
        for (int i = this.findFirst(string); i < this.types.length && this.types[i].FullName.startsWith(string); ++i) {
            Type type = this.types[i];
            if (type.FullName.equals("java.lang.Object") || type.FullName.equals("java.lang.String")) continue;
            int n2 = type.FullName.indexOf(".", n);
            if (n2 < 0) {
                this.typesMap.put(type.Name, type);
                continue;
            }
            this.namespacesSet.add(type.Namespace.substring(n, n2));
        }
    }

    Map getTypes(Symbol symbol) {
        this.enumerateMembers(symbol);
        return this.typesMap;
    }

    Set getNamespaces(Symbol symbol) {
        this.enumerateMembers(symbol);
        return this.namespacesSet;
    }

    static {
        $assertionsDisabled = !Class.forName("scalac.symtab.classfile.CLRTypes").desiredAssertionStatus();
    }

    class 2
    implements Comparator {
        public int compare(Object object, Object object2) {
            Type type = (Type)object;
            Type type2 = (Type)object2;
            return type.FullName.compareTo(type2.FullName);
        }

        2() {
        }
    }
}

