/*
 * Decompiled with CFR 0.152.
 */
package scalac.symtab;

import scalac.Global;
import scalac.symtab.Symbol;
import scalac.util.NameTransformer;

public class SymbolNameWriter {
    private StringBuffer buffer;
    private char root;
    private char peckage;
    private char clasz;
    private char member;
    private char parameter;
    private char none;
    private char error;
    private char other;
    private boolean decode;
    private char unique;
    private int pending;
    private String prefix;
    private static final /* synthetic */ boolean $assertionsDisabled;

    public SymbolNameWriter() {
        this(null);
    }

    public SymbolNameWriter(StringBuffer stringBuffer) {
        this.setStringBuffer(stringBuffer).setAllSeparators('.').setRootSeparator('\u0000');
    }

    public SymbolNameWriter setStringBuffer(StringBuffer stringBuffer) {
        this.buffer = stringBuffer;
        return this;
    }

    public SymbolNameWriter setAllSeparators(char c) {
        this.setRootSeparator(c);
        this.setPackageSeparator(c);
        this.setClassSeparator(c);
        this.setMemberSeparator(c);
        this.setParameterSeparator(c);
        this.setNoneSeparator(c);
        this.setErrorSeparator(c);
        this.setOtherSeparator(c);
        return this;
    }

    public SymbolNameWriter setRootSeparator(char c) {
        this.root = c;
        return this;
    }

    public SymbolNameWriter setPackageSeparator(char c) {
        this.peckage = c;
        return this;
    }

    public SymbolNameWriter setClassSeparator(char c) {
        this.clasz = c;
        return this;
    }

    public SymbolNameWriter setMemberSeparator(char c) {
        this.member = c;
        return this;
    }

    public SymbolNameWriter setParameterSeparator(char c) {
        this.parameter = c;
        return this;
    }

    public SymbolNameWriter setNoneSeparator(char c) {
        this.none = c;
        return this;
    }

    public SymbolNameWriter setErrorSeparator(char c) {
        this.error = c;
        return this;
    }

    public SymbolNameWriter setOtherSeparator(char c) {
        this.other = c;
        return this;
    }

    public SymbolNameWriter setNameDecoding(boolean bl) {
        this.decode = bl;
        return this;
    }

    public SymbolNameWriter setUniqueSeparator(char c) {
        this.unique = c;
        return this;
    }

    public String toString(Symbol symbol) {
        if (!$assertionsDisabled && this.buffer != null) {
            throw new AssertionError();
        }
        String string = this.appendSymbol(symbol).toString();
        this.setStringBuffer(null);
        return string;
    }

    public String toString(String string, Symbol symbol) {
        if (!$assertionsDisabled && this.buffer != null) {
            throw new AssertionError();
        }
        String string2 = this.appendSymbol(string, symbol).toString();
        this.setStringBuffer(null);
        return string2;
    }

    public String toString(Symbol symbol, String string) {
        if (!$assertionsDisabled && this.buffer != null) {
            throw new AssertionError();
        }
        String string2 = this.appendSymbol(symbol, string).toString();
        this.setStringBuffer(null);
        return string2;
    }

    public String toString(String string, Symbol symbol, String string2) {
        if (!$assertionsDisabled && this.buffer != null) {
            throw new AssertionError();
        }
        String string3 = this.appendSymbol(string, symbol, string2).toString();
        this.setStringBuffer(null);
        return string3;
    }

    public StringBuffer appendSymbol(Symbol symbol) {
        String string = this.getSymbolName(symbol);
        this.pending += string.length();
        char c = this.getSymbolSeparator(symbol);
        return this.appendPrefix(symbol.owner(), c).append(string);
    }

    public StringBuffer appendSymbol(String string, Symbol symbol) {
        if (!($assertionsDisabled || this.prefix == null && string != null)) {
            throw new AssertionError();
        }
        this.prefix = string;
        return this.appendSymbol(symbol);
    }

    public StringBuffer appendSymbol(Symbol symbol, String string) {
        this.pending += string.length();
        return this.appendSymbol(symbol).append(string);
    }

    public StringBuffer appendSymbol(String string, Symbol symbol, String string2) {
        if (!($assertionsDisabled || this.prefix == null && string != null)) {
            throw new AssertionError();
        }
        this.prefix = string;
        this.pending += string2.length();
        return this.appendSymbol(symbol).append(string2);
    }

    public StringBuffer appendPrefix(Symbol symbol, char c) {
        if (c == '\u0000') {
            return this.getStringBuffer();
        }
        ++this.pending;
        return this.appendSymbol(symbol).append(c);
    }

    public String getSymbolName(Symbol symbol) {
        String string = symbol.name.toString();
        if (this.decode) {
            string = NameTransformer.decode(string);
        }
        if (this.unique != '\u0000') {
            string = String.valueOf(String.valueOf(String.valueOf(String.valueOf(string)).concat(String.valueOf(this.unique)))).concat(String.valueOf(Global.instance.uniqueID.id(symbol)));
        }
        return string;
    }

    public char getSymbolSeparator(Symbol symbol) {
        if (symbol.isRoot() || symbol.isNone() || symbol.isError()) {
            return '\u0000';
        }
        if (symbol.isParameter()) {
            return this.parameter;
        }
        Symbol symbol2 = symbol.owner();
        if (symbol2.isRoot()) {
            return this.root;
        }
        if (symbol2.isNone()) {
            return this.none;
        }
        if (symbol2.isError()) {
            return this.error;
        }
        if (symbol2.isPackageClass()) {
            return this.peckage;
        }
        if (symbol2.isClass()) {
            return symbol.isClass() ? this.clasz : this.member;
        }
        return this.other;
    }

    public StringBuffer getStringBuffer() {
        if (this.prefix != null) {
            this.pending += this.prefix.length();
        }
        if (this.buffer == null) {
            this.buffer = new StringBuffer(this.pending);
        } else {
            this.buffer.ensureCapacity(this.buffer.length() + this.pending);
        }
        if (this.prefix != null) {
            this.buffer.append(this.prefix);
        }
        this.pending = 0;
        this.prefix = null;
        return this.buffer;
    }

    public String toString() {
        return this.buffer == null ? "" : this.buffer.toString();
    }

    static {
        $assertionsDisabled = !Class.forName("scalac.symtab.SymbolNameWriter").desiredAssertionStatus();
    }
}

