/*
 * Decompiled with CFR 0.152.
 */
package scalac.symtab;

import scalac.Global;
import scalac.atree.ATreeTyper;
import scalac.symtab.ClassSymbol;
import scalac.symtab.ModuleClassSymbol;
import scalac.symtab.Scope;
import scalac.symtab.Symbol;
import scalac.symtab.Type;
import scalac.util.Debug;
import scalac.util.Name;
import scalac.util.Names;
import scalac.util.TermName;
import scalac.util.TypeName;

public class Definitions {
    public final ATreeTyper atyper;
    public final Symbol ROOT_CLASS;
    public final Symbol JAVA;
    public final Symbol JAVALANG;
    public final Symbol SCALA;
    public final Symbol ANY_CLASS;
    public final Symbol ANYVAL_CLASS;
    public final Symbol ANYREF_CLASS;
    public final Symbol ALLREF_CLASS;
    public final Symbol ALL_CLASS;
    public final Symbol OBJECT_CLASS;
    public final Symbol STRING_CLASS;
    public final Symbol THROWABLE_CLASS;
    public final Symbol SERIALIZABLE_CLASS;
    public final Symbol UNIT_CLASS;
    public final Symbol BOOLEAN_CLASS;
    public final Symbol BYTE_CLASS;
    public final Symbol SHORT_CLASS;
    public final Symbol CHAR_CLASS;
    public final Symbol INT_CLASS;
    public final Symbol LONG_CLASS;
    public final Symbol FLOAT_CLASS;
    public final Symbol DOUBLE_CLASS;
    public final Symbol SCALAOBJECT_CLASS;
    public final Symbol ATTRIBUTE_CLASS;
    public final Symbol REF_CLASS;
    public final int TUPLE_COUNT = 10;
    public final Symbol[] TUPLE_CLASS = new Symbol[10];
    public final int FUNCTION_COUNT = 10;
    public final Symbol[] FUNCTION_CLASS = new Symbol[10];
    public final Symbol PARTIALFUNCTION_CLASS;
    public final Symbol ITERABLE_CLASS;
    public final Symbol ITERATOR_CLASS;
    public final Symbol SEQ_CLASS;
    public final Symbol LIST_CLASS;
    public final Symbol ARRAY_CLASS;
    public final Symbol TYPE_CLASS;
    public final Symbol CONSTRUCTEDTYPE_CLASS;
    public final Symbol SINGLETYPE_CLASS;
    public final Symbol PREDEF;
    public final Symbol CONSOLE;
    public final Symbol MATCHERROR;
    public final Symbol ANY_EQEQ;
    public final Symbol ANY_BANGEQ;
    public final Symbol ANY_EQUALS;
    public final Symbol ANY_HASHCODE;
    public final Symbol ANY_TOSTRING;
    public final Symbol ANY_IS;
    public final Symbol ANY_AS;
    public final Symbol ANY_MATCH;
    public final Symbol OBJECT_EQ;
    public final Symbol OBJECT_SYNCHRONIZED;
    public final Symbol STRING_PLUS;
    public final Symbol THROWABLE_THROW;
    private Symbol BOOLEAN_OR;
    private Symbol BOOLEAN_AND;
    private Symbol BOOLEAN_NOT;
    private Symbol SCALAOBJECT_TAG;
    private Symbol REF_ELEM;
    private final Symbol[][] TUPLE_FIELD = new Symbol[10][];
    private final Symbol[] FUNCTION_APPLY = new Symbol[10];
    private Symbol PARTIALFUNCTION_ISDEFINEDAT;
    private Symbol ITERABLE_ELEMENTS;
    private Symbol ITERATOR_NEXT;
    private Symbol ITERATOR_HASNEXT;
    private Symbol SEQ_LENGTH;
    private Symbol LIST_ISEMPTY;
    private Symbol LIST_HEAD;
    private Symbol LIST_TAIL;
    private Symbol ARRAY_LENGTH;
    private Symbol ARRAY_GET;
    private Symbol ARRAY_SET;
    private Symbol PREDEF_ARRAY;
    private Symbol CONSOLE_PRINT;
    private Symbol MATCHERROR_FAIL;
    private Symbol MATCHERROR_REPORT;
    private Symbol TYPE_DEFAULTVALUE;
    private Symbol TYPE_NEWARRAY;
    private Symbol TYPE_HASASINSTANCE;
    private Symbol TYPE_CHECKCASTABILITY;
    private Symbol RTT_DOUBLE;
    private Symbol RTT_FLOAT;
    private Symbol RTT_LONG;
    private Symbol RTT_INT;
    private Symbol RTT_SHORT;
    private Symbol RTT_CHAR;
    private Symbol RTT_BYTE;
    private Symbol RTT_BOOLEAN;
    public final Symbol PATTERN_WILDCARD;
    private final Symbol void_TYPE;
    private final Symbol boolean_TYPE;
    private final Symbol byte_TYPE;
    private final Symbol short_TYPE;
    private final Symbol char_TYPE;
    private final Symbol int_TYPE;
    private final Symbol long_TYPE;
    private final Symbol float_TYPE;
    private final Symbol double_TYPE;
    private final Symbol array_TYPE;
    private static final /* synthetic */ boolean $assertionsDisabled;

    public final Type ANY_TYPE() {
        return this.ANY_CLASS.staticType();
    }

    public final Type ANYVAL_TYPE() {
        return this.ANYVAL_CLASS.staticType();
    }

    public final Type ANYREF_TYPE() {
        return this.ANYREF_CLASS.staticType();
    }

    public final Type ALLREF_TYPE() {
        return this.ALLREF_CLASS.staticType();
    }

    public final Type ALL_TYPE() {
        return this.ALL_CLASS.staticType();
    }

    public final Type OBJECT_TYPE() {
        return this.OBJECT_CLASS.staticType();
    }

    public final Type STRING_TYPE() {
        return this.STRING_CLASS.staticType();
    }

    public final Type THROWABLE_TYPE() {
        return this.THROWABLE_CLASS.staticType();
    }

    public final Type SERIALIZABLE_TYPE() {
        return this.SERIALIZABLE_CLASS.staticType();
    }

    public final Type UNIT_TYPE() {
        return this.UNIT_CLASS.staticType();
    }

    public final Type BOOLEAN_TYPE() {
        return this.BOOLEAN_CLASS.staticType();
    }

    public final Type BYTE_TYPE() {
        return this.BYTE_CLASS.staticType();
    }

    public final Type SHORT_TYPE() {
        return this.SHORT_CLASS.staticType();
    }

    public final Type CHAR_TYPE() {
        return this.CHAR_CLASS.staticType();
    }

    public final Type INT_TYPE() {
        return this.INT_CLASS.staticType();
    }

    public final Type LONG_TYPE() {
        return this.LONG_CLASS.staticType();
    }

    public final Type FLOAT_TYPE() {
        return this.FLOAT_CLASS.staticType();
    }

    public final Type DOUBLE_TYPE() {
        return this.DOUBLE_CLASS.staticType();
    }

    public final Type SCALAOBJECT_TYPE() {
        return this.SCALAOBJECT_CLASS.staticType();
    }

    public final Type ATTRIBUTE_TYPE() {
        return this.ATTRIBUTE_CLASS.staticType();
    }

    public final Type REF_TYPE(Type type) {
        return this.REF_CLASS.staticType(type);
    }

    public final Type TUPLE_TYPE(Type[] typeArray) {
        if (!($assertionsDisabled || typeArray.length > 0 && typeArray.length < 10)) {
            throw new AssertionError((Object)String.valueOf(typeArray.length));
        }
        return this.TUPLE_CLASS[typeArray.length].staticType(typeArray);
    }

    public final Type FUNCTION_TYPE(Type[] typeArray, Type type) {
        if (!$assertionsDisabled && typeArray.length < 0) {
            throw new AssertionError();
        }
        if (typeArray.length >= 10) {
            throw new Type.Error("function has too many arguments; limit = 9");
        }
        typeArray = Type.cloneArray(typeArray, 1);
        typeArray[typeArray.length - 1] = type;
        return this.FUNCTION_CLASS[typeArray.length - 1].staticType(typeArray);
    }

    public final Type PARTIALFUNCTION_TYPE(Type type, Type type2) {
        return this.PARTIALFUNCTION_CLASS.staticType(type, type2);
    }

    public final Type ITERABLE_TYPE(Type type) {
        return this.ITERABLE_CLASS.staticType(type);
    }

    public final Type ITERATOR_TYPE(Type type) {
        return this.ITERATOR_CLASS.staticType(type);
    }

    public final Type SEQ_TYPE(Type type) {
        return this.SEQ_CLASS.staticType(type);
    }

    public final Type LIST_TYPE(Type type) {
        return this.LIST_CLASS.staticType(type);
    }

    public final Symbol NIL() {
        return this.getModule("scala.Nil");
    }

    public final Symbol CONS_CLASS() {
        return this.getClass("scala.$colon$colon");
    }

    public final Type CONS_TYPE(Type type) {
        return this.CONS_CLASS().staticType(type);
    }

    public final Type ARRAY_TYPE(Type type) {
        return this.ARRAY_CLASS.staticType(type);
    }

    public final Type TYPE_TYPE() {
        return this.TYPE_CLASS.staticType();
    }

    public final Type void_TYPE() {
        return this.void_TYPE.type().resultType();
    }

    public final Type boolean_TYPE() {
        return this.boolean_TYPE.type().resultType();
    }

    public final Type byte_TYPE() {
        return this.byte_TYPE.type().resultType();
    }

    public final Type short_TYPE() {
        return this.short_TYPE.type().resultType();
    }

    public final Type char_TYPE() {
        return this.char_TYPE.type().resultType();
    }

    public final Type int_TYPE() {
        return this.int_TYPE.type().resultType();
    }

    public final Type long_TYPE() {
        return this.long_TYPE.type().resultType();
    }

    public final Type float_TYPE() {
        return this.float_TYPE.type().resultType();
    }

    public final Type double_TYPE() {
        return this.double_TYPE.type().resultType();
    }

    public final Type array_TYPE(Type type) {
        Type type2 = this.array_TYPE.type().resultType();
        switch (type2.$tag) {
            case 8: {
                Type.TypeRef typeRef = (Type.TypeRef)type2;
                Type type3 = typeRef.pre;
                Symbol symbol = typeRef.sym;
                return Type.typeRef(type3, symbol, new Type[]{type});
            }
            case 10: {
                return Type.UnboxedArrayType(type);
            }
        }
        throw Debug.abort("illegal case", type2);
    }

    public Symbol BOOLEAN_OR() {
        if (this.BOOLEAN_OR == null) {
            this.BOOLEAN_OR = this.loadTerm(this.BOOLEAN_CLASS, Names.BARBAR);
        }
        return this.BOOLEAN_OR;
    }

    public Symbol BOOLEAN_AND() {
        if (this.BOOLEAN_AND == null) {
            this.BOOLEAN_AND = this.loadTerm(this.BOOLEAN_CLASS, Names.AMPAMP);
        }
        return this.BOOLEAN_AND;
    }

    public Symbol BOOLEAN_NOT() {
        if (this.BOOLEAN_NOT == null) {
            this.BOOLEAN_NOT = this.loadTerm(this.BOOLEAN_CLASS, Names.BANG);
        }
        return this.BOOLEAN_NOT;
    }

    public Symbol SCALAOBJECT_TAG() {
        if (this.SCALAOBJECT_TAG == null) {
            this.SCALAOBJECT_TAG = this.loadTerm(this.SCALAOBJECT_CLASS, Names.tag);
        }
        return this.SCALAOBJECT_TAG;
    }

    public Symbol REF_ELEM() {
        if (this.REF_ELEM == null) {
            this.REF_ELEM = this.loadTerm(this.REF_CLASS, Names.elem);
        }
        return this.REF_ELEM;
    }

    public Symbol TUPLE_FIELD(int n, int n2) {
        if (!($assertionsDisabled || n > 0 && n < 10)) {
            throw new AssertionError((Object)String.valueOf(n));
        }
        if (!($assertionsDisabled || n2 > 0 && n2 <= n)) {
            throw new AssertionError((Object)String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(n).concat(" - "))).concat(String.valueOf(n2)))));
        }
        if (this.TUPLE_FIELD[n][n2 - 1] == null) {
            this.TUPLE_FIELD[n][n2 - 1] = this.loadTerm(this.TUPLE_CLASS[n], Names.TUPLE_FIELD(n2));
        }
        return this.TUPLE_FIELD[n][n2 - 1];
    }

    public Symbol FUNCTION_APPLY(int n) {
        if (!($assertionsDisabled || n >= 0 && n < 10)) {
            throw new AssertionError((Object)String.valueOf(n));
        }
        if (this.FUNCTION_APPLY[n] == null) {
            this.FUNCTION_APPLY[n] = this.loadTerm(this.FUNCTION_CLASS[n], Names.apply);
        }
        return this.FUNCTION_APPLY[n];
    }

    public Symbol PARTIALFUNCTION_ISDEFINEDAT() {
        if (this.PARTIALFUNCTION_ISDEFINEDAT == null) {
            this.PARTIALFUNCTION_ISDEFINEDAT = this.loadTerm(this.PARTIALFUNCTION_CLASS, Names.isDefinedAt);
        }
        return this.PARTIALFUNCTION_ISDEFINEDAT;
    }

    public Symbol ITERABLE_ELEMENTS() {
        if (this.ITERABLE_ELEMENTS == null) {
            this.ITERABLE_ELEMENTS = this.loadTerm(this.ITERABLE_CLASS, Names.elements);
        }
        return this.ITERABLE_ELEMENTS;
    }

    public Symbol ITERATOR_NEXT() {
        if (this.ITERATOR_NEXT == null) {
            this.ITERATOR_NEXT = this.loadTerm(this.ITERATOR_CLASS, Names.next);
        }
        return this.ITERATOR_NEXT;
    }

    public Symbol ITERATOR_HASNEXT() {
        if (this.ITERATOR_HASNEXT == null) {
            this.ITERATOR_HASNEXT = this.loadTerm(this.ITERATOR_CLASS, Names.hasNext);
        }
        return this.ITERATOR_HASNEXT;
    }

    public Symbol SEQ_LENGTH() {
        if (this.SEQ_LENGTH == null) {
            this.SEQ_LENGTH = this.loadTerm(this.SEQ_CLASS, Names.length);
        }
        return this.SEQ_LENGTH;
    }

    public Symbol LIST_ISEMPTY() {
        if (this.LIST_ISEMPTY == null) {
            this.LIST_ISEMPTY = this.loadTerm(this.LIST_CLASS, Names.isEmpty);
        }
        return this.LIST_ISEMPTY;
    }

    public Symbol LIST_HEAD() {
        if (this.LIST_HEAD == null) {
            this.LIST_HEAD = this.loadTerm(this.LIST_CLASS, Names.head);
        }
        return this.LIST_HEAD;
    }

    public Symbol LIST_TAIL() {
        if (this.LIST_TAIL == null) {
            this.LIST_TAIL = this.loadTerm(this.LIST_CLASS, Names.tail);
        }
        return this.LIST_TAIL;
    }

    public Symbol ARRAY_LENGTH() {
        if (this.ARRAY_LENGTH == null) {
            this.ARRAY_LENGTH = this.loadTerm(this.ARRAY_CLASS, Names.length);
        }
        return this.ARRAY_LENGTH;
    }

    public Symbol ARRAY_GET() {
        if (this.ARRAY_GET == null) {
            this.ARRAY_GET = this.loadTerm(this.ARRAY_CLASS, Names.apply, new Type[]{this.int_TYPE()});
        }
        return this.ARRAY_GET;
    }

    public Symbol ARRAY_SET() {
        if (this.ARRAY_SET == null) {
            this.ARRAY_SET = this.loadTerm(this.ARRAY_CLASS, Names.update);
        }
        return this.ARRAY_SET;
    }

    public Symbol PREDEF_ARRAY() {
        if (this.PREDEF_ARRAY == null) {
            this.PREDEF_ARRAY = this.loadTerm(this.PREDEF, Names.Array);
        }
        return this.PREDEF_ARRAY;
    }

    public Symbol CONSOLE_PRINT() {
        if (this.CONSOLE_PRINT == null) {
            this.CONSOLE_PRINT = this.loadTerm(this.CONSOLE, Names.print);
        }
        return this.CONSOLE_PRINT;
    }

    public Symbol MATCHERROR_FAIL() {
        if (this.MATCHERROR_FAIL == null) {
            this.MATCHERROR_FAIL = this.loadTerm(this.MATCHERROR, Names.fail);
        }
        return this.MATCHERROR_FAIL;
    }

    public Symbol MATCHERROR_REPORT() {
        if (this.MATCHERROR_REPORT == null) {
            this.MATCHERROR_REPORT = this.loadTerm(this.MATCHERROR, Names.report);
        }
        return this.MATCHERROR_REPORT;
    }

    public Symbol TYPE_DEFAULTVALUE() {
        if (this.TYPE_DEFAULTVALUE == null) {
            this.TYPE_DEFAULTVALUE = this.loadTerm(this.TYPE_CLASS, Names.defaultValue);
        }
        return this.TYPE_DEFAULTVALUE;
    }

    public Symbol TYPE_NEWARRAY() {
        if (this.TYPE_NEWARRAY == null) {
            this.TYPE_NEWARRAY = this.loadTerm(this.TYPE_CLASS, Names.newArray);
        }
        return this.TYPE_NEWARRAY;
    }

    public Symbol TYPE_HASASINSTANCE() {
        if (this.TYPE_HASASINSTANCE == null) {
            this.TYPE_HASASINSTANCE = this.loadTerm(this.TYPE_CLASS, Names.hasAsInstance);
        }
        return this.TYPE_HASASINSTANCE;
    }

    public Symbol TYPE_CHECKCASTABILITY() {
        if (this.TYPE_CHECKCASTABILITY == null) {
            this.TYPE_CHECKCASTABILITY = this.loadTerm(this.TYPE_CLASS, Names.checkCastability);
        }
        return this.TYPE_CHECKCASTABILITY;
    }

    public Symbol RTT_DOUBLE() {
        if (this.RTT_DOUBLE == null) {
            this.RTT_DOUBLE = this.loadTerm(this.TYPE_CLASS.linkedModule().moduleClass(), Names.Double);
        }
        return this.RTT_DOUBLE;
    }

    public Symbol RTT_FLOAT() {
        if (this.RTT_FLOAT == null) {
            this.RTT_FLOAT = this.loadTerm(this.TYPE_CLASS.linkedModule().moduleClass(), Names.Float);
        }
        return this.RTT_FLOAT;
    }

    public Symbol RTT_LONG() {
        if (this.RTT_LONG == null) {
            this.RTT_LONG = this.loadTerm(this.TYPE_CLASS.linkedModule().moduleClass(), Names.Long);
        }
        return this.RTT_LONG;
    }

    public Symbol RTT_INT() {
        if (this.RTT_INT == null) {
            this.RTT_INT = this.loadTerm(this.TYPE_CLASS.linkedModule().moduleClass(), Names.Int);
        }
        return this.RTT_INT;
    }

    public Symbol RTT_SHORT() {
        if (this.RTT_SHORT == null) {
            this.RTT_SHORT = this.loadTerm(this.TYPE_CLASS.linkedModule().moduleClass(), Names.Short);
        }
        return this.RTT_SHORT;
    }

    public Symbol RTT_CHAR() {
        if (this.RTT_CHAR == null) {
            this.RTT_CHAR = this.loadTerm(this.TYPE_CLASS.linkedModule().moduleClass(), Names.Char);
        }
        return this.RTT_CHAR;
    }

    public Symbol RTT_BYTE() {
        if (this.RTT_BYTE == null) {
            this.RTT_BYTE = this.loadTerm(this.TYPE_CLASS.linkedModule().moduleClass(), Names.Byte);
        }
        return this.RTT_BYTE;
    }

    public Symbol RTT_BOOLEAN() {
        if (this.RTT_BOOLEAN == null) {
            this.RTT_BOOLEAN = this.loadTerm(this.TYPE_CLASS.linkedModule().moduleClass(), Names.Boolean);
        }
        return this.RTT_BOOLEAN;
    }

    public Symbol CONSTRUCTEDTYPE_CTOR(int n) {
        int n2 = n + 2;
        this.CONSTRUCTEDTYPE_CLASS.info();
        Symbol[] symbolArray = this.CONSTRUCTEDTYPE_CLASS.allConstructors().alternativeSymbols();
        for (int i = 0; i < symbolArray.length; ++i) {
            if (symbolArray[i].valueParams().length != n2) continue;
            return symbolArray[i];
        }
        throw Debug.abort(String.valueOf(String.valueOf("constructor not found for ".concat(String.valueOf(n)))).concat(" args"));
    }

    public Definitions(Global global) {
        Symbol symbol;
        Symbol symbol2;
        global.definitions = this;
        this.atyper = new ATreeTyper(global, this);
        this.ROOT_CLASS = ClassSymbol.newRootClass(global);
        this.JAVA = this.getModule("java");
        this.JAVALANG = this.getModule("java.lang");
        this.SCALA = this.getModule("scala");
        ModuleClassSymbol moduleClassSymbol = this.SCALA.moduleClass();
        this.ANY_CLASS = this.newClass(moduleClassSymbol, Names.Any, 0);
        this.ANYVAL_CLASS = this.getClass("scala.AnyVal");
        this.ANYREF_CLASS = this.newAlias(moduleClassSymbol, Names.AnyRef, 0);
        this.ALLREF_CLASS = this.newClass(moduleClassSymbol, Names.AllRef, 0);
        this.ALL_CLASS = this.newClass(moduleClassSymbol, Names.All, 0);
        boolean bl = global.target == Global.TARGET_MSIL;
        this.OBJECT_CLASS = this.getClass(bl ? "System.Object" : "java.lang.Object");
        this.STRING_CLASS = this.getClass(bl ? "System.String" : "java.lang.String");
        this.THROWABLE_CLASS = this.getClass(bl ? "System.Exception" : "java.lang.Throwable");
        this.SERIALIZABLE_CLASS = this.getClass(bl ? "System.Serializable" : "java.io.Serializable");
        this.UNIT_CLASS = this.getClass("scala.Unit");
        this.BOOLEAN_CLASS = this.getClass("scala.Boolean");
        this.BYTE_CLASS = this.getClass("scala.Byte");
        this.SHORT_CLASS = this.getClass("scala.Short");
        this.CHAR_CLASS = this.getClass("scala.Char");
        this.INT_CLASS = this.getClass("scala.Int");
        this.LONG_CLASS = this.getClass("scala.Long");
        this.FLOAT_CLASS = this.getClass("scala.Float");
        this.DOUBLE_CLASS = this.getClass("scala.Double");
        this.SCALAOBJECT_CLASS = this.getClass("scala.ScalaObject");
        this.ATTRIBUTE_CLASS = this.getClass("scala.Attribute");
        this.REF_CLASS = this.getClass("scala.Ref");
        for (int i = 1; i < 10; ++i) {
            this.TUPLE_CLASS[i] = this.getClass("scala.Tuple".concat(String.valueOf(i)));
            this.TUPLE_FIELD[i] = new Symbol[i];
        }
        for (int i = 0; i < 10; ++i) {
            this.FUNCTION_CLASS[i] = this.getClass("scala.Function".concat(String.valueOf(i)));
        }
        this.PARTIALFUNCTION_CLASS = this.getClass("scala.PartialFunction");
        this.ITERABLE_CLASS = this.getClass("scala.Iterable");
        this.ITERATOR_CLASS = this.getClass("scala.Iterator");
        this.SEQ_CLASS = this.getClass("scala.Seq");
        this.LIST_CLASS = this.getClass("scala.List");
        this.ARRAY_CLASS = this.getClass("scala.Array");
        this.TYPE_CLASS = this.getClass("scala.Type");
        this.CONSTRUCTEDTYPE_CLASS = this.getClass("scala.ConstructedType");
        this.SINGLETYPE_CLASS = this.getClass("scala.SingleType");
        this.PREDEF = this.getModule("scala.Predef");
        this.CONSOLE = this.getModule("scala.Console");
        this.MATCHERROR = this.getModule("scala.MatchError");
        this.initClass(this.ANY_CLASS, Type.EMPTY_ARRAY);
        this.initAlias(this.ANYREF_CLASS, this.OBJECT_TYPE());
        this.initClass(this.ALLREF_CLASS, new Type[]{this.ANYREF_TYPE()});
        this.initClass(this.ALL_CLASS, new Type[]{this.ANY_TYPE()});
        this.void_TYPE = this.newTypeMethod(Names.Unit, this.UNIT_TYPE());
        this.boolean_TYPE = this.newTypeMethod(Names.Boolean, this.BOOLEAN_TYPE());
        this.byte_TYPE = this.newTypeMethod(Names.Byte, this.BYTE_TYPE());
        this.short_TYPE = this.newTypeMethod(Names.Short, this.SHORT_TYPE());
        this.char_TYPE = this.newTypeMethod(Names.Char, this.CHAR_TYPE());
        this.int_TYPE = this.newTypeMethod(Names.Int, this.INT_TYPE());
        this.long_TYPE = this.newTypeMethod(Names.Long, this.LONG_TYPE());
        this.float_TYPE = this.newTypeMethod(Names.Float, this.FLOAT_TYPE());
        this.double_TYPE = this.newTypeMethod(Names.Double, this.DOUBLE_TYPE());
        this.array_TYPE = this.newTypeMethod(Names.Array, this.ARRAY_TYPE(this.ANYREF_TYPE()));
        this.ANY_EQEQ = this.newMethod(this.ANY_CLASS, Names.EQEQ, 2);
        this.ANY_BANGEQ = this.newMethod(this.ANY_CLASS, Names.BANGEQ, 2);
        this.ANY_EQUALS = this.newMethod(this.ANY_CLASS, Names.equals, 0);
        this.ANY_HASHCODE = this.newMethod(this.ANY_CLASS, Names.hashCode, 0);
        this.ANY_TOSTRING = this.newMethod(this.ANY_CLASS, Names.toString, 0);
        this.ANY_IS = this.newMethod(this.ANY_CLASS, Names.isInstanceOf, 2);
        this.ANY_AS = this.newMethod(this.ANY_CLASS, Names.asInstanceOf, 2);
        this.ANY_MATCH = this.newMethod(this.ANY_CLASS, Names._match, 2);
        this.initMethod(this.ANY_EQEQ, new Type[]{this.ANY_TYPE()}, this.boolean_TYPE());
        this.initMethod(this.ANY_BANGEQ, new Type[]{this.ANY_TYPE()}, this.boolean_TYPE());
        this.initMethod(this.ANY_EQUALS, new Type[]{this.ANY_TYPE()}, this.boolean_TYPE());
        this.initMethod(this.ANY_HASHCODE, new Type[0], this.int_TYPE());
        this.initMethod(this.ANY_TOSTRING, new Type[0], this.STRING_TYPE());
        Symbol[] symbolArray = new Symbol[]{this.newTParam(this.ANY_IS, 0, this.ANY_TYPE())};
        this.ANY_IS.setInfo(Type.PolyType(symbolArray, this.boolean_TYPE()));
        Symbol[] symbolArray2 = new Symbol[]{this.newTParam(this.ANY_AS, 0, this.ANY_TYPE())};
        this.ANY_AS.setInfo(Type.PolyType(symbolArray2, symbolArray2[0].type()));
        Symbol[] symbolArray3 = new Symbol[]{this.newTParam(this.ANY_MATCH, 0, this.ANY_TYPE()), this.newTParam(this.ANY_MATCH, 1, this.ANY_TYPE())};
        Symbol[] symbolArray4 = new Symbol[]{this.newVParam(this.ANY_MATCH, 0, this.FUNCTION_TYPE(new Type[]{symbolArray3[0].type()}, symbolArray3[1].type()))};
        this.ANY_MATCH.setInfo(Type.PolyType(symbolArray3, Type.MethodType(symbolArray4, symbolArray3[1].type())));
        this.OBJECT_EQ = this.newMethod(this.OBJECT_CLASS, Names.eq, 2);
        this.OBJECT_SYNCHRONIZED = this.newMethod(this.OBJECT_CLASS, Names.synchronized_, 2);
        this.initMethod(this.OBJECT_EQ, new Type[]{this.ANYREF_TYPE()}, this.boolean_TYPE());
        Symbol symbol3 = this.newTParam(this.OBJECT_SYNCHRONIZED, 0, this.ANY_TYPE());
        Symbol symbol4 = this.newVParam(this.OBJECT_SYNCHRONIZED, 0, symbol3.type());
        this.OBJECT_SYNCHRONIZED.setInfo(Type.PolyType(new Symbol[]{symbol3}, Type.MethodType(new Symbol[]{symbol4}, symbol3.type())));
        if (bl) {
            symbol2 = this.newMethod(this.OBJECT_CLASS, Names.wait, 2);
            this.initMethod(symbol2, Type.EMPTY_ARRAY, this.UNIT_TYPE());
            symbol = this.newMethod(this.OBJECT_CLASS, Names.wait, 2);
            this.initMethod(symbol, new Type[]{this.LONG_TYPE()}, this.UNIT_TYPE());
            Symbol symbol5 = this.newMethod(this.OBJECT_CLASS, Names.wait, 2);
            this.initMethod(symbol5, new Type[]{this.LONG_TYPE(), this.INT_TYPE()}, this.UNIT_TYPE());
            Symbol symbol6 = this.newMethod(this.OBJECT_CLASS, Names.notify, 2);
            this.initMethod(symbol6, Type.EMPTY_ARRAY, this.UNIT_TYPE());
            Symbol symbol7 = this.newMethod(this.OBJECT_CLASS, Names.notifyAll, 2);
            this.initMethod(symbol7, Type.EMPTY_ARRAY, this.UNIT_TYPE());
            Symbol symbol8 = this.newAlias(this.JAVALANG, Names.Object, 0);
            this.initAlias(symbol8, this.OBJECT_TYPE());
        }
        this.STRING_PLUS = this.newMethod(this.STRING_CLASS, Names.PLUS, 2);
        this.initMethod(this.STRING_PLUS, new Type[]{this.ANY_TYPE()}, this.STRING_TYPE());
        if (bl) {
            symbol2 = this.newMethod(this.STRING_CLASS, Name.fromString("length"), 0);
            this.initMethod(symbol2, Type.EMPTY_ARRAY, this.INT_TYPE());
            symbol2 = this.newMethod(this.STRING_CLASS, Name.fromString("compareTo"), 0);
            this.initMethod(symbol2, new Type[]{this.STRING_TYPE()}, this.INT_TYPE());
            symbol2 = this.newMethod(this.STRING_CLASS, Name.fromString("charAt"), 0);
            this.initMethod(symbol2, new Type[]{this.INT_TYPE()}, this.CHAR_TYPE());
            symbol2 = this.newMethod(this.STRING_CLASS, Name.fromString("concat"), 0);
            this.initMethod(symbol2, new Type[]{this.STRING_TYPE()}, this.STRING_TYPE());
            symbol2 = this.newMethod(this.STRING_CLASS, Name.fromString("indexOf"), 0);
            this.initMethod(symbol2, new Type[]{this.INT_TYPE()}, this.INT_TYPE());
            symbol2 = this.newMethod(this.STRING_CLASS, Name.fromString("indexOf"), 0);
            this.initMethod(symbol2, new Type[]{this.INT_TYPE(), this.INT_TYPE()}, this.INT_TYPE());
            symbol2 = this.newMethod(this.STRING_CLASS, Name.fromString("indexOf"), 0);
            this.initMethod(symbol2, new Type[]{this.STRING_TYPE()}, this.INT_TYPE());
            symbol2 = this.newMethod(this.STRING_CLASS, Name.fromString("indexOf"), 0);
            this.initMethod(symbol2, new Type[]{this.STRING_TYPE(), this.INT_TYPE()}, this.INT_TYPE());
            symbol2 = this.newMethod(this.STRING_CLASS, Name.fromString("lastIndexOf"), 0);
            this.initMethod(symbol2, new Type[]{this.INT_TYPE()}, this.INT_TYPE());
            symbol2 = this.newMethod(this.STRING_CLASS, Name.fromString("lastIndexOf"), 0);
            this.initMethod(symbol2, new Type[]{this.INT_TYPE(), this.INT_TYPE()}, this.INT_TYPE());
            symbol2 = this.newMethod(this.STRING_CLASS, Name.fromString("lastIndexOf"), 0);
            this.initMethod(symbol2, new Type[]{this.STRING_TYPE()}, this.INT_TYPE());
            symbol2 = this.newMethod(this.STRING_CLASS, Name.fromString("lastIndexOf"), 0);
            this.initMethod(symbol2, new Type[]{this.STRING_TYPE(), this.INT_TYPE()}, this.INT_TYPE());
            symbol2 = this.newMethod(this.STRING_CLASS, Name.fromString("toLowerCase"), 0);
            this.initMethod(symbol2, Type.EMPTY_ARRAY, this.STRING_TYPE());
            symbol2 = this.newMethod(this.STRING_CLASS, Name.fromString("toUpperCase"), 0);
            this.initMethod(symbol2, Type.EMPTY_ARRAY, this.STRING_TYPE());
            symbol2 = this.newMethod(this.STRING_CLASS, Name.fromString("startsWith"), 0);
            this.initMethod(symbol2, new Type[]{this.STRING_TYPE()}, this.BOOLEAN_TYPE());
            symbol2 = this.newMethod(this.STRING_CLASS, Name.fromString("endsWith"), 0);
            this.initMethod(symbol2, new Type[]{this.STRING_TYPE()}, this.BOOLEAN_TYPE());
            symbol2 = this.newMethod(this.STRING_CLASS, Name.fromString("substring"), 0);
            this.initMethod(symbol2, new Type[]{this.INT_TYPE()}, this.STRING_TYPE());
            symbol2 = this.newMethod(this.STRING_CLASS, Name.fromString("substring"), 0);
            this.initMethod(symbol2, new Type[]{this.INT_TYPE(), this.INT_TYPE()}, this.STRING_TYPE());
            symbol2 = this.newMethod(this.STRING_CLASS, Name.fromString("intern"), 0);
            this.initMethod(symbol2, Type.EMPTY_ARRAY, this.STRING_TYPE());
            symbol2 = this.newMethod(this.STRING_CLASS, Name.fromString("replace"), 0);
            this.initMethod(symbol2, new Type[]{this.CHAR_TYPE(), this.CHAR_TYPE()}, this.STRING_TYPE());
            symbol2 = this.newMethod(this.STRING_CLASS, Name.fromString("toCharArray"), 0);
            this.initMethod(symbol2, Type.EMPTY_ARRAY, this.array_TYPE(this.CHAR_TYPE()));
            symbol = this.newAlias(this.JAVALANG, Names.String, 0);
            this.initAlias(symbol, this.STRING_TYPE());
        }
        this.THROWABLE_THROW = this.newMethod(this.THROWABLE_CLASS, Names.throw_, 2);
        this.THROWABLE_THROW.setInfo(Type.PolyType(Symbol.EMPTY_ARRAY, this.ALL_TYPE()));
        this.PATTERN_WILDCARD = Symbol.NONE.newTerm(0, 0, Names.PATTERN_WILDCARD);
        this.PATTERN_WILDCARD.setInfo(this.ALL_TYPE());
        Type.initializeUnboxedTypes(this);
    }

    public Symbol getModule(String string) {
        TermName termName;
        Scope scope = this.ROOT_CLASS.members();
        int n = 0;
        int n2 = string.indexOf(46, n);
        while (n2 >= 0) {
            termName = Name.fromString(string.substring(n, n2));
            scope = scope.lookup(termName).members();
            n = n2 + 1;
            n2 = string.indexOf(46, n);
        }
        termName = Name.fromString(string.substring(n, string.length()));
        Symbol symbol = scope.lookup(termName);
        if (!symbol.isModule()) {
            Type type = symbol.type();
            if (type.$tag == 4) {
                Type.OverloadedType overloadedType = (Type.OverloadedType)type;
                Symbol[] symbolArray = overloadedType.alts;
                for (int i = 0; i < symbolArray.length && !(symbol = symbolArray[i]).isModule(); ++i) {
                }
            }
        }
        return symbol;
    }

    public Symbol getClass(String string) {
        TermName termName;
        Scope scope = this.ROOT_CLASS.members();
        int n = 0;
        int n2 = string.indexOf(46, n);
        while (n2 >= 0) {
            termName = Name.fromString(string.substring(n, n2));
            scope = scope.lookup(termName).members();
            n = n2 + 1;
            n2 = string.indexOf(46, n);
        }
        termName = Name.fromString(string.substring(n, string.length()));
        Symbol symbol = scope.lookup(termName.toTypeName());
        if (!$assertionsDisabled && symbol.kind == 1) {
            throw new AssertionError((Object)String.valueOf(String.valueOf(String.valueOf(String.valueOf("no class '".concat(String.valueOf(String.valueOf(string))))).concat("'"))));
        }
        return symbol;
    }

    private Symbol newClass(Symbol symbol, Name name, int n) {
        name = name.toTypeName();
        ClassSymbol classSymbol = symbol.newClass(0, n, name);
        symbol.members().enter(classSymbol);
        return classSymbol;
    }

    private Symbol newAlias(Symbol symbol, Name name, int n) {
        name = name.toTypeName();
        Symbol symbol2 = symbol.newTypeAlias(0, n, name);
        symbol.members().enter(symbol2);
        return symbol2;
    }

    private Symbol newMethod(Symbol symbol, Name name, int n) {
        if (!$assertionsDisabled && !symbol.isClassType()) {
            throw new AssertionError((Object)String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(Debug.show(symbol))).concat(" -- "))).concat(String.valueOf(String.valueOf(name))))));
        }
        Symbol symbol2 = symbol.newMethod(0, n, name);
        symbol.members().enterOrOverload(symbol2);
        return symbol2;
    }

    private Symbol newTParam(Symbol symbol, int n, Type type) {
        TypeName typeName = Name.fromString("T".concat(String.valueOf(n))).toTypeName();
        return symbol.newTParam(0, 0, typeName, type);
    }

    private Symbol newVParam(Symbol symbol, int n, Type type) {
        TermName termName = Name.fromString("v".concat(String.valueOf(n)));
        return symbol.newVParam(0, 0, termName, type);
    }

    private Symbol newTypeMethod(Name name, Type type) {
        Symbol symbol = this.ANY_CLASS.newMethod(0, 0, name);
        this.initMethod(symbol, Type.EMPTY_ARRAY, type);
        return symbol;
    }

    private void initClass(Symbol symbol, Type[] typeArray) {
        symbol.setInfo(Type.compoundType(typeArray, new Scope(), symbol));
        symbol.primaryConstructor().setInfo(Type.MethodType(Symbol.EMPTY_ARRAY, symbol.typeConstructor()));
    }

    private void initAlias(Symbol symbol, Type type) {
        symbol.setInfo(type);
        symbol.primaryConstructor().setInfo(Type.MethodType(Symbol.EMPTY_ARRAY, type));
    }

    private void initMethod(Symbol symbol, Type[] typeArray, Type type) {
        Symbol[] symbolArray = new Symbol[typeArray.length];
        for (int i = 0; i < typeArray.length; ++i) {
            symbolArray[i] = this.newVParam(symbol, i, typeArray[i]);
        }
        symbol.setInfo(Type.MethodType(symbolArray, type));
    }

    private Symbol loadTerm(Symbol symbol, Name name) {
        Symbol symbol2 = symbol.lookup(name);
        if (!$assertionsDisabled && !symbol2.isTerm()) {
            throw new AssertionError((Object)String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(symbol)).concat("."))).concat(String.valueOf(String.valueOf(name))))).concat(" -> "))).concat(String.valueOf(String.valueOf(symbol2))))));
        }
        if (!$assertionsDisabled && symbol2.isOverloaded()) {
            throw new AssertionError((Object)String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(symbol)).concat("."))).concat(String.valueOf(String.valueOf(name))))).concat(" -> "))).concat(String.valueOf(String.valueOf(symbol2))))));
        }
        return symbol2;
    }

    private Symbol loadTerm(Symbol symbol, Name name, Type[] typeArray) {
        Symbol symbol2 = symbol.lookup(name);
        if (!$assertionsDisabled && !symbol2.isTerm()) {
            throw new AssertionError((Object)String.valueOf(String.valueOf(Debug.show(symbol, name, typeArray, symbol2))));
        }
        Symbol[] symbolArray = symbol2.alternativeSymbols();
        block4: for (int i = 0; i < symbolArray.length; ++i) {
            Type type = symbolArray[i].type();
            switch (type.$tag) {
                case 5: {
                    Type type2 = (Type.PolyType)type;
                    if (type2.result.$tag != 3) continue block4;
                    Object object = (Type.MethodType)type2.result;
                    Symbol[] symbolArray2 = object.vparams;
                    if (!Type.isSameAs(Symbol.type(symbolArray2), typeArray)) continue block4;
                    return symbolArray[i];
                }
                case 3: {
                    Type type2 = (Type.MethodType)type;
                    Object object = ((Type.MethodType)type2).vparams;
                    if (!Type.isSameAs(Symbol.type(object), typeArray)) continue block4;
                    return symbolArray[i];
                }
            }
        }
        throw Debug.abort(Debug.show(symbol, name, typeArray, symbolArray));
    }

    static {
        $assertionsDisabled = !Class.forName("scalac.symtab.Definitions").desiredAssertionStatus();
    }
}

