/*
 * Decompiled with CFR 0.152.
 */
package scalac.checkers;

import scalac.Global;
import scalac.ast.Tree;
import scalac.checkers.Checker;
import scalac.symtab.Symbol;
import scalac.util.Debug;

public class CheckSymbols
extends Checker {
    public CheckSymbols(Global global) {
        super(global);
    }

    public void check(Tree tree) {
        this.verify(tree, this.implies(tree.hasSymbol(), tree.symbol() != null), "symbol not null", "hasSymbol => symbol not null");
        this.verify(tree, this.implies(tree.hasSymbol(), tree.symbol() != Symbol.NONE), "symbol not NONE", "hasSymbol => symbol not NONE");
        switch (tree.$tag) {
            case 40: {
                int n;
                Symbol symbol = tree.symbol();
                Symbol symbol2 = symbol.owner();
                if (!symbol2.isClass()) break;
                Symbol[] symbolArray = symbol2.nextInfo().members().lookup(symbol.name).alternativeSymbols();
                for (n = 0; n < symbolArray.length && symbol != symbolArray[n]; ++n) {
                }
                this.verify(tree, n < symbolArray.length, String.valueOf(String.valueOf("symbol ".concat(String.valueOf(String.valueOf(Debug.show(symbol)))))).concat(" should be in its owner scope"), Debug.show(symbol2.members()));
                break;
            }
            case 13: {
                int n;
                Symbol symbol = tree.symbol();
                Symbol symbol3 = symbol.owner();
                if (!symbol3.isClass()) break;
                Symbol[] symbolArray = symbol3.nextInfo().members().lookup(symbol.name).alternativeSymbols();
                for (n = 0; n < symbolArray.length && symbol != symbolArray[n]; ++n) {
                }
                this.verify(tree, n < symbolArray.length, String.valueOf(String.valueOf("symbol ".concat(String.valueOf(String.valueOf(Debug.show(symbol)))))).concat(" should be in its owner scope"), Debug.show(symbol3.members()));
            }
        }
    }
}

