/*
 * Decompiled with CFR 0.152.
 */
package scalac.ast;

import java.util.LinkedList;
import scalac.ApplicationError;
import scalac.ast.Tree;
import scalac.symtab.Symbol;
import scalac.symtab.Type;
import scalac.util.Name;
import scalac.util.Names;

public class TreeInfo {
    private static final /* synthetic */ boolean $assertionsDisabled;

    public static boolean isTerm(Tree tree) {
        return tree.isTerm();
    }

    public static boolean isType(Tree tree) {
        return tree.isType();
    }

    public static boolean isOwnerDefinition(Tree tree) {
        switch (tree.$tag) {
            case 24: {
                return true;
            }
            case 10: {
                return true;
            }
            case 22: {
                return true;
            }
            case 13: {
                return true;
            }
            case 19: {
                return true;
            }
        }
        return false;
    }

    public static boolean isDefinition(Tree tree) {
        switch (tree.$tag) {
            case 24: {
                return true;
            }
            case 10: {
                return true;
            }
            case 22: {
                return true;
            }
            case 13: {
                return true;
            }
            case 40: {
                return true;
            }
            case 0: {
                return true;
            }
            case 1: {
                return true;
            }
            case 19: {
                return true;
            }
        }
        return false;
    }

    public static boolean isDeclaration(Tree tree) {
        switch (tree.$tag) {
            case 13: {
                Tree.DefDef defDef = (Tree.DefDef)tree;
                Tree tree2 = defDef.rhs;
                return tree2 == Tree.Empty;
            }
            case 40: {
                Tree.ValDef valDef = (Tree.ValDef)tree;
                Tree tree3 = valDef.rhs;
                return tree3 == Tree.Empty;
            }
            case 0: {
                return true;
            }
            case 1: {
                return true;
            }
        }
        return false;
    }

    public static boolean isPureDef(Tree tree) {
        switch (tree.$tag) {
            case 42: {
                return true;
            }
            case 10: {
                return true;
            }
            case 22: {
                return true;
            }
            case 0: {
                return true;
            }
            case 1: {
                return true;
            }
            case 19: {
                return true;
            }
            case 13: {
                Tree.DefDef defDef = (Tree.DefDef)tree;
                Name name = defDef.name;
                return name != Names.CONSTRUCTOR;
            }
            case 40: {
                Tree.ValDef valDef = (Tree.ValDef)tree;
                int n = valDef.mods;
                Tree tree2 = valDef.rhs;
                return (n & 0x4000) == 0 && TreeInfo.isPureExpr(tree2);
            }
            case 14: {
                Tree.DocDef docDef = (Tree.DocDef)tree;
                Tree tree3 = docDef.definition;
                return TreeInfo.isPureDef(tree3);
            }
        }
        return false;
    }

    public static boolean isPureExpr(Tree tree) {
        switch (tree.$tag) {
            case 42: {
                return true;
            }
            case 34: {
                return true;
            }
            case 31: {
                return true;
            }
            case 17: {
                if (!$assertionsDisabled && tree.type == null) {
                    throw new AssertionError((Object)String.valueOf(String.valueOf(tree.toString())));
                }
                return tree.symbol().isStable();
            }
            case 27: {
                Tree.Select select = (Tree.Select)tree;
                Tree tree2 = select.qualifier;
                return tree.symbol().isStable() && TreeInfo.isPureExpr(tree2);
            }
            case 4: {
                Tree.Apply apply = (Tree.Apply)tree;
                Tree tree3 = apply.fun;
                Tree[] treeArray = apply.args;
                return TreeInfo.isPureExpr(tree3) && treeArray.length == 0;
            }
            case 37: {
                Tree.TypeApply typeApply = (Tree.TypeApply)tree;
                Tree tree4 = typeApply.fun;
                return TreeInfo.isPureExpr(tree4);
            }
            case 39: {
                Tree.Typed typed = (Tree.Typed)tree;
                Tree tree5 = typed.expr;
                return TreeInfo.isPureExpr(tree5);
            }
            case 21: {
                return true;
            }
        }
        return false;
    }

    public static boolean isPureConstr(Tree tree) {
        switch (tree.$tag) {
            case 17: {
                return tree.symbol() != null && tree.symbol().isPrimaryConstructor();
            }
            case 27: {
                return tree.symbol() != null && tree.symbol().isPrimaryConstructor();
            }
            case 37: {
                Tree.TypeApply typeApply = (Tree.TypeApply)tree;
                Tree tree2 = typeApply.fun;
                return TreeInfo.isPureConstr(tree2);
            }
            case 4: {
                Tree.Apply apply = (Tree.Apply)tree;
                Tree tree3 = apply.fun;
                Tree[] treeArray = apply.args;
                return treeArray.length == 0 && TreeInfo.isPureConstr(tree3);
            }
        }
        return false;
    }

    public static boolean isSelfConstrCall(Tree tree) {
        switch (tree.$tag) {
            case 17: {
                Tree.Ident ident = (Tree.Ident)tree;
                Name name = ident.name;
                return name == Names.CONSTRUCTOR;
            }
            case 37: {
                Tree.TypeApply typeApply = (Tree.TypeApply)tree;
                Tree tree2 = typeApply.fun;
                return TreeInfo.isSelfConstrCall(tree2);
            }
            case 4: {
                Tree.Apply apply = (Tree.Apply)tree;
                Tree tree3 = apply.fun;
                return TreeInfo.isSelfConstrCall(tree3);
            }
        }
        return false;
    }

    public static boolean isVarPattern(Tree tree) {
        if (tree.$tag == 17) {
            Tree.Ident ident = (Tree.Ident)tree;
            Name name = ident.name;
            return name.isVariable();
        }
        return false;
    }

    public static boolean isSelf(Tree tree, Symbol symbol) {
        if (tree.$tag == 34) {
            return tree.symbol() == symbol;
        }
        return false;
    }

    public static Symbol methSymbol(Tree tree) {
        Tree tree2 = TreeInfo.methPart(tree);
        if (tree2.hasSymbol()) {
            return tree2.symbol();
        }
        return Symbol.NONE;
    }

    public static Tree methPart(Tree tree) {
        switch (tree.$tag) {
            case 4: {
                Tree.Apply apply = (Tree.Apply)tree;
                Tree tree2 = apply.fun;
                return TreeInfo.methPart(tree2);
            }
            case 37: {
                Tree.TypeApply typeApply = (Tree.TypeApply)tree;
                Tree tree3 = typeApply.fun;
                return TreeInfo.methPart(tree3);
            }
            case 3: {
                Tree.AppliedType appliedType = (Tree.AppliedType)tree;
                Tree tree4 = appliedType.tpe;
                return TreeInfo.methPart(tree4);
            }
        }
        return tree;
    }

    public static Symbol importedSymbol(Tree tree, Name name) {
        if (tree.$tag == 19) {
            Tree.Import import_ = (Tree.Import)tree;
            Name[] nameArray = import_.selectors;
            Type type = tree.symbol().type();
            if (type != Type.ErrorType) {
                boolean bl = false;
                for (int i = 0; i < nameArray.length; i += 2) {
                    if (i + 1 < nameArray.length && name.toTermName() == nameArray[i + 1]) {
                        if (name.isTypeName()) {
                            return type.lookupNonPrivate(nameArray[i].toTypeName());
                        }
                        return type.lookupNonPrivate(nameArray[i]);
                    }
                    if (name.toTermName() == nameArray[i]) {
                        bl = true;
                        continue;
                    }
                    if (nameArray[i] != Names.IMPORT_WILDCARD || bl) continue;
                    return type.lookupNonPrivate(name);
                }
            }
            return Symbol.NONE;
        }
        throw new ApplicationError();
    }

    public static boolean isSequenceValued(Tree tree) {
        return TreeInfo.isSequenceValued(tree, new LinkedList());
    }

    public static boolean isSequenceValued(Tree tree, LinkedList linkedList) {
        switch (tree.$tag) {
            case 7: {
                Tree.Bind bind = (Tree.Bind)tree;
                Tree tree2 = bind.rhs;
                linkedList.addFirst(tree.symbol());
                boolean bl = TreeInfo.isSequenceValued(tree2);
                linkedList.removeFirst();
                return bl;
            }
            case 29: {
                return true;
            }
            case 2: {
                Tree.Alternative alternative = (Tree.Alternative)tree;
                Tree[] treeArray = alternative.trees;
                for (int i = 0; i < treeArray.length; ++i) {
                    if (!TreeInfo.isSequenceValued(treeArray[i])) continue;
                    return true;
                }
                return false;
            }
            case 17: {
                return linkedList.contains(tree.symbol());
            }
            case 4: {
                return false;
            }
            case 21: {
                return false;
            }
            case 27: {
                return false;
            }
            case 39: {
                return false;
            }
        }
        throw new ApplicationError("Unexpected pattern ".concat(String.valueOf(String.valueOf(tree.getClass()))));
    }

    public static boolean isEmptySequence(Tree tree) {
        if (tree.$tag == 29) {
            Tree.Sequence sequence = (Tree.Sequence)tree;
            Tree[] treeArray = sequence.trees;
            return treeArray.length == 0;
        }
        return false;
    }

    public static boolean isRegularPattern(Tree tree) {
        switch (tree.$tag) {
            case 2: {
                return true;
            }
            case 7: {
                Tree.Bind bind = (Tree.Bind)tree;
                Tree tree2 = bind.rhs;
                return TreeInfo.isRegularPattern(tree2);
            }
            case 17: {
                return false;
            }
            case 9: {
                Tree.CaseDef caseDef = (Tree.CaseDef)tree;
                Tree tree3 = caseDef.pat;
                TreeInfo.isRegularPattern(tree3);
                break;
            }
            case 29: {
                return true;
            }
            case 4: {
                Tree.Apply apply = (Tree.Apply)tree;
                Tree[] treeArray = apply.args;
                for (int i = 0; i < treeArray.length; ++i) {
                    if (!TreeInfo.isRegularPattern(treeArray[i])) continue;
                    return true;
                }
            }
            case 21: {
                return false;
            }
        }
        return false;
    }

    public static boolean isNameOfStarPattern(Name name) {
        String string = name.toString();
        return string.indexOf("$") != -1 && !string.startsWith("nest");
    }

    static {
        $assertionsDisabled = !Class.forName("scalac.ast.TreeInfo").desiredAssertionStatus();
    }
}

