/*
 * Decompiled with CFR 0.152.
 */
package scala.tools.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import scala.tools.util.AbstractFile;

public class SourceReader {
    private final CharsetDecoder decoder;
    private final ByteBuffer bytes;
    private CharBuffer chars;
    private static final /* synthetic */ boolean $assertionsDisabled;

    public SourceReader(CharsetDecoder charsetDecoder) {
        this.decoder = charsetDecoder;
        this.bytes = ByteBuffer.allocate(16384);
        this.chars = CharBuffer.allocate(16384);
    }

    public char[] read(String string) throws IOException {
        return this.read(new File(string));
    }

    public char[] read(File file) throws IOException {
        char[] cArray;
        FileChannel fileChannel = new FileInputStream(file).getChannel();
        try {
            cArray = this.read(fileChannel);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            fileChannel.close();
            throw throwable;
        }
        fileChannel.close();
        return cArray;
    }

    public char[] read(AbstractFile abstractFile) throws IOException {
        CharsetDecoder charsetDecoder = this.decoder.reset();
        ByteBuffer byteBuffer = ByteBuffer.wrap(abstractFile.read());
        CharBuffer charBuffer = this.chars;
        ((Buffer)charBuffer).clear();
        return this.terminate(SourceReader.flush(charsetDecoder, SourceReader.decode(charsetDecoder, byteBuffer, charBuffer, true)));
    }

    public char[] read(ReadableByteChannel readableByteChannel) throws IOException {
        CharsetDecoder charsetDecoder = this.decoder.reset();
        ByteBuffer byteBuffer = this.bytes;
        ((Buffer)byteBuffer).clear();
        CharBuffer charBuffer = this.chars;
        ((Buffer)charBuffer).clear();
        boolean bl = false;
        while (!bl) {
            bl = readableByteChannel.read(byteBuffer) < 0;
            ((Buffer)byteBuffer).flip();
            charBuffer = SourceReader.decode(charsetDecoder, byteBuffer, charBuffer, bl);
        }
        return this.terminate(SourceReader.flush(charsetDecoder, charBuffer));
    }

    private char[] terminate(CharBuffer charBuffer) {
        char[] cArray = new char[charBuffer.length()];
        charBuffer.get(cArray);
        this.chars = charBuffer;
        return cArray;
    }

    private static CharBuffer decode(CharsetDecoder charsetDecoder, ByteBuffer byteBuffer, CharBuffer charBuffer, boolean bl) throws IOException {
        CoderResult coderResult;
        while (!(coderResult = charsetDecoder.decode(byteBuffer, charBuffer, bl)).isUnderflow()) {
            if (coderResult.isError()) {
                throw new IOException(coderResult.toString());
            }
            if (!$assertionsDisabled && !coderResult.isOverflow()) {
                throw new AssertionError();
            }
            charBuffer = SourceReader.increaseCapacity(charBuffer);
        }
        byteBuffer.compact();
        return charBuffer;
    }

    private static CharBuffer flush(CharsetDecoder charsetDecoder, CharBuffer charBuffer) throws IOException {
        CoderResult coderResult;
        while (!(coderResult = charsetDecoder.flush(charBuffer)).isUnderflow()) {
            if (coderResult.isError()) {
                throw new IOException(coderResult.toString());
            }
            if (!$assertionsDisabled && !coderResult.isOverflow()) {
                throw new AssertionError();
            }
            charBuffer = SourceReader.increaseCapacity(charBuffer);
        }
        ((Buffer)charBuffer).flip();
        return charBuffer;
    }

    private static CharBuffer increaseCapacity(CharBuffer charBuffer) {
        ((Buffer)charBuffer).flip();
        int n = 2 * charBuffer.capacity();
        return CharBuffer.allocate(n).put(charBuffer);
    }

    static {
        $assertionsDisabled = !Class.forName("scala.tools.util.SourceReader").desiredAssertionStatus();
    }
}

