/*
 * Decompiled with CFR 0.152.
 */
package scala.tools.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.HashSet;
import scala.tools.util.Position;
import scala.tools.util.debug.Debug;

public class Reporter {
    private final BufferedReader reader;
    private final PrintWriter writer;
    private final HashSet positions;
    private int errors;
    private int warnings;
    public boolean nowarn;
    public boolean verbose;
    public boolean prompt;
    public boolean shortname;

    public Reporter() {
        this(new BufferedReader(new InputStreamReader(System.in)), new PrintWriter(System.err, true));
    }

    public Reporter(BufferedReader bufferedReader, PrintWriter printWriter) {
        this.reader = bufferedReader;
        this.writer = printWriter;
        this.positions = new HashSet();
        this.prompt = false;
        this.nowarn = false;
        this.verbose = false;
        this.errors = 0;
    }

    public int errors() {
        return this.errors;
    }

    public int warnings() {
        return this.warnings;
    }

    public String getErrorCountString() {
        return this.getCountString(this.errors, "error");
    }

    public String getWarningCountString() {
        return this.getCountString(this.warnings, "warning");
    }

    public String getCountString(int n, String string) {
        switch (n) {
            case 0: {
                return String.valueOf(String.valueOf("no ".concat(String.valueOf(String.valueOf(string))))).concat("s");
            }
            case 1: {
                return "one ".concat(String.valueOf(String.valueOf(string)));
            }
            case 2: {
                return String.valueOf(String.valueOf("two ".concat(String.valueOf(String.valueOf(string))))).concat("s");
            }
            case 3: {
                return String.valueOf(String.valueOf("three ".concat(String.valueOf(String.valueOf(string))))).concat("s");
            }
            case 4: {
                return String.valueOf(String.valueOf("four ".concat(String.valueOf(String.valueOf(string))))).concat("s");
            }
        }
        return String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(n).concat(" "))).concat(String.valueOf(String.valueOf(string))))).concat("s");
    }

    public void resetCounters() {
        this.errors = 0;
        this.warnings = 0;
    }

    public void report(String string) {
        this.printMessage(string);
    }

    public void inform(String string) {
        if (this.verbose) {
            this.printMessage(string);
        }
    }

    public void error(Position position, String string) {
        boolean bl = this.testAndLog(position);
        if (!bl || this.prompt) {
            this.printError(position, string);
        }
        if (!bl) {
            ++this.errors;
        }
        if (this.prompt) {
            this.failOnDemand();
        }
    }

    public void warning(Position position, String string) {
        boolean bl = this.testAndLog(position);
        if (this.nowarn) {
            return;
        }
        if (!bl || this.prompt) {
            this.printWarning(position, string);
        }
        if (!bl) {
            ++this.warnings;
        }
        if (this.prompt) {
            this.failOnDemand();
        }
    }

    public void printMessage(String string) {
        this.writer.println(string);
    }

    public void printMessage(Position position, String string) {
        if (position != null) {
            string = " ".concat(String.valueOf(String.valueOf(string)));
            if (position.getLineNumber() != 0) {
                string = String.valueOf(String.valueOf(String.valueOf(position.getLineNumber()).concat(":"))).concat(String.valueOf(String.valueOf(string)));
            }
            string = this.shortname ? String.valueOf(String.valueOf(String.valueOf(String.valueOf(position.getName())).concat(":"))).concat(String.valueOf(String.valueOf(string))) : String.valueOf(String.valueOf(String.valueOf(String.valueOf(position.getPath())).concat(":"))).concat(String.valueOf(String.valueOf(string)));
        }
        this.printMessage(string);
        this.printSourceLine(position);
    }

    public void printError(Position position, String string) {
        if (position == null) {
            string = "error: ".concat(String.valueOf(String.valueOf(string)));
        }
        this.printMessage(position, string);
    }

    public void printWarning(Position position, String string) {
        string = "warning: ".concat(String.valueOf(String.valueOf(string)));
        this.printMessage(position, string);
    }

    public void printSummary() {
        if (this.errors() > 0) {
            this.report(String.valueOf(String.valueOf(this.getErrorCountString())).concat(" found"));
        }
        if (this.warnings() > 0) {
            this.report(String.valueOf(String.valueOf(this.getWarningCountString())).concat(" found"));
        }
    }

    public void printSourceLine(Position position) {
        String string;
        String string2 = string = position == null ? null : position.getLineContent();
        if (string == null) {
            return;
        }
        this.printMessage(string);
        this.printColumnMarker(position);
    }

    public void printColumnMarker(Position position) {
        int n = position == null ? 0 : position.getColumnNumber();
        StringBuffer stringBuffer = new StringBuffer(n);
        for (int i = 1; i < n; ++i) {
            stringBuffer.append(' ');
        }
        if (n > 0) {
            stringBuffer.append('^');
        }
        this.printMessage(stringBuffer.toString());
    }

    public void failOnDemand() {
        this.failOnDemand("user abort");
    }

    public void failOnDemand(String string) {
        try {
            while (true) {
                this.writer.print("r)esume, a)bort: ");
                this.writer.flush();
                String string2 = this.reader.readLine();
                if (string2 == null) continue;
                if ("abort".startsWith(string2 = string2.toLowerCase())) {
                    throw new Error(string);
                }
                if ("resume".startsWith(string2)) break;
            }
            return;
        }
        catch (IOException iOException) {
            throw Debug.abort("input read error");
        }
    }

    private boolean testAndLog(Position position) {
        if (position == null) {
            return false;
        }
        if (position.getColumnNumber() == 0) {
            return false;
        }
        if (this.positions.contains(position)) {
            return true;
        }
        this.positions.add(position);
        return false;
    }
}

