/*
 * Decompiled with CFR 0.152.
 */
package scala.tools.scalai;

import java.io.PrintWriter;
import scala.runtime.InterpreterSupport;
import scala.tools.scalai.EvaluatorException;
import scala.tools.scalai.EvaluatorResult;
import scala.tools.scalai.Interpreter;
import scalac.util.Debug;

public class InterpreterPrinter
implements InterpreterSupport.DefinitionPrinter {
    private final Interpreter interpreter;
    private final PrintWriter writer;

    public InterpreterPrinter(Interpreter interpreter, PrintWriter printWriter) {
        this.interpreter = interpreter;
        this.writer = printWriter;
    }

    public void showDefinition(String string) {
        this.writer.println(string);
    }

    public void showValueDefinition(String string, Object object) {
        EvaluatorResult evaluatorResult = this.interpreter.toString(object, null);
        switch (evaluatorResult.$tag) {
            case 1: {
                EvaluatorResult.Value value = (EvaluatorResult.Value)evaluatorResult;
                Object object2 = value.value;
                this.writer.println(String.valueOf(String.valueOf(String.valueOf(String.valueOf(string)).concat(" = "))).concat(String.valueOf(String.valueOf(object2))));
                this.writer.flush();
                return;
            }
            case 0: {
                EvaluatorResult.Error error = (EvaluatorResult.Error)evaluatorResult;
                EvaluatorException evaluatorException = error.exception;
                this.writer.print(String.valueOf(String.valueOf(string)).concat(" = "));
                this.writer.print(evaluatorException.getScalaErrorMessage(true));
                this.writer.flush();
                return;
            }
        }
        throw Debug.abort("illegal case", evaluatorResult);
    }

    public void showResult(EvaluatorResult evaluatorResult, boolean bl) {
        switch (evaluatorResult.$tag) {
            case 2: {
                return;
            }
            case 1: {
                EvaluatorResult.Value value = (EvaluatorResult.Value)evaluatorResult;
                Object object = value.value;
                String string = value.type;
                if (bl) {
                    if (object instanceof String) {
                        this.writer.println(String.valueOf(String.valueOf(String.valueOf(String.valueOf(object)).concat(": "))).concat(String.valueOf(String.valueOf(string))));
                    } else {
                        this.showResult(this.interpreter.toString(object, string), bl);
                    }
                }
                this.writer.flush();
                return;
            }
            case 0: {
                EvaluatorResult.Error error = (EvaluatorResult.Error)evaluatorResult;
                EvaluatorException evaluatorException = error.exception;
                String string = Thread.currentThread().getName();
                this.writer.print(String.valueOf(String.valueOf("Exception in thread \"".concat(String.valueOf(String.valueOf(string))))).concat("\" "));
                this.writer.print(evaluatorException.getScalaErrorMessage(true));
                this.writer.flush();
                return;
            }
        }
        throw Debug.abort("illegal case", evaluatorResult);
    }
}

