/*
 * Decompiled with CFR 0.152.
 */
package scala.runtime;

import scala.Array;
import scala.Boolean;
import scala.Byte;
import scala.Char;
import scala.Double;
import scala.Float;
import scala.Int;
import scala.Long;
import scala.Short;
import scala.Unit;
import scala.runtime.BArray;
import scala.runtime.BValue;
import scala.runtime.CArray;
import scala.runtime.CValue;
import scala.runtime.DArray;
import scala.runtime.DValue;
import scala.runtime.FArray;
import scala.runtime.FValue;
import scala.runtime.IArray;
import scala.runtime.IValue;
import scala.runtime.LArray;
import scala.runtime.LValue;
import scala.runtime.OArray;
import scala.runtime.SArray;
import scala.runtime.SValue;
import scala.runtime.UValue;
import scala.runtime.ZArray;
import scala.runtime.ZValue;

public abstract class RunTime {
    private static final int BITS = 8;
    private static final int ARRAY_SIZE = 512;
    private static final int INDEX_MASK = 511;
    private static final int CHECK_MASK = -256;
    private static final UValue uvalue = new UValue();
    private static final ZValue zvalue_f = new ZValue(false);
    private static final ZValue zvalue_t = new ZValue(true);
    private static final BValue[] bvalue = new BValue[256];
    private static final SValue[] svalue = new SValue[512];
    private static final CValue[] cvalue = new CValue[256];
    private static final IValue[] ivalue = new IValue[512];
    private static final LValue[] lvalue = new LValue[512];
    private static ClassLoader loader;

    public static ClassLoader getClassLoader() {
        return loader;
    }

    public static void setClassLoader(ClassLoader classLoader) {
        loader = classLoader;
    }

    public static Unit box_uvalue() {
        return uvalue;
    }

    public static Boolean box_zvalue(boolean bl) {
        return bl ? zvalue_t : zvalue_f;
    }

    public static Byte box_bvalue(byte by) {
        return bvalue[by & 0xFF];
    }

    public static Short box_svalue(short s) {
        int n = s & 0xFFFFFF00;
        if (n == 0 || n == -256) {
            return svalue[s & 0x1FF];
        }
        return new SValue(s);
    }

    public static Char box_cvalue(char c) {
        int n = c & 0xFFFFFF00;
        if (n == 0) {
            return cvalue[c & 0x1FF];
        }
        return new CValue(c);
    }

    public static Int box_ivalue(int n) {
        int n2 = n & 0xFFFFFF00;
        if (n2 == 0 || n2 == -256) {
            return ivalue[n & 0x1FF];
        }
        return new IValue(n);
    }

    public static Long box_lvalue(long l) {
        long l2 = l & 0xFFFFFFFFFFFFFF00L;
        if (l2 == 0L || l2 == -256L) {
            return lvalue[(int)l & 0x1FF];
        }
        return new LValue(l);
    }

    public static Float box_fvalue(float f) {
        return new FValue(f);
    }

    public static Double box_dvalue(double d) {
        return new DValue(d);
    }

    public static Array box_zarray(boolean[] blArray) {
        return new ZArray(blArray);
    }

    public static Array box_barray(byte[] byArray) {
        return new BArray(byArray);
    }

    public static Array box_sarray(short[] sArray) {
        return new SArray(sArray);
    }

    public static Array box_carray(char[] cArray) {
        return new CArray(cArray);
    }

    public static Array box_iarray(int[] nArray) {
        return new IArray(nArray);
    }

    public static Array box_larray(long[] lArray) {
        return new LArray(lArray);
    }

    public static Array box_farray(float[] fArray) {
        return new FArray(fArray);
    }

    public static Array box_darray(double[] dArray) {
        return new DArray(dArray);
    }

    public static Array box_oarray(Object[] objectArray) {
        return new OArray(objectArray);
    }

    public static Array box__array(Object object) {
        if (object == null) {
            return RunTime.box_oarray((Object[])object);
        }
        if (object instanceof boolean[]) {
            return RunTime.box_zarray((boolean[])object);
        }
        if (object instanceof byte[]) {
            return RunTime.box_barray((byte[])object);
        }
        if (object instanceof short[]) {
            return RunTime.box_sarray((short[])object);
        }
        if (object instanceof char[]) {
            return RunTime.box_carray((char[])object);
        }
        if (object instanceof int[]) {
            return RunTime.box_iarray((int[])object);
        }
        if (object instanceof long[]) {
            return RunTime.box_larray((long[])object);
        }
        if (object instanceof float[]) {
            return RunTime.box_farray((float[])object);
        }
        if (object instanceof double[]) {
            return RunTime.box_darray((double[])object);
        }
        if (object instanceof Object[]) {
            return RunTime.box_oarray((Object[])object);
        }
        throw new ClassCastException(String.valueOf(String.valueOf(object.getClass())).concat(" is not an array class"));
    }

    public static void unbox_uvalue(Unit unit) {
        unit.value();
    }

    public static boolean unbox_zvalue(Boolean boolean_) {
        return boolean_.value;
    }

    public static byte unbox_bvalue(Byte byteVal) {
        return byteVal.value;
    }

    public static short unbox_svalue(Short shortVal) {
        return shortVal.value;
    }

    public static char unbox_cvalue(Char char_) {
        return char_.value;
    }

    public static int unbox_ivalue(Int intVal) {
        return intVal.value;
    }

    public static long unbox_lvalue(Long longVal) {
        return longVal.value;
    }

    public static float unbox_fvalue(Float float_) {
        return float_.value;
    }

    public static double unbox_dvalue(Double double_) {
        return double_.value;
    }

    public static boolean[] unbox_zarray(Array array) {
        return array == null ? null : ((ZArray)array).value;
    }

    public static byte[] unbox_barray(Array array) {
        return array == null ? null : ((BArray)array).value;
    }

    public static short[] unbox_sarray(Array array) {
        return array == null ? null : ((SArray)array).value;
    }

    public static char[] unbox_carray(Array array) {
        return array == null ? null : ((CArray)array).value;
    }

    public static int[] unbox_iarray(Array array) {
        return array == null ? null : ((IArray)array).value;
    }

    public static long[] unbox_larray(Array array) {
        return array == null ? null : ((LArray)array).value;
    }

    public static float[] unbox_farray(Array array) {
        return array == null ? null : ((FArray)array).value;
    }

    public static double[] unbox_darray(Array array) {
        return array == null ? null : ((DArray)array).value;
    }

    public static Object[] unbox_oarray(Array array) {
        return array == null ? null : ((OArray)array).value;
    }

    public static Object unbox__array(Array array) {
        return array == null ? null : array.value();
    }

    public static byte b2b(byte by) {
        return by;
    }

    public static short b2s(byte by) {
        return by;
    }

    public static char b2c(byte by) {
        return (char)by;
    }

    public static int b2i(byte by) {
        return by;
    }

    public static long b2l(byte by) {
        return by;
    }

    public static float b2f(byte by) {
        return by;
    }

    public static double b2d(byte by) {
        return by;
    }

    public static byte s2b(short s) {
        return (byte)s;
    }

    public static short s2s(short s) {
        return s;
    }

    public static char s2c(short s) {
        return (char)s;
    }

    public static int s2i(short s) {
        return s;
    }

    public static long s2l(short s) {
        return s;
    }

    public static float s2f(short s) {
        return s;
    }

    public static double s2d(short s) {
        return s;
    }

    public static byte c2b(char c) {
        return (byte)c;
    }

    public static short c2s(char c) {
        return (short)c;
    }

    public static char c2c(char c) {
        return c;
    }

    public static int c2i(char c) {
        return c;
    }

    public static long c2l(char c) {
        return c;
    }

    public static float c2f(char c) {
        return c;
    }

    public static double c2d(char c) {
        return c;
    }

    public static byte i2b(int n) {
        return (byte)n;
    }

    public static short i2s(int n) {
        return (short)n;
    }

    public static char i2c(int n) {
        return (char)n;
    }

    public static int i2i(int n) {
        return n;
    }

    public static long i2l(int n) {
        return n;
    }

    public static float i2f(int n) {
        return n;
    }

    public static double i2d(int n) {
        return n;
    }

    public static byte l2b(long l) {
        return (byte)l;
    }

    public static short l2s(long l) {
        return (short)l;
    }

    public static char l2c(long l) {
        return (char)l;
    }

    public static int l2i(long l) {
        return (int)l;
    }

    public static long l2l(long l) {
        return l;
    }

    public static float l2f(long l) {
        return l;
    }

    public static double l2d(long l) {
        return l;
    }

    public static byte f2b(float f) {
        return (byte)f;
    }

    public static short f2s(float f) {
        return (short)f;
    }

    public static char f2c(float f) {
        return (char)f;
    }

    public static int f2i(float f) {
        return (int)f;
    }

    public static long f2l(float f) {
        return (long)f;
    }

    public static float f2f(float f) {
        return f;
    }

    public static double f2d(float f) {
        return f;
    }

    public static byte d2b(double d) {
        return (byte)d;
    }

    public static short d2s(double d) {
        return (short)d;
    }

    public static char d2c(double d) {
        return (char)d;
    }

    public static int d2i(double d) {
        return (int)d;
    }

    public static long d2l(double d) {
        return (long)d;
    }

    public static float d2f(double d) {
        return (float)d;
    }

    public static double d2d(double d) {
        return d;
    }

    public static boolean[] zarray(int n) {
        return new boolean[n];
    }

    public static byte[] barray(int n) {
        return new byte[n];
    }

    public static short[] sarray(int n) {
        return new short[n];
    }

    public static char[] carray(int n) {
        return new char[n];
    }

    public static int[] iarray(int n) {
        return new int[n];
    }

    public static long[] larray(int n) {
        return new long[n];
    }

    public static float[] farray(int n) {
        return new float[n];
    }

    public static double[] darray(int n) {
        return new double[n];
    }

    public static Object oarray(int n, String string) {
        try {
            Class<?> clazz = Class.forName(string, false, loader);
            return java.lang.reflect.Array.newInstance(clazz, n);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new Error(classNotFoundException.toString());
        }
    }

    public static int zarray_length(boolean[] blArray) {
        return blArray.length;
    }

    public static int barray_length(byte[] byArray) {
        return byArray.length;
    }

    public static int sarray_length(short[] sArray) {
        return sArray.length;
    }

    public static int carray_length(char[] cArray) {
        return cArray.length;
    }

    public static int iarray_length(int[] nArray) {
        return nArray.length;
    }

    public static int larray_length(long[] lArray) {
        return lArray.length;
    }

    public static int farray_length(float[] fArray) {
        return fArray.length;
    }

    public static int darray_length(double[] dArray) {
        return dArray.length;
    }

    public static int oarray_length(Object[] objectArray) {
        return objectArray.length;
    }

    public static boolean zarray_get(boolean[] blArray, int n) {
        return blArray[n];
    }

    public static byte barray_get(byte[] byArray, int n) {
        return byArray[n];
    }

    public static short sarray_get(short[] sArray, int n) {
        return sArray[n];
    }

    public static char carray_get(char[] cArray, int n) {
        return cArray[n];
    }

    public static int iarray_get(int[] nArray, int n) {
        return nArray[n];
    }

    public static long larray_get(long[] lArray, int n) {
        return lArray[n];
    }

    public static float farray_get(float[] fArray, int n) {
        return fArray[n];
    }

    public static double darray_get(double[] dArray, int n) {
        return dArray[n];
    }

    public static Object oarray_get(Object[] objectArray, int n) {
        return objectArray[n];
    }

    public static void zarray_set(boolean[] blArray, int n, boolean bl) {
        blArray[n] = bl;
    }

    public static void barray_set(byte[] byArray, int n, byte by) {
        byArray[n] = by;
    }

    public static void sarray_set(short[] sArray, int n, short s) {
        sArray[n] = s;
    }

    public static void carray_set(char[] cArray, int n, char c) {
        cArray[n] = c;
    }

    public static void iarray_set(int[] nArray, int n, int n2) {
        nArray[n] = n2;
    }

    public static void larray_set(long[] lArray, int n, long l) {
        lArray[n] = l;
    }

    public static void farray_set(float[] fArray, int n, float f) {
        fArray[n] = f;
    }

    public static void darray_set(double[] dArray, int n, double d) {
        dArray[n] = d;
    }

    public static void oarray_set(Object[] objectArray, int n, Object object) {
        objectArray[n] = object;
    }

    static {
        for (int i = 0; i < bvalue.length; ++i) {
            RunTime.bvalue[i] = new BValue((byte)i);
        }
        for (int i = 0; i < 256; ++i) {
            RunTime.svalue[i] = new SValue((short)i);
            RunTime.cvalue[i] = new CValue((char)i);
            RunTime.ivalue[i] = new IValue(i);
            RunTime.lvalue[i] = new LValue(i);
            RunTime.svalue[i + 256] = new SValue((short)(0xFFFFFF00 | i));
            RunTime.ivalue[i + 256] = new IValue(0xFFFFFF00 | i);
            RunTime.lvalue[i + 256] = new LValue(0xFFFFFF00 | i);
        }
        loader = ClassLoader.getSystemClassLoader();
    }
}

