/*
 * Decompiled with CFR 0.152.
 */
package scalac.util;

import java.io.IOException;
import scala.tools.util.AbstractFile;

public class AbstractFileReader {
    public byte[] buf;
    public int bp;
    public final String path;

    public AbstractFileReader(AbstractFile abstractFile) throws IOException {
        this.buf = abstractFile.read();
        this.bp = 0;
        this.path = abstractFile.getPath();
    }

    public byte byteAt(int n) {
        return this.buf[n];
    }

    public byte nextByte() {
        return this.buf[this.bp++];
    }

    public byte[] nextBytes(int n) {
        byte[] byArray = new byte[n];
        System.arraycopy(this.buf, this.bp, byArray, 0, n);
        this.bp += n;
        return byArray;
    }

    public char nextChar() {
        return (char)(((this.buf[this.bp++] & 0xFF) << 8) + (this.buf[this.bp++] & 0xFF));
    }

    public int nextInt() {
        return ((this.buf[this.bp++] & 0xFF) << 24) + ((this.buf[this.bp++] & 0xFF) << 16) + ((this.buf[this.bp++] & 0xFF) << 8) + (this.buf[this.bp++] & 0xFF);
    }

    public char getChar(int n) {
        return (char)(((this.buf[n] & 0xFF) << 8) + (this.buf[n + 1] & 0xFF));
    }

    public int getInt(int n) {
        return ((this.buf[n] & 0xFF) << 24) + ((this.buf[n + 1] & 0xFF) << 16) + ((this.buf[n + 2] & 0xFF) << 8) + (this.buf[n + 3] & 0xFF);
    }

    public long getLong(int n) {
        return ((long)this.getInt(n) << 32) + ((long)this.getInt(n + 4) & 0xFFFFFFFFL);
    }

    public strictfp float getFloat(int n) {
        return Float.intBitsToFloat(this.getInt(n));
    }

    public strictfp double getDouble(int n) {
        return Double.longBitsToDouble(this.getLong(n));
    }

    public void skip(int n) {
        this.bp += n;
    }
}

