/*
 * Decompiled with CFR 0.152.
 */
package scalac.transformer.matching;

import scala.tools.util.Position;
import scalac.ApplicationError;
import scalac.CompilationUnit;
import scalac.Global;
import scalac.ast.Tree;
import scalac.atree.AConstant;
import scalac.symtab.ClassSymbol;
import scalac.symtab.Symbol;
import scalac.symtab.Type;
import scalac.transformer.matching.CaseEnv;
import scalac.transformer.matching.CodeFactory;
import scalac.transformer.matching.PatternNode;
import scalac.transformer.matching.PatternNodeCreator;
import scalac.transformer.matching.PatternTool;
import scalac.util.Name;
import scalac.util.Names;

public class PatternMatcher
extends PatternTool {
    protected boolean optimize = true;
    protected boolean delegateSequenceMatching = false;
    protected boolean doBinding = true;
    protected Symbol owner;
    protected Tree selector;
    protected PatternNode root;
    protected Symbol resultVar;
    protected CodeFactory cf;
    protected PatternNodeCreator mk;
    private static final /* synthetic */ boolean $assertionsDisabled;

    public PatternMatcher(CompilationUnit compilationUnit, Tree tree, Symbol symbol, Type type) {
        super(compilationUnit);
        this.initialize(tree, symbol, type, true);
    }

    protected PatternMatcher(CompilationUnit compilationUnit) {
        super(compilationUnit);
    }

    protected void initialize(Tree tree, Symbol symbol, Type type, boolean bl) {
        this.mk = new PatternNodeCreator(this.unit, symbol);
        this.cf = new CodeFactory(this.unit, tree.pos);
        this.root = this.mk.ConstrPat(tree.pos, tree.type.widen());
        this.root.and = this.mk.Header(tree.pos, tree.type.widen(), this.gen.Ident(tree.pos, this.root.symbol()));
        this.resultVar = symbol.newVariable(tree.pos, 16384, this.fresh.newName(PatternTool.RESULT_N));
        this.resultVar.setType(type);
        this.owner = symbol;
        this.selector = tree;
        this.optimize &= this.unit.global.target == Global.TARGET_JVM;
        this.doBinding = bl;
    }

    public void print() {
        this.print(this.root.and, "");
    }

    public void print(PatternNode patternNode, String string) {
        if (patternNode == null) {
            System.out.println(String.valueOf(String.valueOf(string)).concat("NULL"));
        } else {
            switch (patternNode.$tag) {
                case 5: {
                    PatternNode.Header header = (PatternNode.Header)patternNode;
                    Tree tree = header.selector;
                    PatternNode.Header header2 = header.next;
                    System.out.println(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(string)).concat("HEADER("))).concat(String.valueOf(String.valueOf(patternNode.type))))).concat(", "))).concat(String.valueOf(String.valueOf(tree))))).concat(")"));
                    this.print(patternNode.or, String.valueOf(String.valueOf(string)).concat("|"));
                    if (header2 == null) break;
                    this.print(header2, string);
                    break;
                }
                case 3: {
                    PatternNode.ConstrPat constrPat = (PatternNode.ConstrPat)patternNode;
                    Symbol symbol = constrPat.casted;
                    String string2 = String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf("-- ".concat(String.valueOf(String.valueOf(patternNode.type.symbol().name))))).concat("("))).concat(String.valueOf(String.valueOf(patternNode.type))))).concat(", "))).concat(String.valueOf(String.valueOf(symbol))))).concat(") -> ");
                    String string3 = string;
                    string = patternNode.or != null ? string : String.valueOf(String.valueOf(string.substring(0, string.length() - 1))).concat(" ");
                    for (int i = 0; i < string2.length(); ++i) {
                        string = String.valueOf(String.valueOf(string)).concat(" ");
                    }
                    System.out.println(String.valueOf(String.valueOf(string3)).concat(String.valueOf(String.valueOf(string2))));
                    this.print(patternNode.and, string);
                    if (patternNode.or == null) break;
                    this.print(patternNode.or, string3);
                    break;
                }
                case 7: {
                    PatternNode.SequencePat sequencePat = (PatternNode.SequencePat)patternNode;
                    Symbol symbol = sequencePat.casted;
                    int n = sequencePat.len;
                    String string4 = String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf("-- ".concat(String.valueOf(String.valueOf(patternNode.type.symbol().name))))).concat("("))).concat(String.valueOf(String.valueOf(patternNode.type))))).concat(", "))).concat(String.valueOf(String.valueOf(symbol))))).concat(", "))).concat(String.valueOf(n)))).concat(") -> ");
                    String string5 = string;
                    string = patternNode.or != null ? string : String.valueOf(String.valueOf(string.substring(0, string.length() - 1))).concat(" ");
                    for (int i = 0; i < string4.length(); ++i) {
                        string = String.valueOf(String.valueOf(string)).concat(" ");
                    }
                    System.out.println(String.valueOf(String.valueOf(string5)).concat(String.valueOf(String.valueOf(string4))));
                    this.print(patternNode.and, string);
                    if (patternNode.or == null) break;
                    this.print(patternNode.or, string5);
                    break;
                }
                case 4: {
                    System.out.println(String.valueOf(String.valueOf(string)).concat("-- _ -> "));
                    this.print(patternNode.and, String.valueOf(String.valueOf(string.substring(0, string.length() - 1))).concat("         "));
                    if (patternNode.or == null) break;
                    this.print(patternNode.or, string);
                    break;
                }
                case 2: {
                    PatternNode.ConstantPat constantPat = (PatternNode.ConstantPat)patternNode;
                    AConstant aConstant = constantPat.value;
                    String string6 = String.valueOf(String.valueOf("-- CONST(".concat(String.valueOf(String.valueOf(aConstant))))).concat(") -> ");
                    String string7 = string;
                    string = patternNode.or != null ? string : String.valueOf(String.valueOf(string.substring(0, string.length() - 1))).concat(" ");
                    for (int i = 0; i < string6.length(); ++i) {
                        string = String.valueOf(String.valueOf(string)).concat(" ");
                    }
                    System.out.println(String.valueOf(String.valueOf(string7)).concat(String.valueOf(String.valueOf(string6))));
                    this.print(patternNode.and, string);
                    if (patternNode.or == null) break;
                    this.print(patternNode.or, string7);
                    break;
                }
                case 8: {
                    PatternNode.VariablePat variablePat = (PatternNode.VariablePat)patternNode;
                    Tree tree = variablePat.tree;
                    String string8 = String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf("-- STABLEID(".concat(String.valueOf(String.valueOf(tree))))).concat(": "))).concat(String.valueOf(String.valueOf(patternNode.type))))).concat(") -> ");
                    String string9 = string;
                    string = patternNode.or != null ? string : String.valueOf(String.valueOf(string.substring(0, string.length() - 1))).concat(" ");
                    for (int i = 0; i < string8.length(); ++i) {
                        string = String.valueOf(String.valueOf(string)).concat(" ");
                    }
                    System.out.println(String.valueOf(String.valueOf(string9)).concat(String.valueOf(String.valueOf(string8))));
                    this.print(patternNode.and, string);
                    if (patternNode.or == null) break;
                    this.print(patternNode.or, string9);
                    break;
                }
                case 0: {
                    PatternNode.AltPat altPat = (PatternNode.AltPat)patternNode;
                    PatternNode.Header header = altPat.subheader;
                    System.out.println(String.valueOf(String.valueOf(string)).concat("-- ALTERNATIVES:"));
                    this.print(header, String.valueOf(String.valueOf(string)).concat("   * "));
                    this.print(patternNode.and, String.valueOf(String.valueOf(string)).concat("   * -> "));
                    if (patternNode.or == null) break;
                    this.print(patternNode.or, string);
                    break;
                }
                case 1: {
                    PatternNode.Body body = (PatternNode.Body)patternNode;
                    Tree[] treeArray = body.guard;
                    Tree[] treeArray2 = body.body;
                    if (treeArray.length == 0 && treeArray2.length == 0) {
                        System.out.println(String.valueOf(String.valueOf(string)).concat("true"));
                        break;
                    }
                    System.out.println(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(string)).concat("BODY("))).concat(String.valueOf(treeArray2.length)))).concat(")"));
                }
            }
        }
    }

    public void construct(Tree[] treeArray) {
        for (int i = 0; i < treeArray.length; ++i) {
            this.enter(treeArray[i]);
        }
    }

    protected void enter(Tree tree) {
        block4: {
            if (tree.$tag != 9) break block4;
            Tree.CaseDef caseDef = (Tree.CaseDef)tree;
            Tree tree2 = caseDef.pat;
            Tree tree3 = caseDef.guard;
            Tree tree4 = caseDef.body;
            CaseEnv caseEnv = new CaseEnv(this.owner, this.unit);
            PatternNode patternNode = this.enter1(tree2, -1, this.root, this.root.symbol(), caseEnv);
            if (patternNode.and == null) {
                patternNode.and = this.mk.Body(tree.pos, caseEnv.boundVars(), tree3, tree4);
            } else if (patternNode.and instanceof PatternNode.Body) {
                this.updateBody((PatternNode.Body)patternNode.and, caseEnv.boundVars(), tree3, tree4);
            } else {
                this.unit.error(tree2.pos, "duplicate case");
            }
        }
    }

    protected void updateBody(PatternNode.Body body, Tree.ValDef[] valDefArray, Tree tree, Tree tree2) {
        if (body.guard[body.guard.length - 1] != Tree.Empty) {
            Tree.ValDef[][] valDefArrayArray = new Tree.ValDef[body.bound.length + 1][];
            Tree[] treeArray = new Tree[body.guard.length + 1];
            Tree[] treeArray2 = new Tree[body.body.length + 1];
            System.arraycopy(body.bound, 0, valDefArrayArray, 0, body.bound.length);
            System.arraycopy(body.guard, 0, treeArray, 0, body.guard.length);
            System.arraycopy(body.body, 0, treeArray2, 0, body.body.length);
            valDefArrayArray[valDefArrayArray.length - 1] = valDefArray;
            treeArray[treeArray.length - 1] = tree;
            treeArray2[treeArray2.length - 1] = tree2;
            body.bound = valDefArrayArray;
            body.guard = treeArray;
            body.body = treeArray2;
        }
    }

    protected Tree[] patternArgs(Tree tree) {
        switch (tree.$tag) {
            case 7: {
                Tree.Bind bind = (Tree.Bind)tree;
                Tree tree2 = bind.rhs;
                return this.patternArgs(tree2);
            }
            case 4: {
                Tree.Apply apply = (Tree.Apply)tree;
                Tree[] treeArray = apply.args;
                if (this.isSeqApply((Tree.Apply)tree) && !this.delegateSequenceMatching) {
                    Tree tree3 = treeArray[0];
                    if (tree3.$tag == 29) {
                        Tree.Sequence sequence = (Tree.Sequence)tree3;
                        Tree[] treeArray2 = sequence.trees;
                        return treeArray2;
                    }
                }
                return treeArray;
            }
            case 29: {
                Tree.Sequence sequence = (Tree.Sequence)tree;
                Tree[] treeArray = sequence.trees;
                if (!this.delegateSequenceMatching) {
                    return treeArray;
                }
                return Tree.EMPTY_ARRAY;
            }
        }
        return Tree.EMPTY_ARRAY;
    }

    protected boolean isSeqApply(Tree.Apply apply) {
        if (apply.args.length == 1 && (apply.type.symbol().flags & 0x40) == 0) {
            Tree tree = apply.args[0];
            return tree.$tag == 29;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected PatternNode patternNode(Tree tree, PatternNode.Header header, CaseEnv caseEnv) {
        switch (tree.$tag) {
            case 7: {
                Object object;
                Tree tree2;
                Tree.Bind bind = (Tree.Bind)tree;
                switch (bind.rhs.$tag) {
                    case 39: {
                        tree2 = (Tree.Typed)bind.rhs;
                        if (((Tree.Typed)tree2).expr.$tag != 17) break;
                        object = (Tree.Ident)((Tree.Typed)tree2).expr;
                        if (!((Tree.Ident)object).name.equals(Names.PATTERN_WILDCARD)) break;
                        Tree tree3 = ((Tree.Typed)tree2).tpe;
                        if (header.type.isSubType(tree3.type)) {
                            PatternNode.DefaultPat defaultPat = PatternNodeCreator.DefaultPat(tree.pos, tree3.type);
                            caseEnv.newBoundVar(tree.symbol(), tree.type, header.selector);
                            return defaultPat;
                        }
                        PatternNode.ConstrPat constrPat = this.mk.ConstrPat(tree.pos, tree3.type);
                        caseEnv.newBoundVar(tree.symbol(), tree.type, this.gen.Ident(tree.pos, constrPat.casted));
                        return constrPat;
                    }
                    case 17: {
                        tree2 = (Tree.Ident)bind.rhs;
                        if (!((Tree.Ident)tree2).name.equals(Names.PATTERN_WILDCARD)) break;
                        PatternNode.DefaultPat defaultPat = PatternNodeCreator.DefaultPat(tree.pos, header.type);
                        if (caseEnv == null || tree.symbol() == this.defs.PATTERN_WILDCARD) return defaultPat;
                        caseEnv.newBoundVar(tree.symbol(), tree.type, header.selector);
                        return defaultPat;
                    }
                }
                tree2 = bind.rhs;
                object = this.patternNode(tree2, header, caseEnv);
                if (caseEnv == null || tree.symbol() == this.defs.PATTERN_WILDCARD) return object;
                Symbol symbol = ((PatternNode)object).symbol();
                Tree tree4 = symbol == Symbol.NONE ? header.selector : this.gen.Ident(tree.pos, symbol);
                caseEnv.newBoundVar(tree.symbol(), tree.type, tree4);
                return object;
            }
            case 4: {
                Tree.Apply apply = (Tree.Apply)tree;
                Tree tree5 = apply.fun;
                Tree[] treeArray = apply.args;
                if (this.isSeqApply((Tree.Apply)tree)) {
                    if (!this.delegateSequenceMatching) {
                        Tree tree6 = treeArray[0];
                        if (tree6.$tag != 29) return this.mk.ConstrPat(tree.pos, tree.type);
                        Tree.Sequence sequence = (Tree.Sequence)tree6;
                        Tree[] treeArray2 = sequence.trees;
                        return this.mk.SequencePat(tree.pos, tree.type, treeArray2.length);
                    }
                    PatternNode.ConstrPat constrPat = this.mk.ConstrPat(tree.pos, tree.type);
                    constrPat.and = this.mk.Header(tree.pos, header.type, header.selector);
                    constrPat.and.and = this.mk.SeqContainerPat(tree.pos, tree.type, treeArray[0]);
                    return constrPat;
                }
                if (tree5.symbol() == null || !tree5.symbol().isStable() || tree5.symbol().isModule() && (tree5.symbol().flags & 0x40) != 0) return this.mk.ConstrPat(tree.pos, tree.type);
                return PatternNodeCreator.VariablePat(tree.pos, tree);
            }
            case 39: {
                PatternNode.DefaultPat defaultPat;
                Tree.Ident ident;
                Tree.Typed typed = (Tree.Typed)tree;
                if (typed.expr.$tag != 17) throw new ApplicationError(String.valueOf(String.valueOf(String.valueOf(String.valueOf("unit = ".concat(String.valueOf(String.valueOf(this.unit))))).concat("; tree = "))).concat(String.valueOf(String.valueOf(tree))));
                Tree.Ident ident2 = ident = (Tree.Ident)typed.expr;
                Tree tree7 = typed.tpe;
                boolean bl = header.type.isSubType(tree7.type);
                PatternNode patternNode = defaultPat = bl ? PatternNodeCreator.DefaultPat(tree.pos, tree7.type) : this.mk.ConstrPat(tree.pos, tree7.type);
                if (caseEnv == null || ident2.symbol() == this.defs.PATTERN_WILDCARD) return defaultPat;
                if (defaultPat.$tag == 3) {
                    PatternNode.ConstrPat constrPat = (PatternNode.ConstrPat)((Object)defaultPat);
                    Symbol symbol = constrPat.casted;
                    caseEnv.newBoundVar(((Tree.Typed)tree).expr.symbol(), tree7.type, this.gen.Ident(tree.pos, symbol));
                    return defaultPat;
                } else {
                    caseEnv.newBoundVar(((Tree.Typed)tree).expr.symbol(), tree7.type, bl ? header.selector : this.gen.Ident(tree.pos, ((PatternNode.ConstrPat)((Object)defaultPat)).casted));
                }
                return defaultPat;
            }
            case 17: {
                Tree.Ident ident = (Tree.Ident)tree;
                Name name = ident.name;
                if (tree.symbol() == this.defs.PATTERN_WILDCARD) {
                    return PatternNodeCreator.DefaultPat(tree.pos, header.type);
                }
                if (tree.symbol().isPrimaryConstructor()) {
                    if ($assertionsDisabled) return this.mk.ConstrPat(tree.pos, tree.type);
                    throw new AssertionError();
                }
                if (!name.isVariable()) return PatternNodeCreator.VariablePat(tree.pos, tree);
                if (!$assertionsDisabled) {
                    throw new AssertionError((Object)String.valueOf(String.valueOf("encountered ident:".concat(String.valueOf(String.valueOf(name))))));
                }
                if (caseEnv == null) return PatternNodeCreator.DefaultPat(tree.pos, header.type);
                caseEnv.newBoundVar(tree.symbol(), tree.type, header.selector);
                return PatternNodeCreator.DefaultPat(tree.pos, header.type);
            }
            case 27: {
                if (!tree.symbol().isPrimaryConstructor()) return PatternNodeCreator.VariablePat(tree.pos, tree);
                return this.mk.ConstrPat(tree.pos, tree.type);
            }
            case 21: {
                Tree.Literal literal = (Tree.Literal)tree;
                AConstant aConstant = literal.value;
                return PatternNodeCreator.ConstantPat(tree.pos, tree.type, aConstant);
            }
            case 29: {
                Tree.Sequence sequence = (Tree.Sequence)tree;
                Tree[] treeArray = sequence.trees;
                if (this.delegateSequenceMatching) return this.mk.SeqContainerPat(tree.pos, tree.type, tree);
                return this.mk.SequencePat(tree.pos, tree.type, treeArray.length);
            }
            case 2: {
                Tree.Alternative alternative = (Tree.Alternative)tree;
                Tree[] treeArray = alternative.trees;
                if (!$assertionsDisabled && treeArray.length <= 1) {
                    throw new AssertionError();
                }
                PatternNode.ConstrPat constrPat = this.mk.ConstrPat(header.pos, header.type);
                constrPat.and = this.mk.Header(header.pos, header.type, header.selector.duplicate());
                CaseEnv caseEnv2 = new CaseEnv(this.owner, this.unit);
                for (int i = 0; i < treeArray.length; ++i) {
                    PatternNode patternNode = this.enter1(treeArray[i], -1, constrPat, constrPat.symbol(), caseEnv2);
                    patternNode.and = this.mk.Body(tree.pos);
                }
                return PatternNodeCreator.AltPat(tree.pos, (PatternNode.Header)constrPat.and);
            }
        }
        throw new ApplicationError(String.valueOf(String.valueOf(String.valueOf(String.valueOf("unit = ".concat(String.valueOf(String.valueOf(this.unit))))).concat("; tree = "))).concat(String.valueOf(String.valueOf(tree))));
    }

    protected PatternNode enter(Tree tree, int n, PatternNode patternNode, Symbol symbol, CaseEnv caseEnv) {
        switch (patternNode.$tag) {
            case 3: {
                PatternNode.ConstrPat constrPat = (PatternNode.ConstrPat)patternNode;
                Symbol symbol2 = constrPat.casted;
                return this.enter1(tree, n, patternNode, symbol2, caseEnv);
            }
            case 7: {
                PatternNode.SequencePat sequencePat = (PatternNode.SequencePat)patternNode;
                Symbol symbol3 = sequencePat.casted;
                return this.enter1(tree, n, patternNode, symbol3, caseEnv);
            }
        }
        return this.enter1(tree, n, patternNode, symbol, caseEnv);
    }

    private PatternNode.Header newHeader(int n, Symbol symbol, int n2) {
        Tree.Ident ident = this.gen.Ident(n, symbol);
        if (symbol.pos == Position.FIRSTPOS) {
            Tree tree = this.gen.mkApply_V(this.gen.Select(ident, this.defs.FUNCTION_APPLY(1)), new Tree[]{this.gen.mkIntLit(n, n2)});
            Type type = tree.type;
            return this.mk.Header(n, type, tree);
        }
        Symbol symbol2 = ((ClassSymbol)symbol.getType().symbol()).caseFieldAccessor(n2);
        Type type = symbol.getType().memberType(symbol2);
        Tree.Select select = this.gen.Select(ident, symbol2);
        if (type.$tag == 3) {
            return this.mk.Header(n, type.resultType(), this.gen.mkApply__(select));
        }
        return this.mk.Header(n, type, select);
    }

    protected PatternNode enter1(Tree tree, int n, PatternNode patternNode, Symbol symbol, CaseEnv caseEnv) {
        Tree[] treeArray = this.patternArgs(tree);
        PatternNode.Header header = (PatternNode.Header)patternNode.and;
        if (header == null) {
            if (!$assertionsDisabled && n < 0) {
                throw new AssertionError((Object)String.valueOf(String.valueOf(symbol)));
            }
            header = this.newHeader(tree.pos, symbol, n);
            patternNode.and = header;
            header.or = this.patternNode(tree, header, caseEnv);
            return this.enter(treeArray, header.or, symbol, caseEnv);
        }
        while (header.next != null) {
            header = header.next;
        }
        PatternNode patternNode2 = this.patternNode(tree, header, caseEnv);
        PatternNode patternNode3 = header;
        while (true) {
            if (patternNode3.isSameAs(patternNode2)) {
                if (patternNode2.$tag == 3) {
                    PatternNode.ConstrPat constrPat = (PatternNode.ConstrPat)patternNode2;
                    Symbol symbol2 = constrPat.casted;
                    caseEnv.substitute(symbol2, this.gen.Ident(patternNode2.pos, ((PatternNode.ConstrPat)patternNode3).casted));
                }
                return this.enter(treeArray, patternNode3, symbol, caseEnv);
            }
            if (patternNode3.isDefaultPat() || patternNode3.or == null && (patternNode2.isDefaultPat() || patternNode3.subsumes(patternNode2))) {
                header = header.next = this.mk.Header(patternNode2.pos, header.type, header.selector);
                header.next.or = patternNode2;
                return this.enter(treeArray, header.next.or, symbol, caseEnv);
            }
            if (patternNode3.or == null) {
                patternNode3.or = patternNode2;
                return this.enter(treeArray, patternNode3.or, symbol, caseEnv);
            }
            patternNode3 = patternNode3.or;
        }
    }

    protected PatternNode enter(Tree[] treeArray, PatternNode patternNode, Symbol symbol, CaseEnv caseEnv) {
        switch (patternNode.$tag) {
            case 3: {
                Symbol symbol2;
                PatternNode patternNode2 = (PatternNode.ConstrPat)patternNode;
                symbol = symbol2 = patternNode2.casted;
                break;
            }
            case 7: {
                Symbol symbol2;
                PatternNode patternNode2 = (PatternNode.SequencePat)patternNode;
                symbol = symbol2 = ((PatternNode.SequencePat)patternNode2).casted;
            }
        }
        for (int i = 0; i < treeArray.length; ++i) {
            patternNode = this.enter1(treeArray[i], i, patternNode, symbol, caseEnv);
        }
        return patternNode;
    }

    protected int nCaseComponents(Tree tree) {
        if (tree.$tag == 4) {
            Type type = tree.type.symbol().primaryConstructor().type();
            switch (type.$tag) {
                case 15: {
                    if (!$assertionsDisabled) {
                        throw new AssertionError();
                    }
                    return 0;
                }
                case 3: {
                    Type.MethodType methodType = (Type.MethodType)type;
                    Symbol[] symbolArray = methodType.vparams;
                    return symbolArray.length;
                }
                case 5: {
                    Type.PolyType polyType = (Type.PolyType)type;
                    if (polyType.result.$tag == 3) {
                        Type.MethodType methodType = (Type.MethodType)polyType.result;
                        Symbol[] symbolArray = methodType.vparams;
                        return symbolArray.length;
                    }
                    return 0;
                }
            }
            throw new ApplicationError(String.valueOf(String.valueOf(String.valueOf(String.valueOf("not yet implemented;pattern matching for ".concat(String.valueOf(String.valueOf(tree))))).concat(": "))).concat(String.valueOf(String.valueOf(type))));
        }
        return 0;
    }

    public Tree toTree() {
        if (this.optimize && this.isSimpleIntSwitch()) {
            return this.intSwitchToTree();
        }
        return this.generalSwitchToTree();
    }

    protected boolean isSimpleIntSwitch() {
        if (this.selector.type.widen().isSameAs(this.defs.int_TYPE())) {
            for (PatternNode patternNode = this.root.and; patternNode != null; patternNode = patternNode.next()) {
                PatternNode patternNode2 = patternNode;
                while ((patternNode2 = patternNode2.or) != null) {
                    if (patternNode2.$tag != 2) {
                        return false;
                    }
                    if (patternNode2.and.$tag == 1) {
                        PatternNode.Body body = (PatternNode.Body)patternNode2.and;
                        Tree.ValDef[][] valDefArray = body.bound;
                        Tree[] treeArray = body.guard;
                        if (treeArray.length <= 1 && treeArray[0] == Tree.Empty && valDefArray[0].length <= 0) continue;
                        return false;
                    }
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    protected boolean isSimpleSwitch() {
        this.print();
        for (PatternNode patternNode = this.root.and; patternNode != null; patternNode = patternNode.next()) {
            PatternNode patternNode2 = patternNode;
            block10: while ((patternNode2 = patternNode2.or) != null) {
                switch (patternNode2.$tag) {
                    case 8: {
                        PatternNode patternNode3 = (PatternNode.VariablePat)patternNode2;
                        Object object = patternNode3.tree;
                        System.out.println((((Tree)object).symbol().flags & 0x40) != 0);
                        break;
                    }
                    case 3: {
                        Object object;
                        System.out.println(String.valueOf(String.valueOf(String.valueOf(String.valueOf(patternNode2.type)).concat(" / "))).concat(String.valueOf((patternNode2.type.symbol().flags & 0x40) != 0)));
                        PatternNode patternNode3 = patternNode2.and;
                        while (true) {
                            switch (patternNode3.$tag) {
                                case 5: {
                                    object = (PatternNode.Header)patternNode3;
                                    Tree[] treeArray = ((PatternNode.Header)object).next;
                                    if (treeArray != null) {
                                        return false;
                                    }
                                    patternNode3 = patternNode3.or;
                                    break;
                                }
                                case 4: {
                                    patternNode3 = patternNode3.and;
                                    break;
                                }
                                case 1: {
                                    object = (PatternNode.Body)patternNode3;
                                    Tree[] treeArray = ((PatternNode.Body)object).guard;
                                    if (treeArray.length <= 1 && treeArray[0] == Tree.Empty) continue block10;
                                    return false;
                                }
                                default: {
                                    System.out.println(patternNode3);
                                    return false;
                                }
                            }
                        }
                    }
                    default: {
                        return false;
                    }
                }
            }
        }
        return true;
    }

    static TagBodyPair insert(int n, Tree tree, TagBodyPair tagBodyPair) {
        if (tagBodyPair == null) {
            return new TagBodyPair(n, tree, null);
        }
        if (n > tagBodyPair.tag) {
            return new TagBodyPair(tagBodyPair.tag, tagBodyPair.body, PatternMatcher.insert(n, tree, tagBodyPair.next));
        }
        return new TagBodyPair(n, tree, tagBodyPair);
    }

    protected int numCases(PatternNode patternNode) {
        int n = 0;
        while ((patternNode = patternNode.or) != null) {
            if (patternNode.$tag == 4) continue;
            ++n;
        }
        return n;
    }

    protected Tree defaultBody(PatternNode patternNode, Tree tree) {
        while (patternNode != null) {
            PatternNode patternNode2 = patternNode;
            while ((patternNode2 = patternNode2.or) != null) {
                if (patternNode2.$tag != 4) continue;
                return this.bodyToTree(patternNode2.and);
            }
            patternNode = patternNode.next();
        }
        return tree;
    }

    public Tree intSwitchToTree() {
        int n = this.numCases(this.root.and);
        Tree tree = this.cf.ThrowMatchError(this.selector.pos, this.resultVar.getType());
        if (n == 0) {
            return this.defaultBody(this.root.and, tree);
        }
        if (n == 1) {
            PatternNode patternNode = this.root.and.or;
            if (patternNode.$tag == 2) {
                PatternNode.ConstantPat constantPat = (PatternNode.ConstantPat)patternNode;
                AConstant aConstant = constantPat.value;
                return this.gen.If(this.cf.Equals(this.selector, this.gen.Literal(this.root.and.or.pos, aConstant)), this.bodyToTree(this.root.and.or.and), this.defaultBody(this.root.and, tree));
            }
            return this.generalSwitchToTree();
        }
        if (this.root.and.$tag == 5) {
            Tree[] treeArray;
            Object object;
            TagBodyPair tagBodyPair = null;
            Tree tree2 = tree;
            for (PatternNode patternNode = this.root.and; patternNode != null; patternNode = patternNode.next()) {
                PatternNode patternNode2 = patternNode.or;
                block5: while (patternNode2 != null) {
                    switch (patternNode2.$tag) {
                        case 4: {
                            if (tree2 != null) {
                                throw new ApplicationError();
                            }
                            tree2 = this.bodyToTree(patternNode2.and);
                            patternNode2 = patternNode2.or;
                            continue block5;
                        }
                        case 2: {
                            object = (PatternNode.ConstantPat)patternNode2;
                            if (object.value.$tag != 5) break;
                            treeArray = (AConstant.INT)object.value;
                            int n2 = treeArray.value;
                            tagBodyPair = PatternMatcher.insert(n2, this.bodyToTree(patternNode2.and), tagBodyPair);
                            patternNode2 = patternNode2.or;
                            continue block5;
                        }
                    }
                    throw new ApplicationError(patternNode2.toString());
                }
            }
            if (tagBodyPair == null) {
                return this.gen.Switch(this.selector, new int[0], new Tree[0], tree2, this.resultVar.getType());
            }
            int n3 = tagBodyPair.length();
            object = new int[n3];
            treeArray = new Tree[n3];
            n3 = 0;
            while (tagBodyPair != null) {
                object[n3] = tagBodyPair.tag;
                treeArray[n3++] = tagBodyPair.body;
                tagBodyPair = tagBodyPair.next;
            }
            return this.gen.Switch(this.selector, (int[])object, treeArray, tree2, this.resultVar.getType());
        }
        throw new ApplicationError();
    }

    protected Tree bodyToTree(PatternNode patternNode) {
        if (patternNode.$tag == 1) {
            PatternNode.Body body = (PatternNode.Body)patternNode;
            Tree[] treeArray = body.body;
            return treeArray[0];
        }
        throw new ApplicationError();
    }

    public Tree switchToTree() {
        throw new Error();
    }

    public Tree generalSwitchToTree() {
        Tree[] treeArray = new Tree[]{this.gen.ValDef(this.root.symbol(), this.selector), this.gen.ValDef(this.resultVar, this.gen.mkDefaultValue(this.selector.pos, this.resultVar.getType()))};
        Tree.If if_ = this.gen.If(this.selector.pos, this.toTree(this.root.and), (Tree)this.gen.Ident(this.selector.pos, this.resultVar), this.cf.ThrowMatchError(this.selector.pos, this.resultVar.getType(), this.gen.Ident(this.selector.pos, this.root.symbol())));
        return this.gen.mkBlock(this.selector.pos, treeArray, (Tree)if_);
    }

    protected Tree toTree(PatternNode treeArray) {
        Tree tree = this.gen.mkBooleanLit(treeArray.pos, false);
        block4: while (treeArray != null) {
            switch (treeArray.$tag) {
                case 5: {
                    PatternNode patternNode = (PatternNode.Header)treeArray;
                    Tree.ValDef[][] valDefArray = patternNode.selector;
                    Tree[] treeArray2 = patternNode.next;
                    tree = this.optimize(treeArray.type, treeArray.or) ? this.cf.Or(tree, this.toOptTree(treeArray.or, (Tree)valDefArray)) : this.cf.Or(tree, this.toTree(treeArray.or, (Tree)valDefArray));
                    treeArray = treeArray2;
                    continue block4;
                }
                case 1: {
                    PatternNode patternNode = (PatternNode.Body)treeArray;
                    Tree.ValDef[][] valDefArray = ((PatternNode.Body)patternNode).bound;
                    Tree[] treeArray2 = ((PatternNode.Body)patternNode).guard;
                    Tree[] treeArray3 = ((PatternNode.Body)patternNode).body;
                    if (valDefArray.length == 0 && treeArray2.length == 0 && treeArray3.length == 0) {
                        return this.gen.mkBooleanLit(treeArray.pos, true);
                    }
                    if (!this.doBinding) {
                        valDefArray = new Tree.ValDef[][]{new Tree.ValDef[0]};
                    }
                    for (int i = treeArray2.length - 1; i >= 0; --i) {
                        Tree[] treeArray4 = valDefArray[i];
                        Tree tree2 = this.gen.mkBlock(this.gen.Assign(this.gen.Ident(treeArray3[i].pos, this.resultVar), treeArray3[i]), this.gen.mkBooleanLit(treeArray3[i].pos, true));
                        if (treeArray2[i] != Tree.Empty) {
                            tree2 = this.cf.And(treeArray2[i], tree2);
                        }
                        tree = this.cf.Or(this.gen.mkBlock(treeArray3[i].pos, treeArray4, tree2), tree);
                    }
                    return tree;
                }
            }
            throw new ApplicationError();
        }
        return tree;
    }

    protected boolean optimize(Type type, PatternNode patternNode) {
        if (!this.optimize || !type.isSubType(this.defs.SCALAOBJECT_TYPE())) {
            return false;
        }
        int n = 0;
        while (patternNode != null) {
            switch (patternNode.$tag) {
                case 3: {
                    if (patternNode.type.symbol().isCaseClass()) {
                        ++n;
                        break;
                    }
                    return false;
                }
                case 4: {
                    break;
                }
                default: {
                    return false;
                }
            }
            patternNode = patternNode.or;
        }
        return n > 2;
    }

    static TagNodePair insert(int n, PatternNode patternNode, TagNodePair tagNodePair) {
        if (tagNodePair == null) {
            return new TagNodePair(n, patternNode, null);
        }
        if (n > tagNodePair.tag) {
            return new TagNodePair(tagNodePair.tag, tagNodePair.node, PatternMatcher.insert(n, patternNode, tagNodePair.next));
        }
        if (n == tagNodePair.tag) {
            PatternNode patternNode2 = tagNodePair.node;
            tagNodePair.node = patternNode;
            patternNode.or = patternNode2;
            return tagNodePair;
        }
        return new TagNodePair(n, patternNode, tagNodePair);
    }

    static TagNodePair insertNode(int n, PatternNode patternNode, TagNodePair tagNodePair) {
        PatternNode patternNode2 = patternNode.dup();
        patternNode2.or = null;
        return PatternMatcher.insert(n, patternNode2, tagNodePair);
    }

    protected Tree toOptTree(PatternNode patternNode, Tree tree) {
        TagNodePair tagNodePair = null;
        PatternNode patternNode2 = null;
        block4: while (patternNode != null) {
            switch (patternNode.$tag) {
                case 3: {
                    tagNodePair = PatternMatcher.insertNode(patternNode.type.symbol().tag(), patternNode, tagNodePair);
                    patternNode = patternNode.or;
                    continue block4;
                }
                case 4: {
                    patternNode2 = patternNode;
                    patternNode = patternNode.or;
                    continue block4;
                }
            }
            throw new ApplicationError();
        }
        int n = tagNodePair.length();
        int[] nArray = new int[n];
        Tree[] treeArray = new Tree[n];
        n = 0;
        while (tagNodePair != null) {
            nArray[n] = tagNodePair.tag;
            treeArray[n++] = this.toTree(tagNodePair.node, tree);
            tagNodePair = tagNodePair.next;
        }
        return this.gen.Switch(this.gen.mkApply__(this.gen.Select(tree.duplicate(), this.defs.SCALAOBJECT_TAG())), nArray, treeArray, patternNode2 == null ? this.gen.mkBooleanLit(tree.pos, false) : this.toTree(patternNode2.and), this.defs.boolean_TYPE());
    }

    protected Tree toTree(PatternNode patternNode, Tree tree) {
        if (patternNode == null) {
            return this.gen.mkBooleanLit(tree.pos, false);
        }
        switch (patternNode.$tag) {
            case 4: {
                return this.toTree(patternNode.and);
            }
            case 3: {
                PatternNode.ConstrPat constrPat = (PatternNode.ConstrPat)patternNode;
                Symbol symbol = constrPat.casted;
                return this.gen.If(this.gen.mkIsInstanceOf(tree.duplicate(), patternNode.type), this.gen.mkBlock(this.gen.ValDef(symbol, this.gen.mkAsInstanceOf(tree.duplicate(), patternNode.type)), this.toTree(patternNode.and)), this.toTree(patternNode.or, tree.duplicate()));
            }
            case 7: {
                PatternNode.SequencePat sequencePat = (PatternNode.SequencePat)patternNode;
                Symbol symbol = sequencePat.casted;
                int n = sequencePat.len;
                return this.gen.If(this.cf.And(this.gen.mkIsInstanceOf(tree.duplicate(), patternNode.type), this.cf.Equals(this.gen.mkApply__(this.gen.Select(this.gen.mkAsInstanceOf(tree.duplicate(), patternNode.type), this.defs.SEQ_LENGTH())), this.gen.mkIntLit(tree.pos, n))), this.gen.mkBlock(this.gen.ValDef(symbol, this.gen.mkAsInstanceOf(tree.duplicate(), patternNode.type)), this.toTree(patternNode.and)), this.toTree(patternNode.or, tree.duplicate()));
            }
            case 2: {
                PatternNode.ConstantPat constantPat = (PatternNode.ConstantPat)patternNode;
                AConstant aConstant = constantPat.value;
                return this.gen.If(this.cf.Equals(tree.duplicate(), this.gen.Literal(tree.pos, aConstant)), this.toTree(patternNode.and), this.toTree(patternNode.or, tree.duplicate()));
            }
            case 8: {
                PatternNode.VariablePat variablePat = (PatternNode.VariablePat)patternNode;
                Tree tree2 = variablePat.tree;
                return this.gen.If(this.cf.Equals(tree.duplicate(), tree2), this.toTree(patternNode.and), this.toTree(patternNode.or, tree.duplicate()));
            }
            case 0: {
                PatternNode.AltPat altPat = (PatternNode.AltPat)patternNode;
                PatternNode.Header header = altPat.subheader;
                return this.gen.If(this.toTree(header), this.toTree(patternNode.and), this.toTree(patternNode.or, tree.duplicate()));
            }
        }
        throw new ApplicationError();
    }

    static {
        $assertionsDisabled = !Class.forName("scalac.transformer.matching.PatternMatcher").desiredAssertionStatus();
    }

    static class TagNodePair {
        int tag;
        PatternNode node;
        TagNodePair next;

        TagNodePair(int n, PatternNode patternNode, TagNodePair tagNodePair) {
            this.tag = n;
            this.node = patternNode;
            this.next = tagNodePair;
        }

        int length() {
            return this.next == null ? 1 : this.next.length() + 1;
        }
    }

    static class TagBodyPair {
        int tag;
        Tree body;
        TagBodyPair next;

        TagBodyPair(int n, Tree tree, TagBodyPair tagBodyPair) {
            this.tag = n;
            this.body = tree;
            this.next = tagBodyPair;
        }

        int length() {
            return this.next == null ? 1 : this.next.length() + 1;
        }
    }
}

