/*
 * Decompiled with CFR 0.152.
 */
package scalac.transformer;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import scalac.CompilationUnit;
import scalac.Global;
import scalac.Phase;
import scalac.PhaseDescriptor;
import scalac.ast.GenTransformer;
import scalac.ast.Tree;
import scalac.ast.Tree$;
import scalac.backend.Primitives;
import scalac.symtab.Definitions;
import scalac.symtab.Scope;
import scalac.symtab.Symbol;
import scalac.symtab.Type;
import scalac.util.Debug;
import scalac.util.Names;

public class TypesAsValuesPhase
extends Phase {
    private final TV_Transformer transformer;
    private static final HashMap membersToAdd;
    private static final HashMap paramsToAdd;
    private static final HashMap accessors;
    private final Definitions defs;
    private final Primitives prims;
    private final Type typeType;
    private final Type.MethodType typeAccessorType;
    private final Symbol singleTypeClass;
    private final Symbol ARRAY_CONSTRUCTOR;
    private final Map basicTypes;
    private static final /* synthetic */ boolean $assertionsDisabled;

    public TypesAsValuesPhase(Global global, PhaseDescriptor phaseDescriptor) {
        super(global, phaseDescriptor);
        this.defs = this.global.definitions;
        this.prims = this.global.primitives;
        this.typeType = this.defs.TYPE_TYPE();
        this.typeAccessorType = new Type.MethodType(new Symbol[0], this.typeType);
        this.singleTypeClass = this.defs.SINGLETYPE_CLASS;
        this.ARRAY_CONSTRUCTOR = this.defs.ARRAY_CLASS.primaryConstructor();
        this.transformer = new TV_Transformer(global);
        this.basicTypes = new HashMap();
        this.basicTypes.put(this.defs.DOUBLE_CLASS, this.defs.RTT_DOUBLE());
        this.basicTypes.put(this.defs.FLOAT_CLASS, this.defs.RTT_FLOAT());
        this.basicTypes.put(this.defs.LONG_CLASS, this.defs.RTT_LONG());
        this.basicTypes.put(this.defs.INT_CLASS, this.defs.RTT_INT());
        this.basicTypes.put(this.defs.SHORT_CLASS, this.defs.RTT_SHORT());
        this.basicTypes.put(this.defs.CHAR_CLASS, this.defs.RTT_CHAR());
        this.basicTypes.put(this.defs.BYTE_CLASS, this.defs.RTT_BYTE());
        this.basicTypes.put(this.defs.BOOLEAN_CLASS, this.defs.RTT_BOOLEAN());
    }

    private HashMap typeAccessors(Symbol symbol) {
        HashMap<Symbol, Symbol> hashMap = (HashMap<Symbol, Symbol>)membersToAdd.get(symbol);
        if (hashMap == null) {
            hashMap = new HashMap<Symbol, Symbol>();
            Scope.SymbolIterator symbolIterator = symbol.members().iterator();
            while (symbolIterator.hasNext()) {
                Symbol symbol2 = symbolIterator.next();
                if (!symbol2.isType()) continue;
                Symbol symbol3 = this.getAccessorSymbol(symbol2);
                hashMap.put(symbol2, symbol3);
            }
            membersToAdd.put(symbol, hashMap);
        }
        return hashMap;
    }

    private HashMap typeParams(Symbol symbol) {
        HashMap<Symbol, Symbol> hashMap = (HashMap<Symbol, Symbol>)paramsToAdd.get(symbol);
        if (hashMap == null) {
            Symbol[] symbolArray = symbol.typeParams();
            if (!$assertionsDisabled && symbolArray.length <= 0) {
                throw new AssertionError();
            }
            hashMap = new HashMap<Symbol, Symbol>();
            for (int i = 0; i < symbolArray.length; ++i) {
                Symbol symbol2 = symbolArray[i];
                Symbol symbol3 = this.getAccessorSymbol(symbol2);
                hashMap.put(symbol2, symbol3);
            }
            paramsToAdd.put(symbol, hashMap);
        }
        return hashMap;
    }

    private Symbol getAccessorSymbol(Symbol symbol) {
        if (!$assertionsDisabled && !symbol.isType()) {
            throw new AssertionError();
        }
        Symbol symbol2 = (Symbol)accessors.get(symbol);
        if (symbol2 == null) {
            symbol2 = symbol.owner().newVariable(symbol.pos, symbol.flags, Names.TYPE(symbol));
            symbol2.setInfo(symbol.owner().isClass() ? this.typeAccessorType : this.typeType);
            accessors.put(symbol, symbol2);
        }
        return symbol2;
    }

    public Type transformInfo(Symbol symbol, Type type) {
        if (symbol.isClass()) {
            HashMap hashMap = this.typeAccessors(symbol);
            if (hashMap.isEmpty()) {
                return type;
            }
            Scope scope = new Scope(symbol.members());
            Iterator iterator = hashMap.values().iterator();
            while (iterator.hasNext()) {
                scope.enterOrOverload((Symbol)iterator.next());
            }
            return Type.compoundType(type.parents(), scope, symbol);
        }
        if (type.typeParams().length > 0 && !this.isPrimitive(symbol)) {
            if (type.$tag == 5) {
                Type.PolyType polyType = (Type.PolyType)type;
                if (polyType.result.$tag == 3) {
                    Type.MethodType methodType = (Type.MethodType)polyType.result;
                    Symbol[] symbolArray = polyType.tparams;
                    Symbol[] symbolArray2 = methodType.vparams;
                    Type type2 = methodType.result;
                    HashMap hashMap = this.typeParams(symbol);
                    Symbol[] symbolArray3 = new Symbol[hashMap.size() + symbolArray2.length];
                    for (int i = 0; i < symbolArray.length; ++i) {
                        symbolArray3[i] = (Symbol)hashMap.get(symbolArray[i]);
                    }
                    System.arraycopy(symbolArray2, 0, symbolArray3, symbolArray.length, symbolArray2.length);
                    return new Type.PolyType(symbolArray, new Type.MethodType(symbolArray3, type2));
                }
            }
            throw Debug.abort("unexpected type: ", type);
        }
        return type;
    }

    private boolean isPrimitive(Symbol symbol) {
        throw new Error();
    }

    public void apply(CompilationUnit[] compilationUnitArray) {
        this.transformer.apply(compilationUnitArray);
    }

    final /* synthetic */ Symbol access$36(Symbol symbol) {
        return this.getAccessorSymbol(symbol);
    }

    final /* synthetic */ HashMap access$32(Symbol symbol) {
        return this.typeAccessors(symbol);
    }

    final /* synthetic */ Map access$35() {
        return this.basicTypes;
    }

    final /* synthetic */ Symbol access$34() {
        return this.ARRAY_CONSTRUCTOR;
    }

    final /* synthetic */ Symbol access$38() {
        return this.singleTypeClass;
    }

    final /* synthetic */ Primitives access$37() {
        return this.prims;
    }

    final /* synthetic */ Definitions access$33() {
        return this.defs;
    }

    static {
        $assertionsDisabled = !Class.forName("scalac.transformer.TypesAsValuesPhase").desiredAssertionStatus();
        membersToAdd = new HashMap();
        paramsToAdd = new HashMap();
        accessors = new HashMap();
    }

    private class TV_Transformer
    extends GenTransformer {
        private Symbol currentOwner;
        private static final /* synthetic */ boolean $assertionsDisabled;

        public TV_Transformer(Global global) {
            super(global);
        }

        public Tree transform(Tree tree) {
            switch (tree.$tag) {
                case 10: {
                    Tree[] treeArray;
                    Tree.ClassDef classDef = (Tree.ClassDef)tree;
                    Tree.Template template = classDef.impl;
                    Symbol symbol = tree.symbol();
                    Tree[] treeArray2 = this.transform(template.body, template.symbol());
                    HashMap hashMap = TypesAsValuesPhase.this.access$32(symbol);
                    if (!hashMap.isEmpty()) {
                        treeArray = new Tree[treeArray2.length + hashMap.size()];
                        int n = 0;
                        for (int i = 0; i < treeArray2.length; ++i) {
                            treeArray[n++] = treeArray2[i];
                            Symbol symbol2 = treeArray2[i].symbol();
                            if (!hashMap.containsKey(symbol2)) continue;
                            Symbol symbol3 = (Symbol)hashMap.get(symbol2);
                            Tree$.Var var = symbol2.isAbstractType() ? Tree.Empty : this.typeAsValue(treeArray2[i].pos, symbol2.type(), symbol3);
                            treeArray[n++] = this.gen.DefDef(symbol3, var);
                        }
                    } else {
                        treeArray = treeArray2;
                    }
                    return this.gen.ClassDef(symbol, this.transform(template.parents), template.symbol(), treeArray);
                }
                case 13: {
                    Tree.DefDef defDef = (Tree.DefDef)tree;
                    Tree tree2 = defDef.rhs;
                    Symbol symbol = this.getSymbolFor(tree);
                    return this.gen.DefDef(symbol, this.transform(tree2, symbol));
                }
                case 40: {
                    Tree tree3;
                    Tree.ValDef valDef = (Tree.ValDef)tree;
                    if (valDef.rhs.$tag == 21) {
                        tree3 = (Tree.Literal)valDef.rhs;
                        if (((Tree.Literal)tree3).value.$tag == 11) {
                            Tree tree4 = valDef.tpe;
                            Symbol symbol = this.getSymbolFor(tree);
                            Tree tree5 = this.gen.mkRef(tree.pos, this.typeAsValue(tree.pos, tree4.type, this.currentOwner), TypesAsValuesPhase.this.access$33().TYPE_DEFAULTVALUE());
                            Tree tree6 = this.gen.mkApply__(tree.pos, tree5);
                            return this.gen.ValDef(symbol, tree6);
                        }
                    }
                    tree3 = valDef.rhs;
                    Symbol symbol = this.getSymbolFor(tree);
                    return this.gen.ValDef(symbol, this.transform(tree3, symbol));
                }
                case 23: {
                    Tree.New new_ = (Tree.New)tree;
                    if (new_.init.$tag != 4) break;
                    Tree.Apply apply = (Tree.Apply)new_.init;
                    if (apply.fun.$tag != 37) break;
                    Tree.TypeApply typeApply = (Tree.TypeApply)apply.fun;
                    Tree tree7 = typeApply.fun;
                    Tree[] treeArray = typeApply.args;
                    Tree[] treeArray3 = apply.args;
                    if (tree7.symbol() == TypesAsValuesPhase.this.access$34()) {
                        if (!$assertionsDisabled && treeArray.length != 1) {
                            throw new AssertionError();
                        }
                        if (!$assertionsDisabled && treeArray3.length != 1) {
                            throw new AssertionError();
                        }
                        Tree tree8 = this.gen.mkRef(tree.pos, this.typeAsValue(treeArray[0].pos, treeArray[0].type, this.currentOwner), TypesAsValuesPhase.this.access$33().TYPE_NEWARRAY());
                        return this.gen.mkApplyTV(tree8, treeArray, treeArray3);
                    }
                    return super.transform(tree);
                }
                case 4: {
                    Tree.Apply apply = (Tree.Apply)tree;
                    if (apply.fun.$tag != 37) break;
                    Tree.TypeApply typeApply = (Tree.TypeApply)apply.fun;
                    Tree tree9 = typeApply.fun;
                    Tree[] treeArray = typeApply.args;
                    Tree[] treeArray4 = apply.args;
                    Symbol symbol = tree9.symbol();
                    if (symbol == TypesAsValuesPhase.this.access$33().ANY_IS) {
                        if (!($assertionsDisabled || treeArray.length == 1 && treeArray4.length == 0)) {
                            throw new AssertionError();
                        }
                        Tree tree10 = treeArray[0];
                        if (this.isTrivialType(tree10.type)) {
                            return super.transform(tree);
                        }
                        Tree tree11 = this.typeAsValue(tree10.pos, tree10.type, this.currentOwner);
                        Tree.Select select = this.gen.Select(tree10.pos, tree11, TypesAsValuesPhase.this.access$33().TYPE_HASASINSTANCE());
                        return this.gen.mkApply_V(tree.pos, select, new Tree[]{this.extractQualifier(tree9)});
                    }
                    if (symbol == TypesAsValuesPhase.this.access$33().ANY_AS) {
                        if (!($assertionsDisabled || treeArray.length == 1 && treeArray4.length == 0)) {
                            throw new AssertionError();
                        }
                        return super.transform(tree);
                    }
                    Tree[] treeArray5 = this.transform(treeArray4);
                    Tree[] treeArray6 = new Tree[treeArray5.length + treeArray.length];
                    for (int i = 0; i < treeArray.length; ++i) {
                        treeArray6[i] = this.typeAsValue(treeArray[i].pos, treeArray[i].type, this.currentOwner);
                    }
                    System.arraycopy(treeArray5, 0, treeArray6, treeArray.length, treeArray5.length);
                    return this.gen.mkApplyTV(tree.pos, this.transform(tree9), treeArray, treeArray6);
                }
            }
            return super.transform(tree);
        }

        private Tree transform(Tree tree, Symbol symbol) {
            Symbol symbol2 = this.currentOwner;
            this.currentOwner = symbol;
            Tree tree2 = this.transform(tree);
            this.currentOwner = symbol2;
            return tree2;
        }

        private Tree[] transform(Tree[] treeArray, Symbol symbol) {
            Symbol symbol2 = this.currentOwner;
            this.currentOwner = symbol;
            Tree[] treeArray2 = this.transform(treeArray);
            this.currentOwner = symbol2;
            return treeArray2;
        }

        private boolean isTrivialType(Type type) {
            switch (type.$tag) {
                case 1: {
                    Type.ConstantType constantType = (Type.ConstantType)type;
                    Type type2 = constantType.base;
                    return this.isTrivialType(type2);
                }
                case 8: {
                    Type.TypeRef typeRef = (Type.TypeRef)type;
                    Symbol symbol = typeRef.sym;
                    Type[] typeArray = typeRef.args;
                    return symbol.isStatic() && typeArray.length == 0;
                }
                case 6: {
                    return false;
                }
                case 7: {
                    return false;
                }
                case 0: {
                    return false;
                }
            }
            throw Debug.abort("unexpected type", type);
        }

        private Tree typeAsValue(int n, Type type, Symbol symbol) {
            switch (type.$tag) {
                case 1: {
                    Type.ConstantType constantType = (Type.ConstantType)type;
                    Type type2 = constantType.base;
                    return this.typeAsValue(n, type2, symbol);
                }
                case 8: {
                    Type.TypeRef typeRef = (Type.TypeRef)type;
                    Type type3 = typeRef.pre;
                    Symbol symbol2 = typeRef.sym;
                    Type[] typeArray = typeRef.args;
                    Symbol symbol3 = symbol2.owner();
                    if (TypesAsValuesPhase.this.access$35().containsKey(symbol2)) {
                        return this.gen.mkGlobalRef(n, (Symbol)TypesAsValuesPhase.this.access$35().get(symbol2));
                    }
                    if (symbol3.isClass() || symbol3.isMethod()) {
                        Symbol symbol4 = TypesAsValuesPhase.this.access$36(symbol2);
                        if (symbol4.isMethod()) {
                            return this.gen.mkApply__(this.gen.mkLocalRef(n, symbol4));
                        }
                        return this.gen.mkLocalRef(n, symbol4);
                    }
                    Tree[] treeArray = new Tree[typeArray.length + 2];
                    treeArray[0] = symbol3.isPackage() ? this.gen.mkNullLit(n) : this.prefixAsValue(n, type3);
                    treeArray[1] = this.gen.mkStringLit(n, TypesAsValuesPhase.this.access$37().getJREClassName(symbol2));
                    for (int i = 0; i < typeArray.length; ++i) {
                        treeArray[i + 2] = this.typeAsValue(n, typeArray[i], symbol);
                    }
                    Symbol symbol5 = TypesAsValuesPhase.this.access$33().CONSTRUCTEDTYPE_CTOR(typeArray.length);
                    return this.gen.New(n, this.gen.mkApply_V(this.gen.mkGlobalRef(n, symbol5), treeArray));
                }
                case 6: {
                    Type.SingleType singleType = (Type.SingleType)type;
                    Type type4 = singleType.pre;
                    Symbol symbol6 = singleType.sym;
                    Tree tree = this.gen.mkPrimaryConstructorGlobalRef(n, TypesAsValuesPhase.this.access$38());
                    Tree[] treeArray = new Tree[]{this.gen.mkRef(n, type4, symbol6)};
                    return this.gen.New(n, this.gen.mkApply_V(tree, treeArray));
                }
            }
            throw Global.fail("unexpected type: ", type);
        }

        private Tree extractQualifier(Tree tree) {
            if (tree.$tag == 27) {
                Tree.Select select = (Tree.Select)tree;
                Tree tree2 = select.qualifier;
                return tree2;
            }
            throw Debug.abort("cannot extract qualifier from ", tree);
        }

        private Tree prefixAsValue(int n, Type type) {
            switch (type.$tag) {
                case 7: {
                    Type.ThisType thisType = (Type.ThisType)type;
                    Symbol symbol = thisType.sym;
                    if (symbol.isPackage() || symbol.isNone()) {
                        return this.gen.mkNullLit(n);
                    }
                    return this.gen.This(n, symbol);
                }
                case 6: {
                    Type.SingleType singleType = (Type.SingleType)type;
                    Type type2 = singleType.pre;
                    Symbol symbol = singleType.sym;
                    return this.gen.mkApply__(n, this.gen.mkRef(n, this.prefixAsValue(n, type2), symbol));
                }
            }
            throw Debug.abort("unexpected prefix", type);
        }

        static {
            $assertionsDisabled = !Class.forName("scalac.transformer.TypesAsValuesPhase").desiredAssertionStatus();
        }
    }
}

