/*
 * Decompiled with CFR 0.152.
 */
package scalac.symtab.classfile;

import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.Vector;
import scalac.ApplicationError;
import scalac.symtab.Modifiers;
import scalac.symtab.Scope;
import scalac.symtab.Symbol;
import scalac.symtab.Type;
import scalac.symtab.classfile.JavaTypeFactory;
import scalac.util.Name;

class MetaParser {
    private final Symbol owner;
    private final StringTokenizer scanner;
    private final Type defaultType;
    private String token;
    private final Scope tvars;
    private Scope locals;
    private final Symbol clazz;
    private final Type ctype;
    private final JavaTypeFactory make;
    private static final /* synthetic */ boolean $assertionsDisabled;

    MetaParser(String string, Scope scope, Symbol symbol, Type type, Symbol symbol2, Type type2, JavaTypeFactory javaTypeFactory) {
        this.scanner = new StringTokenizer(string, "()[], \t<;", true);
        this.defaultType = type;
        this.owner = symbol;
        this.tvars = scope;
        this.clazz = symbol2;
        this.ctype = type2;
        this.make = javaTypeFactory;
    }

    private static Name getTypeName(String string) {
        return Name.fromString(string).toTypeName();
    }

    private Symbol getTVar(String string) {
        return this.getTVar(string, this.clazz.primaryConstructor());
    }

    private Symbol getTVar(String string, Symbol symbol) {
        if (string.startsWith("?")) {
            Symbol symbol2 = (this.locals != null ? this.locals : this.tvars).lookup(MetaParser.getTypeName(string));
            if (symbol2 != Symbol.NONE) {
                return symbol2;
            }
            if (this.locals != null && (symbol2 = this.tvars.lookup(MetaParser.getTypeName(string))) != Symbol.NONE) {
                return symbol2;
            }
            symbol2 = symbol.newTParam(0, 0, MetaParser.getTypeName(this.token), this.make.anyType());
            this.tvars.enter(symbol2);
            return symbol2;
        }
        return Symbol.NONE;
    }

    private String nextToken() {
        do {
            this.token = this.scanner.nextToken().trim();
        } while (this.token.length() == 0);
        return this.token;
    }

    protected Type parse() {
        if (this.scanner.hasMoreTokens()) {
            this.nextToken();
            if (!this.scanner.hasMoreTokens()) {
                return this.defaultType;
            }
            if ("class".equals(this.token)) {
                return this.parseMetaClass();
            }
            if ("method".equals(this.token)) {
                return this.parseMetaMethod();
            }
            if ("field".equals(this.token)) {
                return this.parseMetaField();
            }
            if ("constr".equals(this.token)) {
                return this.parseConstrField();
            }
        }
        return this.defaultType;
    }

    protected Type parseMetaClass() {
        Object object;
        Object object2;
        Symbol[] symbolArray;
        Modifiers modifiers;
        Object object3;
        this.nextToken();
        if ("[".equals(this.token)) {
            try {
                object3 = new Vector();
                do {
                    this.nextToken();
                    int n = 0;
                    if (this.token.equals("+")) {
                        this.nextToken();
                        n = 0x40000000;
                    } else if (this.token.equals("-")) {
                        this.nextToken();
                        n = Integer.MIN_VALUE;
                    }
                    if (!$assertionsDisabled && !this.token.startsWith("?")) {
                        throw new AssertionError();
                    }
                    modifiers = this.getTVar(this.token);
                    if (modifiers == Symbol.NONE) {
                        return this.defaultType;
                    }
                    ((Symbol)modifiers).flags |= n;
                    this.nextToken();
                    if (this.token.equals("<")) {
                        this.nextToken();
                        ((Symbol)modifiers).setInfo(this.parseType());
                    }
                    ((Vector)object3).add(modifiers);
                } while (this.token.equals(","));
                if (!$assertionsDisabled && !"]".equals(this.token)) {
                    throw new AssertionError();
                }
                this.nextToken();
                symbolArray = ((Vector)object3).toArray(new Symbol[((Vector)object3).size()]);
                modifiers = Type.appliedType(this.ctype, Symbol.type(symbolArray));
                object2 = this.clazz.primaryConstructor();
                object = ((Symbol)object2).rawInfo();
                if (object.$tag != 3) {
                    throw new ApplicationError(((Symbol)object2).rawInfo());
                }
                Type.MethodType methodType = (Type.MethodType)object;
                Symbol[] symbolArray2 = methodType.vparams;
                ((Symbol)object2).setInfo(Type.PolyType(symbolArray, Type.MethodType(symbolArray2, (Type)modifiers)));
            }
            catch (NoSuchElementException noSuchElementException) {
                // empty catch block
            }
        }
        object3 = this.defaultType;
        if ("extends".equals(this.token)) {
            symbolArray = new Vector();
            do {
                this.nextToken();
                symbolArray.add(this.parseType());
            } while (this.token.equals("with"));
            if (this.defaultType.$tag == 0) {
                modifiers = (Type.CompoundType)this.defaultType;
                object2 = ((Type.CompoundType)modifiers).members;
                object = symbolArray.toArray(new Type[symbolArray.size()]);
                object3 = Type.compoundType(object, (Scope)object2, this.defaultType.symbol());
            }
        }
        if (!$assertionsDisabled && !";".equals(this.token)) {
            throw new AssertionError();
        }
        return object3;
    }

    protected Type parseType() {
        String string = this.token;
        Symbol symbol = this.getTVar(string);
        this.nextToken();
        if (symbol != Symbol.NONE) {
            return symbol.type();
        }
        Type type = this.make.classType(string).unalias();
        if (this.token.equals("[")) {
            Vector<Type> vector = new Vector<Type>();
            do {
                this.nextToken();
                vector.add(this.parseType());
            } while (this.token.equals(","));
            if (!$assertionsDisabled && !"]".equals(this.token)) {
                throw new AssertionError();
            }
            this.nextToken();
            Type[] typeArray = new Type[vector.size()];
            vector.toArray(typeArray);
            return Type.appliedType(type, typeArray);
        }
        return type;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Type parseMetaMethod() {
        Object object;
        this.locals = new Scope();
        try {
            try {
                Object object2;
                this.nextToken();
                Symbol[] symbolArray = null;
                if ("[".equals(this.token)) {
                    object2 = new Vector();
                    do {
                        this.nextToken();
                        if ("]".equals(this.token)) break;
                        if (!$assertionsDisabled && !this.token.startsWith("?")) {
                            throw new AssertionError();
                        }
                        object = this.owner.newTParam(0, 0, MetaParser.getTypeName(this.token), this.make.anyType());
                        this.locals.enter((Symbol)object);
                        this.nextToken();
                        if (this.token.equals("<")) {
                            this.nextToken();
                            ((Symbol)object).setInfo(this.parseType());
                        }
                        ((Vector)object2).add(object);
                    } while (this.token.equals(","));
                    if (!$assertionsDisabled && !"]".equals(this.token)) {
                        throw new AssertionError();
                    }
                    this.nextToken();
                    symbolArray = ((Vector)object2).toArray(new Symbol[((Vector)object2).size()]);
                }
                if ("(".equals(this.token)) {
                    Modifiers modifiers;
                    int n = 0;
                    object = new Vector();
                    do {
                        this.nextToken();
                        if (")".equals(this.token)) break;
                        int n2 = 0;
                        if ("def".equals(this.token)) {
                            this.nextToken();
                            n2 |= 0x100;
                        }
                        modifiers = this.owner.newVParam(0, n2, Name.fromString("x".concat(String.valueOf(n++))));
                        ((Vector)object).add(((Symbol)modifiers).setInfo(this.parseType()));
                    } while (this.token.equals(","));
                    if (!$assertionsDisabled && !")".equals(this.token)) {
                        throw new AssertionError();
                    }
                    this.nextToken();
                    Type type = this.parseType();
                    if (!$assertionsDisabled && !";".equals(this.token)) {
                        throw new AssertionError();
                    }
                    modifiers = Type.MethodType(((Vector)object).toArray(new Symbol[((Vector)object).size()]), type);
                    Modifiers modifiers2 = symbolArray == null ? modifiers : Type.PolyType(symbolArray, (Type)modifiers);
                    Object var8_11 = null;
                    this.locals = null;
                    return modifiers2;
                }
                object2 = this.parseType();
                if (!$assertionsDisabled && !";".equals(this.token)) {
                    throw new AssertionError();
                }
                object = Type.PolyType(symbolArray == null ? Symbol.EMPTY_ARRAY : symbolArray, (Type)object2);
            }
            catch (NoSuchElementException noSuchElementException) {
                noSuchElementException.printStackTrace();
                Type type = this.defaultType;
                Object var8_13 = null;
                this.locals = null;
                return type;
            }
        }
        catch (Throwable throwable) {
            Object var8_14 = null;
            this.locals = null;
            throw throwable;
        }
        Object var8_12 = null;
        this.locals = null;
        return object;
    }

    protected Type parseMetaField() {
        this.nextToken();
        return this.parseType();
    }

    protected Type parseConstrField() {
        try {
            this.nextToken();
            if ("(".equals(this.token)) {
                int n = 0;
                Vector<Symbol> vector = new Vector<Symbol>();
                do {
                    this.nextToken();
                    if (")".equals(this.token)) break;
                    Symbol symbol = this.owner.newVParam(0, 0, Name.fromString("x".concat(String.valueOf(n++))));
                    vector.add(symbol.setInfo(this.parseType()));
                } while (this.token.equals(","));
                if (!$assertionsDisabled && !")".equals(this.token)) {
                    throw new AssertionError();
                }
                this.nextToken();
                if (!$assertionsDisabled && !";".equals(this.token)) {
                    throw new AssertionError();
                }
                return Type.MethodType(vector.toArray(new Symbol[vector.size()]), this.ctype);
            }
            if (!$assertionsDisabled && !";".equals(this.token)) {
                throw new AssertionError();
            }
            return Type.PolyType(Symbol.EMPTY_ARRAY, this.ctype);
        }
        catch (NoSuchElementException noSuchElementException) {
            return this.defaultType;
        }
    }

    static {
        $assertionsDisabled = !Class.forName("scalac.symtab.classfile.MetaParser").desiredAssertionStatus();
    }
}

