/*
 * Decompiled with CFR 0.152.
 */
package scalac.framework;

import scalac.Global;
import scalac.Phase;
import scalac.framework.Promise;
import scalac.util.Debug;

public class History {
    private static final Object[] NO_VALUES;
    private static final Phase[] NO_STARTS;
    private final Global global;
    private Object[] values;
    private Phase[] starts;
    private Phase limit;
    private Promise next;
    private static final /* synthetic */ boolean $assertionsDisabled;

    public History() {
        this(Global.instance);
    }

    public History(Global global) {
        this(global, global.currentPhase);
    }

    public History(Phase phase) {
        this(phase.global, phase);
    }

    public History(Global global, Phase phase) {
        this.global = global;
        this.reset(phase);
    }

    public final Phase getFirstPhase() {
        return this.starts.length > 0 ? this.starts[this.starts.length - 1] : this.limit.next;
    }

    public final Object getValue(Object object) {
        return this.getValueAt(object, this.getPhase());
    }

    public final Object getNextValue(Object object) {
        return this.getValueAt(object, this.getNextPhase());
    }

    public final Object getValueAt(Object object, Phase phase) {
        if (!$assertionsDisabled && phase == null) {
            throw new AssertionError((Object)String.valueOf(String.valueOf(this.show(object, phase))));
        }
        while (this.limit.id < phase.id) {
            this.incrementLimit(object);
        }
        for (int i = 0; i < this.starts.length; ++i) {
            if (this.starts[i].id > phase.id) continue;
            return this.values[i];
        }
        throw Debug.abort("prehistoric phase", this.show(object, phase));
    }

    public final History setValue(Object object, Object object2) {
        return this.setValueAt(object, this.getPhase(), object2);
    }

    public final History setNextValue(Object object, Object object2) {
        return this.setValueAt(object, this.getNextPhase(), object2);
    }

    public final History setValueAt(Object object, Phase phase, Object object2) {
        if (!$assertionsDisabled && phase == null) {
            throw new AssertionError((Object)String.valueOf(String.valueOf(this.show(object, phase))));
        }
        if (!($assertionsDisabled || phase == this.limit.next && this.next == null)) {
            throw new AssertionError((Object)String.valueOf(String.valueOf(this.show(object, phase))));
        }
        if (this.values.length == 0 || this.values[0] != object2) {
            this.values = History.append(object2, this.values);
            this.starts = History.append(phase, this.starts);
        }
        this.limit = phase;
        return this;
    }

    public final History setPromise(Object object, Promise promise) {
        return this.setPromiseAt(object, this.getPhase(), promise);
    }

    public final History setNextPromise(Object object, Promise promise) {
        return this.setPromiseAt(object, this.getNextPhase(), promise);
    }

    public final History setPromiseAt(Object object, Phase phase, Promise promise) {
        if (!$assertionsDisabled && phase == null) {
            throw new AssertionError((Object)String.valueOf(String.valueOf(this.show(object, phase))));
        }
        if (!($assertionsDisabled || phase == this.limit.next && this.next == null)) {
            throw new AssertionError((Object)String.valueOf(String.valueOf(this.show(object, phase))));
        }
        this.next = promise;
        return this;
    }

    public final void reset() {
        this.reset(this.getFirstPhase());
    }

    public final void reset(Phase phase) {
        if (!($assertionsDisabled || phase != null && phase.prev != null)) {
            throw new AssertionError((Object)String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(this)).concat(" - "))).concat(String.valueOf(String.valueOf(phase))))));
        }
        this.values = NO_VALUES;
        this.starts = NO_STARTS;
        this.limit = phase.prev;
        this.next = null;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("[");
        for (int i = 0; i < this.values.length; ++i) {
            stringBuffer.append(this.starts[i]).append(" -> ");
            stringBuffer.append(Debug.show(this.values[i])).append(", ");
        }
        stringBuffer.append(this.limit);
        if (this.next != null) {
            stringBuffer.append(" - ").append(this.next);
        }
        return stringBuffer.append("]").toString();
    }

    protected Object transformValueAt(Object object, Phase phase, Object object2) {
        Phase phase2 = this.global.currentPhase;
        this.global.currentPhase = phase;
        Object object3 = this.transformValue(object, object2);
        this.global.currentPhase = phase2;
        return object3;
    }

    protected Object transformValue(Object object, Object object2) {
        return this.computeValueAt(object, this.global.currentPhase.next);
    }

    protected Object computeValueAt(Object object, Phase phase) {
        Phase phase2 = this.global.currentPhase;
        this.global.currentPhase = phase;
        Object object2 = this.computeValue(object);
        this.global.currentPhase = phase2;
        return object2;
    }

    protected Object computeValue(Object object) {
        throw Debug.abort("undefined value", this.show(object, this.getPhase()));
    }

    private Phase getPhase() {
        return this.global.currentPhase;
    }

    private Phase getNextPhase() {
        return this.getPhase().next;
    }

    private void incrementLimit(Object object) {
        Object object2;
        Phase phase = this.limit;
        if (this.next != null) {
            object2 = this.next.forceAt(object, this.global, phase.next);
            if (this.limit == phase) {
                this.next = null;
            }
        } else {
            object2 = this.values.length > 0 ? this.transformValueAt(object, phase, this.values[0]) : this.computeValueAt(object, phase.next);
        }
        if (this.limit == phase) {
            this.setValueAt(object, phase.next, object2);
        }
    }

    private String show(Object object) {
        return String.valueOf(String.valueOf(String.valueOf(String.valueOf(this)).concat(" @ "))).concat(String.valueOf(String.valueOf(Debug.show(object))));
    }

    private String show(Object object, Phase phase) {
        return String.valueOf(String.valueOf(String.valueOf(String.valueOf(this.show(object))).concat(" - "))).concat(String.valueOf(String.valueOf(phase)));
    }

    private static Object[] append(Object object, Object[] objectArray) {
        Object[] objectArray2 = new Object[1 + objectArray.length];
        objectArray2[0] = object;
        for (int i = 1; i < objectArray2.length; ++i) {
            objectArray2[i] = objectArray[i - 1];
        }
        return objectArray2;
    }

    private static Phase[] append(Phase phase, Phase[] phaseArray) {
        Phase[] phaseArray2 = new Phase[1 + phaseArray.length];
        phaseArray2[0] = phase;
        for (int i = 1; i < phaseArray2.length; ++i) {
            phaseArray2[i] = phaseArray[i - 1];
        }
        return phaseArray2;
    }

    static {
        $assertionsDisabled = !Class.forName("scalac.framework.History").desiredAssertionStatus();
        NO_VALUES = new Object[0];
        NO_STARTS = new Phase[0];
    }
}

