/*
 * Decompiled with CFR 0.152.
 */
package scalac.ast;

import scalac.Global;
import scalac.ast.Traverser;
import scalac.ast.Tree;
import scalac.ast.TreeFactory;
import scalac.ast.TreeInfo;
import scalac.atree.AConstant;
import scalac.symtab.ClassSymbol;
import scalac.symtab.Definitions;
import scalac.symtab.Kinds;
import scalac.symtab.Modifiers;
import scalac.symtab.Scope;
import scalac.symtab.Symbol;
import scalac.symtab.Type;
import scalac.symtab.TypeTags;
import scalac.util.Debug;
import scalac.util.Name;
import scalac.util.Names;
import scalac.util.TypeName;
import scalac.util.TypeNames;

public class TreeGen
implements Kinds,
Modifiers,
TypeTags {
    private final Global global;
    private final Definitions definitions;
    private final TreeFactory make;
    private static final /* synthetic */ boolean $assertionsDisabled;

    public TreeGen(Global global) {
        this(global, global.make);
    }

    public TreeGen(Global global, TreeFactory treeFactory) {
        this.global = global;
        this.definitions = global.definitions;
        this.make = treeFactory;
    }

    public Tree[] mkTypeRefs(int n, Symbol[] symbolArray) {
        if (symbolArray.length == 0) {
            return Tree.EMPTY_ARRAY;
        }
        Tree[] treeArray = new Tree[symbolArray.length];
        for (int i = 0; i < treeArray.length; ++i) {
            treeArray[i] = this.mkTypeRef(n, symbolArray[i]);
        }
        return treeArray;
    }

    public Tree mkTypeRef(int n, Symbol symbol) {
        if (!$assertionsDisabled && symbol.kind != 4) {
            throw new AssertionError((Object)String.valueOf(String.valueOf(Debug.show(symbol))));
        }
        symbol.flags |= 0x40000;
        return this.mkType(n, symbol.nextType());
    }

    public Tree[] mkTypes(int n, Type[] typeArray) {
        if (typeArray.length == 0) {
            return Tree.EMPTY_ARRAY;
        }
        Tree[] treeArray = new Tree[typeArray.length];
        for (int i = 0; i < treeArray.length; ++i) {
            treeArray[i] = this.mkType(n, typeArray[i]);
        }
        return treeArray;
    }

    public Tree mkType(int n, Type type) {
        return this.TypeTerm(n, type);
    }

    public Tree.TypeTerm TypeTerm(int n, Type type) {
        Tree.TypeTerm typeTerm = this.make.TypeTerm(n);
        typeTerm.setType(type);
        return typeTerm;
    }

    public Tree mkUnitLit(int n) {
        return this.Literal(n, AConstant.UNIT);
    }

    public Tree mkBooleanLit(int n, boolean bl) {
        return this.Literal(n, AConstant.BOOLEAN(bl));
    }

    public Tree mkByteLit(int n, byte by) {
        return this.Literal(n, AConstant.BYTE(by));
    }

    public Tree mkShortLit(int n, short s) {
        return this.Literal(n, AConstant.SHORT(s));
    }

    public Tree mkCharLit(int n, char c) {
        return this.Literal(n, AConstant.CHAR(c));
    }

    public Tree mkIntLit(int n, int n2) {
        return this.Literal(n, AConstant.INT(n2));
    }

    public Tree mkLongLit(int n, long l) {
        return this.Literal(n, AConstant.LONG(l));
    }

    public Tree mkFloatLit(int n, float f) {
        return this.Literal(n, AConstant.FLOAT(f));
    }

    public Tree mkDoubleLit(int n, double d) {
        return this.Literal(n, AConstant.DOUBLE(d));
    }

    public Tree mkStringLit(int n, String string) {
        return this.Literal(n, AConstant.STRING(string));
    }

    public Tree mkNullLit(int n) {
        return this.Literal(n, AConstant.NULL);
    }

    public Tree mkZeroLit(int n) {
        return this.Literal(n, AConstant.ZERO);
    }

    public Tree mkDefaultValue(int n, int n2) {
        switch (n2) {
            case 18: {
                return this.mkUnitLit(n);
            }
            case 17: {
                return this.mkBooleanLit(n, false);
            }
            case 10: {
                return this.mkByteLit(n, (byte)0);
            }
            case 12: {
                return this.mkShortLit(n, (short)0);
            }
            case 11: {
                return this.mkCharLit(n, '\u0000');
            }
            case 13: {
                return this.mkIntLit(n, 0);
            }
            case 14: {
                return this.mkLongLit(n, 0L);
            }
            case 15: {
                return this.mkFloatLit(n, 0.0f);
            }
            case 16: {
                return this.mkDoubleLit(n, 0.0);
            }
        }
        throw Debug.abort("unknown type tag: ".concat(String.valueOf(n2)));
    }

    public Tree mkDefaultValue(int n, Type type) {
        if (this.definitions.ALLREF_TYPE().isSubType(type)) {
            return this.mkNullLit(n);
        }
        Type type2 = type.unbox();
        if (type2.$tag == 11) {
            Type.UnboxedType unboxedType = (Type.UnboxedType)type2;
            int n2 = unboxedType.tag;
            return this.mkDefaultValue(n, n2);
        }
        return this.mkZeroLit(n);
    }

    public Tree.Literal Literal(int n, AConstant aConstant) {
        Tree.Literal literal = this.make.Literal(n, aConstant);
        this.global.nextPhase();
        literal.setType(this.definitions.atyper.type(aConstant));
        this.global.prevPhase();
        return literal;
    }

    public Tree mkPrimaryConstructorRef(int n, Tree tree, Symbol symbol) {
        return this.mkRef(n, tree, this.primaryConstructorOf(symbol));
    }

    public Tree mkPrimaryConstructorRef(Tree tree, Symbol symbol) {
        return this.mkPrimaryConstructorRef(tree.pos, tree, symbol);
    }

    public Tree mkPrimaryConstructorRef(int n, Type type, Symbol symbol) {
        return this.mkRef(n, type, this.primaryConstructorOf(symbol));
    }

    public Tree mkPrimaryConstructorLocalRef(int n, Symbol symbol) {
        return this.mkLocalRef(n, this.primaryConstructorOf(symbol));
    }

    public Tree mkPrimaryConstructorGlobalRef(int n, Symbol symbol) {
        return this.mkGlobalRef(n, this.primaryConstructorOf(symbol));
    }

    public Tree[] mkLocalRefs(int n, Symbol[] symbolArray) {
        if (symbolArray.length == 0) {
            return Tree.EMPTY_ARRAY;
        }
        Tree[] treeArray = new Tree[symbolArray.length];
        for (int i = 0; i < treeArray.length; ++i) {
            treeArray[i] = this.mkLocalRef(n, symbolArray[i]);
        }
        return treeArray;
    }

    public Tree[] mkGlobalRefs(int n, Symbol[] symbolArray) {
        if (symbolArray.length == 0) {
            return Tree.EMPTY_ARRAY;
        }
        Tree[] treeArray = new Tree[symbolArray.length];
        for (int i = 0; i < treeArray.length; ++i) {
            treeArray[i] = this.mkGlobalRef(n, symbolArray[i]);
        }
        return treeArray;
    }

    public Tree mkRef(int n, Tree tree, Symbol symbol) {
        return this.Select(n, tree, symbol);
    }

    public Tree mkRef(Tree tree, Symbol symbol) {
        return this.mkRef(tree.pos, tree, symbol);
    }

    public Tree mkRef(int n, Type type, Symbol symbol) {
        Tree tree = this.mkQualifier(n, type);
        if (tree == Tree.Empty) {
            return this.Ident(n, symbol);
        }
        return this.mkRef(n, tree, symbol);
    }

    public Tree mkLocalRef(int n, Symbol symbol) {
        if (!$assertionsDisabled && !symbol.isTerm()) {
            throw new AssertionError((Object)String.valueOf(String.valueOf(Debug.show(symbol))));
        }
        return this.mkRef(n, symbol.owner().thisType(), symbol);
    }

    public Tree mkGlobalRef(int n, Symbol symbol) {
        if (!$assertionsDisabled && !symbol.isTerm()) {
            throw new AssertionError((Object)String.valueOf(String.valueOf(Debug.show(symbol))));
        }
        this.global.nextPhase();
        Type type = symbol.owner().staticPrefix();
        this.global.prevPhase();
        return this.mkRef(n, type, symbol);
    }

    public Tree mkQualifier(int n, Type type) {
        switch (type.$tag) {
            case 14: {
                return Tree.Empty;
            }
            case 7: {
                Type.ThisType thisType = (Type.ThisType)type;
                Symbol symbol = thisType.sym;
                return this.This(n, symbol);
            }
            case 6: {
                Type.SingleType singleType = (Type.SingleType)type;
                Type type2 = singleType.pre;
                Symbol symbol = singleType.sym;
                Tree tree = this.mkRef(n, type2, symbol);
                Type type3 = tree.type();
                if (type3.$tag == 3) {
                    Type.MethodType methodType = (Type.MethodType)type3;
                    Symbol[] symbolArray = methodType.vparams;
                    if (!$assertionsDisabled && symbolArray.length != 0) {
                        throw new AssertionError((Object)String.valueOf(String.valueOf(tree.type())));
                    }
                    return this.Apply(n, tree);
                }
                return tree;
            }
        }
        throw Debug.abort("illegal case", type);
    }

    public Tree.This This(int n, Symbol symbol) {
        if (!$assertionsDisabled && !symbol.isClassType()) {
            throw new AssertionError((Object)String.valueOf(String.valueOf(Debug.show(symbol))));
        }
        Tree.This this_ = this.make.This(n, symbol);
        this.global.nextPhase();
        this_.setType(symbol.thisType());
        this.global.prevPhase();
        return this_;
    }

    public Tree.Super Super(int n, Symbol symbol) {
        if (!$assertionsDisabled && !symbol.isClass()) {
            throw new AssertionError((Object)String.valueOf(String.valueOf(Debug.show(symbol))));
        }
        Tree.Super super_ = this.make.Super(n, symbol, TypeNames.EMPTY);
        this.global.nextPhase();
        super_.setType(symbol.thisType());
        this.global.prevPhase();
        return super_;
    }

    public Tree.Ident Ident(int n, Symbol symbol) {
        Type type;
        if (!$assertionsDisabled && !symbol.isTerm()) {
            throw new AssertionError((Object)String.valueOf(String.valueOf(Debug.show(symbol))));
        }
        symbol.flags |= 0x40000;
        Tree.Ident ident = this.make.Ident(n, symbol);
        this.global.nextPhase();
        if (symbol.isInitializer()) {
            type = symbol.type();
            Symbol[] symbolArray = symbol.owner().typeParams();
            if (symbolArray.length != 0) {
                type = Type.PolyType(symbolArray, type);
            }
        } else {
            type = symbol.owner().thisType().memberStabilizedType(symbol);
        }
        ident.setType(type);
        this.global.prevPhase();
        return ident;
    }

    public Tree.Select Select(int n, Tree tree, Symbol symbol) {
        if (!$assertionsDisabled && !symbol.isTerm()) {
            throw new AssertionError((Object)String.valueOf(String.valueOf(Debug.show(symbol))));
        }
        symbol.flags |= 0xC0000;
        Tree.Select select = this.make.Select(n, symbol, tree);
        this.global.nextPhase();
        select.setType(tree.type.memberStabilizedType(symbol));
        this.global.prevPhase();
        return select;
    }

    public Tree.Select Select(Tree tree, Symbol symbol) {
        return this.Select(tree.pos, tree, symbol);
    }

    public Tree mkApplyTV(int n, Tree tree, Type[] typeArray, Tree[] treeArray) {
        if (typeArray.length != 0) {
            tree = this.TypeApply(n, tree, this.mkTypes(n, typeArray));
        }
        if (treeArray.length == 0 && tree.getType().isObjectType()) {
            return tree;
        }
        return this.Apply(n, tree, treeArray);
    }

    public Tree mkApplyTV(Tree tree, Type[] typeArray, Tree[] treeArray) {
        return this.mkApplyTV(tree.pos, tree, typeArray, treeArray);
    }

    public Tree mkApplyTV(int n, Tree tree, Tree[] treeArray, Tree[] treeArray2) {
        if (treeArray.length != 0) {
            tree = this.TypeApply(n, tree, treeArray);
        }
        if (treeArray2.length == 0 && tree.getType().isObjectType()) {
            return tree;
        }
        return this.Apply(n, tree, treeArray2);
    }

    public Tree mkApplyTV(Tree tree, Tree[] treeArray, Tree[] treeArray2) {
        return this.mkApplyTV(tree.pos, tree, treeArray, treeArray2);
    }

    public Tree mkApplyT_(int n, Tree tree, Type[] typeArray) {
        return this.mkApplyTV(n, tree, typeArray, Tree.EMPTY_ARRAY);
    }

    public Tree mkApplyT_(Tree tree, Type[] typeArray) {
        return this.mkApplyT_(tree.pos, tree, typeArray);
    }

    public Tree mkApplyT_(int n, Tree tree, Tree[] treeArray) {
        return this.mkApplyTV(n, tree, treeArray, Tree.EMPTY_ARRAY);
    }

    public Tree mkApplyT_(Tree tree, Tree[] treeArray) {
        return this.mkApplyT_(tree.pos, tree, treeArray);
    }

    public Tree mkApply_V(int n, Tree tree, Tree[] treeArray) {
        return this.mkApplyTV(n, tree, Tree.EMPTY_ARRAY, treeArray);
    }

    public Tree mkApply_V(Tree tree, Tree[] treeArray) {
        return this.mkApply_V(tree.pos, tree, treeArray);
    }

    public Tree mkApply__(int n, Tree tree) {
        return this.mkApplyTV(n, tree, Tree.EMPTY_ARRAY, Tree.EMPTY_ARRAY);
    }

    public Tree mkApply__(Tree tree) {
        return this.mkApply__(tree.pos, tree);
    }

    public Tree.TypeApply TypeApply(int n, Tree tree, Type[] typeArray) {
        return this.TypeApply(n, tree, this.mkTypes(n, typeArray));
    }

    public Tree.TypeApply TypeApply(Tree tree, Type[] typeArray) {
        return this.TypeApply(tree.pos, tree, typeArray);
    }

    public Tree.TypeApply TypeApply(int n, Tree tree, Tree[] treeArray) {
        Type type = tree.type();
        switch (type.$tag) {
            case 4: {
                throw Debug.abort("unresolved name", String.valueOf(String.valueOf(String.valueOf(String.valueOf(tree)).concat(" - "))).concat(String.valueOf(String.valueOf(tree.type))));
            }
            case 5: {
                Type.PolyType polyType = (Type.PolyType)type;
                Symbol[] symbolArray = polyType.tparams;
                Type type2 = polyType.result;
                this.global.nextPhase();
                type2 = type2.subst(symbolArray, Tree.typeOf(treeArray));
                this.global.prevPhase();
                return (Tree.TypeApply)this.make.TypeApply(n, tree, treeArray).setType(type2);
            }
        }
        throw Debug.abort("illegal case", String.valueOf(String.valueOf(String.valueOf(String.valueOf(tree)).concat(" - "))).concat(String.valueOf(String.valueOf(tree.type()))));
    }

    public Tree.TypeApply TypeApply(Tree tree, Tree[] treeArray) {
        return this.TypeApply(tree.pos, tree, treeArray);
    }

    public Tree.Apply Apply(int n, Tree tree, Tree[] treeArray) {
        Type type = tree.type();
        switch (type.$tag) {
            case 4: {
                throw Debug.abort("unresolved name", String.valueOf(String.valueOf(String.valueOf(String.valueOf(tree)).concat(" - "))).concat(String.valueOf(String.valueOf(tree.type()))));
            }
            case 3: {
                Type.MethodType methodType = (Type.MethodType)type;
                Type type2 = methodType.result;
                return (Tree.Apply)this.make.Apply(n, tree, treeArray).setType(type2);
            }
        }
        throw Debug.abort("illegal case", String.valueOf(String.valueOf(String.valueOf(String.valueOf(tree)).concat(" - "))).concat(String.valueOf(String.valueOf(tree.type()))));
    }

    public Tree.Apply Apply(Tree tree, Tree[] treeArray) {
        return this.Apply(tree.pos, tree, treeArray);
    }

    public Tree.Apply Apply(int n, Tree tree) {
        return this.Apply(n, tree, Tree.EMPTY_ARRAY);
    }

    public Tree.Apply Apply(Tree tree) {
        return this.Apply(tree.pos, tree);
    }

    public Tree mkNewTV(int n, Tree tree, Symbol symbol, Type[] typeArray, Tree[] treeArray) {
        return this.mkNewTV(n, tree, symbol, this.mkTypes(n, typeArray), treeArray);
    }

    public Tree mkNewTV(Tree tree, Symbol symbol, Type[] typeArray, Tree[] treeArray) {
        return this.mkNewTV(tree.pos, tree, symbol, typeArray, treeArray);
    }

    public Tree mkNewTV(int n, Tree tree, Symbol symbol, Tree[] treeArray, Tree[] treeArray2) {
        if (!$assertionsDisabled && !symbol.isInitializer()) {
            throw new AssertionError((Object)String.valueOf(String.valueOf(Debug.show(symbol))));
        }
        Tree.Create create = this.Create(n, tree, symbol.owner(), treeArray);
        return this.New(n, this.Apply(n, this.Select(n, create, symbol), treeArray2));
    }

    public Tree mkNewTV(Tree tree, Symbol symbol, Tree[] treeArray, Tree[] treeArray2) {
        return this.mkNewTV(tree.pos, tree, symbol, treeArray, treeArray2);
    }

    public Tree mkNewT_(int n, Tree tree, Symbol symbol, Type[] typeArray) {
        return this.mkNewTV(n, tree, symbol, typeArray, Tree.EMPTY_ARRAY);
    }

    public Tree mkNewT_(Tree tree, Symbol symbol, Type[] typeArray) {
        return this.mkNewT_(tree.pos, tree, symbol, typeArray);
    }

    public Tree mkNewT_(int n, Tree tree, Symbol symbol, Tree[] treeArray) {
        return this.mkNewTV(n, tree, symbol, treeArray, Tree.EMPTY_ARRAY);
    }

    public Tree mkNewT_(Tree tree, Symbol symbol, Tree[] treeArray) {
        return this.mkNewT_(tree.pos, tree, symbol, treeArray);
    }

    public Tree mkNew_V(int n, Tree tree, Symbol symbol, Tree[] treeArray) {
        return this.mkNewTV(n, tree, symbol, Tree.EMPTY_ARRAY, treeArray);
    }

    public Tree mkNew_V(Tree tree, Symbol symbol, Tree[] treeArray) {
        return this.mkNew_V(tree.pos, tree, symbol, treeArray);
    }

    public Tree mkNew__(int n, Tree tree, Symbol symbol) {
        return this.mkNewTV(n, tree, symbol, Tree.EMPTY_ARRAY, Tree.EMPTY_ARRAY);
    }

    public Tree mkNew__(Tree tree, Symbol symbol) {
        return this.mkNew__(tree.pos, tree, symbol);
    }

    public Tree.New New(int n, Tree tree) {
        Tree.New new_;
        block2: {
            new_ = this.make.New(n, tree);
            new_.setType(tree.type());
            if (tree.$tag != 4) break block2;
            Tree.Apply apply = (Tree.Apply)tree;
            if (apply.fun.$tag == 27) {
                Tree.Select select = (Tree.Select)apply.fun;
                Tree tree2 = select.qualifier;
                if (tree2 instanceof Tree.Create) {
                    new_.setType(tree2.type());
                }
            }
        }
        return new_;
    }

    public Tree.New New(Tree tree) {
        return this.New(tree.pos, tree);
    }

    public Tree.Create Create(int n, Tree tree, Symbol symbol, Type[] typeArray) {
        return this.Create(n, tree, symbol, this.mkTypes(n, typeArray));
    }

    public Tree.Create Create(Tree tree, Symbol symbol, Type[] typeArray) {
        return this.Create(tree.pos, tree, symbol, typeArray);
    }

    public Tree.Create Create(int n, Tree tree, Symbol symbol, Tree[] treeArray) {
        if (!$assertionsDisabled && !symbol.isClass()) {
            throw new AssertionError((Object)String.valueOf(String.valueOf(Debug.show(symbol))));
        }
        Tree.Create create = this.make.Create(n, symbol, tree, treeArray);
        this.global.nextPhase();
        if (!$assertionsDisabled && treeArray.length != symbol.typeParams().length) {
            throw new AssertionError((Object)String.valueOf(String.valueOf(create)));
        }
        Type type = tree == Tree.Empty ? Type.NoPrefix : tree.type();
        create.setType(Type.typeRef(type, symbol, Tree.typeOf(treeArray)));
        this.global.prevPhase();
        return create;
    }

    public Tree.Create Create(Tree tree, Symbol symbol, Tree[] treeArray) {
        return this.Create(tree.pos, tree, symbol, treeArray);
    }

    public Tree.Create Create(int n, Tree tree, Symbol symbol) {
        return this.Create(n, tree, symbol, Tree.EMPTY_ARRAY);
    }

    public Tree.Create Create(Tree tree, Symbol symbol) {
        return this.Create(tree.pos, tree, symbol);
    }

    public Tree.Create Create(int n, Type type) {
        if (type.$tag == 8) {
            Type.TypeRef typeRef = (Type.TypeRef)type;
            Type type2 = typeRef.pre;
            Symbol symbol = typeRef.sym;
            Type[] typeArray = typeRef.args;
            return this.Create(n, this.mkQualifier(n, type2), symbol, typeArray);
        }
        throw Debug.abort("illegal case", type);
    }

    public Tree[] flatten_(Tree[] treeArray) {
        Tree[] treeArray2;
        boolean bl = false;
        int n = 0;
        block8: for (int i = 0; i < treeArray.length; ++i) {
            treeArray2 = treeArray[i];
            switch (treeArray2.$tag) {
                case 42: {
                    bl = true;
                    --n;
                    continue block8;
                }
                case 8: {
                    Tree.Block block = (Tree.Block)treeArray2;
                    Tree[] treeArray3 = block.stats;
                    bl = true;
                    n += treeArray3.length + 1;
                    continue block8;
                }
                default: {
                    ++n;
                }
            }
        }
        if (!bl) {
            return treeArray;
        }
        treeArray2 = new Tree[n];
        int n2 = 0;
        block9: for (int i = 0; i < treeArray.length; ++i) {
            Tree tree = treeArray[i];
            switch (tree.$tag) {
                case 42: {
                    continue block9;
                }
                case 8: {
                    Tree.Block block = (Tree.Block)tree;
                    Tree[] treeArray4 = block.stats;
                    Tree tree2 = block.expr;
                    for (int j = 0; j < treeArray4.length; ++j) {
                        treeArray2[n2++] = treeArray4[j];
                    }
                    treeArray2[n2++] = tree2;
                    continue block9;
                }
                default: {
                    treeArray2[n2++] = treeArray[i];
                }
            }
        }
        return treeArray2;
    }

    public Tree.Import mkImportAll(int n, Tree tree) {
        return this.Import(n, tree, new Name[]{Names.IMPORT_WILDCARD});
    }

    public Tree.Import mkImportAll(Tree tree) {
        return this.mkImportAll(tree.pos, tree);
    }

    public Tree.Import mkImportAll(int n, Symbol symbol) {
        return this.mkImportAll(n, this.mkGlobalRef(n, symbol));
    }

    public Tree mkIsInstanceOf(int n, Tree tree, Type type) {
        Type[] typeArray = new Type[]{type};
        return this.mkApplyT_(n, (Tree)this.Select(tree, this.definitions.ANY_IS), typeArray);
    }

    public Tree mkIsInstanceOf(Tree tree, Type type) {
        return this.mkIsInstanceOf(tree.pos, tree, type);
    }

    public Tree mkAsInstanceOf(int n, Tree tree, Type type) {
        Type[] typeArray = new Type[]{type};
        return this.mkApplyT_(n, (Tree)this.Select(tree, this.definitions.ANY_AS), typeArray);
    }

    public Tree mkAsInstanceOf(Tree tree, Type type) {
        return this.mkAsInstanceOf(tree.pos, tree, type);
    }

    public Tree mkUnitBlock(int n, Tree[] treeArray) {
        return this.mkBlock(n, treeArray, this.mkUnitLit(n));
    }

    public Tree mkUnitBlock(int n, Tree tree) {
        return this.mkUnitBlock(n, new Tree[]{tree});
    }

    public Tree mkUnitBlock(Tree tree) {
        return this.mkUnitBlock(tree.pos, tree);
    }

    public Tree mkBlock(int n, Tree[] treeArray, Tree tree) {
        if (treeArray.length == 0) {
            return tree;
        }
        return this.Block(n, treeArray, tree);
    }

    public Tree mkBlock(Tree[] treeArray, Tree tree) {
        return this.mkBlock((treeArray.length != 0 ? treeArray[0] : tree).pos, treeArray, tree);
    }

    public Tree mkBlock(int n, Tree tree, Tree tree2) {
        switch (tree.$tag) {
            case 42: {
                return tree2;
            }
            case 8: {
                Tree.Block block = (Tree.Block)tree;
                Tree[] treeArray = block.stats;
                Tree tree3 = block.expr;
                Tree[] treeArray2 = Tree.cloneArray(treeArray, 1);
                treeArray2[treeArray.length] = tree3;
                return this.Block(tree.pos, treeArray2, tree2);
            }
        }
        return this.Block(n, new Tree[]{tree}, tree2);
    }

    public Tree mkBlock(Tree tree, Tree tree2) {
        return this.mkBlock(tree.pos, tree, tree2);
    }

    public Tree.Import Import(int n, Tree tree, Name[] nameArray) {
        Tree.Import import_ = this.make.Import(n, tree.symbol(), tree, nameArray);
        import_.setType(Type.NoType);
        return import_;
    }

    public Tree.Import Import(Tree tree, Name[] nameArray) {
        return this.Import(tree.pos, tree, nameArray);
    }

    public Tree.Import Import(int n, Symbol symbol, Name[] nameArray) {
        return this.Import(n, this.mkGlobalRef(n, symbol), nameArray);
    }

    public Tree.Template Template(int n, Symbol symbol, Tree[] treeArray, Tree[] treeArray2) {
        Tree.Template template = this.make.Template(n, symbol, treeArray, treeArray2);
        template.setType(Type.NoType);
        return template;
    }

    public Tree.Block Block(int n, Tree[] treeArray, Tree tree) {
        Tree.Block block;
        block4: {
            if (tree.$tag == 8) {
                block = (Tree.Block)tree;
                Tree[] treeArray2 = block.stats;
                Tree tree2 = block.expr;
                int n2 = 0;
                for (int i = 0; i < treeArray2.length; ++i) {
                    if (!treeArray2[i].definesSymbol()) {
                        if (treeArray2[i] == Tree.Empty) continue;
                        ++n2;
                        continue;
                    }
                    break block4;
                }
                Tree[] treeArray3 = Tree.cloneArray(treeArray, n2);
                int n3 = treeArray.length;
                for (int i = 0; i < treeArray2.length; ++i) {
                    if (treeArray2[i] == Tree.Empty) continue;
                    treeArray3[n3++] = treeArray2[i];
                }
                treeArray = treeArray3;
                tree = tree2;
            }
        }
        block = this.make.Block(n, treeArray, tree);
        block.setType(tree.type());
        return block;
    }

    public Tree.Block Block(Tree[] treeArray, Tree tree) {
        return this.Block((treeArray.length != 0 ? treeArray[0] : tree).pos, treeArray, tree);
    }

    public Tree.Assign Assign(int n, Tree tree, Tree tree2) {
        Tree.Assign assign = this.make.Assign(n, tree, tree2);
        this.global.nextPhase();
        assign.setType(this.definitions.void_TYPE());
        this.global.prevPhase();
        return assign;
    }

    public Tree.Assign Assign(Tree tree, Tree tree2) {
        return this.Assign(tree.pos, tree, tree2);
    }

    public Tree.If If(int n, Tree tree, Tree tree2, Tree tree3, Type type) {
        if (!$assertionsDisabled && !this.assertTreeSubTypeOf(tree2, type)) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !this.assertTreeSubTypeOf(tree3, type)) {
            throw new AssertionError();
        }
        Tree.If if_ = this.make.If(n, tree, tree2, tree3);
        if_.setType(type);
        return if_;
    }

    public Tree.If If(Tree tree, Tree tree2, Tree tree3, Type type) {
        return this.If(tree.pos, tree, tree2, tree3, type);
    }

    public Tree.If If(int n, Tree tree, Tree tree2, Tree tree3) {
        this.global.nextPhase();
        Type type = tree2.getType().isSameAs(tree3.getType()) ? tree2.type : Type.lub(new Type[]{tree2.getType(), tree3.getType()});
        this.global.prevPhase();
        return this.If(n, tree, tree2, tree3, type);
    }

    public Tree.If If(Tree tree, Tree tree2, Tree tree3) {
        return this.If(tree.pos, tree, tree2, tree3);
    }

    public Tree.Switch Switch(int n, Tree tree, int[] nArray, Tree[] treeArray, Tree tree2, Type type) {
        for (int i = 0; i < treeArray.length; ++i) {
            if (!$assertionsDisabled && !this.assertTreeSubTypeOf(treeArray[i], type)) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && i != 0 && nArray[i - 1] >= nArray[i]) {
                throw new AssertionError((Object)"expecting sorted tags");
            }
        }
        if (!$assertionsDisabled && !this.assertTreeSubTypeOf(tree2, type)) {
            throw new AssertionError();
        }
        Tree.Switch switch_ = this.make.Switch(n, tree, nArray, treeArray, tree2);
        switch_.setType(type);
        return switch_;
    }

    public Tree.Switch Switch(Tree tree, int[] nArray, Tree[] treeArray, Tree tree2, Type type) {
        return this.Switch(tree.pos, tree, nArray, treeArray, tree2, type);
    }

    public Tree.Switch Switch(int n, Tree tree, int[] nArray, Tree[] treeArray, Tree tree2) {
        Type[] typeArray = new Type[treeArray.length + 1];
        for (int i = 0; i < treeArray.length; ++i) {
            typeArray[i] = treeArray[i].getType();
        }
        typeArray[treeArray.length] = tree2.getType();
        this.global.nextPhase();
        Type type = Type.lub(typeArray);
        this.global.prevPhase();
        return this.Switch(n, tree, nArray, treeArray, tree2, type);
    }

    public Tree.Switch Switch(Tree tree, int[] nArray, Tree[] treeArray, Tree tree2) {
        return this.Switch(tree.pos, tree, nArray, treeArray, tree2);
    }

    public Tree.Return Return(int n, Symbol symbol, Tree tree) {
        Tree.Return return_ = this.make.Return(n, symbol, tree);
        return_.setType(this.definitions.ALL_TYPE());
        return return_;
    }

    public Tree.Return Return(Symbol symbol, Tree tree) {
        return this.Return(tree.pos, symbol, tree);
    }

    public Tree.Typed Typed(int n, Tree tree, Tree tree2) {
        Tree.Typed typed = this.make.Typed(n, tree, tree2);
        typed.setType(tree2.type());
        return typed;
    }

    public Tree.Typed Typed(Tree tree, Tree tree2) {
        return this.Typed(tree.pos, tree, tree2);
    }

    public Tree.Typed Typed(int n, Tree tree, Type type) {
        return this.Typed(n, tree, this.mkType(n, type));
    }

    public Tree.Typed Typed(Tree tree, Type type) {
        return this.Typed(tree.pos, tree, type);
    }

    public Tree mkNil(int n) {
        return this.mkGlobalRef(n, this.definitions.NIL());
    }

    public Tree mkNewCons(int n, Type type, Tree tree, Tree tree2) {
        this.global.nextPhase();
        if (!$assertionsDisabled && !tree.type().isSubType(type)) {
            throw new AssertionError((Object)String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(type)).concat(" -- "))).concat(String.valueOf(String.valueOf(tree))))).concat(" : "))).concat(String.valueOf(String.valueOf(tree.type))))));
        }
        if (!$assertionsDisabled && !tree2.type().isSubType(this.definitions.LIST_TYPE(type))) {
            throw new AssertionError((Object)String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(type)).concat(" -- "))).concat(String.valueOf(String.valueOf(tree2))))).concat(" : "))).concat(String.valueOf(String.valueOf(tree2.type))))));
        }
        this.global.prevPhase();
        return this.New(this.mkApplyTV(this.mkPrimaryConstructorGlobalRef(n, this.definitions.CONS_CLASS()), new Type[]{type}, new Tree[]{tree, tree2}));
    }

    public Tree mkNewCons(Type type, Tree tree, Tree tree2) {
        return this.mkNewCons(tree.pos, type, tree, tree2);
    }

    public Tree mkNewList(int n, Type type, Tree[] treeArray) {
        Tree tree = this.mkNil(n);
        for (int i = treeArray.length - 1; i >= 0; --i) {
            tree = this.mkNewCons(n, type, treeArray[i], tree);
        }
        return tree;
    }

    public Tree mkNewArray(int n, Type type, Tree tree) {
        return this.New(this.mkApplyTV(this.mkPrimaryConstructorGlobalRef(n, this.definitions.ARRAY_CLASS), new Type[]{type}, new Tree[]{tree}));
    }

    public Tree mkNewArray(Type type, Tree tree) {
        return this.mkNewArray(tree.pos, type, tree);
    }

    public Tree mkNewArray(int n, Type type, int n2) {
        return this.mkNewArray(n, type, this.mkIntLit(n, n2));
    }

    public Tree mkNewArray(int n, Type type, Tree[] treeArray, Symbol symbol) {
        if (treeArray.length == 0) {
            return this.mkNewArray(n, type, 0);
        }
        Tree[] treeArray2 = new Tree[1 + treeArray.length];
        Symbol symbol2 = this.newLocal(symbol, n, 2, "array", this.definitions.array_TYPE(type));
        treeArray2[0] = this.ValDef(symbol2, this.mkNewArray(n, type, treeArray.length));
        for (int i = 0; i < treeArray.length; ++i) {
            treeArray2[1 + i] = this.mkArraySet((Tree)this.Ident(n, symbol2), i, treeArray[i]);
        }
        return this.Block(n, treeArray2, this.Ident(n, symbol2));
    }

    public Tree mkArrayLength(int n, Tree tree) {
        Tree.Select select = this.Select(n, tree, this.definitions.ARRAY_LENGTH());
        return this.Apply(n, select);
    }

    public Tree mkArrayLength(Tree tree) {
        return this.mkArrayLength(tree.pos, tree);
    }

    public Tree mkArrayGet(int n, Tree tree, Tree tree2) {
        Tree.Select select = this.Select(n, tree, this.definitions.ARRAY_GET());
        return this.Apply(n, select, new Tree[]{tree2});
    }

    public Tree mkArrayGet(Tree tree, Tree tree2) {
        return this.mkArrayGet(tree.pos, tree, tree2);
    }

    public Tree mkArrayGet(int n, Tree tree, int n2) {
        return this.mkArrayGet(n, tree, this.mkIntLit(n, n2));
    }

    public Tree mkArrayGet(Tree tree, int n) {
        return this.mkArrayGet(tree.pos, tree, n);
    }

    public Tree mkArraySet(int n, Tree tree, Tree tree2, Tree tree3) {
        Tree.Select select = this.Select(n, tree, this.definitions.ARRAY_SET());
        return this.Apply(n, select, new Tree[]{tree2, tree3});
    }

    public Tree mkArraySet(Tree tree, Tree tree2, Tree tree3) {
        return this.mkArraySet(tree.pos, tree, tree2, tree3);
    }

    public Tree mkArraySet(int n, Tree tree, int n2, Tree tree2) {
        return this.mkArraySet(n, tree, this.mkIntLit(n, n2), tree2);
    }

    public Tree mkArraySet(Tree tree, int n, Tree tree2) {
        return this.mkArraySet(tree.pos, tree, n, tree2);
    }

    public Tree.AbsTypeDef[] mkTypeParamsOf(Symbol symbol) {
        Symbol[] symbolArray = symbol.nextTypeParams();
        Tree.AbsTypeDef[] absTypeDefArray = new Tree.AbsTypeDef[symbolArray.length];
        for (int i = 0; i < symbolArray.length; ++i) {
            absTypeDefArray[i] = this.mkTypeParam(symbolArray[i]);
        }
        return absTypeDefArray;
    }

    public Tree.ValDef[][] mkParamsOf(Symbol symbol) {
        this.global.nextPhase();
        if (symbol.isClass()) {
            symbol = symbol.primaryConstructor();
        }
        Object object = symbol.type();
        this.global.prevPhase();
        Tree.ValDef[][] valDefArray = Tree.ValDef_EMPTY_ARRAY_ARRAY;
        block4: while (true) {
            switch (object.$tag) {
                case 5: {
                    Symbol[] symbolArray;
                    Type type = (Type.PolyType)object;
                    object = symbolArray = type.result;
                    continue block4;
                }
                case 3: {
                    Type type = (Type.MethodType)object;
                    Symbol[] symbolArray = ((Type.MethodType)type).vparams;
                    Type type2 = ((Type.MethodType)type).result;
                    Tree.ValDef[] valDefArray2 = new Tree.ValDef[symbolArray.length];
                    for (int i = 0; i < symbolArray.length; ++i) {
                        valDefArray2[i] = this.mkParam(symbolArray[i]);
                    }
                    Tree.ValDef[][] valDefArrayArray = new Tree.ValDef[valDefArray.length + 1][];
                    for (int i = 0; i < valDefArray.length; ++i) {
                        valDefArrayArray[i] = valDefArray[i];
                    }
                    valDefArrayArray[valDefArray.length] = valDefArray2;
                    valDefArray = valDefArrayArray;
                    object = type2;
                    continue block4;
                }
            }
            break;
        }
        return valDefArray;
    }

    public Tree.AbsTypeDef mkTypeParam(Symbol symbol) {
        return this.AbsTypeDef(symbol);
    }

    public Tree.ValDef mkParam(Symbol symbol) {
        return this.ValDef(symbol, Tree.Empty);
    }

    public Tree.PackageDef PackageDef(Tree tree, Tree.Template template) {
        Tree.PackageDef packageDef = this.make.PackageDef(tree.pos, tree, template);
        packageDef.setType(Type.NoType);
        return packageDef;
    }

    public Tree.PackageDef PackageDef(Symbol symbol, Tree.Template template) {
        return this.PackageDef(this.mkGlobalRef(symbol.pos, symbol), template);
    }

    public Tree.PackageDef PackageDef(Tree tree, Tree[] treeArray) {
        return this.PackageDef(tree, this.Template(tree.pos, Symbol.NONE, Tree.EMPTY_ARRAY, treeArray));
    }

    public Tree.PackageDef PackageDef(Symbol symbol, Tree[] treeArray) {
        return this.PackageDef(this.mkGlobalRef(symbol.pos, symbol), treeArray);
    }

    public Tree.ClassDef ClassDef(Symbol symbol, Tree.Template template) {
        Tree tree = Tree.Empty;
        if (symbol.thisSym() != symbol) {
            this.global.nextPhase();
            tree = this.mkType(symbol.pos, symbol.typeOfThis());
            this.global.prevPhase();
        }
        Tree.ClassDef classDef = this.make.ClassDef(symbol.pos, symbol, this.mkTypeParamsOf(symbol), this.mkParamsOf(symbol), tree, template);
        classDef.setType(Type.NoType);
        return classDef;
    }

    public Tree.ClassDef ClassDef(Symbol symbol, Tree[] treeArray, Symbol symbol2, Tree[] treeArray2) {
        return this.ClassDef(symbol, this.Template(symbol.pos, symbol2, treeArray, treeArray2));
    }

    public Tree ClassDef(Symbol symbol, Tree[] treeArray) {
        for (int i = 0; i < treeArray.length; ++i) {
            if (!($assertionsDisabled || treeArray[i] == Tree.Empty || treeArray[i].definesSymbol() && treeArray[i].symbol().owner() == symbol)) {
                throw new AssertionError((Object)String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf("\nclass : ".concat(String.valueOf(String.valueOf(Debug.show(symbol)))))).concat("\nmember: "))).concat(String.valueOf(String.valueOf(Debug.show(treeArray[i].symbol())))))).concat("\nmember: "))).concat(String.valueOf(String.valueOf(treeArray[i]))))));
            }
        }
        Global.instance.nextPhase();
        Type[] typeArray = symbol.parents();
        Global.instance.prevPhase();
        Tree[] treeArray2 = new Tree[typeArray.length];
        for (int i = 0; i < treeArray2.length; ++i) {
            Type type = typeArray[i];
            if (type.$tag != 8) {
                throw Debug.abort("invalid type", typeArray[i]);
            }
            Type.TypeRef typeRef = (Type.TypeRef)type;
            Type type2 = typeRef.pre;
            Symbol symbol2 = typeRef.sym;
            Type[] typeArray2 = typeRef.args;
            treeArray2[i] = this.mkApplyT_(this.mkPrimaryConstructorRef(symbol.pos, type2, symbol2), typeArray2);
        }
        return this.ClassDef(symbol, treeArray2, Symbol.NONE, treeArray);
    }

    public Tree.ValDef ValDef(Symbol symbol, Tree tree) {
        Tree.ValDef valDef = this.make.ValDef(symbol.pos, symbol, this.TypeTerm(symbol.pos, symbol.nextType()), tree);
        valDef.setType(Type.NoType);
        return valDef;
    }

    public Tree.DefDef DefDef(Symbol symbol, Tree tree) {
        Tree.DefDef defDef = this.make.DefDef(symbol.pos, symbol, this.mkTypeParamsOf(symbol), this.mkParamsOf(symbol), this.TypeTerm(symbol.pos, symbol.nextType().resultType()), tree);
        defDef.setType(Type.NoType);
        return defDef;
    }

    public Tree.AbsTypeDef AbsTypeDef(Symbol symbol) {
        Tree.AbsTypeDef absTypeDef = this.make.AbsTypeDef(symbol.pos, symbol, this.TypeTerm(symbol.pos, symbol.isViewBounded() ? symbol.vuBound() : symbol.nextInfo()), this.TypeTerm(symbol.pos, symbol.loBound()));
        absTypeDef.setType(Type.NoType);
        return absTypeDef;
    }

    public Tree.AliasTypeDef AliasTypeDef(Symbol symbol) {
        Tree.AliasTypeDef aliasTypeDef = this.make.AliasTypeDef(symbol.pos, symbol, this.mkTypeParamsOf(symbol), this.TypeTerm(symbol.pos, symbol.nextInfo()));
        aliasTypeDef.setType(Type.NoType);
        return aliasTypeDef;
    }

    public Tree.CaseDef CaseDef(Tree tree, Tree tree2, Tree tree3) {
        Tree.CaseDef caseDef = this.make.CaseDef(tree.pos, tree, tree2, tree3);
        caseDef.setType(tree3.getType());
        return caseDef;
    }

    public Tree.CaseDef CaseDef(Tree tree, Tree tree2) {
        return this.CaseDef(tree, Tree.Empty, tree2);
    }

    public Tree.LabelDef LabelDef(Symbol symbol, Tree.Ident[] identArray, Tree tree) {
        Tree.LabelDef labelDef = this.make.LabelDef(symbol.pos, symbol, identArray, tree);
        labelDef.setType(symbol.nextType().resultType());
        return labelDef;
    }

    public Tree.LabelDef LabelDef(Symbol symbol, Symbol[] symbolArray, Tree tree) {
        Tree.Ident[] identArray = new Tree.Ident[symbolArray.length];
        for (int i = 0; i < symbolArray.length; ++i) {
            identArray[i] = this.Ident(symbolArray[i].pos, symbolArray[i]);
        }
        return this.LabelDef(symbol, identArray, tree);
    }

    private boolean assertTreeSubTypeOf(Tree tree, Type type) {
        this.global.nextPhase();
        if (!$assertionsDisabled && !tree.getType().isSubType(type)) {
            throw new AssertionError((Object)String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf("\ntree    : ".concat(String.valueOf(String.valueOf(tree))))).concat("\ntype    : "))).concat(String.valueOf(String.valueOf(tree.getType()))))).concat("\nexpected: "))).concat(String.valueOf(String.valueOf(type))))));
        }
        this.global.prevPhase();
        return true;
    }

    private Symbol newLocal(Symbol symbol, int n, int n2, String string, Type type) {
        Name name = Names.LOCAL(symbol);
        Symbol symbol2 = symbol.newVariable(n, n2 |= 0x400, name);
        this.global.nextPhase();
        symbol2.setType(type);
        this.global.prevPhase();
        return symbol2;
    }

    private Symbol primaryConstructorOf(Symbol symbol) {
        this.global.nextPhase();
        Symbol symbol2 = symbol.primaryConstructor();
        this.global.prevPhase();
        return symbol2;
    }

    public Tree mkUnitFunction(Tree tree, Type type, Symbol symbol) {
        return this.mkFunction(tree.pos, Tree.ValDef_EMPTY_ARRAY, tree, type, symbol);
    }

    public Tree mkFunction(int n, Tree.ValDef[] valDefArray, Tree tree, Type type, Symbol symbol) {
        int n2 = valDefArray.length;
        Symbol[] symbolArray = new Symbol[n2];
        Type[] typeArray = new Type[n2];
        for (int i = 0; i < n2; ++i) {
            symbolArray[i] = valDefArray[i].symbol();
            typeArray[i] = symbolArray[i].type();
        }
        Type[] typeArray2 = new Type[]{this.definitions.ANYREF_TYPE(), this.definitions.FUNCTION_TYPE(typeArray, type)};
        TypeName typeName = Names.ANON_CLASS_NAME.toTypeName();
        ClassSymbol classSymbol = symbol.newAnonymousClass(n, typeName);
        classSymbol.setInfo(Type.compoundType(typeArray2, new Scope(), classSymbol));
        ((Symbol)classSymbol).allConstructors().setInfo(Type.MethodType(Symbol.EMPTY_ARRAY, ((Symbol)classSymbol).typeConstructor()));
        Symbol symbol2 = classSymbol.newMethod(n, 2, Names.apply).setInfo(Type.MethodType(symbolArray, type));
        classSymbol.info().members().enter(symbol2);
        for (int i = 0; i < symbolArray.length; ++i) {
            symbolArray[i].setOwner(symbol2);
        }
        this.changeOwner(tree, symbol, symbol2);
        Tree[] treeArray = new Tree[]{this.DefDef(symbol2, tree)};
        Tree tree2 = this.ClassDef((Symbol)classSymbol, treeArray);
        Tree.New new_ = this.New(this.mkApply__(this.mkPrimaryConstructorLocalRef(n, classSymbol)));
        return this.mkBlock(tree2, (Tree)this.Typed((Tree)new_, typeArray2[1]));
    }

    public Tree mkPartialFunction(int n, Tree tree, Tree tree2, Type type, Type type2, Symbol symbol) {
        TypeName typeName = Names.ANON_CLASS_NAME.toTypeName();
        ClassSymbol classSymbol = symbol.newAnonymousClass(n, typeName);
        Type[] typeArray = new Type[]{this.definitions.ANYREF_TYPE(), this.definitions.PARTIALFUNCTION_TYPE(type, type2)};
        classSymbol.setInfo(Type.compoundType(typeArray, new Scope(), classSymbol));
        ((Symbol)classSymbol).allConstructors().setInfo(Type.MethodType(Symbol.EMPTY_ARRAY, ((Symbol)classSymbol).typeConstructor()));
        Tree[] treeArray = new Tree[]{this.makeVisitorMethod(n, Names.apply, tree, type, type2, classSymbol, symbol), this.makeVisitorMethod(n, Names.isDefinedAt, tree2, type, this.definitions.boolean_TYPE(), classSymbol, symbol)};
        Tree tree3 = this.ClassDef((Symbol)classSymbol, treeArray);
        Tree.New new_ = this.New(this.mkApply__(this.mkPrimaryConstructorLocalRef(n, classSymbol)));
        return this.mkBlock(tree3, (Tree)this.Typed((Tree)new_, typeArray[1]));
    }

    private Tree makeVisitorMethod(int n, Name name, Tree tree, Type type, Type type2, Symbol symbol, Symbol symbol2) {
        Symbol symbol3 = symbol.newMethod(n, 2, name);
        Symbol symbol4 = symbol3.newVParam(n, 0, Name.fromString("x$"), type);
        symbol3.setInfo(Type.MethodType(new Symbol[]{symbol4}, type2));
        symbol.info().members().enter(symbol3);
        this.changeOwner(tree, symbol2, symbol3);
        Tree tree2 = this.mkApplyTV((Tree)this.Select(this.Ident(n, symbol4), this.definitions.ANY_MATCH), new Tree[]{this.mkType(n, type), this.mkType(n, type2)}, new Tree[]{tree});
        return this.DefDef(symbol3, tree2);
    }

    public void changeOwner(Tree tree, Symbol symbol, Symbol symbol2) {
        1 var4_4 = new 1(symbol, symbol2, this);
        ((Traverser)var4_4).traverse(tree);
    }

    public Tree postfixApply(Tree tree, Tree tree2, Symbol symbol) {
        if (TreeInfo.isPureExpr(tree) || TreeInfo.isPureExpr(tree2)) {
            return this.Apply(this.Select(tree2, this.definitions.FUNCTION_APPLY(1)), new Tree[]{tree});
        }
        Symbol symbol2 = this.newLocal(symbol, tree.pos, 2, "postfix", tree.type);
        Tree tree3 = this.postfixApply(this.Ident(tree.pos, symbol2), tree2, symbol);
        return this.mkBlock(this.ValDef(symbol2, tree), tree3);
    }

    public Tree Console_print(int n, String string) {
        return this.Console_print(n, this.mkStringLit(n, string));
    }

    public Tree Console_print(int n, Tree tree) {
        return this.Apply(this.Select(n, this.mkGlobalRef(n, this.definitions.CONSOLE), this.definitions.CONSOLE_PRINT()), new Tree[]{tree});
    }

    static {
        $assertionsDisabled = !Class.forName("scalac.ast.TreeGen").desiredAssertionStatus();
    }

    static class 1
    extends Traverser {
        final /* synthetic */ Symbol val$prevOwner;
        final /* synthetic */ Symbol val$newOwner;
        final /* synthetic */ TreeGen this$0;

        public void traverse(Tree tree) {
            Symbol symbol;
            if (tree.definesSymbol() && (symbol = tree.symbol()) != null && symbol.owner() == this.val$prevOwner) {
                symbol.setOwner(this.val$newOwner);
            }
            super.traverse(tree);
        }

        1(Symbol symbol, Symbol symbol2, TreeGen treeGen) {
            this.val$prevOwner = symbol;
            this.val$newOwner = symbol2;
            this.this$0 = treeGen;
        }
    }
}

