/*
 * Decompiled with CFR 0.152.
 */
package scalac.transformer.matching;

import scalac.CompilationUnit;
import scalac.ast.Tree;
import scalac.ast.TreeGen;
import scalac.symtab.Definitions;
import scalac.symtab.Symbol;
import scalac.symtab.Type;

class CaseEnv {
    Symbol owner;
    Definitions defs;
    TreeGen gen;
    protected Tree.ValDef[] boundVars = new Tree.ValDef[4];
    protected int numVars = 0;

    CaseEnv(Symbol symbol, CompilationUnit compilationUnit) {
        this.owner = symbol;
        this.defs = compilationUnit.global.definitions;
        this.gen = compilationUnit.global.treeGen;
    }

    public void substitute(Symbol symbol, Tree tree) {
        for (int i = 0; i < this.numVars; ++i) {
            if (this.boundVars[i].rhs.symbol() != symbol) continue;
            this.boundVars[i].rhs = tree;
            return;
        }
    }

    public void newBoundVar(Symbol symbol, Type type, Tree tree) {
        symbol.setOwner(this.owner);
        if (this.numVars == this.boundVars.length) {
            Tree.ValDef[] valDefArray = new Tree.ValDef[this.numVars * 2];
            System.arraycopy(this.boundVars, 0, valDefArray, 0, this.numVars);
            this.boundVars = valDefArray;
        }
        symbol.setType(type);
        this.boundVars[this.numVars++] = this.gen.ValDef(symbol, tree.duplicate());
    }

    public Tree.ValDef[] boundVars() {
        Tree.ValDef[] valDefArray = new Tree.ValDef[this.numVars];
        System.arraycopy(this.boundVars, 0, valDefArray, 0, this.numVars);
        return valDefArray;
    }

    public boolean equals(Object object) {
        if (!(object instanceof CaseEnv)) {
            return false;
        }
        CaseEnv caseEnv = (CaseEnv)object;
        if (caseEnv.numVars != this.numVars) {
            return false;
        }
        for (int i = 0; i < this.numVars; ++i) {
            if (this.boundVars[i].name == caseEnv.boundVars[i].name && this.boundVars[i].tpe.type.isSameAs(caseEnv.boundVars[i].tpe.type) && this.boundVars[i].rhs == caseEnv.boundVars[i].rhs) continue;
            return false;
        }
        return true;
    }
}

