/*
 * Decompiled with CFR 0.152.
 */
package scalac.transformer;

import java.util.HashMap;
import java.util.Map;
import scalac.CompilationUnit;
import scalac.Global;
import scalac.Phase;
import scalac.PhaseDescriptor;
import scalac.symtab.Definitions;
import scalac.symtab.Scope;
import scalac.symtab.Symbol;
import scalac.symtab.SymbolNameWriter;
import scalac.symtab.SymbolSubstTypeMap;
import scalac.symtab.Type;
import scalac.transformer.AddInterfaces;
import scalac.util.Debug;
import scalac.util.Name;
import scalac.util.TermName;

public class AddInterfacesPhase
extends Phase {
    protected final SymbolNameWriter uniqueNameWriter = new SymbolNameWriter().setAllSeparators('$').setRootSeparator('\u0000');
    protected static final String CLASS_SUFFIX = "$class";
    protected HashMap ifaceToClass = new HashMap();
    protected HashMap classToIFace = new HashMap();
    HashMap classSubstitutions = new HashMap();
    HashMap classMemberMaps = new HashMap();
    private static final /* synthetic */ boolean $assertionsDisabled;

    public AddInterfacesPhase(Global global, PhaseDescriptor phaseDescriptor) {
        super(global, phaseDescriptor);
    }

    public void apply(CompilationUnit[] compilationUnitArray) {
        for (int i = 0; i < compilationUnitArray.length; ++i) {
            new AddInterfaces(this.global, this).apply(compilationUnitArray[i]);
        }
    }

    public Type transformInfo(Symbol symbol, Type type) {
        if (symbol.isConstructor() || symbol.owner().isConstructor()) {
            return type;
        }
        if (symbol.isClass() && !symbol.isJava()) {
            Type[] typeArray;
            Definitions definitions = this.global.definitions;
            if (symbol == definitions.ANY_CLASS) {
                return type;
            }
            Type[] typeArray2 = type.parents();
            if (!$assertionsDisabled && typeArray2.length <= 0) {
                throw new AssertionError((Object)String.valueOf(String.valueOf(Debug.show(symbol))));
            }
            for (int i = 1; i < typeArray2.length; ++i) {
                Symbol symbol2 = typeArray2[i].symbol();
                if (!$assertionsDisabled && symbol2.isJava() && !symbol2.isInterface()) {
                    throw new AssertionError((Object)String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(Debug.show(symbol))).concat(" <: "))).concat(String.valueOf(String.valueOf(Debug.show(symbol2)))))));
                }
            }
            boolean bl = this.needInterface(symbol);
            Scope scope = new Scope();
            Scope.SymbolIterator symbolIterator = type.members().iterator();
            while (symbolIterator.hasNext()) {
                Symbol symbol3 = symbolIterator.next();
                if (bl && (symbol3.isInitializer() || !this.memberGoesInInterface(symbol3))) continue;
                if (symbol3.isPrivate()) {
                    symbol3.name = this.uniqueName(symbol3);
                    symbol3.flags ^= 4;
                } else if (symbol3.isProtected()) {
                    symbol3.flags ^= 8;
                }
                scope.enterOrOverload(symbol3);
            }
            if (bl) {
                symbol.flags |= 0x10000000;
                typeArray = typeArray2;
            } else {
                typeArray = new Type[typeArray2.length];
                for (int i = 0; i < typeArray2.length; ++i) {
                    Type type2 = typeArray2[i];
                    if (type2.$tag != 8) {
                        throw Debug.abort("illegal case", typeArray2[i]);
                    }
                    Type.TypeRef typeRef = (Type.TypeRef)type2;
                    Type type3 = typeRef.pre;
                    Symbol symbol4 = typeRef.sym;
                    Type[] typeArray3 = typeRef.args;
                    typeArray[i] = !this.needInterface(symbol4) ? typeArray2[i] : Type.typeRef(type3, this.getClassSymbol(symbol4), typeArray3);
                }
            }
            return Type.compoundType(typeArray, scope, symbol);
        }
        return type;
    }

    protected boolean memberGoesInInterface(Symbol symbol) {
        return symbol.isType() || symbol.isMethod();
    }

    protected Name uniqueName(Symbol symbol) {
        TermName termName = Name.fromString(this.uniqueNameWriter.toString(symbol));
        return symbol.name.isTypeName() ? termName.toTypeName() : termName;
    }

    protected boolean needInterface(Symbol symbol) {
        if (!$assertionsDisabled && !symbol.isClass()) {
            throw new AssertionError((Object)String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(Debug.show(symbol))).concat(" is not a class (kind "))).concat(String.valueOf(symbol.kind)))).concat(")"))));
        }
        return !symbol.isJava() && !symbol.isModuleClass() && !symbol.isAnonymousClass() && !this.hasInterfaceSymbol(symbol) && symbol != this.global.definitions.ANY_CLASS && symbol != this.global.definitions.ANYREF_CLASS && symbol != this.global.definitions.ALL_CLASS && symbol != this.global.definitions.ALLREF_CLASS;
    }

    protected Name className(Name name) {
        TermName termName = Name.fromString(String.valueOf(String.valueOf(name.toString())).concat(CLASS_SUFFIX));
        if (name.isTypeName()) {
            return termName.toTypeName();
        }
        return termName;
    }

    protected Symbol getClassSymbol(Symbol symbol) {
        if (!$assertionsDisabled && !symbol.isClass()) {
            throw new AssertionError((Object)String.valueOf(String.valueOf(Debug.show(symbol))));
        }
        if (!this.needInterface(symbol)) {
            return symbol;
        }
        Symbol symbol2 = (Symbol)this.ifaceToClass.get(symbol);
        if (symbol2 == null) {
            Type[] typeArray;
            symbol2 = symbol.cloneSymbol(symbol.owner());
            symbol2.name = this.className(symbol.name);
            symbol.flags &= 0xFFFFFFFD;
            symbol2.flags &= 0xEFFFFFFF;
            Scope scope = symbol.owner().members();
            scope.enter(symbol2);
            Type.SubstThisMap substThisMap = new Type.SubstThisMap(symbol, symbol2);
            SymbolSubstTypeMap symbolSubstTypeMap = this.newClassSubst(symbol2);
            HashMap hashMap = this.newClassMemberMap(symbol2);
            Symbol[] symbolArray = symbol.typeParams();
            Symbol[] symbolArray2 = symbol2.typeParams();
            symbolSubstTypeMap.insertSymbol(symbolArray, symbolArray2);
            Scope scope2 = new Scope();
            Scope.SymbolIterator symbolIterator = symbol.members().iterator();
            while (symbolIterator.hasNext()) {
                Object object;
                typeArray = symbolIterator.next();
                if (typeArray.isType() || typeArray.isDeferred()) continue;
                if (this.memberGoesInInterface((Symbol)typeArray)) {
                    if (typeArray.isPrivate()) {
                        typeArray.name = this.uniqueName((Symbol)typeArray);
                        typeArray.flags |= 2;
                        typeArray.flags ^= 4;
                    } else if (typeArray.isProtected()) {
                        typeArray.flags ^= 8;
                    }
                    object = typeArray.cloneSymbol(symbol2);
                    typeArray.flags &= 0xFFFFFFFD;
                    ((Symbol)object).setInfo(substThisMap.applyParams(symbolSubstTypeMap.applyParams(((Symbol)object).info().cloneType((Symbol)typeArray, (Symbol)object))));
                    typeArray.flags |= 1;
                } else {
                    object = typeArray;
                    ((Symbol)object).setOwner(symbol2);
                    ((Symbol)object).updateInfo(substThisMap.apply(symbolSubstTypeMap.apply(((Symbol)object).info())));
                }
                hashMap.put(typeArray, object);
                scope2.enterOrOverload((Symbol)object);
            }
            typeArray = symbol2.parents();
            int n = typeArray.length;
            Type[] typeArray2 = new Type[n + 1];
            for (int i = 0; i < n; ++i) {
                Type type = typeArray[i];
                if (type.$tag != 8) {
                    throw Debug.abort("unexpected type for parent", typeArray[i]);
                }
                Type.TypeRef typeRef = (Type.TypeRef)type;
                Type type2 = typeRef.pre;
                Symbol symbol3 = typeRef.sym;
                Type[] typeArray3 = typeRef.args;
                Type type3 = Type.typeRef(type2, this.getClassSymbol(symbol3), typeArray3);
                typeArray2[i] = symbolSubstTypeMap.apply(type3);
            }
            typeArray2[n] = symbolSubstTypeMap.apply(symbol.type());
            symbol2.updateInfo(Type.compoundType(typeArray2, scope2, symbol2));
            this.ifaceToClass.put(symbol, symbol2);
            this.classToIFace.put(symbol2, symbol);
        }
        return symbol2;
    }

    public boolean hasInterfaceSymbol(Symbol symbol) {
        return this.classToIFace.containsKey(symbol);
    }

    public Symbol getInterfaceSymbol(Symbol symbol) {
        return (Symbol)this.classToIFace.get(symbol);
    }

    protected SymbolSubstTypeMap newClassSubst(Symbol symbol) {
        SymbolSubstTypeMap symbolSubstTypeMap = new SymbolSubstTypeMap();
        this.classSubstitutions.put(symbol, symbolSubstTypeMap);
        return symbolSubstTypeMap;
    }

    public SymbolSubstTypeMap getClassSubst(Symbol symbol) {
        SymbolSubstTypeMap symbolSubstTypeMap = (SymbolSubstTypeMap)this.classSubstitutions.get(symbol);
        if (!$assertionsDisabled && symbolSubstTypeMap == null) {
            throw new AssertionError();
        }
        return symbolSubstTypeMap;
    }

    protected HashMap newClassMemberMap(Symbol symbol) {
        HashMap hashMap = new HashMap();
        this.classMemberMaps.put(symbol, hashMap);
        return hashMap;
    }

    public Map getClassMemberMap(Symbol symbol) {
        return (Map)this.classMemberMaps.get(symbol);
    }

    static {
        $assertionsDisabled = !Class.forName("scalac.transformer.AddInterfacesPhase").desiredAssertionStatus();
    }
}

