/*
 * Decompiled with CFR 0.152.
 */
package scalac.symtab.classfile;

import scalac.Global;
import scalac.symtab.Symbol;
import scalac.symtab.Type;
import scalac.symtab.classfile.JavaTypeFactory;
import scalac.util.AbstractFileReader;
import scalac.util.Name;
import scalac.util.Names;
import scalac.util.SourceRepresentation;

public class Signatures {
    private final Global global;
    private final JavaTypeFactory make;
    private final AbstractFileReader in;
    private int first;
    private int last;
    private int current;

    public Signatures(Global global, JavaTypeFactory javaTypeFactory, AbstractFileReader abstractFileReader) {
        this.global = global;
        this.make = javaTypeFactory;
        this.in = abstractFileReader;
    }

    public Signatures at(int n) {
        this.first = n + 3;
        this.last = this.first + this.in.getChar(n + 1) - 1;
        this.current = this.first;
        return this;
    }

    public String getSignature() {
        return SourceRepresentation.ascii2string(this.in.buf, this.first, this.last - this.first + 1);
    }

    public Symbol readClassName() {
        Symbol symbol;
        Name name;
        byte by;
        Symbol symbol2 = this.global.definitions.ROOT_CLASS;
        int n = this.current;
        while (this.current <= this.last && (by = this.in.byteAt(this.current)) != 59) {
            if (by == 47) {
                name = Name.fromAscii(this.in.buf, n, this.current - n);
                symbol = symbol2.members().lookup(name);
                if (!symbol.isModule()) {
                    Symbol symbol3 = symbol2.newModule(0, 0, name);
                    symbol3.moduleClass().setInfo(Type.ErrorType);
                    this.error("could not find module ".concat(String.valueOf(String.valueOf(symbol3.staticType()))));
                    if (symbol.isNone()) {
                        symbol2.members().enterNoHide(symbol3);
                    }
                    symbol = symbol3;
                }
                symbol2 = symbol.moduleClass();
                n = this.current + 1;
            }
            ++this.current;
        }
        Symbol symbol4 = null;
        name = Name.fromAscii(this.in.buf, n, this.current - n);
        if (symbol2 == this.global.definitions.JAVALANG.moduleClass()) {
            if (name == Names.String) {
                symbol4 = this.global.definitions.STRING_CLASS;
            } else if (name == Names.Object) {
                symbol4 = this.global.definitions.OBJECT_CLASS;
            }
        }
        if (symbol4 == null) {
            name = name.toTypeName();
            symbol4 = symbol2.members().lookup(name);
        }
        if (!symbol4.isClass()) {
            symbol = symbol2.newErrorClass(name);
            this.error("could not find class ".concat(String.valueOf(String.valueOf(symbol.staticType()))));
            if (symbol4.isNone()) {
                symbol2.members().enterNoHide(symbol);
            }
            symbol4 = symbol;
        }
        ++this.current;
        return symbol4;
    }

    public Type readValueType() {
        switch (this.in.byteAt(this.current++)) {
            case 86: {
                return this.make.voidType();
            }
            case 90: {
                return this.make.booleanType();
            }
            case 66: {
                return this.make.byteType();
            }
            case 83: {
                return this.make.shortType();
            }
            case 67: {
                return this.make.charType();
            }
            case 73: {
                return this.make.intType();
            }
            case 74: {
                return this.make.longType();
            }
            case 70: {
                return this.make.floatType();
            }
            case 68: {
                return this.make.doubleType();
            }
            case 76: {
                return this.make.classType(this.readClassName());
            }
            case 91: {
                return this.make.arrayType(this.readValueType());
            }
        }
        return this.errorBadTypeTag(this.current - 1);
    }

    public Type readMethodType() {
        if (this.in.byteAt(this.current++) != 40) {
            return this.errorBadTypeTag(this.current - 1);
        }
        Type[] typeArray = this.readParamterTypes(0);
        Type type = this.readValueType();
        return this.make.methodType(typeArray, type, Type.EMPTY_ARRAY);
    }

    private Type[] readParamterTypes(int n) {
        if (this.in.byteAt(this.current) == 41) {
            ++this.current;
            return new Type[n];
        }
        Type type = this.readValueType();
        Type[] typeArray = this.readParamterTypes(n + 1);
        typeArray[n] = type;
        return typeArray;
    }

    private Type errorBadTypeTag(int n) {
        char c = (char)this.in.byteAt(n);
        this.error(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf("bad tag '".concat(String.valueOf(c)))).concat("' in signature '"))).concat(String.valueOf(String.valueOf(this.getSignature()))))).concat("'"));
        return Type.ErrorType;
    }

    private void error(String string) {
        this.global.error(String.valueOf(String.valueOf(String.valueOf(String.valueOf("class file '".concat(String.valueOf(String.valueOf(this.in.path))))).concat("': "))).concat(String.valueOf(String.valueOf(string))));
    }
}

