/*
 * Decompiled with CFR 0.152.
 */
package scalac.symtab;

import java.util.Iterator;
import java.util.TreeMap;
import scalac.framework.History;
import scalac.symtab.Symbol;
import scalac.symtab.SymbolComparator;
import scalac.symtab.Type;
import scalac.util.Debug;

public class ClosureHistory
extends History {
    protected Object transformValue(Object object, Object object2) {
        Type[] typeArray = (Type[])object2;
        for (int i = 0; i < typeArray.length; ++i) {
            Symbol symbol = typeArray[i].symbol();
            if (symbol.info() == symbol.nextInfo()) continue;
            return super.transformValue(object, typeArray);
        }
        return typeArray;
    }

    protected Object computeValue(Object object) {
        Symbol symbol = (Symbol)object;
        TreeMap treeMap = new TreeMap(SymbolComparator.instance);
        ClosureHistory.addParents(treeMap, symbol.info());
        Type[] typeArray = new Type[1 + treeMap.size()];
        Iterator iterator = treeMap.values().iterator();
        typeArray[0] = symbol.type();
        for (int i = 1; i < typeArray.length; ++i) {
            typeArray[i] = (Type)iterator.next();
        }
        return typeArray;
    }

    private static void addParents(TreeMap treeMap, Type type) {
        switch (type.$tag) {
            case 13: {
                return;
            }
            case 15: {
                return;
            }
            case 8: {
                Type.TypeRef typeRef = (Type.TypeRef)type;
                Symbol symbol = typeRef.sym;
                Type.Map map = Type.getThisTypeMap(symbol, type);
                Type[] typeArray = symbol.closure();
                for (int i = 0; i < typeArray.length; ++i) {
                    treeMap.put(typeArray[i].symbol(), map.apply(typeArray[i]));
                }
                return;
            }
            case 0: {
                Type.CompoundType compoundType = (Type.CompoundType)type;
                Type[] typeArray = compoundType.parts;
                for (int i = 0; i < typeArray.length; ++i) {
                    ClosureHistory.addParents(treeMap, typeArray[i]);
                }
                return;
            }
            case 6: {
                ClosureHistory.addParents(treeMap, type.singleDeref());
                return;
            }
            case 7: {
                ClosureHistory.addParents(treeMap, type.singleDeref());
                return;
            }
        }
        throw Debug.abort("illegal case", type);
    }
}

