/*
 * Decompiled with CFR 0.152.
 */
package scalac.backend.msil;

import ch.epfl.lamp.compiler.msil.AssemblyName;
import ch.epfl.lamp.compiler.msil.ConstructorInfo;
import ch.epfl.lamp.compiler.msil.FieldInfo;
import ch.epfl.lamp.compiler.msil.MemberInfo;
import ch.epfl.lamp.compiler.msil.MethodBase;
import ch.epfl.lamp.compiler.msil.MethodInfo;
import ch.epfl.lamp.compiler.msil.emit.AssemblyBuilder;
import ch.epfl.lamp.compiler.msil.emit.ConstructorBuilder;
import ch.epfl.lamp.compiler.msil.emit.FieldBuilder;
import ch.epfl.lamp.compiler.msil.emit.ILGenerator;
import ch.epfl.lamp.compiler.msil.emit.MethodBuilder;
import ch.epfl.lamp.compiler.msil.emit.ModuleBuilder;
import ch.epfl.lamp.compiler.msil.emit.OpCodes;
import ch.epfl.lamp.compiler.msil.emit.TypeBuilder;
import java.io.IOException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import scala.tools.util.Position;
import scalac.ApplicationError;
import scalac.CompilationUnit;
import scalac.Global;
import scalac.Phase;
import scalac.ast.Traverser;
import scalac.ast.Tree;
import scalac.backend.msil.GenMSILPhase;
import scalac.symtab.ClassSymbol;
import scalac.symtab.Definitions;
import scalac.symtab.Modifiers;
import scalac.symtab.Scope;
import scalac.symtab.Symbol;
import scalac.symtab.Type;
import scalac.symtab.classfile.CLRTypes;
import scalac.util.Debug;
import scalac.util.Name;
import scalac.util.Names;
import scalac.util.SourceRepresentation;

final class TypeCreator {
    private final Global global;
    private final Definitions defs;
    private final ArrayList typeBuilders = new ArrayList();
    private final Map syms2staticMethods = new HashMap();
    private final Map types2symbols;
    private final Map symbols2types;
    private final Map symbols2fields;
    private final Map symbols2methods;
    private final Map symbols2moduleFields;
    public static final String MODULE_S = "$MODULE";
    public final ch.epfl.lamp.compiler.msil.Type BYTE;
    public final ch.epfl.lamp.compiler.msil.Type CHAR;
    public final ch.epfl.lamp.compiler.msil.Type SHORT;
    public final ch.epfl.lamp.compiler.msil.Type INT;
    public final ch.epfl.lamp.compiler.msil.Type LONG;
    public final ch.epfl.lamp.compiler.msil.Type FLOAT;
    public final ch.epfl.lamp.compiler.msil.Type DOUBLE;
    public final ch.epfl.lamp.compiler.msil.Type BOOLEAN;
    public final ch.epfl.lamp.compiler.msil.Type VOID;
    public final ch.epfl.lamp.compiler.msil.Type ENUM;
    public final ch.epfl.lamp.compiler.msil.Type OBJECT;
    public final ch.epfl.lamp.compiler.msil.Type STRING;
    public final ch.epfl.lamp.compiler.msil.Type STRING_ARRAY;
    private final ch.epfl.lamp.compiler.msil.Type MONITOR;
    public final MethodInfo CONCAT_OBJECT_OBJECT;
    public final MethodInfo OBJECT_EQUALS;
    public final MethodInfo MONITOR_ENTER;
    public final MethodInfo MONITOR_EXIT;
    public final ch.epfl.lamp.compiler.msil.Type SCALA_BYTE;
    public final ch.epfl.lamp.compiler.msil.Type SCALA_SHORT;
    public final ch.epfl.lamp.compiler.msil.Type SCALA_INT;
    public final ch.epfl.lamp.compiler.msil.Type SCALA_LONG;
    public final ch.epfl.lamp.compiler.msil.Type SCALA_FLOAT;
    public final ch.epfl.lamp.compiler.msil.Type SCALA_DOUBLE;
    public final ch.epfl.lamp.compiler.msil.Type SCALA_CHAR;
    public final ch.epfl.lamp.compiler.msil.Type SCALA_BOOLEAN;
    public final ch.epfl.lamp.compiler.msil.Type SCALA_UNIT;
    public final MethodInfo RUNTIME_BOX_UNIT;
    public Symbol SYM_SUBSTRING_INT_INT;
    public MethodInfo SUBSTRING_INT_INT;
    public Symbol SYM_COMPARE_TO_IGNORE_CASE;
    public MethodInfo COMPARE_TO_IGNORE_CASE;
    public ConstructorInfo SCALA_SYMTAB_ATTR_CONSTR;
    private Type MAIN_METHOD_TYPE;
    private final CLRTypes ti;
    private final Phase backPhase;
    private boolean initialized = false;
    private static final Name MAIN_N;
    private final Set types2create = new LinkedHashSet();
    private String assemName;
    private Symbol entryPoint;
    private boolean moreThanOneEntryPoint;
    private CompilationUnit entryPointUnit;
    private int entryPointPos;
    private AssemblyBuilder msilAssembly;
    private ModuleBuilder msilModule;
    private final Map interfaces = new HashMap();
    private Map syms2staticTypes = new HashMap();
    private static final /* synthetic */ boolean $assertionsDisabled;

    TypeCreator(Global global, GenMSILPhase genMSILPhase) {
        this.global = global;
        this.defs = global.definitions;
        this.backPhase = global.PHASE.ADDINTERFACES.phase();
        this.ti = CLRTypes.instance();
        this.types2symbols = genMSILPhase.types2symbols;
        this.symbols2types = genMSILPhase.symbols2types;
        this.symbols2fields = genMSILPhase.symbols2fields;
        this.symbols2methods = genMSILPhase.symbols2methods;
        this.symbols2moduleFields = genMSILPhase.symbols2moduleFields;
        this.BYTE = this.ti.BYTE;
        this.CHAR = this.ti.CHAR;
        this.SHORT = this.ti.SHORT;
        this.INT = this.ti.INT;
        this.LONG = this.ti.LONG;
        this.FLOAT = this.ti.FLOAT;
        this.DOUBLE = this.ti.DOUBLE;
        this.BOOLEAN = this.ti.BOOLEAN;
        this.VOID = this.ti.VOID;
        this.ENUM = this.ti.ENUM;
        this.OBJECT = this.ti.OBJECT;
        this.STRING = this.ti.STRING;
        this.STRING_ARRAY = ch.epfl.lamp.compiler.msil.Type.GetType((String)"System.String[]");
        this.MONITOR = ch.epfl.lamp.compiler.msil.Type.GetType((String)"System.Threading.Monitor");
        ch.epfl.lamp.compiler.msil.Type[] typeArray = new ch.epfl.lamp.compiler.msil.Type[]{this.OBJECT};
        this.CONCAT_OBJECT_OBJECT = this.STRING.GetMethod("Concat", new ch.epfl.lamp.compiler.msil.Type[]{this.OBJECT, this.OBJECT});
        this.OBJECT_EQUALS = this.OBJECT.GetMethod("Equals", typeArray);
        this.MONITOR_ENTER = this.MONITOR.GetMethod("Enter", typeArray);
        this.MONITOR_EXIT = this.MONITOR.GetMethod("Exit", typeArray);
        this.SCALA_BYTE = this.getType("scala.Byte");
        this.SCALA_SHORT = this.getType("scala.Short");
        this.SCALA_INT = this.getType("scala.Int");
        this.SCALA_LONG = this.getType("scala.Long");
        this.SCALA_FLOAT = this.getType("scala.Float");
        this.SCALA_DOUBLE = this.getType("scala.Double");
        this.SCALA_CHAR = this.getType("scala.Char");
        this.SCALA_BOOLEAN = this.getType("scala.Boolean");
        this.SCALA_UNIT = this.getType("scala.Unit");
        this.RUNTIME_BOX_UNIT = this.getType("scala.runtime.RunTime").GetMethod("box_uvalue", ch.epfl.lamp.compiler.msil.Type.EmptyTypes);
    }

    public void init() {
        if (this.initialized) {
            return;
        }
        Symbol symbol = this.defs.OBJECT_CLASS;
        Symbol symbol2 = this.defs.STRING_CLASS;
        this.map(this.defs.ANY_CLASS, this.OBJECT);
        this.map(this.defs.ANYREF_CLASS, this.OBJECT);
        this.map(symbol, this.OBJECT);
        this.map(symbol2, this.STRING);
        Type.UnboxedType unboxedType = new Type.UnboxedType(14);
        Type.UnboxedType unboxedType2 = new Type.UnboxedType(13);
        Type.UnboxedType unboxedType3 = new Type.UnboxedType(11);
        Type[] typeArray = Type.EMPTY_ARRAY;
        Type[] typeArray2 = new Type[]{this.defs.STRING_TYPE()};
        Type[] typeArray3 = new Type[]{unboxedType2};
        Type[] typeArray4 = new Type[]{unboxedType2, unboxedType2};
        Type[] typeArray5 = new Type[]{this.defs.STRING_TYPE(), unboxedType2};
        Type[] typeArray6 = new Type[]{unboxedType3, unboxedType3};
        ch.epfl.lamp.compiler.msil.Type[] typeArray7 = new ch.epfl.lamp.compiler.msil.Type[]{this.OBJECT};
        ch.epfl.lamp.compiler.msil.Type[] typeArray8 = new ch.epfl.lamp.compiler.msil.Type[]{this.STRING};
        ch.epfl.lamp.compiler.msil.Type[] typeArray9 = new ch.epfl.lamp.compiler.msil.Type[]{this.STRING, this.STRING};
        ch.epfl.lamp.compiler.msil.Type[] typeArray10 = new ch.epfl.lamp.compiler.msil.Type[]{this.CHAR};
        ch.epfl.lamp.compiler.msil.Type[] typeArray11 = new ch.epfl.lamp.compiler.msil.Type[]{this.CHAR, this.INT};
        ch.epfl.lamp.compiler.msil.Type.GetType((String)"com.ms.vjsharp.lang.ObjectImpl");
        this.translateMethod(symbol, "equals", this.OBJECT, "Equals");
        this.translateMethod(symbol, "hashCode", this.OBJECT, "GetHashCode");
        this.translateMethod(symbol, "toString", this.OBJECT, "ToString");
        this.translateMethod(symbol, "finalize", this.OBJECT, "Finalize");
        this.translateMethod(symbol, "wait", typeArray, this.MONITOR, "Wait", typeArray7);
        this.translateMethod(symbol, "wait", new Type[]{unboxedType}, this.MONITOR, "Wait", new ch.epfl.lamp.compiler.msil.Type[]{this.OBJECT, this.INT});
        this.translateMethod(symbol, "notify", typeArray, this.MONITOR, "Pulse", typeArray7);
        this.translateMethod(symbol, "notifyAll", typeArray, this.MONITOR, "PulseAll", typeArray7);
        this.translateMethod(symbol2, "compareTo", this.STRING, "CompareTo");
        this.translateMethod(symbol2, "length", this.STRING, "get_Length");
        this.translateMethod(symbol2, "charAt", this.STRING, "get_Chars");
        this.translateMethod(symbol2, "concat", typeArray2, this.STRING, "Concat", typeArray9);
        this.translateMethod(symbol2, "indexOf", typeArray3, this.STRING, "IndexOf", typeArray10);
        this.translateMethod(symbol2, "indexOf", typeArray4, this.STRING, "IndexOf", typeArray11);
        this.translateMethod(symbol2, "indexOf", typeArray2, this.STRING, "IndexOf");
        this.translateMethod(symbol2, "indexOf", typeArray5, this.STRING, "IndexOf");
        this.translateMethod(symbol2, "lastIndexOf", typeArray3, this.STRING, "LastIndexOf", typeArray10);
        this.translateMethod(symbol2, "lastIndexOf", typeArray4, this.STRING, "LastIndexOf", typeArray11);
        this.translateMethod(symbol2, "lastIndexOf", typeArray2, this.STRING, "LastIndexOf");
        this.translateMethod(symbol2, "lastIndexOf", typeArray5, this.STRING, "LastIndexOf");
        this.translateMethod(symbol2, "toLowerCase", typeArray, this.STRING, "ToLower");
        this.translateMethod(symbol2, "toUpperCase", typeArray, this.STRING, "ToUpper");
        this.translateMethod(symbol2, "startsWith", typeArray2, this.STRING, "StartsWith");
        this.translateMethod(symbol2, "endsWith", typeArray2, this.STRING, "EndsWith");
        this.translateMethod(symbol2, "substring", typeArray3, this.STRING, "Substring");
        this.translateMethod(symbol2, "intern", typeArray, this.STRING, "Intern", typeArray8);
        this.translateMethod(symbol2, "replace", typeArray6, this.STRING, "Replace");
        this.translateMethod(symbol2, "toCharArray", this.STRING, "ToCharArray");
        this.SYM_SUBSTRING_INT_INT = this.lookupMethod(symbol2, "substring", typeArray4);
        this.SUBSTRING_INT_INT = this.STRING.GetMethod("Substring", new ch.epfl.lamp.compiler.msil.Type[]{this.INT, this.INT});
        this.SYM_COMPARE_TO_IGNORE_CASE = this.lookupMethod(symbol2, "compareToIgnoreCase", typeArray2);
        this.COMPARE_TO_IGNORE_CASE = this.STRING.GetMethod("Compare", new ch.epfl.lamp.compiler.msil.Type[]{this.STRING, this.STRING, this.BOOLEAN});
        this.initialized = true;
        this.SCALA_SYMTAB_ATTR_CONSTR = this.ti.SCALA_SYMTAB_ATTR.GetConstructors()[0];
        Type type = this.defs.array_TYPE(this.defs.STRING_TYPE());
        Type type2 = this.defs.void_TYPE();
        Symbol symbol3 = Symbol.NONE.newTerm(0, 32768, Name.fromString("args"));
        symbol3.setInfo(type);
        this.MAIN_METHOD_TYPE = Type.MethodType(new Symbol[]{symbol3}, type2);
    }

    private Symbol lookupMethod(Symbol symbol, String string, Type[] typeArray) {
        Symbol[] symbolArray = symbol.members().lookup(Name.fromString(string)).alternativeSymbols();
        block0: for (int i = 0; i < symbolArray.length; ++i) {
            Type type = symbolArray[i].info();
            if (type.$tag != 3) continue;
            Type.MethodType methodType = (Type.MethodType)type;
            Symbol[] symbolArray2 = methodType.vparams;
            if (typeArray.length != symbolArray2.length) continue;
            for (int j = 0; j < symbolArray2.length; ++j) {
                if (!typeArray[j].isSameAs(symbolArray2[j].info())) continue block0;
            }
            return symbolArray[i];
        }
        return null;
    }

    private static String methodSignature(Symbol symbol) {
        Type type = symbol.info();
        if (type.$tag == 3) {
            Type.MethodType methodType = (Type.MethodType)type;
            Symbol[] symbolArray = methodType.vparams;
            Type type2 = methodType.result;
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(type2);
            stringBuffer.append(' ');
            stringBuffer.append(Debug.show(symbol.owner()));
            stringBuffer.append('.');
            stringBuffer.append(symbol.name.toString());
            stringBuffer.append('(');
            for (int i = 0; i < symbolArray.length; ++i) {
                if (i > 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(symbolArray[i].info());
            }
            stringBuffer.append(")");
            return stringBuffer.toString();
        }
        return "Symbol doesn't have a method type: ".concat(String.valueOf(String.valueOf(Debug.show(symbol))));
    }

    private static String methodSignature(ch.epfl.lamp.compiler.msil.Type[] typeArray) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('(');
        for (int i = 0; i < typeArray.length; ++i) {
            if (i > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(typeArray[i]);
        }
        stringBuffer.append(')');
        return stringBuffer.toString();
    }

    private void mapMethod(Symbol symbol, ch.epfl.lamp.compiler.msil.Type type, String string, ch.epfl.lamp.compiler.msil.Type[] typeArray) {
        MethodInfo methodInfo = type.GetMethod(string, typeArray);
        if (!$assertionsDisabled && methodInfo == null) {
            throw new AssertionError((Object)String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf("Cannot find translation for: ".concat(String.valueOf(String.valueOf(TypeCreator.methodSignature(symbol)))))).concat("->"))).concat(String.valueOf(String.valueOf(type))))).concat("::"))).concat(String.valueOf(String.valueOf(string))))).concat(String.valueOf(String.valueOf(TypeCreator.methodSignature(typeArray)))))));
        }
        this.symbols2methods.put(symbol, methodInfo);
    }

    private void translateMethod(Symbol symbol, String string, Type[] typeArray, ch.epfl.lamp.compiler.msil.Type type, String string2, ch.epfl.lamp.compiler.msil.Type[] typeArray2) {
        Symbol symbol2 = this.lookupMethod(symbol, string, typeArray);
        if (!$assertionsDisabled && symbol2 == null) {
            throw new AssertionError((Object)String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf("Cannot find method: ".concat(String.valueOf(String.valueOf(string))))).concat(" in class "))).concat(String.valueOf(String.valueOf(Debug.show(symbol)))))).concat("; scope = "))).concat(String.valueOf(String.valueOf(Debug.show(symbol.members())))))));
        }
        this.mapMethod(symbol2, type, string2, typeArray2);
    }

    private void translateMethod(Symbol symbol, String string, ch.epfl.lamp.compiler.msil.Type type, String string2) {
        Symbol symbol2 = symbol.lookup(Name.fromString(string));
        if (!$assertionsDisabled && symbol2 == null) {
            throw new AssertionError((Object)String.valueOf(String.valueOf("Cannot find method: ".concat(String.valueOf(String.valueOf(string))))));
        }
        this.translateMethod(symbol2, type, string2);
    }

    private void translateMethod(Symbol symbol, String string, Type[] typeArray, ch.epfl.lamp.compiler.msil.Type type, String string2) {
        ch.epfl.lamp.compiler.msil.Type[] typeArray2 = new ch.epfl.lamp.compiler.msil.Type[typeArray.length];
        for (int i = 0; i < typeArray.length; ++i) {
            typeArray2[i] = this.getType(typeArray[i]);
        }
        this.translateMethod(symbol, string, typeArray, type, string2, typeArray2);
    }

    private void translateMethod(Symbol symbol, ch.epfl.lamp.compiler.msil.Type type, String string) {
        Type type2 = symbol.info();
        switch (type2.$tag) {
            case 3: {
                Type.MethodType methodType = (Type.MethodType)type2;
                Symbol[] symbolArray = methodType.vparams;
                ch.epfl.lamp.compiler.msil.Type[] typeArray = new ch.epfl.lamp.compiler.msil.Type[symbolArray.length];
                for (int i = 0; i < typeArray.length; ++i) {
                    typeArray[i] = this.getType(symbolArray[i]);
                }
                this.mapMethod(symbol, type, string, typeArray);
                break;
            }
            case 4: {
                Type.OverloadedType overloadedType = (Type.OverloadedType)type2;
                Symbol[] symbolArray = overloadedType.alts;
                for (int i = 0; i < symbolArray.length; ++i) {
                    this.translateMethod(symbolArray[i], type, string);
                }
                return;
            }
            default: {
                Global.fail(String.valueOf(String.valueOf(String.valueOf(String.valueOf(Debug.show(symbol))).concat(" : "))).concat(String.valueOf(String.valueOf(Debug.show(symbol.info())))));
            }
        }
    }

    public boolean moreThanOneEntryPoint() {
        return this.moreThanOneEntryPoint;
    }

    public void collectSymbols(CompilationUnit[] compilationUnitArray) {
        this.types2create.clear();
        this.entryPoint = null;
        new CollectSymbols().traverse(compilationUnitArray);
        String string = this.global.args.assemname.value;
        if (this.entryPoint == null) {
            this.assemName = string;
            if (this.assemName == null) {
                this.assemName = this.entryPointUnit.source.getFile().getName();
                if (!$assertionsDisabled && !this.assemName.endsWith(".scala")) {
                    throw new AssertionError((Object)String.valueOf(String.valueOf(this.assemName)));
                }
                this.assemName = this.assemName.substring(0, this.assemName.length() - 6);
            }
        } else {
            this.assemName = string != null ? string : this.entryPoint.owner().name.toString();
        }
    }

    public boolean isEntryPoint(Symbol symbol) {
        return symbol.name == MAIN_N && symbol.owner().isModuleClass() && symbol.owner().owner().isPackageClass() && this.MAIN_METHOD_TYPE.isSameAs(symbol.info());
    }

    void initAssembly() {
        AssemblyName assemblyName = new AssemblyName();
        assemblyName.Name = this.assemName;
        this.msilAssembly = AssemblyBuilder.DefineDynamicAssembly((AssemblyName)assemblyName);
        this.msilModule = this.msilAssembly.DefineDynamicModule(assemblyName.Name, String.valueOf(String.valueOf(assemblyName.Name)).concat(String.valueOf(String.valueOf(this.entryPoint == null ? ".dll" : ".exe"))));
        Iterator iterator = this.types2create.iterator();
        while (iterator.hasNext()) {
            Symbol symbol = (Symbol)iterator.next();
            this.createType(symbol);
        }
    }

    public void saveAssembly() {
        Object object;
        if (this.entryPoint != null) {
            object = (MethodInfo)this.getMethod(this.entryPoint);
            if (!$assertionsDisabled && object == null) {
                throw new AssertionError((Object)String.valueOf(String.valueOf(Debug.show(this.entryPoint))));
            }
            FieldInfo fieldInfo = this.getModuleField(this.entryPoint.owner());
            if (!$assertionsDisabled && fieldInfo == null) {
                throw new AssertionError((Object)String.valueOf(String.valueOf(Debug.show(this.entryPoint.owner()))));
            }
            MethodBuilder methodBuilder = this.msilModule.DefineGlobalMethod("Main", 22, this.VOID, new ch.epfl.lamp.compiler.msil.Type[]{this.STRING_ARRAY});
            methodBuilder.DefineParameter(0, 0, "args");
            this.msilAssembly.SetEntryPoint((MethodInfo)methodBuilder);
            ILGenerator iLGenerator = methodBuilder.GetILGenerator();
            if (this.global.args.debuginfo.value) {
                String string = SourceRepresentation.escape(this.entryPointUnit.source.getFile().getPath());
                iLGenerator.setPosition(Position.line(this.entryPointPos), string);
            }
            iLGenerator.Emit(OpCodes.Ldsfld, fieldInfo);
            iLGenerator.Emit(OpCodes.Ldarg_0);
            iLGenerator.Emit(OpCodes.Callvirt, object);
            iLGenerator.Emit(OpCodes.Ret);
        }
        this.createTypes();
        object = String.valueOf(String.valueOf(this.msilAssembly.GetName().Name)).concat(".il");
        try {
            this.msilAssembly.Save((String)object);
            if (this.moreThanOneEntryPoint()) {
                this.global.warning(String.valueOf(String.valueOf("Setting ".concat(String.valueOf(String.valueOf(Debug.show(this.entryPoint)))))).concat(" as an entry point"));
            }
        }
        catch (IOException iOException) {
            this.global.error("Could not save ".concat(String.valueOf(String.valueOf(object))));
        }
    }

    private void createTypes() {
        Iterator iterator = ((AbstractList)this.typeBuilders).iterator();
        while (iterator.hasNext()) {
            ((TypeBuilder)iterator.next()).CreateType();
        }
    }

    private ch.epfl.lamp.compiler.msil.Type map(Symbol symbol, ch.epfl.lamp.compiler.msil.Type type) {
        this.symbols2types.put(symbol, type);
        if (symbol.isClass()) {
            this.types2symbols.put(type, symbol);
        }
        return type;
    }

    private ch.epfl.lamp.compiler.msil.Type getType(String string) {
        return this.ti.getType(string);
    }

    public ch.epfl.lamp.compiler.msil.Type getType(Symbol symbol) {
        if (symbol == null) {
            return null;
        }
        if (symbol == this.defs.ANY_CLASS || symbol == this.defs.ANYREF_CLASS || symbol == this.defs.OBJECT_CLASS) {
            return this.OBJECT;
        }
        if (symbol == this.defs.STRING_CLASS) {
            return this.STRING;
        }
        ch.epfl.lamp.compiler.msil.Type type = (ch.epfl.lamp.compiler.msil.Type)this.symbols2types.get(symbol);
        if (type != null) {
            if (symbol.isExternal()) {
                if (!$assertionsDisabled && type instanceof TypeBuilder) {
                    throw new AssertionError((Object)String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(Debug.show(symbol))).concat(" -> "))).concat(String.valueOf(String.valueOf(type.toString()))))));
                }
                return type;
            }
            if (this.types2create.contains(symbol) && type instanceof TypeBuilder) {
                return type;
            }
        } else if (this.types2create.contains(symbol)) {
            type = this.createType(symbol);
        }
        if (type != null) {
            return type;
        }
        type = (ch.epfl.lamp.compiler.msil.Type)this.ti.getMember(symbol);
        if (type != null) {
            return this.map(symbol, type);
        }
        if (symbol.isClass()) {
            Symbol symbol2 = symbol.owner();
            if (symbol2.isClass()) {
                ch.epfl.lamp.compiler.msil.Type type2 = this.getType(symbol2);
                if (!$assertionsDisabled && type2 == null) {
                    throw new AssertionError((Object)String.valueOf(String.valueOf(Debug.show(symbol2))));
                }
                type = type2.GetNestedType(symbol.name.toString());
            } else {
                String string = this.global.primitives.getCLRClassName(symbol);
                type = this.getType(symbol.isModuleClass() && !symbol.isJava() ? String.valueOf(String.valueOf(string)).concat("$") : string);
            }
        } else {
            type = this.getType(symbol.info());
        }
        if (type != null) {
            return this.map(symbol, type);
        }
        throw Debug.abort("Type resolution failed for ".concat(String.valueOf(String.valueOf(Debug.show(symbol)))));
    }

    public ch.epfl.lamp.compiler.msil.Type getType(Type type) {
        switch (type.$tag) {
            case 7: {
                Type.ThisType thisType = (Type.ThisType)type;
                Symbol symbol = thisType.sym;
                return this.getType(symbol);
            }
            case 8: {
                Type.TypeRef typeRef = (Type.TypeRef)type;
                Symbol symbol = typeRef.sym;
                return this.getType(symbol);
            }
            case 0: {
                return this.getType(type.symbol());
            }
            case 11: {
                Type.UnboxedType unboxedType = (Type.UnboxedType)type;
                int n = unboxedType.tag;
                return this.getTypeFromKind(n);
            }
            case 10: {
                Type.UnboxedArrayType unboxedArrayType = (Type.UnboxedArrayType)type;
                Type type2 = unboxedArrayType.elemtp;
                return this.ti.mkArrayType(this.getType(type2));
            }
            case 15: {
                return this.VOID;
            }
        }
        throw Debug.abort(Debug.show(type));
    }

    private ch.epfl.lamp.compiler.msil.Type getTypeFromKind(int n) {
        switch (n) {
            case 11: {
                return this.CHAR;
            }
            case 10: {
                return this.BYTE;
            }
            case 12: {
                return this.SHORT;
            }
            case 13: {
                return this.INT;
            }
            case 14: {
                return this.LONG;
            }
            case 15: {
                return this.FLOAT;
            }
            case 16: {
                return this.DOUBLE;
            }
            case 17: {
                return this.BOOLEAN;
            }
            case 18: {
                return this.VOID;
            }
            case 19: {
                return this.STRING;
            }
        }
        throw new ApplicationError("Unknown kind: ".concat(String.valueOf(n)));
    }

    public ch.epfl.lamp.compiler.msil.Type createType(Symbol symbol) {
        try {
            return this.createType0(symbol);
        }
        catch (Error error) {
            throw Debug.abort(Debug.show(symbol), (Throwable)error);
        }
    }

    public ch.epfl.lamp.compiler.msil.Type createType0(Symbol symbol) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        if (!$assertionsDisabled && !this.types2create.contains(symbol)) {
            throw new AssertionError((Object)String.valueOf(String.valueOf(Debug.show(symbol))));
        }
        ch.epfl.lamp.compiler.msil.Type type = (ch.epfl.lamp.compiler.msil.Type)this.symbols2types.get(symbol);
        if (type != null && type instanceof TypeBuilder) {
            return type;
        }
        TypeBuilder typeBuilder = null;
        Symbol symbol2 = symbol.owner();
        String string = symbol2.isClass() ? symbol.nameString() : this.global.primitives.getCLRClassName(symbol);
        String string2 = String.valueOf(String.valueOf(string)).concat(String.valueOf(String.valueOf(symbol.isModuleClass() ? "$" : "")));
        Type type2 = symbol.info();
        if (type2.$tag == 0) {
            int n;
            object4 = (Type.CompoundType)type2;
            object3 = ((Type.CompoundType)object4).parts;
            object2 = null;
            object = null;
            int n2 = ((Type[])object3).length;
            if (symbol.isInterface()) {
                n = 0;
                if (object3[0].symbol() == this.defs.ANY_CLASS) {
                    --n2;
                    n = 1;
                }
                object = new ch.epfl.lamp.compiler.msil.Type[n2];
                for (int i = 0; i < n2; ++i) {
                    if (!$assertionsDisabled && !((Type)object3[i + n]).symbol().isInterface()) {
                        throw new AssertionError();
                    }
                    object[i] = this.getType(((Type)object3[i + n]).symbol());
                }
            } else {
                object2 = this.getType(object3[0].symbol());
                if (!$assertionsDisabled && n2 <= 0) {
                    throw new AssertionError();
                }
                object = new ch.epfl.lamp.compiler.msil.Type[n2 - 1];
                for (n = 1; n < n2; ++n) {
                    object[n - 1] = this.getType(((Type)object3[n]).symbol());
                }
            }
            if ((type = (TypeBuilder)this.symbols2types.get(symbol)) != null) {
                return type;
            }
            if (symbol2.isPackageClass()) {
                Symbol symbol3;
                ClassSymbol classSymbol;
                type = this.msilModule.DefineType(string2, TypeCreator.translateTypeAttributes(symbol.flags, false), object2, (ch.epfl.lamp.compiler.msil.Type[])object);
                if (symbol.isModuleClass() && ((classSymbol = (symbol3 = symbol2.members().lookup(symbol.name.toTermName())).linkedClass()) == null || classSymbol.info().isError())) {
                    typeBuilder = this.msilModule.DefineType(string, TypeCreator.translateTypeAttributes(symbol.flags, false), this.OBJECT, ch.epfl.lamp.compiler.msil.Type.EmptyTypes);
                }
            } else {
                ch.epfl.lamp.compiler.msil.Type type3 = this.getType(symbol2);
                type = (TypeBuilder)this.symbols2types.get(symbol);
                if (type != null) {
                    return type;
                }
                if (!$assertionsDisabled && !(type3 instanceof TypeBuilder)) {
                    throw new AssertionError((Object)String.valueOf(String.valueOf(Debug.show(symbol))));
                }
                type = ((TypeBuilder)type3).DefineNestedType(string2, TypeCreator.translateTypeAttributes(symbol.flags, true), object2, (ch.epfl.lamp.compiler.msil.Type[])object);
            }
        } else {
            Global.fail("Symbol does not have a CompoundType: ".concat(String.valueOf(String.valueOf(Debug.show(symbol)))));
        }
        this.typeBuilders.add(type);
        this.map(symbol, type);
        if (symbol.isModuleClass() && typeBuilder != null) {
            this.syms2staticTypes.put(symbol, typeBuilder);
        }
        object4 = symbol.members().iterator();
        while (((Scope.SymbolIterator)object4).hasNext()) {
            object3 = ((Scope.SymbolIterator)object4).next();
            if (((Symbol)object3).isMethod()) {
                object2 = this.createMethod((Symbol)object3);
                if (typeBuilder == null || !object2.IsPublic() || object2.IsConstructor()) continue;
                object = this.createMethod(typeBuilder, (Symbol)object3, true);
                this.syms2staticMethods.put(object3, object);
                continue;
            }
            if (((Symbol)object3).isClass() || ((Symbol)object3).isModule() || ((Symbol)object3).isType()) continue;
            this.createField((Symbol)object3);
        }
        if (symbol.isClass() && !symbol.isInterface()) {
            object3 = new HashSet(this.getInterfacesOf(symbol));
            object2 = symbol.parents()[0].symbol();
            object3.removeAll(this.getInterfacesOf((Symbol)object2));
            object = object3.iterator();
            while (object.hasNext()) {
                Symbol symbol4 = (Symbol)object.next();
                Scope.SymbolIterator symbolIterator = symbol4.members().iterator();
                while (symbolIterator.hasNext()) {
                    Symbol symbol5;
                    Symbol symbol6;
                    Symbol symbol7 = symbolIterator.next();
                    if (!symbol7.isTerm() || !symbol7.isDeferred() || (symbol6 = symbol7.overridingSymbol(symbol.info(), true)) != symbol7 || !(symbol5 = symbol7.overriddenSymbol(symbol.parents()[0], symbol, true)).isNone()) continue;
                    Symbol symbol8 = symbol7.cloneSymbol(symbol);
                    symbol8.flags = symbol8.flags & 0xFFFFEFFF | 0x400 | 1;
                    this.createMethod(symbol8);
                }
            }
        }
        return type;
    }

    private Set getInterfacesOf(Symbol symbol) {
        if (!$assertionsDisabled && !symbol.isClass()) {
            throw new AssertionError((Object)String.valueOf(String.valueOf(Debug.show(symbol))));
        }
        HashSet<Symbol> hashSet = (HashSet<Symbol>)this.interfaces.get(symbol);
        if (hashSet == null) {
            hashSet = new HashSet<Symbol>();
            this.interfaces.put(symbol, hashSet);
            Type[] typeArray = symbol.parents();
            for (int i = 0; i < typeArray.length; ++i) {
                hashSet.addAll(this.getInterfacesOf(typeArray[i].symbol()));
            }
            if (symbol.isInterface()) {
                hashSet.add(symbol);
            }
        }
        return hashSet;
    }

    public MethodBase getMethod(Symbol symbol) {
        MethodBase methodBase = null;
        try {
            methodBase = this.getMethod0(symbol);
        }
        catch (Throwable throwable) {
            this.printMapping(symbol, this.symbols2methods);
            throw Debug.abort(throwable);
        }
        return methodBase;
    }

    private static String dumpSymbol(Symbol symbol) {
        return String.valueOf(String.valueOf(String.valueOf(String.valueOf(Debug.show(symbol))).concat(" : "))).concat(String.valueOf(String.valueOf(Integer.toHexString(symbol.flags))));
    }

    private void printMapping(Symbol symbol, Map map) {
        System.out.println("For symbol ".concat(String.valueOf(String.valueOf(TypeCreator.dumpSymbol(symbol)))));
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            Symbol symbol2 = (Symbol)entry.getKey();
            if (symbol2.owner() != symbol.owner() || symbol2.name != symbol.name) continue;
            System.out.println(String.valueOf(String.valueOf(String.valueOf(String.valueOf("Existing mapping ".concat(String.valueOf(String.valueOf(TypeCreator.dumpSymbol(symbol2)))))).concat(" => "))).concat(String.valueOf(String.valueOf(entry.getValue()))));
        }
        System.out.println("Scope of owner: ".concat(String.valueOf(String.valueOf(symbol.owner().members()))));
    }

    public MethodBase getMethod0(Symbol symbol) {
        MethodBase methodBase = (MethodBase)this.symbols2methods.get(symbol);
        if (methodBase != null) {
            return methodBase;
        }
        MemberInfo memberInfo = this.ti.getMember(symbol);
        if (memberInfo != null && memberInfo instanceof MethodBase) {
            methodBase = (MethodBase)memberInfo;
        } else {
            ch.epfl.lamp.compiler.msil.Type type = this.getType(symbol.owner());
            if (!$assertionsDisabled && type == null) {
                throw new AssertionError((Object)String.valueOf(String.valueOf(Debug.show(symbol))));
            }
            methodBase = (MethodBase)this.symbols2methods.get(symbol);
            if (methodBase != null) {
                return methodBase;
            }
            Type type2 = symbol.info();
            if (type2.$tag == 3) {
                Type.MethodType methodType = (Type.MethodType)type2;
                Symbol[] symbolArray = methodType.vparams;
                ch.epfl.lamp.compiler.msil.Type[] typeArray = new ch.epfl.lamp.compiler.msil.Type[symbolArray.length];
                for (int i = 0; i < typeArray.length; ++i) {
                    typeArray[i] = this.getType(symbolArray[i]);
                }
                if (symbol.isInitializer()) {
                    methodBase = type.GetConstructor(typeArray);
                    if (!$assertionsDisabled && methodBase == null) {
                        throw new AssertionError((Object)String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf("cannot find ".concat(String.valueOf(String.valueOf(type))))).concat("::.ctor"))).concat(String.valueOf(String.valueOf(TypeCreator.methodSignature(typeArray)))))));
                    }
                } else {
                    methodBase = type instanceof TypeBuilder ? this.findMethod(symbol.owner(), symbol) : type.GetMethod(this.getMethodName(symbol.name, typeArray), typeArray);
                }
            } else {
                Global.fail("Symbol doesn't have a method type: ".concat(String.valueOf(String.valueOf(Debug.show(symbol)))));
            }
            if (!$assertionsDisabled && methodBase == null) {
                throw new AssertionError((Object)String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(Debug.show(type))).concat(" => Cannot find method: "))).concat(String.valueOf(String.valueOf(TypeCreator.methodSignature(symbol)))))));
            }
        }
        this.symbols2methods.put(symbol, methodBase);
        return methodBase;
    }

    private String getMethodName(Name name, ch.epfl.lamp.compiler.msil.Type[] typeArray) {
        if (name == Names.finalize && typeArray.length == 0) {
            return "Finalize";
        }
        if (name == Names.toString && typeArray.length == 0) {
            return "ToString";
        }
        if (name == Names.hashCode && typeArray.length == 0) {
            return "GetHashCode";
        }
        if (name == Names.equals && typeArray.length == 1 && typeArray[0] == this.OBJECT) {
            return "Equals";
        }
        return name.toString();
    }

    private MethodBase findMethod(Symbol symbol, Symbol symbol2) {
        Symbol[] symbolArray = symbol.lookup(symbol2.name).alternativeSymbols();
        for (int i = 0; i < symbolArray.length; ++i) {
            MethodBase methodBase;
            if (!symbol2.info().isSameAs(symbolArray[i].info()) || (methodBase = this.getMethod(symbolArray[i])) == null) continue;
            return methodBase;
        }
        throw Debug.abort("Couldn't find mapping for ".concat(String.valueOf(String.valueOf(Debug.show(symbol2)))));
    }

    private MethodBase createMethod(Symbol symbol) {
        MethodBase methodBase = this.createMethod((TypeBuilder)this.getType(symbol.owner()), symbol, false);
        this.symbols2methods.put(symbol, methodBase);
        return methodBase;
    }

    private MethodBase createMethod(TypeBuilder typeBuilder, Symbol symbol, boolean bl) {
        Type type = symbol.info();
        if (type.$tag == 3) {
            short s = TypeCreator.translateMethodAttributes(symbol);
            if (bl) {
                s = (short)(s & 0xFFFFFFBF & 0xFFFFFFDF | 0x10);
            }
            Phase phase = this.global.currentPhase;
            this.global.currentPhase = this.backPhase;
            Name name = symbol.name;
            String string = name.toString();
            Type type2 = symbol.info();
            if (type2.$tag == 5) {
                Type.PolyType polyType = (Type.PolyType)type2;
                Symbol[] symbolArray = polyType.tparams;
                if (symbolArray.length == 0) {
                    name = Name.fromString("get_".concat(String.valueOf(String.valueOf(name))));
                }
            } else if (string.endsWith("_$eq")) {
                name = Name.fromString("set_".concat(String.valueOf(String.valueOf(string.substring(0, string.length() - 4)))));
            }
            this.global.currentPhase = phase;
            return this.createMethod(typeBuilder, name, symbol.info(), s);
        }
        throw Debug.abort("Symbol doesn't have a method type: ".concat(String.valueOf(String.valueOf(Debug.show(symbol)))));
    }

    private MethodBase createMethod(TypeBuilder typeBuilder, Name name, Type type, short s) {
        if (type.$tag == 3) {
            Type.MethodType methodType = (Type.MethodType)type;
            Symbol[] symbolArray = methodType.vparams;
            Type type2 = methodType.result;
            ch.epfl.lamp.compiler.msil.Type[] typeArray = new ch.epfl.lamp.compiler.msil.Type[symbolArray.length];
            for (int i = 0; i < typeArray.length; ++i) {
                typeArray[i] = this.getType(symbolArray[i]);
            }
            if (name == Names.CONSTRUCTOR) {
                ConstructorBuilder constructorBuilder = typeBuilder.DefineConstructor(s, (short)1, typeArray);
                for (int i = 0; i < symbolArray.length; ++i) {
                    constructorBuilder.DefineParameter(i, 0, symbolArray[i].name.toString());
                }
                return constructorBuilder;
            }
            String string = this.getMethodName(name, typeArray);
            MethodBuilder methodBuilder = typeBuilder.DefineMethod(string, s, this.getType(type2), typeArray);
            for (int i = 0; i < symbolArray.length; ++i) {
                methodBuilder.DefineParameter(i, 0, symbolArray[i].name.toString());
            }
            return methodBuilder;
        }
        throw Debug.abort("Method type expected: ".concat(String.valueOf(String.valueOf(Debug.show(type)))));
    }

    public FieldInfo getField(Symbol symbol) {
        FieldInfo fieldInfo = (FieldInfo)this.symbols2fields.get(symbol);
        if (fieldInfo != null) {
            return fieldInfo;
        }
        MemberInfo memberInfo = this.ti.getMember(symbol);
        if (memberInfo != null && memberInfo instanceof FieldInfo) {
            fieldInfo = (FieldInfo)memberInfo;
        } else {
            ch.epfl.lamp.compiler.msil.Type type = this.getType(symbol.owner());
            fieldInfo = type.GetField(symbol.name.toString());
            if (fieldInfo == null) {
                System.out.println("Fields of class ".concat(String.valueOf(String.valueOf(type))));
                int n = 62;
                FieldInfo[] fieldInfoArray = type.GetFields(n);
                for (int i = 0; i < fieldInfoArray.length; ++i) {
                    System.out.println("\t".concat(String.valueOf(String.valueOf(fieldInfoArray[i]))));
                }
            }
        }
        if (!$assertionsDisabled && fieldInfo == null) {
            throw new AssertionError((Object)String.valueOf(String.valueOf("Cannot find field: ".concat(String.valueOf(String.valueOf(Debug.show(symbol)))))));
        }
        this.symbols2fields.put(symbol, fieldInfo);
        return fieldInfo;
    }

    public FieldInfo createField(Symbol symbol) {
        TypeBuilder typeBuilder = (TypeBuilder)this.getType(symbol.owner());
        FieldInfo fieldInfo = (FieldInfo)this.symbols2fields.get(symbol);
        if (fieldInfo != null) {
            if (!$assertionsDisabled && !(fieldInfo instanceof FieldBuilder)) {
                throw new AssertionError();
            }
            return fieldInfo;
        }
        fieldInfo = typeBuilder.DefineField(symbol.name.toString(), this.getType(symbol.type()), TypeCreator.translateFieldAttributes(symbol));
        FieldInfo fieldInfo2 = this.symbols2fields.put(symbol, fieldInfo);
        if (!$assertionsDisabled && fieldInfo2 != null) {
            throw new AssertionError((Object)String.valueOf(String.valueOf("Cannot re-define field: ".concat(String.valueOf(String.valueOf(Debug.show(symbol)))))));
        }
        return fieldInfo;
    }

    private FieldInfo getModuleField(ch.epfl.lamp.compiler.msil.Type type) {
        Symbol symbol = (Symbol)this.types2symbols.get(type);
        if (!$assertionsDisabled && symbol == null) {
            throw new AssertionError();
        }
        return this.getModuleField(symbol);
    }

    public MethodBuilder getStaticObjectMethod(Symbol symbol) {
        if (!$assertionsDisabled && !symbol.owner().isModuleClass()) {
            throw new AssertionError((Object)String.valueOf(String.valueOf(Debug.show(symbol))));
        }
        MethodBuilder methodBuilder = (MethodBuilder)this.syms2staticMethods.get(symbol);
        if (!$assertionsDisabled && symbol == null) {
            throw new AssertionError((Object)String.valueOf(String.valueOf(Debug.show(symbol))));
        }
        return methodBuilder;
    }

    public TypeBuilder getStaticType(Symbol symbol) {
        this.getType(symbol);
        TypeBuilder typeBuilder = (TypeBuilder)this.syms2staticTypes.get(symbol);
        return typeBuilder;
    }

    private Symbol getTypeSymbol(Type type) {
        if (type.$tag == 8) {
            Type.TypeRef typeRef = (Type.TypeRef)type;
            Symbol symbol = typeRef.sym;
            return symbol;
        }
        throw new ApplicationError("Cannot get symbol for: ".concat(String.valueOf(String.valueOf(Debug.show(type)))));
    }

    public FieldInfo getModuleField(Symbol symbol) {
        if (!($assertionsDisabled || symbol.isModule() || symbol.isModuleClass())) {
            throw new AssertionError((Object)String.valueOf(String.valueOf(Debug.show(symbol))));
        }
        FieldInfo fieldInfo = (FieldInfo)this.symbols2moduleFields.get(symbol);
        if (fieldInfo == null) {
            Symbol symbol2 = this.getTypeSymbol(symbol.type());
            if (symbol != symbol2) {
                fieldInfo = this.getModuleField(symbol2);
            } else {
                ch.epfl.lamp.compiler.msil.Type type = this.getType(symbol);
                if (type instanceof TypeBuilder) {
                    TypeBuilder typeBuilder = (TypeBuilder)type;
                    fieldInfo = typeBuilder.DefineField(MODULE_S, (ch.epfl.lamp.compiler.msil.Type)typeBuilder, (short)54);
                } else {
                    fieldInfo = type.GetField(MODULE_S);
                    if (!$assertionsDisabled && fieldInfo == null) {
                        throw new AssertionError();
                    }
                }
            }
            this.symbols2moduleFields.put(symbol, fieldInfo);
        }
        if (!$assertionsDisabled && fieldInfo == null) {
            throw new AssertionError((Object)String.valueOf(String.valueOf(Debug.show(symbol))));
        }
        return fieldInfo;
    }

    private static int translateTypeAttributes(int n, boolean bl) {
        int n2 = 0;
        n2 = Modifiers.Helper.isInterface(n) ? (n2 |= 0x20) : (n2 |= 0);
        if (Modifiers.Helper.isAbstract(n)) {
            n2 |= 0x80;
        }
        if (Modifiers.Helper.isFinal(n)) {
            n2 |= 0x100;
        }
        n2 = bl ? (Modifiers.Helper.isPrivate(n) ? (n2 |= 3) : (Modifiers.Helper.isProtected(n) ? (n2 |= 7) : (n2 |= 2))) : (Modifiers.Helper.isPrivate(n) ? (n2 |= 0) : (n2 |= 1));
        return n2;
    }

    private static short translateFieldAttributes(Symbol symbol) {
        int n = symbol.flags;
        int n2 = 0;
        if (Modifiers.Helper.isFinal(n)) {
            n2 |= 0x20;
        }
        n2 = Modifiers.Helper.isPrivate(n) ? (n2 |= 1) : (Modifiers.Helper.isProtected(n) ? (n2 |= 5) : (n2 |= 6));
        if (symbol.owner().isJava() && symbol.owner().isModuleClass()) {
            n2 |= 0x10;
        }
        return (short)n2;
    }

    private static short translateMethodAttributes(Symbol symbol) {
        int n = symbol.flags;
        if (symbol.owner().isInterface()) {
            n |= 1;
        }
        int n2 = 128;
        if (!symbol.isInitializer()) {
            n2 |= 0x40;
            if (Modifiers.Helper.isFinal(n)) {
                n2 |= 0x20;
            }
            if (Modifiers.Helper.isAbstract(n)) {
                n2 |= 0x400;
            }
        }
        n2 = Modifiers.Helper.isPrivate(n) ? (n2 |= 1) : (Modifiers.Helper.isProtected(n) ? (n2 |= 4) : (n2 |= 6));
        return (short)n2;
    }

    final /* synthetic */ int access$5(int n) {
        this.entryPointPos = n;
        return this.entryPointPos;
    }

    final /* synthetic */ CompilationUnit access$0() {
        return this.entryPointUnit;
    }

    final /* synthetic */ CompilationUnit access$1(CompilationUnit compilationUnit) {
        this.entryPointUnit = compilationUnit;
        return this.entryPointUnit;
    }

    final /* synthetic */ boolean access$6(boolean bl) {
        this.moreThanOneEntryPoint = bl;
        return this.moreThanOneEntryPoint;
    }

    final /* synthetic */ Symbol access$3() {
        return this.entryPoint;
    }

    final /* synthetic */ Symbol access$4(Symbol symbol) {
        this.entryPoint = symbol;
        return this.entryPoint;
    }

    final /* synthetic */ Set access$2() {
        return this.types2create;
    }

    static {
        $assertionsDisabled = !Class.forName("scalac.backend.msil.TypeCreator").desiredAssertionStatus();
        MAIN_N = Name.fromString("main");
    }

    private final class CollectSymbols
    extends Traverser {
        private CompilationUnit currUnit;

        public void traverse(CompilationUnit compilationUnit) {
            this.currUnit = compilationUnit;
            if (TypeCreator.this.access$0() == null) {
                TypeCreator.this.access$1(compilationUnit);
            }
            super.traverse(compilationUnit);
        }

        public void traverse(Tree tree) {
            switch (tree.$tag) {
                case 10: {
                    Tree.ClassDef classDef = (Tree.ClassDef)tree;
                    Tree.Template template = classDef.impl;
                    TypeCreator.this.access$2().add(tree.symbol());
                    this.traverse(template);
                    return;
                }
                case 13: {
                    Symbol symbol = tree.symbol();
                    if (TypeCreator.this.isEntryPoint(symbol)) {
                        if (TypeCreator.this.access$3() == null) {
                            TypeCreator.this.access$4(symbol);
                            TypeCreator.this.access$1(this.currUnit);
                            TypeCreator.this.access$5(tree.pos);
                        } else {
                            TypeCreator.this.access$6(true);
                        }
                    }
                    return;
                }
                case 40: {
                    return;
                }
            }
            super.traverse(tree);
        }
    }
}

