/*
 * Decompiled with CFR 0.152.
 */
package scalac.backend.jvm;

import ch.epfl.lamp.fjbg.FJBGContext;
import ch.epfl.lamp.fjbg.JArrayType;
import ch.epfl.lamp.fjbg.JAttribute;
import ch.epfl.lamp.fjbg.JClass;
import ch.epfl.lamp.fjbg.JCode;
import ch.epfl.lamp.fjbg.JConstantPool;
import ch.epfl.lamp.fjbg.JExtendedCode;
import ch.epfl.lamp.fjbg.JField;
import ch.epfl.lamp.fjbg.JLocalVariable;
import ch.epfl.lamp.fjbg.JMethod;
import ch.epfl.lamp.fjbg.JMethodType;
import ch.epfl.lamp.fjbg.JObjectType;
import ch.epfl.lamp.fjbg.JOpcode;
import ch.epfl.lamp.fjbg.JOtherAttribute;
import ch.epfl.lamp.fjbg.JReferenceType;
import ch.epfl.lamp.fjbg.JType;
import ch.epfl.lamp.util.Pair;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.StringTokenizer;
import scala.tools.util.Position;
import scalac.CompilationUnit;
import scalac.Global;
import scalac.Phase;
import scalac.ast.Tree;
import scalac.atree.AConstant;
import scalac.backend.Primitive;
import scalac.backend.Primitives;
import scalac.backend.jvm.Context;
import scalac.symtab.Definitions;
import scalac.symtab.Modifiers;
import scalac.symtab.Scope;
import scalac.symtab.Symbol;
import scalac.symtab.Type;
import scalac.symtab.classfile.ClassfileConstants;
import scalac.symtab.classfile.Pickle;
import scalac.transformer.AddInterfacesPhase;
import scalac.util.Debug;
import scalac.util.Name;
import scalac.util.Strings;

class GenJVM {
    protected static final String JAVA_LANG_OBJECT = "java.lang.Object";
    protected static final String JAVA_LANG_STRING = "java.lang.String";
    protected static final String JAVA_LANG_STRINGBUFFER = "java.lang.StringBuffer";
    protected static final String JAVA_RMI_REMOTE = "java.rmi.Remote";
    protected static final String JAVA_RMI_REMOTEEXCEPTION = "java.rmi.RemoteException";
    protected static final String SCALA_RUNTIME_RUNTIME = "scala.runtime.RunTime";
    protected static final String SCALA_ATTR;
    protected static final String MODULE_INSTANCE_FIELD_NAME = "MODULE$";
    protected static final String CONSTRUCTOR_STRING = "<init>";
    protected final JObjectType JAVA_LANG_OBJECT_T = new JObjectType("java.lang.Object");
    protected final JObjectType JAVA_LANG_STRING_T = new JObjectType("java.lang.String");
    protected final JObjectType JAVA_LANG_STRINGBUFFER_T = new JObjectType("java.lang.StringBuffer");
    protected final JObjectType JAVA_LANG_THROWABLE_T = new JObjectType("java.lang.Throwable");
    protected final Symbol JAVA_RMI_REMOTE_CLASS;
    protected final Global global;
    protected final Definitions defs;
    protected final Primitives prims;
    protected final Phase refCheckPhase;
    protected final AddInterfacesPhase addInterfacesPhase;
    protected final FJBGContext fjbgContext;
    protected Map arithPrimMap;
    protected JLocalVariable eqEqTempVar;
    protected HashMap nameMap = new HashMap();
    protected HashMap typeMap = new HashMap();
    int[] pcStack = new int[32];
    int pcStackDepth = 0;
    private static final /* synthetic */ boolean $assertionsDisabled;

    public GenJVM(Global global) {
        this.global = global;
        this.defs = global.definitions;
        this.prims = global.primitives;
        this.refCheckPhase = global.PHASE.REFCHECK.phase();
        this.addInterfacesPhase = (AddInterfacesPhase)global.PHASE.ADDINTERFACES.phase();
        this.fjbgContext = new FJBGContext();
        this.initTypeMap();
        this.initArithPrimMap();
        this.JAVA_RMI_REMOTE_CLASS = this.defs.getClass(JAVA_RMI_REMOTE);
    }

    public void translate(CompilationUnit compilationUnit) {
        try {
            for (int i = 0; i < compilationUnit.body.length; ++i) {
                this.gen(Context.EMPTY.withSourceFileName(compilationUnit.source.getFile().getName()), compilationUnit.body[i]);
            }
        }
        catch (JCode.OffsetTooBigException offsetTooBigException) {
            throw Global.fail(offsetTooBigException);
        }
    }

    protected void gen(Context context, Tree tree) throws JCode.OffsetTooBigException {
        this.startCodeForTree(context, tree);
        Symbol symbol = tree.symbol();
        switch (tree.$tag) {
            case 24: {
                Tree.PackageDef packageDef = (Tree.PackageDef)tree;
                Tree.Template template = packageDef.impl;
                this.gen(context, template);
                break;
            }
            case 10: {
                JMethod jMethod;
                Tree.ClassDef classDef = (Tree.ClassDef)tree;
                Tree.Template template = classDef.impl;
                Tree.ClassDef classDef2 = (Tree.ClassDef)tree;
                Context context2 = this.enterClass(context, symbol);
                this.addValueClassMembers(context2, classDef2);
                this.addStaticClassMembers(context2, classDef2);
                if (context2.isModuleClass) {
                    this.addModuleInstanceField(context2);
                }
                if ((jMethod = this.getClassConstructorMethod(context2, false)) != null) {
                    jMethod.getCode().emitRETURN();
                }
                this.gen(context2, template);
                this.leaveClass(context2, symbol);
                break;
            }
            case 33: {
                Tree.Template template = (Tree.Template)tree;
                Tree[] treeArray = template.body;
                this.gen(context, treeArray);
                break;
            }
            case 40: {
                Tree.ValDef valDef = (Tree.ValDef)tree;
                Name name = valDef.name;
                Tree tree2 = valDef.rhs;
                if (context.method == null) break;
                JType jType = this.typeStoJ(symbol.info());
                JLocalVariable jLocalVariable = context.method.addNewLocalVariable(jType, name.toString());
                context.locals.put(symbol, new Integer(jLocalVariable.getIndex()));
                if (!$assertionsDisabled && tree2 == Tree.Empty) {
                    throw new AssertionError((Object)String.valueOf(String.valueOf(Debug.show(symbol))));
                }
                this.genLoad(context, tree2, jType);
                context.code.emitSTORE(jLocalVariable);
                break;
            }
            case 13: {
                Tree.DefDef defDef = (Tree.DefDef)tree;
                Tree tree3 = defDef.rhs;
                Tree.DefDef defDef2 = (Tree.DefDef)tree;
                boolean bl = false;
                while (true) {
                    Context context3 = this.enterMethod(context, defDef2, bl);
                    try {
                        if (!Modifiers.Helper.isAbstract(symbol.flags)) {
                            JType jType = context3.method.getReturnType();
                            this.genLoad(context3, tree3, jType);
                            context3.code.emitRETURN(jType);
                            context3.method.freeze();
                        }
                        this.leaveMethod(context3);
                    }
                    catch (JCode.OffsetTooBigException offsetTooBigException) {
                        context3.clazz.removeMethod(context3.method);
                        if (!$assertionsDisabled && bl) {
                            throw new AssertionError();
                        }
                        if (bl = true) continue;
                    }
                    break;
                }
            }
            case 26: {
                Tree.Return return_ = (Tree.Return)tree;
                Tree tree4 = return_.expr;
                JType jType = context.method.getReturnType();
                this.genLoad(context, tree4, jType);
                context.code.emitRETURN(jType);
                break;
            }
            case 39: {
                Tree.Typed typed = (Tree.Typed)tree;
                Tree tree5 = typed.expr;
                this.gen(context, tree5);
                break;
            }
            case 42: {
                break;
            }
            case 0: {
                break;
            }
            case 1: {
                break;
            }
            case 37: {
                break;
            }
            case 15: {
                break;
            }
            case 11: {
                break;
            }
            case 3: {
                break;
            }
            default: {
                this.genLoad(context, tree, JType.VOID);
            }
        }
        this.endCodeForTree(context, tree);
    }

    protected void gen(Context context, Tree[] treeArray) throws JCode.OffsetTooBigException {
        for (int i = 0; i < treeArray.length; ++i) {
            this.gen(context, treeArray[i]);
        }
    }

    protected JType genLoad(Context context, Tree tree, JType jType) throws JCode.OffsetTooBigException {
        this.startCodeForTree(context, tree);
        JType jType2 = null;
        Symbol symbol = tree.symbol();
        block0 : switch (tree.$tag) {
            case 20: {
                Tree.LabelDef labelDef = (Tree.LabelDef)tree;
                Tree.Ident[] identArray = labelDef.params;
                Tree tree2 = labelDef.rhs;
                JCode.Label label = context.code.newLabel();
                label.anchorToNext();
                context.labels.put(symbol, new Pair(label, identArray));
                jType2 = this.genLoad(context, tree2, jType);
                context.labels.remove(symbol);
                break;
            }
            case 8: {
                Tree.Block block = (Tree.Block)tree;
                Tree[] treeArray = block.stats;
                Tree tree3 = block.expr;
                for (int i = 0; i < treeArray.length; ++i) {
                    this.gen(context, treeArray[i]);
                }
                this.genLoad(context, tree3, jType);
                jType2 = jType;
                break;
            }
            case 39: {
                Tree.Typed typed = (Tree.Typed)tree;
                Tree tree4 = typed.expr;
                this.genLoad(context, tree4, jType);
                jType2 = jType;
                break;
            }
            case 23: {
                Tree.New new_ = (Tree.New)tree;
                Tree tree5 = new_.init;
                String string = this.javaName(tree.type.symbol());
                context.code.emitNEW(string);
                context.code.emitDUP();
                this.gen(context, tree5);
                jType2 = new JObjectType(string);
                break;
            }
            case 4: {
                boolean bl;
                Tree.Apply apply = (Tree.Apply)tree;
                if (apply.fun.$tag == 37) {
                    Tree.TypeApply typeApply = (Tree.TypeApply)apply.fun;
                    Tree tree6 = typeApply.fun;
                    Tree[] treeArray = typeApply.args;
                    this.genLoadQualifier(context, tree6);
                    JType jType3 = this.typeStoJ(treeArray[0].type);
                    if (tree6.symbol() == this.defs.ANY_IS) {
                        context.code.emitINSTANCEOF((JReferenceType)jType3);
                        jType2 = JType.BOOLEAN;
                        break;
                    }
                    if (tree6.symbol() == this.defs.ANY_AS) {
                        context.code.emitCHECKCAST((JReferenceType)jType3);
                        jType2 = jType3;
                        break;
                    }
                    Global.fail("unexpected type application");
                    break;
                }
                Tree tree7 = apply.fun;
                Tree[] treeArray = apply.args;
                Symbol symbol2 = tree7.symbol();
                if (symbol2.isLabel()) {
                    Pair pair = (Pair)context.labels.get(symbol2);
                    if (!$assertionsDisabled && pair == null) {
                        throw new AssertionError((Object)String.valueOf(String.valueOf(Debug.show(symbol2))));
                    }
                    JMethodType jMethodType = (JMethodType)this.typeStoJ(symbol2.info());
                    JCode.Label label = (JCode.Label)pair.fst;
                    Tree[] treeArray2 = (Tree[])pair.snd;
                    if (!$assertionsDisabled && treeArray2.length != treeArray.length) {
                        throw new AssertionError();
                    }
                    for (int i = 0; i < treeArray.length; ++i) {
                        this.genLoad(context, treeArray[i], this.typeStoJ(treeArray[i].type));
                    }
                    for (int i = treeArray2.length; i > 0; --i) {
                        this.genStoreEpilogue(context, treeArray2[i - 1]);
                    }
                    context.code.emitGOTO_maybe_W(label, context.useWideJumps);
                    jType2 = jMethodType.getReturnType();
                    break;
                }
                if (this.isKnownPrimitive(symbol2)) {
                    Primitive primitive = this.prims.getPrimitive(symbol2);
                    switch (primitive.$tag) {
                        case 27: {
                            this.genStringConcatenation(context, this.liftStringConcatenations(tree));
                            jType2 = this.JAVA_LANG_STRING_T;
                            break block0;
                        }
                        case 100: {
                            Tree[] treeArray3 = this.extractPrimitiveArgs((Tree.Apply)tree);
                            treeArray3[0] = this.unbox(treeArray3[0]);
                            JType jType4 = this.typeStoJ(tree.type);
                            this.genArithPrim(context, primitive, treeArray3, jType4, jType);
                            jType2 = jType4;
                            break block0;
                        }
                        case 84: {
                            Tree[] treeArray4 = this.extractPrimitiveArgs((Tree.Apply)tree);
                            treeArray4[0] = this.unbox(treeArray4[0]);
                            JType jType5 = this.typeStoJ(tree.type);
                            this.genArithPrim(context, primitive, treeArray4, jType5, jType);
                            jType2 = jType5;
                            break block0;
                        }
                        case 0: {
                            Tree[] treeArray5 = this.extractPrimitiveArgs((Tree.Apply)tree);
                            treeArray5[0] = this.unbox(treeArray5[0]);
                            JType jType6 = this.typeStoJ(tree.type);
                            this.genArithPrim(context, primitive, treeArray5, jType6, jType);
                            jType2 = jType6;
                            break block0;
                        }
                        case 111: {
                            Tree[] treeArray6 = this.extractPrimitiveArgs((Tree.Apply)tree);
                            treeArray6[0] = this.unbox(treeArray6[0]);
                            JType jType7 = this.typeStoJ(tree.type);
                            this.genArithPrim(context, primitive, treeArray6, jType7, jType);
                            jType2 = jType7;
                            break block0;
                        }
                        case 82: {
                            Tree[] treeArray7 = this.extractPrimitiveArgs((Tree.Apply)tree);
                            treeArray7[0] = this.unbox(treeArray7[0]);
                            JType jType8 = this.typeStoJ(tree.type);
                            this.genArithPrim(context, primitive, treeArray7, jType8, jType);
                            jType2 = jType8;
                            break block0;
                        }
                        case 38: {
                            Tree[] treeArray8 = this.extractPrimitiveArgs((Tree.Apply)tree);
                            treeArray8[0] = this.unbox(treeArray8[0]);
                            JType jType9 = this.typeStoJ(tree.type);
                            this.genArithPrim(context, primitive, treeArray8, jType9, jType);
                            jType2 = jType9;
                            break block0;
                        }
                        case 81: {
                            Tree[] treeArray9 = this.extractPrimitiveArgs((Tree.Apply)tree);
                            treeArray9[0] = this.unbox(treeArray9[0]);
                            JType jType10 = this.typeStoJ(tree.type);
                            this.genArithPrim(context, primitive, treeArray9, jType10, jType);
                            jType2 = jType10;
                            break block0;
                        }
                        case 94: {
                            Tree[] treeArray10 = this.extractPrimitiveArgs((Tree.Apply)tree);
                            treeArray10[0] = this.unbox(treeArray10[0]);
                            JType jType11 = this.typeStoJ(tree.type);
                            this.genArithPrim(context, primitive, treeArray10, jType11, jType);
                            jType2 = jType11;
                            break block0;
                        }
                        case 99: {
                            Tree[] treeArray11 = this.extractPrimitiveArgs((Tree.Apply)tree);
                            treeArray11[0] = this.unbox(treeArray11[0]);
                            JType jType12 = this.typeStoJ(tree.type);
                            this.genArithPrim(context, primitive, treeArray11, jType12, jType);
                            jType2 = jType12;
                            break block0;
                        }
                        case 117: {
                            Tree[] treeArray12 = this.extractPrimitiveArgs((Tree.Apply)tree);
                            treeArray12[0] = this.unbox(treeArray12[0]);
                            JType jType13 = this.typeStoJ(tree.type);
                            this.genArithPrim(context, primitive, treeArray12, jType13, jType);
                            jType2 = jType13;
                            break block0;
                        }
                        case 1: {
                            Tree[] treeArray13 = this.extractPrimitiveArgs((Tree.Apply)tree);
                            treeArray13[0] = this.unbox(treeArray13[0]);
                            JType jType14 = this.typeStoJ(tree.type);
                            this.genArithPrim(context, primitive, treeArray13, jType14, jType);
                            jType2 = jType14;
                            break block0;
                        }
                        case 78: {
                            Tree[] treeArray14 = this.extractPrimitiveArgs((Tree.Apply)tree);
                            treeArray14[0] = this.unbox(treeArray14[0]);
                            JType jType15 = this.typeStoJ(tree.type);
                            this.genArithPrim(context, primitive, treeArray14, jType15, jType);
                            jType2 = jType15;
                            break block0;
                        }
                        case 79: {
                            Tree[] treeArray15 = this.extractPrimitiveArgs((Tree.Apply)tree);
                            treeArray15[0] = this.unbox(treeArray15[0]);
                            JType jType16 = this.typeStoJ(tree.type);
                            this.genArithPrim(context, primitive, treeArray15, jType16, jType);
                            jType2 = jType16;
                            break block0;
                        }
                        case 4: {
                            Tree[] treeArray16 = this.extractPrimitiveArgs((Tree.Apply)tree);
                            treeArray16[0] = this.unbox(treeArray16[0]);
                            JType jType17 = this.typeStoJ(tree.type);
                            this.genArithPrim(context, primitive, treeArray16, jType17, jType);
                            jType2 = jType17;
                            break block0;
                        }
                        case 64: {
                            JCode.Label label = context.code.newLabel();
                            JCode.Label label2 = context.code.newLabel();
                            this.genCond(context, tree, label, false);
                            context.code.emitICONST_1();
                            context.code.emitGOTO_maybe_W(label2, context.useWideJumps);
                            label.anchorToNext();
                            context.code.emitICONST_0();
                            label2.anchorToNext();
                            jType2 = JType.BOOLEAN;
                            break block0;
                        }
                        case 39: {
                            JCode.Label label = context.code.newLabel();
                            JCode.Label label3 = context.code.newLabel();
                            this.genCond(context, tree, label, false);
                            context.code.emitICONST_1();
                            context.code.emitGOTO_maybe_W(label3, context.useWideJumps);
                            label.anchorToNext();
                            context.code.emitICONST_0();
                            label3.anchorToNext();
                            jType2 = JType.BOOLEAN;
                            break block0;
                        }
                        case 83: {
                            JCode.Label label = context.code.newLabel();
                            JCode.Label label4 = context.code.newLabel();
                            this.genCond(context, tree, label, false);
                            context.code.emitICONST_1();
                            context.code.emitGOTO_maybe_W(label4, context.useWideJumps);
                            label.anchorToNext();
                            context.code.emitICONST_0();
                            label4.anchorToNext();
                            jType2 = JType.BOOLEAN;
                            break block0;
                        }
                        case 80: {
                            JCode.Label label = context.code.newLabel();
                            JCode.Label label5 = context.code.newLabel();
                            this.genCond(context, tree, label, false);
                            context.code.emitICONST_1();
                            context.code.emitGOTO_maybe_W(label5, context.useWideJumps);
                            label.anchorToNext();
                            context.code.emitICONST_0();
                            label5.anchorToNext();
                            jType2 = JType.BOOLEAN;
                            break block0;
                        }
                        case 76: {
                            JCode.Label label = context.code.newLabel();
                            JCode.Label label6 = context.code.newLabel();
                            this.genCond(context, tree, label, false);
                            context.code.emitICONST_1();
                            context.code.emitGOTO_maybe_W(label6, context.useWideJumps);
                            label.anchorToNext();
                            context.code.emitICONST_0();
                            label6.anchorToNext();
                            jType2 = JType.BOOLEAN;
                            break block0;
                        }
                        case 51: {
                            JCode.Label label = context.code.newLabel();
                            JCode.Label label7 = context.code.newLabel();
                            this.genCond(context, tree, label, false);
                            context.code.emitICONST_1();
                            context.code.emitGOTO_maybe_W(label7, context.useWideJumps);
                            label.anchorToNext();
                            context.code.emitICONST_0();
                            label7.anchorToNext();
                            jType2 = JType.BOOLEAN;
                            break block0;
                        }
                        case 52: {
                            JCode.Label label = context.code.newLabel();
                            JCode.Label label8 = context.code.newLabel();
                            this.genCond(context, tree, label, false);
                            context.code.emitICONST_1();
                            context.code.emitGOTO_maybe_W(label8, context.useWideJumps);
                            label.anchorToNext();
                            context.code.emitICONST_0();
                            label8.anchorToNext();
                            jType2 = JType.BOOLEAN;
                            break block0;
                        }
                        case 122: {
                            JCode.Label label = context.code.newLabel();
                            JCode.Label label9 = context.code.newLabel();
                            this.genCond(context, tree, label, false);
                            context.code.emitICONST_1();
                            context.code.emitGOTO_maybe_W(label9, context.useWideJumps);
                            label.anchorToNext();
                            context.code.emitICONST_0();
                            label9.anchorToNext();
                            jType2 = JType.BOOLEAN;
                            break block0;
                        }
                        case 123: {
                            JCode.Label label = context.code.newLabel();
                            JCode.Label label10 = context.code.newLabel();
                            this.genCond(context, tree, label, false);
                            context.code.emitICONST_1();
                            context.code.emitGOTO_maybe_W(label10, context.useWideJumps);
                            label.anchorToNext();
                            context.code.emitICONST_0();
                            label10.anchorToNext();
                            jType2 = JType.BOOLEAN;
                            break block0;
                        }
                        case 118: {
                            JCode.Label label = context.code.newLabel();
                            JCode.Label label11 = context.code.newLabel();
                            this.genCond(context, tree, label, false);
                            context.code.emitICONST_1();
                            context.code.emitGOTO_maybe_W(label11, context.useWideJumps);
                            label.anchorToNext();
                            context.code.emitICONST_0();
                            label11.anchorToNext();
                            jType2 = JType.BOOLEAN;
                            break block0;
                        }
                        case 113: {
                            if (!$assertionsDisabled && treeArray.length != 0) {
                                throw new AssertionError();
                            }
                            this.genThrow(context, ((Tree.Select)tree7).qualifier);
                            jType2 = jType;
                            break block0;
                        }
                        case 112: {
                            if (!$assertionsDisabled && treeArray.length != 1) {
                                throw new AssertionError();
                            }
                            Tree tree8 = ((Tree.Select)tree7).qualifier;
                            this.genSynchronized(context, tree8, treeArray[0], jType);
                            jType2 = jType;
                            break block0;
                        }
                        case 91: {
                            if (!$assertionsDisabled && treeArray.length != 2) {
                                throw new AssertionError();
                            }
                            this.genRefArrayCreate(context, treeArray[0], treeArray[1]);
                            jType2 = jType;
                            break block0;
                        }
                        case 93: {
                            if (!$assertionsDisabled && treeArray.length != 1) {
                                throw new AssertionError();
                            }
                            this.genArrayCreate(context, primitive, treeArray[0]);
                            jType2 = this.JAVA_LANG_OBJECT_T;
                            break block0;
                        }
                        case 85: {
                            if (!$assertionsDisabled && treeArray.length != 1) {
                                throw new AssertionError();
                            }
                            this.genArrayCreate(context, primitive, treeArray[0]);
                            jType2 = this.JAVA_LANG_OBJECT_T;
                            break block0;
                        }
                        case 92: {
                            if (!$assertionsDisabled && treeArray.length != 1) {
                                throw new AssertionError();
                            }
                            this.genArrayCreate(context, primitive, treeArray[0]);
                            jType2 = this.JAVA_LANG_OBJECT_T;
                            break block0;
                        }
                        case 86: {
                            if (!$assertionsDisabled && treeArray.length != 1) {
                                throw new AssertionError();
                            }
                            this.genArrayCreate(context, primitive, treeArray[0]);
                            jType2 = this.JAVA_LANG_OBJECT_T;
                            break block0;
                        }
                        case 89: {
                            if (!$assertionsDisabled && treeArray.length != 1) {
                                throw new AssertionError();
                            }
                            this.genArrayCreate(context, primitive, treeArray[0]);
                            jType2 = this.JAVA_LANG_OBJECT_T;
                            break block0;
                        }
                        case 90: {
                            if (!$assertionsDisabled && treeArray.length != 1) {
                                throw new AssertionError();
                            }
                            this.genArrayCreate(context, primitive, treeArray[0]);
                            jType2 = this.JAVA_LANG_OBJECT_T;
                            break block0;
                        }
                        case 88: {
                            if (!$assertionsDisabled && treeArray.length != 1) {
                                throw new AssertionError();
                            }
                            this.genArrayCreate(context, primitive, treeArray[0]);
                            jType2 = this.JAVA_LANG_OBJECT_T;
                            break block0;
                        }
                        case 87: {
                            if (!$assertionsDisabled && treeArray.length != 1) {
                                throw new AssertionError();
                            }
                            this.genArrayCreate(context, primitive, treeArray[0]);
                            jType2 = this.JAVA_LANG_OBJECT_T;
                            break block0;
                        }
                        case 121: {
                            if (!$assertionsDisabled && treeArray.length != 3) {
                                throw new AssertionError();
                            }
                            this.genArrayUpdate(context, treeArray[0], treeArray[1], treeArray[2]);
                            jType2 = JType.VOID;
                            break block0;
                        }
                        case 14: {
                            if (!$assertionsDisabled && treeArray.length != 3) {
                                throw new AssertionError();
                            }
                            this.genArrayUpdate(context, treeArray[0], treeArray[1], treeArray[2]);
                            jType2 = JType.VOID;
                            break block0;
                        }
                        case 110: {
                            if (!$assertionsDisabled && treeArray.length != 3) {
                                throw new AssertionError();
                            }
                            this.genArrayUpdate(context, treeArray[0], treeArray[1], treeArray[2]);
                            jType2 = JType.VOID;
                            break block0;
                        }
                        case 25: {
                            if (!$assertionsDisabled && treeArray.length != 3) {
                                throw new AssertionError();
                            }
                            this.genArrayUpdate(context, treeArray[0], treeArray[1], treeArray[2]);
                            jType2 = JType.VOID;
                            break block0;
                        }
                        case 63: {
                            if (!$assertionsDisabled && treeArray.length != 3) {
                                throw new AssertionError();
                            }
                            this.genArrayUpdate(context, treeArray[0], treeArray[1], treeArray[2]);
                            jType2 = JType.VOID;
                            break block0;
                        }
                        case 75: {
                            if (!$assertionsDisabled && treeArray.length != 3) {
                                throw new AssertionError();
                            }
                            this.genArrayUpdate(context, treeArray[0], treeArray[1], treeArray[2]);
                            jType2 = JType.VOID;
                            break block0;
                        }
                        case 50: {
                            if (!$assertionsDisabled && treeArray.length != 3) {
                                throw new AssertionError();
                            }
                            this.genArrayUpdate(context, treeArray[0], treeArray[1], treeArray[2]);
                            jType2 = JType.VOID;
                            break block0;
                        }
                        case 37: {
                            if (!$assertionsDisabled && treeArray.length != 3) {
                                throw new AssertionError();
                            }
                            this.genArrayUpdate(context, treeArray[0], treeArray[1], treeArray[2]);
                            jType2 = JType.VOID;
                            break block0;
                        }
                        case 98: {
                            if (!$assertionsDisabled && treeArray.length != 3) {
                                throw new AssertionError();
                            }
                            this.genArrayUpdate(context, treeArray[0], treeArray[1], treeArray[2]);
                            jType2 = JType.VOID;
                            break block0;
                        }
                        case 119: {
                            if (!$assertionsDisabled && treeArray.length != 2) {
                                throw new AssertionError((Object)String.valueOf(String.valueOf("get - ".concat(String.valueOf(treeArray.length)))));
                            }
                            this.genArrayAccess(context, treeArray[0], treeArray[1]);
                            jType2 = this.getArrayElementType(treeArray[0]);
                            break block0;
                        }
                        case 12: {
                            if (!$assertionsDisabled && treeArray.length != 2) {
                                throw new AssertionError((Object)String.valueOf(String.valueOf("get - ".concat(String.valueOf(treeArray.length)))));
                            }
                            this.genArrayAccess(context, treeArray[0], treeArray[1]);
                            jType2 = this.getArrayElementType(treeArray[0]);
                            break block0;
                        }
                        case 108: {
                            if (!$assertionsDisabled && treeArray.length != 2) {
                                throw new AssertionError((Object)String.valueOf(String.valueOf("get - ".concat(String.valueOf(treeArray.length)))));
                            }
                            this.genArrayAccess(context, treeArray[0], treeArray[1]);
                            jType2 = this.getArrayElementType(treeArray[0]);
                            break block0;
                        }
                        case 23: {
                            if (!$assertionsDisabled && treeArray.length != 2) {
                                throw new AssertionError((Object)String.valueOf(String.valueOf("get - ".concat(String.valueOf(treeArray.length)))));
                            }
                            this.genArrayAccess(context, treeArray[0], treeArray[1]);
                            jType2 = this.getArrayElementType(treeArray[0]);
                            break block0;
                        }
                        case 61: {
                            if (!$assertionsDisabled && treeArray.length != 2) {
                                throw new AssertionError((Object)String.valueOf(String.valueOf("get - ".concat(String.valueOf(treeArray.length)))));
                            }
                            this.genArrayAccess(context, treeArray[0], treeArray[1]);
                            jType2 = this.getArrayElementType(treeArray[0]);
                            break block0;
                        }
                        case 73: {
                            if (!$assertionsDisabled && treeArray.length != 2) {
                                throw new AssertionError((Object)String.valueOf(String.valueOf("get - ".concat(String.valueOf(treeArray.length)))));
                            }
                            this.genArrayAccess(context, treeArray[0], treeArray[1]);
                            jType2 = this.getArrayElementType(treeArray[0]);
                            break block0;
                        }
                        case 48: {
                            if (!$assertionsDisabled && treeArray.length != 2) {
                                throw new AssertionError((Object)String.valueOf(String.valueOf("get - ".concat(String.valueOf(treeArray.length)))));
                            }
                            this.genArrayAccess(context, treeArray[0], treeArray[1]);
                            jType2 = this.getArrayElementType(treeArray[0]);
                            break block0;
                        }
                        case 35: {
                            if (!$assertionsDisabled && treeArray.length != 2) {
                                throw new AssertionError((Object)String.valueOf(String.valueOf("get - ".concat(String.valueOf(treeArray.length)))));
                            }
                            this.genArrayAccess(context, treeArray[0], treeArray[1]);
                            jType2 = this.getArrayElementType(treeArray[0]);
                            break block0;
                        }
                        case 96: {
                            if (!$assertionsDisabled && treeArray.length != 2) {
                                throw new AssertionError((Object)String.valueOf(String.valueOf("get - ".concat(String.valueOf(treeArray.length)))));
                            }
                            this.genArrayAccess(context, treeArray[0], treeArray[1]);
                            jType2 = this.getArrayElementType(treeArray[0]);
                            break block0;
                        }
                        case 120: {
                            if (!$assertionsDisabled && treeArray.length != 1) {
                                throw new AssertionError((Object)String.valueOf(treeArray.length));
                            }
                            this.genArrayLength(context, treeArray[0]);
                            jType2 = JType.INT;
                            break block0;
                        }
                        case 13: {
                            if (!$assertionsDisabled && treeArray.length != 1) {
                                throw new AssertionError((Object)String.valueOf(treeArray.length));
                            }
                            this.genArrayLength(context, treeArray[0]);
                            jType2 = JType.INT;
                            break block0;
                        }
                        case 109: {
                            if (!$assertionsDisabled && treeArray.length != 1) {
                                throw new AssertionError((Object)String.valueOf(treeArray.length));
                            }
                            this.genArrayLength(context, treeArray[0]);
                            jType2 = JType.INT;
                            break block0;
                        }
                        case 24: {
                            if (!$assertionsDisabled && treeArray.length != 1) {
                                throw new AssertionError((Object)String.valueOf(treeArray.length));
                            }
                            this.genArrayLength(context, treeArray[0]);
                            jType2 = JType.INT;
                            break block0;
                        }
                        case 62: {
                            if (!$assertionsDisabled && treeArray.length != 1) {
                                throw new AssertionError((Object)String.valueOf(treeArray.length));
                            }
                            this.genArrayLength(context, treeArray[0]);
                            jType2 = JType.INT;
                            break block0;
                        }
                        case 74: {
                            if (!$assertionsDisabled && treeArray.length != 1) {
                                throw new AssertionError((Object)String.valueOf(treeArray.length));
                            }
                            this.genArrayLength(context, treeArray[0]);
                            jType2 = JType.INT;
                            break block0;
                        }
                        case 49: {
                            if (!$assertionsDisabled && treeArray.length != 1) {
                                throw new AssertionError((Object)String.valueOf(treeArray.length));
                            }
                            this.genArrayLength(context, treeArray[0]);
                            jType2 = JType.INT;
                            break block0;
                        }
                        case 36: {
                            if (!$assertionsDisabled && treeArray.length != 1) {
                                throw new AssertionError((Object)String.valueOf(treeArray.length));
                            }
                            this.genArrayLength(context, treeArray[0]);
                            jType2 = JType.INT;
                            break block0;
                        }
                        case 97: {
                            if (!$assertionsDisabled && treeArray.length != 1) {
                                throw new AssertionError((Object)String.valueOf(treeArray.length));
                            }
                            this.genArrayLength(context, treeArray[0]);
                            jType2 = JType.INT;
                            break block0;
                        }
                        case 5: {
                            if (!$assertionsDisabled && treeArray.length != 1) {
                                throw new AssertionError((Object)String.valueOf(treeArray.length));
                            }
                            JType jType18 = this.typeStoJ(treeArray[0].type);
                            this.genLoad(context, treeArray[0], jType18);
                            context.code.emitT2T(jType18, jType);
                            jType2 = jType;
                            break block0;
                        }
                        case 11: {
                            if (!$assertionsDisabled && treeArray.length != 1) {
                                throw new AssertionError((Object)String.valueOf(treeArray.length));
                            }
                            JType jType19 = this.typeStoJ(treeArray[0].type);
                            this.genLoad(context, treeArray[0], jType19);
                            context.code.emitT2T(jType19, jType);
                            jType2 = jType;
                            break block0;
                        }
                        case 6: {
                            if (!$assertionsDisabled && treeArray.length != 1) {
                                throw new AssertionError((Object)String.valueOf(treeArray.length));
                            }
                            JType jType20 = this.typeStoJ(treeArray[0].type);
                            this.genLoad(context, treeArray[0], jType20);
                            context.code.emitT2T(jType20, jType);
                            jType2 = jType;
                            break block0;
                        }
                        case 9: {
                            if (!$assertionsDisabled && treeArray.length != 1) {
                                throw new AssertionError((Object)String.valueOf(treeArray.length));
                            }
                            JType jType21 = this.typeStoJ(treeArray[0].type);
                            this.genLoad(context, treeArray[0], jType21);
                            context.code.emitT2T(jType21, jType);
                            jType2 = jType;
                            break block0;
                        }
                        case 10: {
                            if (!$assertionsDisabled && treeArray.length != 1) {
                                throw new AssertionError((Object)String.valueOf(treeArray.length));
                            }
                            JType jType22 = this.typeStoJ(treeArray[0].type);
                            this.genLoad(context, treeArray[0], jType22);
                            context.code.emitT2T(jType22, jType);
                            jType2 = jType;
                            break block0;
                        }
                        case 8: {
                            if (!$assertionsDisabled && treeArray.length != 1) {
                                throw new AssertionError((Object)String.valueOf(treeArray.length));
                            }
                            JType jType23 = this.typeStoJ(treeArray[0].type);
                            this.genLoad(context, treeArray[0], jType23);
                            context.code.emitT2T(jType23, jType);
                            jType2 = jType;
                            break block0;
                        }
                        case 7: {
                            if (!$assertionsDisabled && treeArray.length != 1) {
                                throw new AssertionError((Object)String.valueOf(treeArray.length));
                            }
                            JType jType24 = this.typeStoJ(treeArray[0].type);
                            this.genLoad(context, treeArray[0], jType24);
                            context.code.emitT2T(jType24, jType);
                            jType2 = jType;
                            break block0;
                        }
                        case 101: {
                            if (!$assertionsDisabled && treeArray.length != 1) {
                                throw new AssertionError((Object)String.valueOf(treeArray.length));
                            }
                            JType jType25 = this.typeStoJ(treeArray[0].type);
                            this.genLoad(context, treeArray[0], jType25);
                            context.code.emitT2T(jType25, jType);
                            jType2 = jType;
                            break block0;
                        }
                        case 107: {
                            if (!$assertionsDisabled && treeArray.length != 1) {
                                throw new AssertionError((Object)String.valueOf(treeArray.length));
                            }
                            JType jType26 = this.typeStoJ(treeArray[0].type);
                            this.genLoad(context, treeArray[0], jType26);
                            context.code.emitT2T(jType26, jType);
                            jType2 = jType;
                            break block0;
                        }
                        case 102: {
                            if (!$assertionsDisabled && treeArray.length != 1) {
                                throw new AssertionError((Object)String.valueOf(treeArray.length));
                            }
                            JType jType27 = this.typeStoJ(treeArray[0].type);
                            this.genLoad(context, treeArray[0], jType27);
                            context.code.emitT2T(jType27, jType);
                            jType2 = jType;
                            break block0;
                        }
                        case 105: {
                            if (!$assertionsDisabled && treeArray.length != 1) {
                                throw new AssertionError((Object)String.valueOf(treeArray.length));
                            }
                            JType jType28 = this.typeStoJ(treeArray[0].type);
                            this.genLoad(context, treeArray[0], jType28);
                            context.code.emitT2T(jType28, jType);
                            jType2 = jType;
                            break block0;
                        }
                        case 106: {
                            if (!$assertionsDisabled && treeArray.length != 1) {
                                throw new AssertionError((Object)String.valueOf(treeArray.length));
                            }
                            JType jType29 = this.typeStoJ(treeArray[0].type);
                            this.genLoad(context, treeArray[0], jType29);
                            context.code.emitT2T(jType29, jType);
                            jType2 = jType;
                            break block0;
                        }
                        case 104: {
                            if (!$assertionsDisabled && treeArray.length != 1) {
                                throw new AssertionError((Object)String.valueOf(treeArray.length));
                            }
                            JType jType30 = this.typeStoJ(treeArray[0].type);
                            this.genLoad(context, treeArray[0], jType30);
                            context.code.emitT2T(jType30, jType);
                            jType2 = jType;
                            break block0;
                        }
                        case 103: {
                            if (!$assertionsDisabled && treeArray.length != 1) {
                                throw new AssertionError((Object)String.valueOf(treeArray.length));
                            }
                            JType jType31 = this.typeStoJ(treeArray[0].type);
                            this.genLoad(context, treeArray[0], jType31);
                            context.code.emitT2T(jType31, jType);
                            jType2 = jType;
                            break block0;
                        }
                        case 16: {
                            if (!$assertionsDisabled && treeArray.length != 1) {
                                throw new AssertionError((Object)String.valueOf(treeArray.length));
                            }
                            JType jType32 = this.typeStoJ(treeArray[0].type);
                            this.genLoad(context, treeArray[0], jType32);
                            context.code.emitT2T(jType32, jType);
                            jType2 = jType;
                            break block0;
                        }
                        case 22: {
                            if (!$assertionsDisabled && treeArray.length != 1) {
                                throw new AssertionError((Object)String.valueOf(treeArray.length));
                            }
                            JType jType33 = this.typeStoJ(treeArray[0].type);
                            this.genLoad(context, treeArray[0], jType33);
                            context.code.emitT2T(jType33, jType);
                            jType2 = jType;
                            break block0;
                        }
                        case 17: {
                            if (!$assertionsDisabled && treeArray.length != 1) {
                                throw new AssertionError((Object)String.valueOf(treeArray.length));
                            }
                            JType jType34 = this.typeStoJ(treeArray[0].type);
                            this.genLoad(context, treeArray[0], jType34);
                            context.code.emitT2T(jType34, jType);
                            jType2 = jType;
                            break block0;
                        }
                        case 20: {
                            if (!$assertionsDisabled && treeArray.length != 1) {
                                throw new AssertionError((Object)String.valueOf(treeArray.length));
                            }
                            JType jType35 = this.typeStoJ(treeArray[0].type);
                            this.genLoad(context, treeArray[0], jType35);
                            context.code.emitT2T(jType35, jType);
                            jType2 = jType;
                            break block0;
                        }
                        case 21: {
                            if (!$assertionsDisabled && treeArray.length != 1) {
                                throw new AssertionError((Object)String.valueOf(treeArray.length));
                            }
                            JType jType36 = this.typeStoJ(treeArray[0].type);
                            this.genLoad(context, treeArray[0], jType36);
                            context.code.emitT2T(jType36, jType);
                            jType2 = jType;
                            break block0;
                        }
                        case 19: {
                            if (!$assertionsDisabled && treeArray.length != 1) {
                                throw new AssertionError((Object)String.valueOf(treeArray.length));
                            }
                            JType jType37 = this.typeStoJ(treeArray[0].type);
                            this.genLoad(context, treeArray[0], jType37);
                            context.code.emitT2T(jType37, jType);
                            jType2 = jType;
                            break block0;
                        }
                        case 18: {
                            if (!$assertionsDisabled && treeArray.length != 1) {
                                throw new AssertionError((Object)String.valueOf(treeArray.length));
                            }
                            JType jType38 = this.typeStoJ(treeArray[0].type);
                            this.genLoad(context, treeArray[0], jType38);
                            context.code.emitT2T(jType38, jType);
                            jType2 = jType;
                            break block0;
                        }
                        case 54: {
                            if (!$assertionsDisabled && treeArray.length != 1) {
                                throw new AssertionError((Object)String.valueOf(treeArray.length));
                            }
                            JType jType39 = this.typeStoJ(treeArray[0].type);
                            this.genLoad(context, treeArray[0], jType39);
                            context.code.emitT2T(jType39, jType);
                            jType2 = jType;
                            break block0;
                        }
                        case 60: {
                            if (!$assertionsDisabled && treeArray.length != 1) {
                                throw new AssertionError((Object)String.valueOf(treeArray.length));
                            }
                            JType jType40 = this.typeStoJ(treeArray[0].type);
                            this.genLoad(context, treeArray[0], jType40);
                            context.code.emitT2T(jType40, jType);
                            jType2 = jType;
                            break block0;
                        }
                        case 55: {
                            if (!$assertionsDisabled && treeArray.length != 1) {
                                throw new AssertionError((Object)String.valueOf(treeArray.length));
                            }
                            JType jType41 = this.typeStoJ(treeArray[0].type);
                            this.genLoad(context, treeArray[0], jType41);
                            context.code.emitT2T(jType41, jType);
                            jType2 = jType;
                            break block0;
                        }
                        case 58: {
                            if (!$assertionsDisabled && treeArray.length != 1) {
                                throw new AssertionError((Object)String.valueOf(treeArray.length));
                            }
                            JType jType42 = this.typeStoJ(treeArray[0].type);
                            this.genLoad(context, treeArray[0], jType42);
                            context.code.emitT2T(jType42, jType);
                            jType2 = jType;
                            break block0;
                        }
                        case 59: {
                            if (!$assertionsDisabled && treeArray.length != 1) {
                                throw new AssertionError((Object)String.valueOf(treeArray.length));
                            }
                            JType jType43 = this.typeStoJ(treeArray[0].type);
                            this.genLoad(context, treeArray[0], jType43);
                            context.code.emitT2T(jType43, jType);
                            jType2 = jType;
                            break block0;
                        }
                        case 57: {
                            if (!$assertionsDisabled && treeArray.length != 1) {
                                throw new AssertionError((Object)String.valueOf(treeArray.length));
                            }
                            JType jType44 = this.typeStoJ(treeArray[0].type);
                            this.genLoad(context, treeArray[0], jType44);
                            context.code.emitT2T(jType44, jType);
                            jType2 = jType;
                            break block0;
                        }
                        case 56: {
                            if (!$assertionsDisabled && treeArray.length != 1) {
                                throw new AssertionError((Object)String.valueOf(treeArray.length));
                            }
                            JType jType45 = this.typeStoJ(treeArray[0].type);
                            this.genLoad(context, treeArray[0], jType45);
                            context.code.emitT2T(jType45, jType);
                            jType2 = jType;
                            break block0;
                        }
                        case 66: {
                            if (!$assertionsDisabled && treeArray.length != 1) {
                                throw new AssertionError((Object)String.valueOf(treeArray.length));
                            }
                            JType jType46 = this.typeStoJ(treeArray[0].type);
                            this.genLoad(context, treeArray[0], jType46);
                            context.code.emitT2T(jType46, jType);
                            jType2 = jType;
                            break block0;
                        }
                        case 72: {
                            if (!$assertionsDisabled && treeArray.length != 1) {
                                throw new AssertionError((Object)String.valueOf(treeArray.length));
                            }
                            JType jType47 = this.typeStoJ(treeArray[0].type);
                            this.genLoad(context, treeArray[0], jType47);
                            context.code.emitT2T(jType47, jType);
                            jType2 = jType;
                            break block0;
                        }
                        case 67: {
                            if (!$assertionsDisabled && treeArray.length != 1) {
                                throw new AssertionError((Object)String.valueOf(treeArray.length));
                            }
                            JType jType48 = this.typeStoJ(treeArray[0].type);
                            this.genLoad(context, treeArray[0], jType48);
                            context.code.emitT2T(jType48, jType);
                            jType2 = jType;
                            break block0;
                        }
                        case 70: {
                            if (!$assertionsDisabled && treeArray.length != 1) {
                                throw new AssertionError((Object)String.valueOf(treeArray.length));
                            }
                            JType jType49 = this.typeStoJ(treeArray[0].type);
                            this.genLoad(context, treeArray[0], jType49);
                            context.code.emitT2T(jType49, jType);
                            jType2 = jType;
                            break block0;
                        }
                        case 71: {
                            if (!$assertionsDisabled && treeArray.length != 1) {
                                throw new AssertionError((Object)String.valueOf(treeArray.length));
                            }
                            JType jType50 = this.typeStoJ(treeArray[0].type);
                            this.genLoad(context, treeArray[0], jType50);
                            context.code.emitT2T(jType50, jType);
                            jType2 = jType;
                            break block0;
                        }
                        case 69: {
                            if (!$assertionsDisabled && treeArray.length != 1) {
                                throw new AssertionError((Object)String.valueOf(treeArray.length));
                            }
                            JType jType51 = this.typeStoJ(treeArray[0].type);
                            this.genLoad(context, treeArray[0], jType51);
                            context.code.emitT2T(jType51, jType);
                            jType2 = jType;
                            break block0;
                        }
                        case 68: {
                            if (!$assertionsDisabled && treeArray.length != 1) {
                                throw new AssertionError((Object)String.valueOf(treeArray.length));
                            }
                            JType jType52 = this.typeStoJ(treeArray[0].type);
                            this.genLoad(context, treeArray[0], jType52);
                            context.code.emitT2T(jType52, jType);
                            jType2 = jType;
                            break block0;
                        }
                        case 41: {
                            if (!$assertionsDisabled && treeArray.length != 1) {
                                throw new AssertionError((Object)String.valueOf(treeArray.length));
                            }
                            JType jType53 = this.typeStoJ(treeArray[0].type);
                            this.genLoad(context, treeArray[0], jType53);
                            context.code.emitT2T(jType53, jType);
                            jType2 = jType;
                            break block0;
                        }
                        case 47: {
                            if (!$assertionsDisabled && treeArray.length != 1) {
                                throw new AssertionError((Object)String.valueOf(treeArray.length));
                            }
                            JType jType54 = this.typeStoJ(treeArray[0].type);
                            this.genLoad(context, treeArray[0], jType54);
                            context.code.emitT2T(jType54, jType);
                            jType2 = jType;
                            break block0;
                        }
                        case 42: {
                            if (!$assertionsDisabled && treeArray.length != 1) {
                                throw new AssertionError((Object)String.valueOf(treeArray.length));
                            }
                            JType jType55 = this.typeStoJ(treeArray[0].type);
                            this.genLoad(context, treeArray[0], jType55);
                            context.code.emitT2T(jType55, jType);
                            jType2 = jType;
                            break block0;
                        }
                        case 45: {
                            if (!$assertionsDisabled && treeArray.length != 1) {
                                throw new AssertionError((Object)String.valueOf(treeArray.length));
                            }
                            JType jType56 = this.typeStoJ(treeArray[0].type);
                            this.genLoad(context, treeArray[0], jType56);
                            context.code.emitT2T(jType56, jType);
                            jType2 = jType;
                            break block0;
                        }
                        case 46: {
                            if (!$assertionsDisabled && treeArray.length != 1) {
                                throw new AssertionError((Object)String.valueOf(treeArray.length));
                            }
                            JType jType57 = this.typeStoJ(treeArray[0].type);
                            this.genLoad(context, treeArray[0], jType57);
                            context.code.emitT2T(jType57, jType);
                            jType2 = jType;
                            break block0;
                        }
                        case 44: {
                            if (!$assertionsDisabled && treeArray.length != 1) {
                                throw new AssertionError((Object)String.valueOf(treeArray.length));
                            }
                            JType jType58 = this.typeStoJ(treeArray[0].type);
                            this.genLoad(context, treeArray[0], jType58);
                            context.code.emitT2T(jType58, jType);
                            jType2 = jType;
                            break block0;
                        }
                        case 43: {
                            if (!$assertionsDisabled && treeArray.length != 1) {
                                throw new AssertionError((Object)String.valueOf(treeArray.length));
                            }
                            JType jType59 = this.typeStoJ(treeArray[0].type);
                            this.genLoad(context, treeArray[0], jType59);
                            context.code.emitT2T(jType59, jType);
                            jType2 = jType;
                            break block0;
                        }
                        case 28: {
                            if (!$assertionsDisabled && treeArray.length != 1) {
                                throw new AssertionError((Object)String.valueOf(treeArray.length));
                            }
                            JType jType60 = this.typeStoJ(treeArray[0].type);
                            this.genLoad(context, treeArray[0], jType60);
                            context.code.emitT2T(jType60, jType);
                            jType2 = jType;
                            break block0;
                        }
                        case 34: {
                            if (!$assertionsDisabled && treeArray.length != 1) {
                                throw new AssertionError((Object)String.valueOf(treeArray.length));
                            }
                            JType jType61 = this.typeStoJ(treeArray[0].type);
                            this.genLoad(context, treeArray[0], jType61);
                            context.code.emitT2T(jType61, jType);
                            jType2 = jType;
                            break block0;
                        }
                        case 29: {
                            if (!$assertionsDisabled && treeArray.length != 1) {
                                throw new AssertionError((Object)String.valueOf(treeArray.length));
                            }
                            JType jType62 = this.typeStoJ(treeArray[0].type);
                            this.genLoad(context, treeArray[0], jType62);
                            context.code.emitT2T(jType62, jType);
                            jType2 = jType;
                            break block0;
                        }
                        case 32: {
                            if (!$assertionsDisabled && treeArray.length != 1) {
                                throw new AssertionError((Object)String.valueOf(treeArray.length));
                            }
                            JType jType63 = this.typeStoJ(treeArray[0].type);
                            this.genLoad(context, treeArray[0], jType63);
                            context.code.emitT2T(jType63, jType);
                            jType2 = jType;
                            break block0;
                        }
                        case 33: {
                            if (!$assertionsDisabled && treeArray.length != 1) {
                                throw new AssertionError((Object)String.valueOf(treeArray.length));
                            }
                            JType jType64 = this.typeStoJ(treeArray[0].type);
                            this.genLoad(context, treeArray[0], jType64);
                            context.code.emitT2T(jType64, jType);
                            jType2 = jType;
                            break block0;
                        }
                        case 31: {
                            if (!$assertionsDisabled && treeArray.length != 1) {
                                throw new AssertionError((Object)String.valueOf(treeArray.length));
                            }
                            JType jType65 = this.typeStoJ(treeArray[0].type);
                            this.genLoad(context, treeArray[0], jType65);
                            context.code.emitT2T(jType65, jType);
                            jType2 = jType;
                            break block0;
                        }
                        case 30: {
                            if (!$assertionsDisabled && treeArray.length != 1) {
                                throw new AssertionError((Object)String.valueOf(treeArray.length));
                            }
                            JType jType66 = this.typeStoJ(treeArray[0].type);
                            this.genLoad(context, treeArray[0], jType66);
                            context.code.emitT2T(jType66, jType);
                            jType2 = jType;
                            break block0;
                        }
                    }
                    throw Debug.abort("unknown primitive ", primitive);
                }
                JMethodType jMethodType = (JMethodType)this.typeStoJ(symbol2.info());
                JType[] jTypeArray = jMethodType.getArgumentTypes();
                boolean bl2 = symbol2.isInitializer();
                boolean bl3 = false;
                if (tree7.$tag == 27) {
                    Tree.Select select = (Tree.Select)tree7;
                    if (select.qualifier.$tag == 31) {
                        bl3 = true;
                    }
                }
                if (!(bl = this.isStaticMember(symbol2))) {
                    this.genLoadQualifier(context, tree7);
                }
                for (int i = 0; i < treeArray.length; ++i) {
                    this.genLoad(context, treeArray[i], jTypeArray[i]);
                }
                String string = bl3 ? context.clazz.getSuperclassName() : this.javaName(symbol2.owner());
                String string2 = symbol2.name.toString();
                symbol2.owner().info();
                if (symbol2.owner().isInterface()) {
                    context.code.emitINVOKEINTERFACE(string, string2, jMethodType);
                } else if (bl2 || bl3) {
                    context.code.emitINVOKESPECIAL(string, string2, jMethodType);
                    if (bl2 && bl3 && context.isModuleClass) {
                        context.code.emitALOAD_0();
                        context.code.emitPUTSTATIC(context.clazz.getName(), MODULE_INSTANCE_FIELD_NAME, context.clazz.getType());
                    }
                } else if (bl) {
                    context.code.emitINVOKESTATIC(string, string2, jMethodType);
                } else {
                    context.code.emitINVOKEVIRTUAL(string, string2, jMethodType);
                }
                jType2 = jMethodType.getReturnType();
                break;
            }
            case 17: {
                JType jType67 = this.typeStoJ(symbol.info());
                if (symbol.isModule()) {
                    String string = this.javaName(symbol.moduleClass());
                    context.code.emitGETSTATIC(string, MODULE_INSTANCE_FIELD_NAME, jType67);
                    jType2 = jType67;
                    break;
                }
                if (symbol.owner().isClass()) {
                    JType jType68 = this.typeStoJ(symbol.info());
                    String string = this.javaName(symbol.owner());
                    String string3 = symbol.name.toString();
                    context.code.emitGETSTATIC(string, string3, jType68);
                    jType2 = jType67;
                    break;
                }
                if (!$assertionsDisabled && !context.locals.containsKey(symbol)) {
                    throw new AssertionError((Object)String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(Debug.show(symbol))).concat(" not in "))).concat(String.valueOf(String.valueOf(context.locals))))));
                }
                int n = (Integer)context.locals.get(symbol);
                context.code.emitLOAD(n, jType67);
                jType2 = jType67;
                break;
            }
            case 27: {
                JType jType69 = this.typeStoJ(symbol.info());
                String string = this.javaName(symbol.owner());
                String string4 = symbol.name.toString();
                this.genLoadQualifier(context, tree);
                context.code.emitGETFIELD(string, string4, jType69);
                jType2 = jType69;
                break;
            }
            case 5: {
                Tree.Assign assign = (Tree.Assign)tree;
                Tree tree9 = assign.lhs;
                Tree tree10 = assign.rhs;
                this.genStorePrologue(context, tree9);
                this.genLoad(context, tree10, this.typeStoJ(tree9.symbol().info()));
                this.genStoreEpilogue(context, tree9);
                jType2 = JType.VOID;
                break;
            }
            case 18: {
                Tree.If if_ = (Tree.If)tree;
                Tree tree11 = if_.cond;
                Tree tree12 = if_.thenp;
                Tree tree13 = if_.elsep;
                JType jType70 = this.typeStoJ(tree.type);
                JCode.Label label = context.code.newLabel();
                this.genCond(context, tree11, label, false);
                this.genLoad(context, tree12, jType70);
                JCode.Label label12 = context.code.newLabel();
                context.code.emitGOTO_maybe_W(label12, context.useWideJumps);
                label.anchorToNext();
                this.genLoad(context, tree13, jType70);
                label12.anchorToNext();
                jType2 = jType70;
                break;
            }
            case 32: {
                Tree.Switch switch_ = (Tree.Switch)tree;
                Tree tree14 = switch_.test;
                int[] nArray = switch_.tags;
                Tree[] treeArray = switch_.bodies;
                Tree tree15 = switch_.otherwise;
                JCode.Label[] labelArray = context.code.newLabels(treeArray.length);
                JCode.Label label = context.code.newLabel();
                JCode.Label label13 = context.code.newLabel();
                this.genLoad(context, tree14, JType.INT);
                context.code.emitSWITCH(nArray, labelArray, label, 0.9);
                for (int i = 0; i < treeArray.length; ++i) {
                    labelArray[i].anchorToNext();
                    this.genLoad(context, treeArray[i], jType);
                    context.code.emitGOTO_maybe_W(label13, context.useWideJumps);
                }
                label.anchorToNext();
                this.genLoad(context, tree15, jType);
                label13.anchorToNext();
                jType2 = jType;
                break;
            }
            case 34: {
                context.code.emitALOAD_0();
                jType2 = this.JAVA_LANG_OBJECT_T;
                break;
            }
            case 31: {
                context.code.emitALOAD_0();
                jType2 = this.JAVA_LANG_OBJECT_T;
                break;
            }
            case 21: {
                Tree.Literal literal = (Tree.Literal)tree;
                AConstant aConstant = literal.value;
                jType2 = this.genLoadLiteral(context, aConstant, jType);
                break;
            }
            case 42: {
                jType2 = JType.VOID;
                break;
            }
            case 0: {
                jType2 = JType.VOID;
                break;
            }
            case 1: {
                jType2 = JType.VOID;
                break;
            }
            case 37: {
                jType2 = JType.VOID;
                break;
            }
            case 15: {
                jType2 = JType.VOID;
                break;
            }
            case 11: {
                jType2 = JType.VOID;
                break;
            }
            case 3: {
                jType2 = JType.VOID;
                break;
            }
            case 29: {
                throw Global.fail("unexpected node", tree);
            }
            case 22: {
                throw Global.fail("unexpected node", tree);
            }
            case 25: {
                throw Global.fail("unexpected node", tree);
            }
            case 19: {
                throw Global.fail("unexpected node", tree);
            }
            case 9: {
                throw Global.fail("unexpected node", tree);
            }
            case 41: {
                throw Global.fail("unexpected node", tree);
            }
            case 16: {
                throw Global.fail("unexpected node", tree);
            }
            default: {
                throw Global.fail("unknown node", tree);
            }
        }
        if (jType == JType.VOID && jType2 != JType.VOID) {
            if (jType2 == JType.LONG || jType2 == JType.DOUBLE) {
                context.code.emitPOP2();
            } else {
                context.code.emitPOP();
            }
        } else if (jType != JType.VOID && jType2 != jType && !jType2.isReferenceType()) {
            context.code.emitT2T(jType2, jType);
        }
        this.endCodeForTree(context, tree);
        return jType;
    }

    protected void genLoadQualifier(Context context, Tree tree) throws JCode.OffsetTooBigException {
        switch (tree.$tag) {
            case 17: {
                break;
            }
            case 27: {
                Tree.Select select = (Tree.Select)tree;
                if (select.qualifier.$tag == 12) break;
                Tree tree2 = select.qualifier;
                this.genLoad(context, tree2, (JType)this.JAVA_LANG_OBJECT_T);
                break;
            }
            default: {
                throw Global.fail("unknown qualifier");
            }
        }
    }

    protected JType genLoadLiteral(Context context, AConstant aConstant, JType jType) {
        switch (aConstant.$tag) {
            case 10: {
                return JType.VOID;
            }
            case 0: {
                AConstant.BOOLEAN bOOLEAN = (AConstant.BOOLEAN)aConstant;
                boolean bl = bOOLEAN.value;
                context.code.emitPUSH(bl);
                return JType.BOOLEAN;
            }
            case 1: {
                AConstant.BYTE bYTE = (AConstant.BYTE)aConstant;
                byte by = bYTE.value;
                context.code.emitPUSH(by);
                return JType.BYTE;
            }
            case 7: {
                AConstant.SHORT sHORT = (AConstant.SHORT)aConstant;
                short s = sHORT.value;
                context.code.emitPUSH(s);
                return JType.SHORT;
            }
            case 2: {
                AConstant.CHAR cHAR = (AConstant.CHAR)aConstant;
                char c = cHAR.value;
                context.code.emitPUSH(c);
                return JType.CHAR;
            }
            case 5: {
                AConstant.INT iNT = (AConstant.INT)aConstant;
                int n = iNT.value;
                context.code.emitPUSH(n);
                return JType.INT;
            }
            case 6: {
                AConstant.LONG lONG = (AConstant.LONG)aConstant;
                long l = lONG.value;
                context.code.emitPUSH(l);
                return JType.LONG;
            }
            case 4: {
                AConstant.FLOAT fLOAT = (AConstant.FLOAT)aConstant;
                float f = fLOAT.value;
                context.code.emitPUSH(f);
                return JType.FLOAT;
            }
            case 3: {
                AConstant.DOUBLE dOUBLE = (AConstant.DOUBLE)aConstant;
                double d = dOUBLE.value;
                context.code.emitPUSH(d);
                return JType.DOUBLE;
            }
            case 8: {
                AConstant.STRING sTRING = (AConstant.STRING)aConstant;
                String string = sTRING.value;
                context.code.emitPUSH(string);
                return this.JAVA_LANG_STRING_T;
            }
            case 9: {
                if (jType != JType.VOID) {
                    context.code.emitACONST_NULL();
                }
                return jType;
            }
        }
        throw Debug.abort("unknown literal", aConstant);
    }

    protected void genStorePrologue(Context context, Tree tree) throws JCode.OffsetTooBigException {
        this.genLoadQualifier(context, tree);
    }

    protected void genStoreEpilogue(Context context, Tree tree) {
        Symbol symbol = tree.symbol();
        if (symbol.owner().isClass()) {
            String string = this.javaName(symbol.owner());
            if (this.isStaticMember(symbol)) {
                context.code.emitPUTSTATIC(string, symbol.name.toString(), this.typeStoJ(symbol.info()));
            } else {
                context.code.emitPUTFIELD(string, symbol.name.toString(), this.typeStoJ(symbol.info()));
            }
        } else {
            if (!$assertionsDisabled && !context.locals.containsKey(symbol)) {
                throw new AssertionError((Object)String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(Debug.show(symbol))).concat(" not in "))).concat(String.valueOf(String.valueOf(context.locals))))));
            }
            int n = (Integer)context.locals.get(symbol);
            context.code.emitSTORE(n, this.typeStoJ(symbol.info()));
        }
    }

    protected void genCond(Context context, Tree tree, JCode.Label label, boolean bl) throws JCode.OffsetTooBigException {
        if (tree.$tag == 4) {
            Tree.Apply apply = (Tree.Apply)tree;
            Tree tree2 = apply.fun;
            if (this.isJumpingPrimitive(tree2.symbol())) {
                Primitive primitive = this.prims.getPrimitive(tree2.symbol());
                Tree[] treeArray = this.extractPrimitiveArgs((Tree.Apply)tree);
                switch (primitive.$tag) {
                    case 64: {
                        Tree tree3;
                        if (!$assertionsDisabled && treeArray.length != 2) {
                            throw new AssertionError();
                        }
                        Tree tree4 = this.unbox(treeArray[0]);
                        if (!this.getMaxType(tree4, tree3 = this.unbox(treeArray[1])).isReferenceType()) {
                            treeArray[0] = tree4;
                            treeArray[1] = tree3;
                            this.genCompPrim(context, primitive, treeArray, label, bl);
                        } else {
                            this.genEqPrim(context, primitive, treeArray, label, bl);
                        }
                        return;
                    }
                    case 39: {
                        Tree tree5;
                        if (!$assertionsDisabled && treeArray.length != 2) {
                            throw new AssertionError();
                        }
                        Tree tree6 = this.unbox(treeArray[0]);
                        if (!this.getMaxType(tree6, tree5 = this.unbox(treeArray[1])).isReferenceType()) {
                            treeArray[0] = tree6;
                            treeArray[1] = tree5;
                            this.genCompPrim(context, primitive, treeArray, label, bl);
                        } else {
                            this.genEqPrim(context, primitive, treeArray, label, bl);
                        }
                        return;
                    }
                    case 83: {
                        Tree tree7;
                        if (!$assertionsDisabled && treeArray.length != 2) {
                            throw new AssertionError();
                        }
                        Tree tree8 = this.unbox(treeArray[0]);
                        if (!this.getMaxType(tree8, tree7 = this.unbox(treeArray[1])).isReferenceType()) {
                            treeArray[0] = tree8;
                            treeArray[1] = tree7;
                            this.genCompPrim(context, primitive, treeArray, label, bl);
                        } else {
                            this.genEqPrim(context, primitive, treeArray, label, bl);
                        }
                        return;
                    }
                    case 80: {
                        if (!$assertionsDisabled && treeArray.length != 2) {
                            throw new AssertionError();
                        }
                        treeArray[0] = this.unbox(treeArray[0]);
                        this.genCompPrim(context, primitive, treeArray, label, bl);
                        return;
                    }
                    case 76: {
                        if (!$assertionsDisabled && treeArray.length != 2) {
                            throw new AssertionError();
                        }
                        treeArray[0] = this.unbox(treeArray[0]);
                        this.genCompPrim(context, primitive, treeArray, label, bl);
                        return;
                    }
                    case 51: {
                        if (!$assertionsDisabled && treeArray.length != 2) {
                            throw new AssertionError();
                        }
                        treeArray[0] = this.unbox(treeArray[0]);
                        this.genCompPrim(context, primitive, treeArray, label, bl);
                        return;
                    }
                    case 52: {
                        if (!$assertionsDisabled && treeArray.length != 2) {
                            throw new AssertionError();
                        }
                        treeArray[0] = this.unbox(treeArray[0]);
                        this.genCompPrim(context, primitive, treeArray, label, bl);
                        return;
                    }
                    case 122: {
                        if (!$assertionsDisabled && treeArray.length != 1) {
                            throw new AssertionError();
                        }
                        this.genCond(context, this.unbox(treeArray[0]), label, !bl);
                        return;
                    }
                    case 123: {
                        if (bl ^ primitive == Primitive.ZAND) {
                            this.genCond(context, this.unbox(treeArray[0]), label, bl);
                            this.genCond(context, treeArray[1], label, bl);
                        } else {
                            JCode.Label label2 = context.code.newLabel();
                            this.genCond(context, this.unbox(treeArray[0]), label2, !bl);
                            this.genCond(context, treeArray[1], label, bl);
                            label2.anchorToNext();
                        }
                        return;
                    }
                    case 118: {
                        if (bl ^ primitive == Primitive.ZAND) {
                            this.genCond(context, this.unbox(treeArray[0]), label, bl);
                            this.genCond(context, treeArray[1], label, bl);
                        } else {
                            JCode.Label label3 = context.code.newLabel();
                            this.genCond(context, this.unbox(treeArray[0]), label3, !bl);
                            this.genCond(context, treeArray[1], label, bl);
                            label3.anchorToNext();
                        }
                        return;
                    }
                }
            }
        }
        this.genLoad(context, tree, JType.BOOLEAN);
        if (bl) {
            context.code.emitIFNE(label);
        } else {
            context.code.emitIFEQ(label);
        }
    }

    protected void addPrim(Primitive primitive, JOpcode jOpcode, JOpcode jOpcode2, JOpcode jOpcode3, JOpcode jOpcode4, JOpcode jOpcode5) {
        this.arithPrimMap.put(primitive, new JOpcode[]{jOpcode, jOpcode2, jOpcode3, jOpcode4, jOpcode5});
    }

    protected void initArithPrimMap() {
        this.arithPrimMap = new HashMap();
        this.addPrim(Primitive.ADD, null, JOpcode.IADD, JOpcode.LADD, JOpcode.FADD, JOpcode.DADD);
        this.addPrim(Primitive.SUB, null, JOpcode.ISUB, JOpcode.LSUB, JOpcode.FSUB, JOpcode.DSUB);
        this.addPrim(Primitive.MUL, null, JOpcode.IMUL, JOpcode.LMUL, JOpcode.FMUL, JOpcode.DMUL);
        this.addPrim(Primitive.DIV, null, JOpcode.IDIV, JOpcode.LDIV, JOpcode.FDIV, JOpcode.DDIV);
        this.addPrim(Primitive.MOD, null, JOpcode.IREM, JOpcode.LREM, JOpcode.FREM, JOpcode.DREM);
        this.addPrim(Primitive.AND, JOpcode.IAND, JOpcode.IAND, JOpcode.LAND, null, null);
        this.addPrim(Primitive.OR, JOpcode.IOR, JOpcode.IOR, JOpcode.LOR, null, null);
        this.addPrim(Primitive.XOR, JOpcode.IXOR, JOpcode.IXOR, JOpcode.LXOR, null, null);
        this.addPrim(Primitive.LSL, null, JOpcode.ISHL, JOpcode.LSHL, null, null);
        this.addPrim(Primitive.LSR, null, JOpcode.IUSHR, JOpcode.LUSHR, null, null);
        this.addPrim(Primitive.ASR, null, JOpcode.ISHR, JOpcode.LSHR, null, null);
        this.addPrim(Primitive.POS, null, null, null, null, null);
        this.addPrim(Primitive.NEG, null, JOpcode.INEG, JOpcode.LNEG, JOpcode.FNEG, JOpcode.DNEG);
    }

    protected void genArithPrim(Context context, Primitive primitive, Tree[] treeArray, JType jType, JType jType2) throws JCode.OffsetTooBigException {
        int n = treeArray.length;
        int n2 = this.getTypeIndex(jType);
        if (primitive == Primitive.LSL || primitive == Primitive.LSR || primitive == Primitive.ASR) {
            this.genLoad(context, treeArray[0], jType);
            this.genLoad(context, treeArray[1], JType.INT);
        } else {
            for (int i = 0; i < n; ++i) {
                this.genLoad(context, treeArray[i], jType);
            }
        }
        if (primitive == Primitive.NOT) {
            if (jType == JType.LONG) {
                context.code.emitPUSH(-1L);
                context.code.emitLXOR();
            } else {
                if (!$assertionsDisabled && jType != JType.INT) {
                    throw new AssertionError();
                }
                context.code.emitPUSH(-1);
                context.code.emitIXOR();
            }
        } else {
            if (!$assertionsDisabled && !this.arithPrimMap.containsKey(primitive)) {
                throw new AssertionError();
            }
            JOpcode jOpcode = ((JOpcode[])this.arithPrimMap.get(primitive))[n2];
            if (jOpcode != null) {
                context.code.emit(jOpcode);
            }
        }
    }

    protected void genEqPrim(Context context, Primitive primitive, Tree[] treeArray, JCode.Label label, boolean bl) throws JCode.OffsetTooBigException {
        JType jType = this.getMaxType(treeArray);
        if (!$assertionsDisabled && !jType.isReferenceType()) {
            throw new AssertionError((Object)String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(treeArray[0])).concat(" - "))).concat(String.valueOf(String.valueOf(treeArray[1]))))).concat(" : "))).concat(String.valueOf(String.valueOf(jType))))));
        }
        for (int i = 0; i < treeArray.length; ++i) {
            this.genLoad(context, treeArray[i], jType);
        }
        if (primitive == Primitive.ID) {
            if (bl) {
                context.code.emitIF_ACMPEQ(label);
            } else {
                context.code.emitIF_ACMPNE(label);
            }
        } else {
            if (!$assertionsDisabled && primitive != Primitive.EQ && primitive != Primitive.NE) {
                throw new AssertionError();
            }
            if (this.eqEqTempVar == null || this.eqEqTempVar.getOwner() != context.method) {
                this.eqEqTempVar = context.method.addNewLocalVariable((JType)JObjectType.JAVA_LANG_OBJECT, "eqEqTemp$");
            }
            context.code.emitSTORE(this.eqEqTempVar);
            context.code.emitDUP();
            JCode.Label label2 = context.code.newLabel();
            context.code.emitIFNONNULL(label2);
            context.code.emitPOP();
            context.code.emitLOAD(this.eqEqTempVar);
            if (bl ^ primitive != Primitive.EQ) {
                context.code.emitIFNULL(label);
            } else {
                context.code.emitIFNONNULL(label);
            }
            JCode.Label label3 = context.code.newLabel();
            context.code.emitGOTO_maybe_W(label3, context.useWideJumps);
            label2.anchorToNext();
            context.code.emitLOAD(this.eqEqTempVar);
            JMethodType jMethodType = new JMethodType(JType.BOOLEAN, new JType[]{JObjectType.JAVA_LANG_OBJECT});
            context.code.emitINVOKEVIRTUAL(JAVA_LANG_OBJECT, "equals", jMethodType);
            if (bl ^ primitive != Primitive.EQ) {
                context.code.emitIFNE(label);
            } else {
                context.code.emitIFEQ(label);
            }
            label3.anchorToNext();
        }
    }

    protected void genCompPrim(Context context, Primitive primitive, Tree[] treeArray, JCode.Label label, boolean bl) throws JCode.OffsetTooBigException {
        JType jType = this.getMaxType(treeArray);
        if (!$assertionsDisabled && jType.isReferenceType()) {
            throw new AssertionError((Object)String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(treeArray[0])).concat(" - "))).concat(String.valueOf(String.valueOf(treeArray[1]))))).concat(" : "))).concat(String.valueOf(String.valueOf(jType))))));
        }
        int n = this.getTypeIndex(jType);
        int n2 = this.getTypeIndex(JType.INT);
        boolean bl2 = false;
        for (int i = 0; i < treeArray.length; ++i) {
            boolean bl3 = false;
            if (n <= n2) {
                Tree tree = treeArray[i];
                if (tree.$tag == 21) {
                    int n3;
                    Tree.Literal literal = (Tree.Literal)tree;
                    AConstant aConstant = literal.value;
                    switch (aConstant.$tag) {
                        case 0: {
                            AConstant aConstant2 = (AConstant.BOOLEAN)aConstant;
                            int n4 = aConstant2.value;
                            n3 = n4 != 0 ? 1 : 0;
                            break;
                        }
                        case 1: {
                            int n4;
                            AConstant aConstant2 = (AConstant.BYTE)aConstant;
                            n3 = n4 = ((AConstant.BYTE)aConstant2).value;
                            break;
                        }
                        case 7: {
                            int n4;
                            AConstant aConstant2 = (AConstant.SHORT)aConstant;
                            n3 = n4 = ((AConstant.SHORT)aConstant2).value;
                            break;
                        }
                        case 2: {
                            int n4;
                            AConstant aConstant2 = (AConstant.CHAR)aConstant;
                            n3 = n4 = (int)((AConstant.CHAR)aConstant2).value;
                            break;
                        }
                        case 5: {
                            int n4;
                            AConstant aConstant2 = (AConstant.INT)aConstant;
                            n3 = n4 = ((AConstant.INT)aConstant2).value;
                            break;
                        }
                        default: {
                            throw Debug.abort("unknown literal", aConstant);
                        }
                    }
                    if (n3 == 0) {
                        bl3 = true;
                        if (i == 0) {
                            primitive = primitive.swap();
                        }
                    }
                }
            }
            if (bl2 || !bl3) {
                this.genLoad(context, treeArray[i], jType);
            }
            bl2 |= bl3;
        }
        if (n <= n2 && !bl2) {
            Primitive primitive2 = this.maybeNegatedPrim(primitive, !bl);
            switch (primitive2.$tag) {
                case 80: {
                    context.code.emitIF_ICMPLT(label);
                    break;
                }
                case 76: {
                    context.code.emitIF_ICMPLE(label);
                    break;
                }
                case 39: {
                    context.code.emitIF_ICMPEQ(label);
                    break;
                }
                case 83: {
                    context.code.emitIF_ICMPNE(label);
                    break;
                }
                case 51: {
                    context.code.emitIF_ICMPGE(label);
                    break;
                }
                case 52: {
                    context.code.emitIF_ICMPGT(label);
                    break;
                }
                default: {
                    throw Global.fail("unknown primitive ".concat(String.valueOf(String.valueOf(primitive))));
                }
            }
        } else {
            switch (jType.getTag()) {
                case 11: {
                    context.code.emitLCMP();
                    break;
                }
                case 6: {
                    context.code.emitFCMPG();
                    break;
                }
                case 7: {
                    context.code.emitDCMPG();
                    break;
                }
            }
            Primitive primitive3 = this.maybeNegatedPrim(primitive, !bl);
            switch (primitive3.$tag) {
                case 80: {
                    context.code.emitIFLT(label);
                    break;
                }
                case 76: {
                    context.code.emitIFLE(label);
                    break;
                }
                case 39: {
                    context.code.emitIFEQ(label);
                    break;
                }
                case 83: {
                    context.code.emitIFNE(label);
                    break;
                }
                case 51: {
                    context.code.emitIFGE(label);
                    break;
                }
                case 52: {
                    context.code.emitIFGT(label);
                    break;
                }
                default: {
                    throw Global.fail("unknown primitive ".concat(String.valueOf(String.valueOf(primitive))));
                }
            }
        }
    }

    protected void genThrow(Context context, Tree tree) throws JCode.OffsetTooBigException {
        this.genLoad(context, tree, (JType)this.JAVA_LANG_OBJECT_T);
        context.code.emitCHECKCAST((JReferenceType)this.JAVA_LANG_THROWABLE_T);
        context.code.emitATHROW();
    }

    protected void genSynchronized(Context context, Tree tree, Tree tree2, JType jType) throws JCode.OffsetTooBigException {
        JLocalVariable jLocalVariable = context.method.addNewLocalVariable((JType)this.JAVA_LANG_OBJECT_T, "monitor");
        this.genLoad(context, tree, (JType)this.JAVA_LANG_OBJECT_T);
        context.code.emitSTORE(jLocalVariable);
        context.code.emitLOAD(jLocalVariable);
        context.code.emitMONITORENTER();
        int n = context.code.getPC();
        this.genLoad(context, tree2, jType);
        int n2 = context.code.getPC();
        context.code.emitLOAD(jLocalVariable);
        context.code.emitMONITOREXIT();
        JCode.Label label = context.code.newLabel();
        context.code.emitGOTO(label);
        int n3 = context.code.getPC();
        context.code.emitLOAD(jLocalVariable);
        context.code.emitMONITOREXIT();
        context.code.emitATHROW();
        label.anchorToNext();
        context.code.addFinallyHandler(n, n2, n3);
    }

    protected void genArrayCreate(Context context, Primitive primitive, Tree tree) throws JCode.OffsetTooBigException {
        JType jType;
        this.genLoad(context, tree, JType.INT);
        switch (primitive.$tag) {
            case 93: {
                jType = JType.BOOLEAN;
                break;
            }
            case 85: {
                jType = JType.BYTE;
                break;
            }
            case 92: {
                jType = JType.SHORT;
                break;
            }
            case 86: {
                jType = JType.CHAR;
                break;
            }
            case 89: {
                jType = JType.INT;
                break;
            }
            case 90: {
                jType = JType.LONG;
                break;
            }
            case 88: {
                jType = JType.FLOAT;
                break;
            }
            case 87: {
                jType = JType.DOUBLE;
                break;
            }
            default: {
                throw Debug.abort("unexpected primitive", primitive);
            }
        }
        context.code.emitNEWARRAY(jType);
    }

    protected void genRefArrayCreate(Context context, Tree tree, Tree tree2) throws JCode.OffsetTooBigException {
        String string;
        Tree.Literal literal;
        block6: {
            block5: {
                this.genLoad(context, tree, JType.INT);
                if (tree2.$tag != 21) break block5;
                literal = (Tree.Literal)tree2;
                if (literal.value.$tag == 8) break block6;
            }
            throw Global.fail("invalid argument for oarray ".concat(String.valueOf(String.valueOf(tree2))));
        }
        AConstant.STRING sTRING = (AConstant.STRING)literal.value;
        String string2 = string = sTRING.value;
        switch (string2.charAt(0)) {
            case 'L': 
            case '[': {
                literal = (JReferenceType)JType.parseSignature((String)string2);
                break;
            }
            default: {
                literal = new JObjectType(string2);
            }
        }
        context.code.emitANEWARRAY((JReferenceType)literal);
    }

    protected void genArrayUpdate(Context context, Tree tree, Tree tree2, Tree tree3) throws JCode.OffsetTooBigException {
        this.genLoad(context, tree, (JType)this.JAVA_LANG_OBJECT_T);
        this.genLoad(context, tree2, JType.INT);
        JType jType = this.getArrayElementType(tree);
        if (jType.isValueType()) {
            tree3 = this.unbox(tree3);
        }
        this.genLoad(context, tree3, jType);
        context.code.emitASTORE(jType);
    }

    protected void genArrayAccess(Context context, Tree tree, Tree tree2) throws JCode.OffsetTooBigException {
        this.genLoad(context, tree, (JType)this.JAVA_LANG_OBJECT_T);
        this.genLoad(context, tree2, JType.INT);
        context.code.emitALOAD(this.getArrayElementType(tree));
    }

    protected void genArrayLength(Context context, Tree tree) throws JCode.OffsetTooBigException {
        this.genLoad(context, tree, (JType)this.JAVA_LANG_OBJECT_T);
        context.code.emitARRAYLENGTH();
    }

    protected JType getArrayElementType(Tree tree) {
        JArrayType jArrayType = (JArrayType)this.typeStoJ(tree.type);
        return jArrayType.getElementType();
    }

    protected Tree[] liftStringConcatenations(Tree tree) {
        LinkedList linkedList = new LinkedList();
        this.liftStringConcatenations(tree, linkedList);
        return linkedList.toArray(new Tree[linkedList.size()]);
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void liftStringConcatenations(Tree tree, LinkedList linkedList) {
        if (tree.$tag == 4) {
            Tree.Apply apply = (Tree.Apply)tree;
            if (apply.fun.$tag == 27) {
                Tree.Select select = (Tree.Select)apply.fun;
                Tree tree2 = select.qualifier;
                Tree[] treeArray = apply.args;
                Symbol symbol = ((Tree.Apply)tree).fun.symbol();
                if (this.prims.isPrimitive(symbol) && this.prims.getPrimitive(symbol) == Primitive.CONCAT) {
                    this.liftStringConcatenations(tree2, linkedList);
                    this.liftStringConcatenations(treeArray[0], linkedList);
                    return;
                }
                linkedList.addLast(tree);
                return;
            }
        }
        linkedList.addLast(tree);
    }

    protected void genStringConcatenation(Context context, Tree[] treeArray) throws JCode.OffsetTooBigException {
        context.code.emitNEW(JAVA_LANG_STRINGBUFFER);
        context.code.emitDUP();
        context.code.emitINVOKESPECIAL(JAVA_LANG_STRINGBUFFER, CONSTRUCTOR_STRING, JMethodType.ARGLESS_VOID_FUNCTION);
        for (int i = 0; i < treeArray.length; ++i) {
            JType jType = this.typeStoJ(treeArray[i].type);
            if (!jType.equals(JObjectType.JAVA_LANG_STRING) && jType.isReferenceType()) {
                jType = JObjectType.JAVA_LANG_OBJECT;
            }
            this.genLoad(context, treeArray[i], jType);
            context.code.emitINVOKEVIRTUAL(JAVA_LANG_STRINGBUFFER, "append", new JMethodType((JType)this.JAVA_LANG_STRINGBUFFER_T, new JType[]{jType}));
        }
        context.code.emitINVOKEVIRTUAL(JAVA_LANG_STRINGBUFFER, "toString", new JMethodType((JType)JObjectType.JAVA_LANG_STRING, JType.EMPTY_ARRAY));
    }

    protected boolean isJumpingPrimitive(Symbol symbol) {
        if (this.prims.isPrimitive(symbol)) {
            Primitive primitive = this.prims.getPrimitive(symbol);
            switch (primitive.$tag) {
                case 64: {
                    return true;
                }
                case 39: {
                    return true;
                }
                case 83: {
                    return true;
                }
                case 80: {
                    return true;
                }
                case 76: {
                    return true;
                }
                case 51: {
                    return true;
                }
                case 52: {
                    return true;
                }
                case 122: {
                    return true;
                }
                case 123: {
                    return true;
                }
                case 118: {
                    return true;
                }
            }
        }
        return false;
    }

    protected boolean isKnownPrimitive(Symbol symbol) {
        if (this.isJumpingPrimitive(symbol)) {
            return true;
        }
        if (this.prims.isPrimitive(symbol)) {
            Primitive primitive = this.prims.getPrimitive(symbol);
            switch (primitive.$tag) {
                case 100: {
                    return true;
                }
                case 84: {
                    return true;
                }
                case 0: {
                    return true;
                }
                case 111: {
                    return true;
                }
                case 82: {
                    return true;
                }
                case 38: {
                    return true;
                }
                case 81: {
                    return true;
                }
                case 94: {
                    return true;
                }
                case 99: {
                    return true;
                }
                case 117: {
                    return true;
                }
                case 1: {
                    return true;
                }
                case 78: {
                    return true;
                }
                case 79: {
                    return true;
                }
                case 4: {
                    return true;
                }
                case 93: {
                    return true;
                }
                case 85: {
                    return true;
                }
                case 92: {
                    return true;
                }
                case 86: {
                    return true;
                }
                case 89: {
                    return true;
                }
                case 90: {
                    return true;
                }
                case 88: {
                    return true;
                }
                case 87: {
                    return true;
                }
                case 91: {
                    return true;
                }
                case 119: {
                    return true;
                }
                case 12: {
                    return true;
                }
                case 108: {
                    return true;
                }
                case 23: {
                    return true;
                }
                case 61: {
                    return true;
                }
                case 73: {
                    return true;
                }
                case 48: {
                    return true;
                }
                case 35: {
                    return true;
                }
                case 96: {
                    return true;
                }
                case 121: {
                    return true;
                }
                case 14: {
                    return true;
                }
                case 110: {
                    return true;
                }
                case 25: {
                    return true;
                }
                case 63: {
                    return true;
                }
                case 75: {
                    return true;
                }
                case 50: {
                    return true;
                }
                case 37: {
                    return true;
                }
                case 98: {
                    return true;
                }
                case 120: {
                    return true;
                }
                case 13: {
                    return true;
                }
                case 109: {
                    return true;
                }
                case 24: {
                    return true;
                }
                case 62: {
                    return true;
                }
                case 74: {
                    return true;
                }
                case 49: {
                    return true;
                }
                case 36: {
                    return true;
                }
                case 97: {
                    return true;
                }
                case 65: {
                    return true;
                }
                case 3: {
                    return true;
                }
                case 64: {
                    return true;
                }
                case 27: {
                    return true;
                }
                case 113: {
                    return true;
                }
                case 112: {
                    return true;
                }
                case 5: {
                    return true;
                }
                case 11: {
                    return true;
                }
                case 6: {
                    return true;
                }
                case 9: {
                    return true;
                }
                case 10: {
                    return true;
                }
                case 8: {
                    return true;
                }
                case 7: {
                    return true;
                }
                case 101: {
                    return true;
                }
                case 107: {
                    return true;
                }
                case 102: {
                    return true;
                }
                case 105: {
                    return true;
                }
                case 106: {
                    return true;
                }
                case 104: {
                    return true;
                }
                case 103: {
                    return true;
                }
                case 16: {
                    return true;
                }
                case 22: {
                    return true;
                }
                case 17: {
                    return true;
                }
                case 20: {
                    return true;
                }
                case 21: {
                    return true;
                }
                case 19: {
                    return true;
                }
                case 18: {
                    return true;
                }
                case 54: {
                    return true;
                }
                case 60: {
                    return true;
                }
                case 55: {
                    return true;
                }
                case 58: {
                    return true;
                }
                case 59: {
                    return true;
                }
                case 57: {
                    return true;
                }
                case 56: {
                    return true;
                }
                case 66: {
                    return true;
                }
                case 72: {
                    return true;
                }
                case 67: {
                    return true;
                }
                case 70: {
                    return true;
                }
                case 71: {
                    return true;
                }
                case 69: {
                    return true;
                }
                case 68: {
                    return true;
                }
                case 41: {
                    return true;
                }
                case 47: {
                    return true;
                }
                case 42: {
                    return true;
                }
                case 45: {
                    return true;
                }
                case 46: {
                    return true;
                }
                case 44: {
                    return true;
                }
                case 43: {
                    return true;
                }
                case 28: {
                    return true;
                }
                case 34: {
                    return true;
                }
                case 29: {
                    return true;
                }
                case 32: {
                    return true;
                }
                case 33: {
                    return true;
                }
                case 31: {
                    return true;
                }
                case 30: {
                    return true;
                }
                case 40: {
                    return false;
                }
                case 53: {
                    return false;
                }
                case 114: {
                    return false;
                }
                case 26: {
                    return false;
                }
                case 15: {
                    return false;
                }
                case 115: {
                    return false;
                }
                case 2: {
                    return false;
                }
                case 116: {
                    return false;
                }
                case 77: {
                    return false;
                }
            }
            throw Debug.abort("unknown primitive", symbol);
        }
        return false;
    }

    protected Primitive maybeNegatedPrim(Primitive primitive, boolean bl) {
        return bl ? primitive.negate() : primitive;
    }

    protected Tree[] extractPrimitiveArgs(Tree.Apply apply) {
        Tree[] treeArray = Tree.cloneArray(1, apply.args);
        treeArray[0] = ((Tree.Select)apply.fun).qualifier;
        return treeArray;
    }

    protected Tree unbox(Tree tree) {
        if (tree.$tag == 4) {
            Tree.Apply apply = (Tree.Apply)tree;
            Tree tree2 = apply.fun;
            Tree[] treeArray = apply.args;
            if (this.prims.getPrimitive(tree2.symbol()) == Primitive.BOX) {
                if (!$assertionsDisabled && treeArray.length != 1) {
                    throw new AssertionError();
                }
                return treeArray[0];
            }
            return tree;
        }
        return tree;
    }

    protected void addModuleInstanceField(Context context) {
        context.clazz.addNewField(25, MODULE_INSTANCE_FIELD_NAME, context.clazz.getType());
        JMethod jMethod = this.getClassConstructorMethod(context, true);
        JExtendedCode jExtendedCode = (JExtendedCode)jMethod.getCode();
        jExtendedCode.emitNEW(context.clazz.getName());
        jExtendedCode.emitINVOKESPECIAL(context.clazz.getName(), CONSTRUCTOR_STRING, JMethodType.ARGLESS_VOID_FUNCTION);
    }

    protected JMethod addNewScalaMethod(JClass jClass, Symbol symbol, int n) {
        JMethodType jMethodType = (JMethodType)this.typeStoJ(symbol.type());
        Symbol[] symbolArray = symbol.valueParams();
        String[] stringArray = new String[symbolArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = symbolArray[i].name.toString();
        }
        return jClass.addNewMethod(this.modifiersStoJ(symbol.flags) | n, symbol.name.toString(), jMethodType.getReturnType(), jMethodType.getArgumentTypes(), stringArray);
    }

    protected void dumpModuleMirrorClass(Context context, Symbol symbol, Pickle pickle) {
        Object object;
        String string = this.javaName(symbol);
        String string2 = string.substring(0, string.length() - 1);
        JClass jClass = this.fjbgContext.JClass(49, string2, JAVA_LANG_OBJECT, JClass.NO_INTERFACES, context.sourceFileName);
        Scope.SymbolIterator symbolIterator = symbol.members().iterator();
        while (symbolIterator.hasNext()) {
            object = symbolIterator.next();
            if (!((Symbol)object).isMethod() || ((Symbol)object).isInitializer()) continue;
            JMethod jMethod = this.addNewScalaMethod(jClass, (Symbol)object, 8);
            JExtendedCode jExtendedCode = (JExtendedCode)jMethod.getCode();
            jExtendedCode.emitGETSTATIC(string, MODULE_INSTANCE_FIELD_NAME, (JType)new JObjectType(string));
            JType[] jTypeArray = jMethod.getArgumentTypes();
            int n = 0;
            for (int i = 0; i < jTypeArray.length; ++i) {
                jExtendedCode.emitLOAD(n, jTypeArray[i]);
                n += jTypeArray[i].getSize();
            }
            jExtendedCode.emitINVOKEVIRTUAL(string, jMethod.getName(), (JMethodType)jMethod.getType());
            jExtendedCode.emitRETURN(jMethod.getReturnType());
            jExtendedCode.setLineNumber(0, jExtendedCode.getPC(), Position.line(((Symbol)object).pos));
        }
        this.addScalaAttr(jClass, pickle);
        try {
            object = this.javaFileName(string2);
            jClass.writeTo((String)object);
            this.global.operation("wrote ".concat(String.valueOf(String.valueOf(object))));
        }
        catch (IOException iOException) {
            throw Global.fail(iOException.getMessage());
        }
    }

    protected void addScalaAttr(JClass jClass, Pickle pickle) {
        JOtherAttribute jOtherAttribute = this.fjbgContext.JOtherAttribute(jClass, (Object)jClass, SCALA_ATTR, pickle.bytes, pickle.size());
        jClass.addAttribute((JAttribute)jOtherAttribute);
    }

    protected String javaName(Symbol symbol) {
        Object v = this.nameMap.get(symbol);
        if (v != null) {
            return (String)v;
        }
        String string = this.prims.getJREClassName(symbol);
        this.nameMap.put(symbol, string);
        return string;
    }

    protected String javaFileName(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        File file = new File(this.global.outpath);
        while (stringTokenizer.hasMoreElements()) {
            file = new File(file, stringTokenizer.nextToken());
        }
        return String.valueOf(String.valueOf(file.getPath())).concat(".class");
    }

    protected int modifiersStoJ(int n) {
        int n2 = 0;
        n2 = Modifiers.Helper.isPrivate(n) ? (n2 |= 2) : (n2 |= 1);
        if (Modifiers.Helper.isAbstract(n)) {
            n2 |= 0x400;
        }
        if (Modifiers.Helper.isInterface(n)) {
            n2 |= 0x200;
        }
        if (Modifiers.Helper.isFinal(n) && !Modifiers.Helper.isAbstract(n) && !Modifiers.Helper.isInterface(n)) {
            n2 |= 0x10;
        }
        return n2;
    }

    protected void initTypeMap() {
        this.typeMap.put(this.defs.ANY_CLASS, JObjectType.JAVA_LANG_OBJECT);
        this.typeMap.put(this.defs.ANYREF_CLASS, JObjectType.JAVA_LANG_OBJECT);
    }

    protected JType typeStoJ(Type type) {
        switch (type.$tag) {
            case 1: {
                Type.ConstantType constantType = (Type.ConstantType)type;
                Type type2 = constantType.base;
                return this.typeStoJ(type2);
            }
            case 8: {
                Type.TypeRef typeRef = (Type.TypeRef)type;
                Symbol symbol = typeRef.sym;
                Object v = this.typeMap.get(symbol);
                if (v != null) {
                    return (JType)v;
                }
                JObjectType jObjectType = new JObjectType(this.javaName(symbol));
                this.typeMap.put(symbol, jObjectType);
                return jObjectType;
            }
            case 11: {
                Type.UnboxedType unboxedType = (Type.UnboxedType)type;
                switch (unboxedType.tag) {
                    case 10: {
                        return JType.BYTE;
                    }
                    case 11: {
                        return JType.CHAR;
                    }
                    case 12: {
                        return JType.SHORT;
                    }
                    case 13: {
                        return JType.INT;
                    }
                    case 14: {
                        return JType.LONG;
                    }
                    case 15: {
                        return JType.FLOAT;
                    }
                    case 16: {
                        return JType.DOUBLE;
                    }
                    case 17: {
                        return JType.BOOLEAN;
                    }
                    case 18: {
                        return JType.VOID;
                    }
                    case 19: {
                        return JObjectType.JAVA_LANG_STRING;
                    }
                }
                break;
            }
            case 10: {
                Type.UnboxedArrayType unboxedArrayType = (Type.UnboxedArrayType)type;
                Type type3 = unboxedArrayType.elemtp;
                return new JArrayType(this.typeStoJ(type3));
            }
            case 3: {
                Type.MethodType methodType = (Type.MethodType)type;
                Symbol[] symbolArray = methodType.vparams;
                Type type4 = methodType.result;
                JType[] jTypeArray = new JType[symbolArray.length];
                for (int i = 0; i < symbolArray.length; ++i) {
                    jTypeArray[i] = this.typeStoJ(symbolArray[i].info());
                }
                return new JMethodType(this.typeStoJ(type4), jTypeArray);
            }
        }
        throw Debug.abort("invalid type", type);
    }

    protected int getTypeIndex(JType jType) {
        return this.getTypeIndex(jType.getTag());
    }

    protected int getTypeIndex(int n) {
        switch (n) {
            case 4: {
                return 0;
            }
            case 5: 
            case 8: 
            case 9: 
            case 10: {
                return 1;
            }
            case 11: {
                return 2;
            }
            case 6: {
                return 3;
            }
            case 7: {
                return 4;
            }
            case 13: 
            case 14: {
                return 5;
            }
        }
        return -1;
    }

    protected JType getMaxType(Tree[] treeArray) {
        JType jType = JType.BOOLEAN;
        int n = this.getTypeIndex(jType);
        for (int i = 0; i < treeArray.length; ++i) {
            JType jType2 = this.typeStoJ(treeArray[i].type);
            if (this.getTypeIndex(jType2) <= n) continue;
            jType = jType2;
            n = this.getTypeIndex(jType);
        }
        return jType;
    }

    protected JType getMaxType(Tree tree, Tree tree2) {
        JType jType = this.typeStoJ(tree.type);
        JType jType2 = this.typeStoJ(tree2.type);
        return this.getTypeIndex(jType) > this.getTypeIndex(jType2) ? jType : jType2;
    }

    void startCodeForTree(Context context, Tree tree) {
        if (this.pcStackDepth == this.pcStack.length) {
            int[] nArray = new int[this.pcStack.length * 2];
            System.arraycopy(this.pcStack, 0, nArray, 0, this.pcStack.length);
            this.pcStack = nArray;
        }
        this.pcStack[this.pcStackDepth++] = context.code == null ? 0 : context.code.getPC();
    }

    void endCodeForTree(Context context, Tree tree) {
        if (!$assertionsDisabled && this.pcStackDepth <= 0) {
            throw new AssertionError();
        }
        int n = this.pcStack[--this.pcStackDepth];
        if (context.code != null) {
            context.code.completeLineNumber(n, context.code.getPC(), Position.line(tree.pos));
        }
    }

    protected Context enterClass(Context context, Symbol symbol) {
        Symbol symbol2;
        String string;
        int n;
        String string2 = this.javaName(symbol);
        Type[] typeArray = symbol.info().parents();
        if (!$assertionsDisabled && typeArray.length <= 0) {
            throw new AssertionError((Object)String.valueOf(String.valueOf(Debug.show(symbol))));
        }
        if (symbol.isInterface()) {
            n = typeArray[0].symbol() == this.defs.ANY_CLASS ? 1 : 0;
            string = JAVA_LANG_OBJECT;
        } else {
            n = 1;
            string = this.javaName(typeArray[0].symbol());
        }
        String[] stringArray = new String[typeArray.length - n];
        for (int i = n; i < typeArray.length; ++i) {
            symbol2 = typeArray[i].symbol();
            if (!$assertionsDisabled && !symbol2.isInterface()) {
                throw new AssertionError((Object)String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(symbol)).concat(" implements "))).concat(String.valueOf(String.valueOf(symbol2))))));
            }
            stringArray[i - n] = this.javaName(symbol2);
        }
        symbol2 = this.fjbgContext.JClass(this.modifiersStoJ(symbol.flags) | 0x20, string2, string, stringArray, context.sourceFileName);
        return context.withClass((JClass)symbol2, symbol.isModuleClass() && context.clazz == null, symbol.isSubClass(this.JAVA_RMI_REMOTE_CLASS));
    }

    protected void leaveClass(Context context, Symbol symbol) {
        Pickle pickle = (Pickle)this.global.symdata.get(symbol);
        if (pickle != null) {
            if (context.isModuleClass) {
                this.dumpModuleMirrorClass(context, symbol, pickle);
            } else {
                this.addScalaAttr(context.clazz, pickle);
            }
        }
        try {
            String string = this.javaFileName(context.clazz.getName());
            context.clazz.writeTo(string);
            this.global.operation("wrote ".concat(String.valueOf(String.valueOf(string))));
        }
        catch (IOException iOException) {
            throw Global.fail(iOException.getMessage());
        }
    }

    protected Context enterMethod(Context context, Tree.DefDef defDef, boolean bl) {
        Symbol symbol = defDef.symbol();
        this.global.log(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf("entering method ".concat(String.valueOf(String.valueOf(Debug.show(symbol)))))).concat(" (type: "))).concat(String.valueOf(String.valueOf(Debug.show(symbol.info())))))).concat(")"))).concat(" wide jumps? "))).concat(String.valueOf(bl)));
        JMethod jMethod = this.addNewScalaMethod(context.clazz, symbol, 0);
        HashMap<Symbol, Integer> hashMap = new HashMap<Symbol, Integer>();
        Symbol[] symbolArray = symbol.valueParams();
        JType[] jTypeArray = jMethod.getArgumentTypes();
        int n = 1;
        for (int i = 0; i < jTypeArray.length; ++i) {
            hashMap.put(symbolArray[i], new Integer(n));
            n += jTypeArray[i].getSize();
        }
        if ((symbol.flags & 0x8000000) != 0) {
            jMethod.addAttribute((JAttribute)this.fjbgContext.JOtherAttribute(context.clazz, (Object)jMethod, "Bridge", new byte[0]));
        }
        if (context.isRemote && symbol.isPublic()) {
            JConstantPool jConstantPool = context.clazz.getConstantPool();
            int n2 = jConstantPool.addClass(JAVA_RMI_REMOTEEXCEPTION);
            ByteBuffer byteBuffer = ByteBuffer.allocate(4);
            byteBuffer.putShort((short)1);
            byteBuffer.putShort((short)n2);
            this.global.log(String.valueOf(String.valueOf(String.valueOf(String.valueOf("adding 'Exceptions_attribute' ".concat(String.valueOf(String.valueOf(byteBuffer.toString()))))).concat(" for remote method "))).concat(String.valueOf(String.valueOf(symbol.name.toString()))));
            jMethod.addAttribute((JAttribute)this.fjbgContext.JOtherAttribute(context.clazz, (Object)jMethod, "Exceptions", byteBuffer.array()));
        }
        return context.withMethod(jMethod, hashMap, bl);
    }

    protected void leaveMethod(Context context) {
        this.global.log("leaving method");
    }

    private JMethod getClassConstructorMethod(Context context, boolean bl) {
        JMethod[] jMethodArray = context.clazz.getMethods();
        JMethod jMethod = null;
        for (int i = 0; i < jMethodArray.length; ++i) {
            if (!jMethodArray[i].getName().equals("<clinit>")) continue;
            jMethod = jMethodArray[i];
            break;
        }
        if (jMethod == null && bl) {
            jMethod = context.clazz.addNewMethod(9, "<clinit>", JType.VOID, JType.EMPTY_ARRAY, Strings.EMPTY_ARRAY);
        }
        return jMethod;
    }

    protected void addValueClassMembers(Context context, Tree.ClassDef classDef) {
        Symbol symbol = classDef.symbol();
        Scope.SymbolIterator symbolIterator = symbol.members().iterator();
        while (symbolIterator.hasNext()) {
            Symbol symbol2 = symbolIterator.next();
            if (!symbol2.isTerm() || symbol2.isMethod()) continue;
            context.clazz.addNewField(this.modifiersStoJ(symbol2.flags), symbol2.name.toString(), this.typeStoJ(symbol2.info()));
        }
    }

    protected void addStaticClassMembers(Context context, Tree.ClassDef classDef) {
        Symbol symbol;
        Symbol symbol2 = classDef.symbol();
        HashMap<Symbol, Object> hashMap = new HashMap<Symbol, Object>();
        Symbol symbol3 = symbol = context.isModuleClass ? symbol2 : this.addInterfacesPhase.getInterfaceSymbol(symbol2);
        if (symbol != null) {
            Object object;
            Object object2;
            Object object3;
            Symbol symbol4;
            Phase phase = this.global.currentPhase;
            this.global.currentPhase = this.refCheckPhase;
            Scope.SymbolIterator symbolIterator = symbol.members().iterator();
            while (symbolIterator.hasNext()) {
                symbol4 = symbolIterator.next();
                if (!symbol4.isTerm() || symbol4.isMethod() || !symbol4.isPrivate()) continue;
                object3 = symbol4.info();
                if (((Type)object3).$tag != 1) continue;
                object2 = (Type.ConstantType)object3;
                object = ((Type.ConstantType)object2).value;
                hashMap.put(symbol4, object);
            }
            this.global.currentPhase = phase;
            symbol4 = this.getClassConstructorMethod(context, true);
            object3 = context.withMethod((JMethod)symbol4, Collections.EMPTY_MAP, false);
            object2 = hashMap.keySet().iterator();
            while (object2.hasNext()) {
                object = (Symbol)object2.next();
                String string = ((Symbol)object).name.toString();
                JType jType = this.typeStoJ(((Symbol)object).info());
                JField jField = ((Context)object3).clazz.addNewField((this.modifiersStoJ(((Symbol)object).flags) | 8 | 1) & 0xFFFFFFFD, string.substring(0, string.length() - 1), jType);
                this.genLoadLiteral((Context)object3, (AConstant)hashMap.get(object), jType);
                ((Context)object3).code.emitPUTSTATIC(((Context)object3).clazz.getName(), jField.getName(), jType);
            }
        }
    }

    protected boolean isStaticMember(Symbol symbol) {
        return !symbol.isInitializer() && symbol.owner().isModuleClass() && symbol.owner().isJava();
    }

    static {
        $assertionsDisabled = !Class.forName("scalac.backend.jvm.GenJVM").desiredAssertionStatus();
        SCALA_ATTR = ClassfileConstants.SCALA_N.toString();
    }
}

