/*
 * Decompiled with CFR 0.152.
 */
package scalac.atree;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import scalac.CompilationUnit;
import scalac.ast.Tree;
import scalac.atree.AClass;
import scalac.atree.ACode;
import scalac.atree.AConstant;
import scalac.atree.AField;
import scalac.atree.AFunction;
import scalac.atree.AInvokeStyle;
import scalac.atree.AInvokeStyle$;
import scalac.atree.ALocation;
import scalac.atree.AMethod;
import scalac.atree.ARepository;
import scalac.atree.ATreeFactory;
import scalac.atree.ATreeFromSTree$Generator$;
import scalac.atree.ATypeKind;
import scalac.symtab.Definitions;
import scalac.symtab.Symbol;
import scalac.symtab.Type;
import scalac.util.Debug;
import scalac.util.Name;
import scalac.util.TermName;

public class ATreeFromSTree {
    private final Definitions definitions;
    private final ATreeFactory make;
    private final Map states;
    private final Map generators;
    private static final /* synthetic */ boolean $assertionsDisabled;

    public ATreeFromSTree(Definitions definitions) {
        this.definitions = definitions;
        this.make = new ATreeFactory();
        this.states = new HashMap();
        this.generators = new HashMap();
        Symbol[] symbolArray = new Symbol[]{definitions.ANY_CLASS, definitions.OBJECT_CLASS, definitions.STRING_CLASS, definitions.THROWABLE_CLASS, definitions.ARRAY_CLASS, definitions.UNIT_CLASS, definitions.BOOLEAN_CLASS, definitions.BYTE_CLASS, definitions.SHORT_CLASS, definitions.CHAR_CLASS, definitions.INT_CLASS, definitions.LONG_CLASS, definitions.FLOAT_CLASS, definitions.DOUBLE_CLASS};
        for (int i = 0; i < symbolArray.length; ++i) {
            this.states.put(symbolArray[i], Boolean.FALSE);
        }
    }

    public void translate(CompilationUnit compilationUnit) {
        compilationUnit.repository = new ARepository();
        this.template(compilationUnit.repository, compilationUnit.body);
    }

    private void template(ARepository aRepository, Tree[] treeArray) {
        for (int i = 0; i < treeArray.length; ++i) {
            this.template(aRepository, treeArray[i]);
        }
    }

    private void template(ARepository aRepository, Tree tree) {
        switch (tree.$tag) {
            case 42: {
                return;
            }
            case 10: {
                Tree.ClassDef classDef = (Tree.ClassDef)tree;
                if (classDef.impl.$tag != 33) break;
                Tree.Template template = classDef.impl;
                Tree[] treeArray = template.body;
                AClass aClass = new AClass(tree.symbol());
                aRepository.addClass(aClass);
                this.member(aClass, treeArray);
                return;
            }
            case 24: {
                Tree.PackageDef packageDef = (Tree.PackageDef)tree;
                if (packageDef.impl.$tag != 33) break;
                Tree.Template template = packageDef.impl;
                Tree[] treeArray = template.body;
                this.template(aRepository, treeArray);
                return;
            }
        }
        throw Debug.abort("illegal case", tree);
    }

    private void member(AClass aClass, Tree[] treeArray) {
        for (int i = 0; i < treeArray.length; ++i) {
            this.member(aClass, treeArray[i]);
        }
    }

    private void member(AClass aClass, Tree tree) {
        switch (tree.$tag) {
            case 42: {
                return;
            }
            case 10: {
                this.template((ARepository)aClass, tree);
                return;
            }
            case 40: {
                AField aField = new AField(tree.symbol(), false);
                aClass.addField(aField);
                return;
            }
            case 13: {
                Tree.DefDef defDef = (Tree.DefDef)tree;
                Tree tree2 = defDef.rhs;
                AMethod aMethod = new AMethod(tree.symbol(), false);
                aClass.addMethod(aMethod);
                if (!aMethod.isAbstract()) {
                    aMethod.setCode(this.expression(tree2));
                }
                return;
            }
        }
        throw Debug.abort("illegal case", tree);
    }

    private ACode[] statement(List list, Tree[] treeArray) {
        ArrayList<ACode> arrayList = new ArrayList<ACode>();
        for (int i = 0; i < treeArray.length; ++i) {
            ACode aCode = this.statement(list, treeArray[i]);
            if (aCode == ACode.Void) continue;
            arrayList.add(aCode);
        }
        return arrayList.toArray(new ACode[arrayList.size()]);
    }

    private ACode statement(List list, Tree tree) {
        switch (tree.$tag) {
            case 42: {
                return this.make.Void;
            }
            case 40: {
                Tree.ValDef valDef = (Tree.ValDef)tree;
                Tree tree2 = valDef.rhs;
                Symbol symbol = tree.symbol();
                list.add(symbol);
                ALocation.Local local = ALocation.Local(symbol, false);
                return this.make.Store(tree, local, this.expression(tree2));
            }
        }
        return ACode.Drop(this.expression(tree), tree.type());
    }

    private ACode[] expression(Tree[] treeArray) {
        ACode[] aCodeArray = new ACode[treeArray.length];
        for (int i = 0; i < aCodeArray.length; ++i) {
            aCodeArray[i] = this.expression(treeArray[i]);
        }
        return aCodeArray;
    }

    private ACode expression(Tree tree) {
        switch (tree.$tag) {
            case 20: {
                Tree.LabelDef labelDef = (Tree.LabelDef)tree;
                Tree[] treeArray = labelDef.params;
                Tree tree2 = labelDef.rhs;
                Symbol[] symbolArray = Tree.symbolOf(treeArray);
                return this.make.Label(tree, tree.symbol(), symbolArray, this.expression(tree2));
            }
            case 8: {
                Tree.Block block = (Tree.Block)tree;
                Tree[] treeArray = block.stats;
                Tree tree3 = block.expr;
                ArrayList arrayList = new ArrayList();
                ACode[] aCodeArray = this.statement(arrayList, treeArray);
                ACode aCode = this.expression(tree3);
                if (arrayList.size() == 0 && aCodeArray.length == 0) {
                    return aCode;
                }
                Symbol[] symbolArray = arrayList.toArray(new Symbol[arrayList.size()]);
                return this.make.Block(tree, symbolArray, aCodeArray, aCode);
            }
            case 5: {
                Tree.Assign assign = (Tree.Assign)tree;
                Tree tree4 = assign.lhs;
                Tree tree5 = assign.rhs;
                return this.make.Block(tree, Symbol.EMPTY_ARRAY, new ACode[]{this.make.Store(tree, this.location(tree4), this.expression(tree5))}, this.make.Void);
            }
            case 18: {
                Tree.If if_ = (Tree.If)tree;
                Tree tree6 = if_.cond;
                Tree tree7 = if_.thenp;
                Tree tree8 = if_.elsep;
                ACode aCode = this.expression(tree6);
                return this.make.If(tree, aCode, this.expression(tree7), this.expression(tree8));
            }
            case 32: {
                Tree.Switch switch_ = (Tree.Switch)tree;
                Tree tree9 = switch_.test;
                int[] nArray = switch_.tags;
                Tree[] treeArray = switch_.bodies;
                Tree tree10 = switch_.otherwise;
                int[][] nArrayArray = new int[nArray.length][];
                for (int i = 0; i < nArrayArray.length; ++i) {
                    nArrayArray[i] = new int[]{nArray[i]};
                }
                ACode[] aCodeArray = new ACode[treeArray.length + 1];
                for (int i = 0; i < treeArray.length; ++i) {
                    aCodeArray[i] = this.expression(treeArray[i]);
                }
                aCodeArray[nArray.length] = this.expression(tree10);
                return this.make.Switch(tree, this.expression(tree9), nArrayArray, aCodeArray);
            }
            case 26: {
                Tree.Return return_ = (Tree.Return)tree;
                Tree tree11 = return_.expr;
                return this.make.Return(tree, tree.symbol(), this.expression(tree11));
            }
            case 35: {
                Tree.Throw throw_ = (Tree.Throw)tree;
                Tree tree12 = throw_.expr;
                return this.make.Throw(tree, this.expression(tree12));
            }
            case 23: {
                Tree.New new_ = (Tree.New)tree;
                if (new_.init.$tag != 4) break;
                Tree.Apply apply = (Tree.Apply)new_.init;
                Tree tree13 = apply.fun;
                Tree[] treeArray = apply.args;
                if (tree13.$tag == 27) {
                    Tree.Select select = (Tree.Select)tree13;
                    if (select.qualifier.$tag == 12) {
                        Tree.Create create = (Tree.Create)select.qualifier;
                        Tree[] treeArray2 = create.targs;
                        return this.apply(tree, tree13, treeArray2, treeArray);
                    }
                }
                throw Debug.abort("illegal case", tree);
            }
            case 4: {
                Tree.Apply apply = (Tree.Apply)tree;
                if (apply.fun.$tag == 37) {
                    Tree.TypeApply typeApply = (Tree.TypeApply)apply.fun;
                    Tree tree14 = typeApply.fun;
                    Tree[] treeArray = typeApply.args;
                    Tree[] treeArray3 = apply.args;
                    return this.apply(tree, tree14, treeArray, treeArray3);
                }
                Tree tree15 = apply.fun;
                Tree[] treeArray = apply.args;
                return this.apply(tree, tree15, Tree.EMPTY_ARRAY, treeArray);
            }
            case 31: {
                return this.make.This(tree, tree.symbol());
            }
            case 34: {
                return this.make.This(tree, tree.symbol());
            }
            case 27: {
                return this.make.Load(tree, this.location(tree));
            }
            case 17: {
                return this.make.Load(tree, this.location(tree));
            }
            case 21: {
                Tree.Literal literal = (Tree.Literal)tree;
                AConstant aConstant = literal.value;
                return this.make.Constant(tree, aConstant);
            }
        }
        throw Debug.abort("illegal case", tree);
    }

    private ACode apply(Tree tree, Tree tree2, Tree[] treeArray, Tree[] treeArray2) {
        Symbol symbol = tree2.symbol();
        ACode[] aCodeArray = this.expression(treeArray2);
        if (symbol.isLabel()) {
            return this.make.Goto(tree, symbol, aCodeArray);
        }
        Type[] typeArray = Tree.typeOf(treeArray);
        AFunction aFunction = this.function(tree2);
        if (aFunction.$tag == 0) {
            Symbol symbol2;
            Object v;
            AFunction.Method method = (AFunction.Method)aFunction;
            ACode aCode = method.object;
            Symbol symbol3 = method.method;
            AInvokeStyle aInvokeStyle = method.style;
            if (aInvokeStyle.isDynamic() && (v = this.states.get(symbol2 = symbol3.owner())) != null) {
                Object v2;
                if (v != Boolean.TRUE) {
                    this.addGeneratorsOf(symbol2);
                }
                if ((v2 = this.generators.get(symbol3)) != null) {
                    return this.generate((Generator)v2, tree, aCode, typeArray, treeArray2);
                }
            }
        }
        return this.make.Apply(tree, aFunction, typeArray, aCodeArray);
    }

    private AFunction function(Tree tree) {
        Symbol symbol = tree.symbol();
        switch (tree.$tag) {
            case 27: {
                Tree.Select select = (Tree.Select)tree;
                if (select.qualifier.$tag == 12) {
                    AInvokeStyle$.Var var = AInvokeStyle.New;
                    return AFunction.Method(this.make.Void, symbol, var);
                }
                Tree tree2 = select.qualifier;
                AInvokeStyle aInvokeStyle = this.invokeStyle(tree2);
                return AFunction.Method(this.expression(tree2), symbol, aInvokeStyle);
            }
            case 17: {
                AInvokeStyle aInvokeStyle = AInvokeStyle.StaticClass;
                return AFunction.Method(this.make.Void, symbol, aInvokeStyle);
            }
        }
        throw Debug.abort("illegal case", tree);
    }

    private AInvokeStyle invokeStyle(Tree tree) {
        if (tree.$tag == 31) {
            return AInvokeStyle.StaticInstance;
        }
        return AInvokeStyle.Dynamic;
    }

    private ALocation location(Tree tree) {
        Symbol symbol = tree.symbol();
        switch (tree.$tag) {
            case 27: {
                Tree.Select select = (Tree.Select)tree;
                Tree tree2 = select.qualifier;
                return ALocation.Field(this.expression(tree2), symbol, false);
            }
            case 17: {
                if (symbol.isModule()) {
                    return ALocation.Module(symbol);
                }
                return symbol.owner().isClass() ? ALocation.Field(this.make.Void, symbol, true) : ALocation.Local(symbol, symbol.isParameter());
            }
        }
        throw Debug.abort("illegal case", tree);
    }

    private AConstant constant(Object object) {
        if (object instanceof Boolean) {
            return this.make.BOOLEAN((Boolean)object);
        }
        if (object instanceof Byte) {
            return this.make.BYTE((Byte)object);
        }
        if (object instanceof Short) {
            return this.make.SHORT((Short)object);
        }
        if (object instanceof Character) {
            return this.make.CHAR((Character)object);
        }
        if (object instanceof Integer) {
            return this.make.INT((Integer)object);
        }
        if (object instanceof Long) {
            return this.make.LONG((Long)object);
        }
        if (object instanceof Float) {
            return this.make.FLOAT((Float)object);
        }
        if (object instanceof Double) {
            return this.make.DOUBLE((Double)object);
        }
        if (object instanceof String) {
            return this.make.STRING((String)object);
        }
        throw Debug.abort("illegal constant", String.valueOf(String.valueOf(String.valueOf(String.valueOf(object)).concat(" -- "))).concat(String.valueOf(String.valueOf(object.getClass()))));
    }

    private ACode generate(Generator generator, Tree tree, ACode aCode, Type[] typeArray, Tree[] treeArray) {
        switch (generator.$tag) {
            case 3: {
                if (!($assertionsDisabled || typeArray.length == 0 && treeArray.length == 1)) {
                    throw new AssertionError((Object)String.valueOf(String.valueOf(tree)));
                }
                return this.make.EQ(tree, ATypeKind.REF, aCode, this.expression(treeArray[0]));
            }
            case 2: {
                Symbol symbol = this.newLocal(tree, this.definitions.ANY_TYPE());
                Symbol symbol2 = this.newLocal(tree, this.definitions.ANY_TYPE());
                return this.make.Block(tree, new Symbol[]{symbol, symbol2}, new ACode[]{this.store(tree, symbol, aCode), this.store(tree, symbol2, this.expression(treeArray[0]))}, this.make.If(tree, this.make.EQ(tree, ATypeKind.REF, this.load(tree, symbol)), this.make.EQ(tree, ATypeKind.REF, this.load(tree, symbol2)), this.make.Apply(tree, AFunction.Method(this.load(tree, symbol), this.definitions.ANY_EQUALS, AInvokeStyle.Dynamic), Type.EMPTY_ARRAY, new ACode[]{this.load(tree, symbol2)})));
            }
            case 4: {
                Symbol symbol = this.newLocal(tree, this.definitions.ANY_TYPE());
                Symbol symbol3 = this.newLocal(tree, this.definitions.ANY_TYPE());
                return this.make.Block(tree, new Symbol[]{symbol, symbol3}, new ACode[]{this.store(tree, symbol, aCode), this.store(tree, symbol3, this.expression(treeArray[0]))}, this.make.If(tree, this.make.EQ(tree, ATypeKind.REF, this.load(tree, symbol)), this.make.NE(tree, ATypeKind.REF, this.load(tree, symbol3)), this.make.NOT(tree, ATypeKind.BOOL, this.make.Apply(tree, AFunction.Method(this.load(tree, symbol), this.definitions.ANY_EQUALS, AInvokeStyle.Dynamic), Type.EMPTY_ARRAY, new ACode[]{this.load(tree, symbol3)}))));
            }
            case 1: {
                Generator.ISAS iSAS = (Generator.ISAS)generator;
                boolean bl = iSAS.cast;
                if (!($assertionsDisabled || typeArray.length == 1 && treeArray.length == 0)) {
                    throw new AssertionError((Object)String.valueOf(String.valueOf(tree)));
                }
                return this.make.IsAs(tree, aCode, typeArray[0], bl);
            }
            case 5: {
                if (!($assertionsDisabled || typeArray.length == 1 && treeArray.length == 1)) {
                    throw new AssertionError((Object)String.valueOf(String.valueOf(tree)));
                }
                return this.make.Synchronized(tree, aCode, this.expression(treeArray[0]));
            }
            case 6: {
                if (!($assertionsDisabled || typeArray.length == 0 && treeArray.length == 0)) {
                    throw new AssertionError((Object)String.valueOf(String.valueOf(tree)));
                }
                return this.make.Throw(tree, aCode);
            }
            case 0: {
                Generator.CONCAT cONCAT = (Generator.CONCAT)generator;
                ATypeKind aTypeKind = cONCAT.prefix;
                if (!($assertionsDisabled || typeArray.length == 0 && treeArray.length == 1)) {
                    throw new AssertionError((Object)String.valueOf(String.valueOf(tree)));
                }
                ATypeKind aTypeKind2 = this.kind(treeArray[0].type());
                ACode aCode2 = this.expression(treeArray[0]);
                return this.make.CONCAT(tree, aTypeKind, aTypeKind2, aCode, aCode2);
            }
        }
        throw Debug.abort("unknown case", generator);
    }

    private ACode load(Tree tree, Symbol symbol) {
        if (!$assertionsDisabled && !symbol.owner().isNone()) {
            throw new AssertionError((Object)String.valueOf(String.valueOf(Debug.show(symbol))));
        }
        return this.make.Load(tree, ALocation.Local(symbol, false));
    }

    private ACode store(Tree tree, Symbol symbol, ACode aCode) {
        if (!$assertionsDisabled && !symbol.owner().isNone()) {
            throw new AssertionError((Object)String.valueOf(String.valueOf(Debug.show(symbol))));
        }
        return this.make.Store(tree, ALocation.Local(symbol, false), aCode);
    }

    private Symbol newLocal(Tree tree, Type type) {
        Symbol symbol = Symbol.NONE;
        TermName termName = Name.fromString("local");
        return symbol.newTerm(tree.pos, 0, termName).setType(type);
    }

    private ATypeKind kind(Type type) {
        switch (type.$tag) {
            case 6: {
                return this.kind(type.singleDeref());
            }
            case 1: {
                return this.kind(type.singleDeref());
            }
            case 8: {
                Type.TypeRef typeRef = (Type.TypeRef)type;
                Symbol symbol = typeRef.sym;
                if (symbol == this.definitions.BOOLEAN_CLASS) {
                    return ATypeKind.BOOL;
                }
                if (symbol == this.definitions.BYTE_CLASS) {
                    return ATypeKind.I1;
                }
                if (symbol == this.definitions.SHORT_CLASS) {
                    return ATypeKind.I2;
                }
                if (symbol == this.definitions.CHAR_CLASS) {
                    return ATypeKind.U2;
                }
                if (symbol == this.definitions.INT_CLASS) {
                    return ATypeKind.I4;
                }
                if (symbol == this.definitions.LONG_CLASS) {
                    return ATypeKind.I8;
                }
                if (symbol == this.definitions.FLOAT_CLASS) {
                    return ATypeKind.R4;
                }
                if (symbol == this.definitions.DOUBLE_CLASS) {
                    return ATypeKind.R8;
                }
                if (symbol == this.definitions.STRING_CLASS) {
                    return ATypeKind.STR;
                }
                return ATypeKind.REF;
            }
        }
        return ATypeKind.REF;
    }

    private void addGeneratorsOf(Symbol symbol) {
        if (symbol == this.definitions.ANY_CLASS) {
            this.addGenerator(this.definitions.ANY_EQEQ, Generator.ANYEQ);
            this.addGenerator(this.definitions.ANY_BANGEQ, Generator.ANYNE);
            this.addGenerator(this.definitions.ANY_IS, Generator.ISAS(false));
            this.addGenerator(this.definitions.ANY_AS, Generator.ISAS(true));
        }
        if (symbol == this.definitions.OBJECT_CLASS) {
            this.addGenerator(this.definitions.OBJECT_EQ, Generator.ANYID);
            this.addGenerator(this.definitions.OBJECT_SYNCHRONIZED, Generator.SYNCHRONIZED);
        }
        if (symbol == this.definitions.STRING_CLASS) {
            this.addGenerator(this.definitions.STRING_PLUS, Generator.CONCAT(ATypeKind.STR));
        }
        if (symbol == this.definitions.THROWABLE_CLASS) {
            this.addGenerator(this.definitions.THROWABLE_THROW, Generator.THROW);
        }
        if (symbol == this.definitions.ARRAY_CLASS) {
            // empty if block
        }
        if (symbol == this.definitions.UNIT_CLASS) {
            // empty if block
        }
        if (symbol == this.definitions.BOOLEAN_CLASS) {
            // empty if block
        }
        if (symbol == this.definitions.BYTE_CLASS) {
            // empty if block
        }
        if (symbol == this.definitions.SHORT_CLASS) {
            // empty if block
        }
        if (symbol == this.definitions.CHAR_CLASS) {
            // empty if block
        }
        if (symbol == this.definitions.INT_CLASS) {
            // empty if block
        }
        if (symbol == this.definitions.LONG_CLASS) {
            // empty if block
        }
        if (symbol == this.definitions.FLOAT_CLASS) {
            // empty if block
        }
        if (symbol == this.definitions.DOUBLE_CLASS) {
            // empty if block
        }
        this.states.put(symbol, Boolean.TRUE);
    }

    private void addGenerator(Symbol symbol, Generator generator) {
        this.generators.put(symbol, generator);
    }

    static {
        $assertionsDisabled = !Class.forName("scalac.atree.ATreeFromSTree").desiredAssertionStatus();
    }

    private static class Generator {
        public static /* synthetic */ Generator[] $extensions;
        public static /* synthetic */ int $subIDs;
        public static /* synthetic */ boolean[] $castable;
        public static final /* synthetic */ int $subID;
        public final /* synthetic */ int $tag;
        static final Generator$$Var ANYEQ;
        static final Generator$$Var ANYID;
        static final Generator$$Var ANYNE;
        static final Generator$$Var SYNCHRONIZED;
        static final Generator$$Var THROW;

        public static /* synthetic */ int $register(Generator generator) {
            if ($subIDs == $extensions.length) {
                Generator[] generatorArray = new Generator[$extensions.length * 2];
                System.arraycopy($extensions, 0, generatorArray, 0, $extensions.length);
                $extensions = generatorArray;
                for (int i = 0; i < $subIDs; ++i) {
                    $extensions[i].$extend();
                }
            }
            Generator.$extensions[Generator.$subIDs] = generator;
            return $subIDs++;
        }

        public static /* synthetic */ Generator throw$cast$exception() {
            throw new ClassCastException();
        }

        public /* synthetic */ void $extend() {
            boolean[] blArray = new boolean[$castable.length * 2];
            System.arraycopy($castable, 0, blArray, 0, $castable.length);
            $castable = blArray;
        }

        public /* synthetic */ int $getSubID() {
            return $subID;
        }

        protected /* synthetic */ Generator(int n) {
            this.$tag = n;
        }

        static /* synthetic */ CONCAT CONCAT(ATypeKind aTypeKind) {
            return new CONCAT(aTypeKind);
        }

        static /* synthetic */ ISAS ISAS(boolean bl) {
            return new ISAS(bl);
        }

        static {
            $extensions = new Generator[]{null, null, null, null};
            $castable = new boolean[]{true, false, false, false};
            $subID = Generator.$register(new Generator(-1));
            ANYEQ = new Generator$$Var(2);
            ANYID = new Generator$$Var(3);
            ANYNE = new Generator$$Var(4);
            SYNCHRONIZED = new Generator$$Var(5);
            THROW = new Generator$$Var(6);
        }

        static class ISAS
        extends Generator {
            public /* synthetic */ boolean cast;

            protected /* synthetic */ ISAS() {
                super(1);
            }

            public /* synthetic */ ISAS(boolean bl) {
                super(1);
                this.cast = bl;
            }
        }

        static class CONCAT
        extends Generator {
            public /* synthetic */ ATypeKind prefix;

            protected /* synthetic */ CONCAT() {
                super(0);
            }

            public /* synthetic */ CONCAT(ATypeKind aTypeKind) {
                super(0);
                this.prefix = aTypeKind;
            }
        }
    }
}

