/*
 * Decompiled with CFR 0.152.
 */
package scalac;

import ch.epfl.lamp.util.CodePrinter;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import scala.tools.util.AbstractFile;
import scala.tools.util.ClassPath;
import scala.tools.util.Position;
import scala.tools.util.Reporter;
import scala.tools.util.SourceFile;
import scala.tools.util.SourceReader;
import scalac.ApplicationError;
import scalac.CompilationUnit;
import scalac.CompilerCommand;
import scalac.CompilerPhases;
import scalac.Phase;
import scalac.PhaseDescriptor;
import scalac.ast.DefaultTreeFactory;
import scalac.ast.Tree;
import scalac.ast.TreeFactory;
import scalac.ast.TreeGen;
import scalac.ast.TreeList;
import scalac.ast.printer.TreePrinter;
import scalac.atree.ATreePrinter;
import scalac.backend.Primitives;
import scalac.symtab.Definitions;
import scalac.symtab.SourceCompleter;
import scalac.symtab.Symbol;
import scalac.symtab.SymbolLoader;
import scalac.symtab.SymbolTablePrinter;
import scalac.symtab.Type;
import scalac.symtab.classfile.CLRPackageParser;
import scalac.symtab.classfile.PackageParser;
import scalac.transformer.ICodePhase;
import scalac.typechecker.AnalyzerPhase;
import scalac.typechecker.Infer;
import scalac.util.Debug;
import scalac.util.Name;
import scalac.util.Names;
import scalac.util.SourceRepresentation;
import scalac.util.UniqueID;

public abstract class Global {
    public static Global instance;
    public final boolean noimports;
    public final boolean nopredefs;
    public final boolean separate;
    public final boolean debug;
    public final boolean explaintypes;
    public final boolean uniqid;
    public final boolean newMatch;
    public final boolean xmlPreserveWS;
    public final boolean printtypes;
    public final boolean printtokens;
    public final String outpath;
    public final String encoding;
    public final String target;
    public final Reporter reporter;
    private final Stack startTimes = new Stack();
    private final Charset charset;
    private final CharsetDecoder decoder;
    private final SourceReader reader;
    public CompilationUnit[] units;
    public final ClassPath classPath;
    public final TreeFactory make;
    public final TreeGen treeGen;
    public final UniqueID uniqueID;
    public final PrintWriter writer;
    public final TreePrinter treePrinter;
    public final Map mapSymbolComment = new HashMap();
    public final Map mapSymbolAttr = new HashMap();
    public final Map viewOfTypeParam = new HashMap();
    public final Map symdata = new HashMap();
    public final CompilerCommand args;
    public HashMap compiledNow = new HashMap();
    public HashSet compiledUnits = new HashSet();
    public Phase currentPhase;
    public Definitions definitions;
    public final Primitives primitives;
    public final CompilerPhases PHASE;
    public static final String TARGET_INT;
    public static final String TARGET_JVM;
    public static final String TARGET_MSIL;
    public static final String TARGET_JVMFROMICODE;
    public static final String[] TARGETS;
    public static final String PRINTER_TEXT;
    public static final String PRINTER_HTML;
    public static final String[] PRINTERS;
    public static final String CONSOLE_S = "$console$";
    private static final Name SHOW_DEFINITION_N;
    private static final Name SHOW_VALUE_DEFINITION_N;
    private static final Name SET_EVALUATION_RESULT_N;
    private Symbol INTERPRETER;
    private Symbol PRINTER;
    private Symbol SHOW_VALUE;
    private Symbol SET_EVALUATION_RESULT;
    private Symbol SHOW_DEFINITION;
    private Symbol SHOW_VALUE_DEFINITION;
    private int module = 0;
    private List imports = new ArrayList();
    public Symbol console;
    private static final /* synthetic */ boolean $assertionsDisabled;

    public Global(CompilerCommand compilerCommand) {
        this(compilerCommand, false);
    }

    public abstract Infer newInfer();

    public abstract TreePrinter newTextTreePrinter(PrintWriter var1);

    public abstract TreePrinter newHTMLTreePrinter(PrintWriter var1);

    public Global(CompilerCommand compilerCommand, boolean bl) {
        OutputStream outputStream;
        if ($assertionsDisabled || !Debug.initialize()) {
            // empty if block
        }
        if (instance != null) {
            Debug.abort("duplicate creation of Global");
        }
        instance = this;
        this.args = compilerCommand;
        this.reporter = compilerCommand.reporter();
        this.start();
        this.noimports = compilerCommand.noimports.value;
        this.nopredefs = compilerCommand.nopredefs.value;
        this.debug = compilerCommand.debug.value;
        this.uniqid = compilerCommand.uniqid.value;
        this.newMatch = compilerCommand.Xnewmatch.value;
        this.xmlPreserveWS = compilerCommand.XpreserveWS.value;
        this.explaintypes = compilerCommand.explaintypes.value;
        this.printtypes = compilerCommand.types.value;
        this.printtokens = compilerCommand.print.tokens;
        this.classPath = compilerCommand.classpath();
        if (this.reporter.verbose) {
            this.reporter.inform("classpath = ".concat(String.valueOf(String.valueOf(this.classPath))));
        }
        this.outpath = compilerCommand.outpath();
        String string = compilerCommand.encoding.value;
        Charset charset = null;
        try {
            charset = Charset.forName(string);
        }
        catch (IllegalCharsetNameException illegalCharsetNameException) {
            compilerCommand.encoding.error(String.valueOf(String.valueOf("illegal charset name '".concat(String.valueOf(String.valueOf(string))))).concat("'"));
        }
        catch (UnsupportedCharsetException unsupportedCharsetException) {
            compilerCommand.encoding.error(String.valueOf(String.valueOf("unsupported charset '".concat(String.valueOf(String.valueOf(string))))).concat("'"));
        }
        if (charset == null) {
            string = "ISO-8859-1";
            charset = Charset.forName(string);
        }
        this.encoding = string;
        this.charset = charset;
        this.decoder = charset.newDecoder();
        this.reader = new SourceReader(this.decoder);
        this.target = bl ? TARGET_INT : compilerCommand.target.value.intern();
        this.separate = compilerCommand.separate.value.equals("yes") || compilerCommand.separate.value.equals("default") && !this.target.equals(TARGET_INT);
        this.uniqueID = new UniqueID();
        String string2 = compilerCommand.printfile.value;
        try {
            outputStream = "-".equals(string2) ? System.out : new FileOutputStream(string2);
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.error(String.valueOf(String.valueOf("unable to open file ".concat(String.valueOf(String.valueOf(string2))))).concat(". Printing on console"));
            outputStream = System.out;
        }
        this.writer = new PrintWriter(outputStream, this.debug);
        if (compilerCommand.printer.value.equals(PRINTER_HTML)) {
            this.treePrinter = this.newHTMLTreePrinter(this.writer);
        } else {
            if (!compilerCommand.printer.value.equals(PRINTER_TEXT)) {
                this.error("unknown printer kind: ".concat(String.valueOf(String.valueOf(compilerCommand.printer.value))));
            }
            this.treePrinter = this.newTextTreePrinter(this.writer);
        }
        this.make = new DefaultTreeFactory();
        this.PHASE = compilerCommand.phases;
        if (this.target != TARGET_MSIL) {
            compilerCommand.phases.GENMSIL.addSkipFlag();
        }
        if (this.target != TARGET_JVM) {
            compilerCommand.phases.GENJVM.addSkipFlag();
        }
        if (this.target != TARGET_JVMFROMICODE) {
            compilerCommand.phases.ICODE.addSkipFlag();
            compilerCommand.phases.GENJVMFROMICODE.addSkipFlag();
        }
        this.PHASE.freeze();
        PhaseDescriptor[] phaseDescriptorArray = this.PHASE.phases();
        for (int i = 0; i <= this.PHASE.ANALYZER.id(); ++i) {
            if (phaseDescriptorArray[i].hasSkipFlag()) continue;
            phaseDescriptorArray[i].create(this);
        }
        this.treeGen = ((AnalyzerPhase)this.PHASE.ANALYZER.phase()).gen;
        this.primitives = new Primitives(this);
        if (!$assertionsDisabled && phaseDescriptorArray[0].hasSkipFlag()) {
            throw new AssertionError();
        }
        for (int i = this.PHASE.ANALYZER.id() + 1; i < phaseDescriptorArray.length; ++i) {
            if (phaseDescriptorArray[i].hasSkipFlag()) continue;
            phaseDescriptorArray[i].create(this);
        }
        this.currentPhase = this.PHASE.INITIAL.phase();
    }

    public void nextPhase() {
        if (!$assertionsDisabled && this.currentPhase.next == null) {
            throw new AssertionError();
        }
        this.currentPhase = this.currentPhase.next;
    }

    public void prevPhase() {
        if (!$assertionsDisabled && this.currentPhase.prev == null) {
            throw new AssertionError();
        }
        this.currentPhase = this.currentPhase.prev;
    }

    public SourceFile getSourceFile(String string, String string2) {
        return new SourceFile(string, string2.toCharArray());
    }

    public SourceFile getSourceFile(String string) throws IOException {
        AbstractFile abstractFile = AbstractFile.getFile(string);
        if (abstractFile == null) {
            throw new FileNotFoundException(String.valueOf(String.valueOf("source file '".concat(String.valueOf(String.valueOf(string))))).concat("' could not be found"));
        }
        return this.getSourceFile(abstractFile);
    }

    public SourceFile getSourceFile(AbstractFile abstractFile) throws IOException {
        return new SourceFile(abstractFile, this.reader.read(abstractFile));
    }

    public SourceFile getSourceFile(Symbol symbol) throws IOException {
        if (!($assertionsDisabled || symbol.isClass() && symbol.isStatic())) {
            throw new AssertionError((Object)String.valueOf(String.valueOf(Debug.show(symbol))));
        }
        AbstractFile abstractFile = this.classPath.getRoot().lookupPath(SourceRepresentation.externalizeFileName(symbol, ".scala"), false);
        if (abstractFile == null) {
            throw new FileNotFoundException(String.valueOf(String.valueOf("source file for ".concat(String.valueOf(String.valueOf(symbol))))).concat(" could not be found"));
        }
        return this.getSourceFile(abstractFile);
    }

    public SymbolLoader getRootLoader() {
        return this.target == TARGET_MSIL ? new CLRPackageParser(this, this.classPath.getRoot()) : new PackageParser(this, this.classPath.getRoot());
    }

    public void compile(String[] stringArray, boolean bl) {
        this.reporter.resetCounters();
        ArrayList<CompilationUnit> arrayList = new ArrayList<CompilationUnit>(stringArray.length);
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                SourceFile sourceFile = this.getSourceFile(stringArray[i]);
                arrayList.add(new CompilationUnit(this, sourceFile, bl));
                this.compiledUnits.add(sourceFile);
                continue;
            }
            catch (IOException iOException) {
                this.error(iOException.getMessage());
            }
        }
        this.units = arrayList.toArray(new CompilationUnit[arrayList.size()]);
        this.compile();
    }

    public void compile(String string, String string2, boolean bl) {
        this.reporter.resetCounters();
        SourceFile sourceFile = this.getSourceFile(string, string2);
        this.compiledUnits.add(sourceFile);
        this.units = new CompilationUnit[]{new CompilationUnit(this, sourceFile, bl)};
        this.compile();
    }

    private void compile() {
        this.treePrinter.begin();
        this.currentPhase = this.PHASE.INITIAL.phase();
        while (this.currentPhase.next != null && this.reporter.errors() == 0) {
            this.currentPhase = this.currentPhase.next;
            this.start();
            this.currentPhase.apply(this.units);
            this.stop(this.currentPhase.descriptor.taskDescription());
            if (this.currentPhase.descriptor.hasPrintFlag()) {
                this.print();
            }
            if (this.currentPhase.descriptor.hasGraphFlag()) {
                this.currentPhase.graph(this);
            }
            if (this.currentPhase.descriptor.hasCheckFlag()) {
                this.currentPhase.check(this);
            }
            if (this.currentPhase == this.PHASE.PARSER.phase()) {
                this.fix1();
            }
            if (this.currentPhase != this.PHASE.ANALYZER.phase()) continue;
            this.fix2();
        }
        if (this.reporter.errors() != 0) {
            this.imports.clear();
            Iterator iterator = this.compiledNow.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                Symbol symbol = (Symbol)entry.getKey();
                AbstractFile abstractFile = ((SourceFile)entry.getValue()).getFile();
                symbol.reset(new SourceCompleter(this, abstractFile));
            }
        }
        this.symdata.clear();
        this.compiledNow.clear();
        this.treePrinter.end();
    }

    public void compileLate(SourceFile sourceFile, boolean bl) {
        if (!this.compiledUnits.contains(sourceFile)) {
            this.compiledUnits.add(sourceFile);
            CompilationUnit compilationUnit = new CompilationUnit(this, sourceFile, false, bl);
            Phase phase = this.currentPhase;
            this.currentPhase = this.PHASE.PARSER.phase();
            this.PHASE.PARSER.phase().apply(new CompilationUnit[]{compilationUnit});
            this.currentPhase = this.PHASE.ANALYZER.phase();
            ((AnalyzerPhase)this.PHASE.ANALYZER.phase()).lateEnter(compilationUnit);
            this.currentPhase = phase;
        }
    }

    private void print() {
        if (this.currentPhase.id == this.PHASE.MAKEBOXINGEXPLICIT.id()) {
            boolean bl;
            boolean bl2 = this.args.printer.value.equals(PRINTER_HTML);
            if (bl2) {
                this.writer.println("<pre>");
            }
            ATreePrinter aTreePrinter = new ATreePrinter(new CodePrinter(this.writer));
            boolean bl3 = bl = this.currentPhase.next != null;
            if (bl) {
                this.currentPhase = this.currentPhase.next;
            }
            aTreePrinter.printGlobal(this);
            if (bl) {
                this.currentPhase = this.currentPhase.prev;
            }
            if (bl2) {
                this.writer.println("</pre>");
            }
        } else if (this.currentPhase.id == this.PHASE.ICODE.id()) {
            boolean bl;
            boolean bl4 = this.args.printer.value.equals(PRINTER_HTML);
            if (bl4) {
                this.writer.println("<pre>");
            }
            ATreePrinter aTreePrinter = ((ICodePhase)this.currentPhase).getPrinter(new CodePrinter(this.writer));
            boolean bl5 = bl = this.currentPhase.next != null;
            if (bl) {
                this.currentPhase = this.currentPhase.next;
            }
            aTreePrinter.printGlobal(this);
            if (bl) {
                this.currentPhase = this.currentPhase.prev;
            }
            if (bl4) {
                this.writer.println("</pre>");
            }
        } else {
            boolean bl;
            boolean bl6 = bl = this.currentPhase.next != null;
            if (bl) {
                this.currentPhase = this.currentPhase.next;
            }
            this.treePrinter.print(this);
            if (bl) {
                this.currentPhase = this.currentPhase.prev;
            }
        }
    }

    private Symbol INTERPRETER() {
        if (this.INTERPRETER == null) {
            this.INTERPRETER = this.definitions.getModule("scala.runtime.InterpreterSupport");
        }
        return this.INTERPRETER;
    }

    private Symbol SHOW_DEFINITION() {
        if (this.SHOW_DEFINITION == null) {
            this.SHOW_DEFINITION = this.INTERPRETER().lookup(SHOW_DEFINITION_N);
        }
        return this.SHOW_DEFINITION;
    }

    private Symbol SHOW_VALUE_DEFINITION() {
        if (this.SHOW_VALUE_DEFINITION == null) {
            this.SHOW_VALUE_DEFINITION = this.INTERPRETER().lookup(SHOW_VALUE_DEFINITION_N);
        }
        return this.SHOW_VALUE_DEFINITION;
    }

    private Symbol SET_EVALUATION_RESULT() {
        if (this.SET_EVALUATION_RESULT == null) {
            this.SET_EVALUATION_RESULT = this.INTERPRETER().lookup(SET_EVALUATION_RESULT_N);
        }
        return this.SET_EVALUATION_RESULT;
    }

    private void fix1() {
        for (int i = 0; i < this.units.length; ++i) {
            if (!this.units[i].console) continue;
            this.fix1(this.units[i]);
        }
        this.nextPhase();
        for (int i = 0; i < this.imports.size(); ++i) {
            Symbol symbol = (Symbol)this.imports.get(i);
            ((AnalyzerPhase)this.PHASE.ANALYZER.phase()).addConsoleImport(symbol);
        }
        this.prevPhase();
    }

    private void fix1(CompilationUnit compilationUnit) {
        compilationUnit.body = new Tree[]{this.make.ModuleDef(Position.FIRSTPOS, 0, Name.fromString(CONSOLE_S.concat(String.valueOf(this.module))), Tree.Empty, this.make.Template(Position.FIRSTPOS, new Tree[]{this.make.Apply(Position.FIRSTPOS, this.make.Select(Position.FIRSTPOS, this.make.Ident(Position.FIRSTPOS, Names.scala), Names.AnyRef.toTypeName()), new Tree[0])}, compilationUnit.body))};
        ++this.module;
    }

    private void fix2() {
        for (int i = 0; i < this.units.length; ++i) {
            if (!this.units[i].console) continue;
            this.fix2(this.units[i]);
        }
    }

    private void fix2(CompilationUnit compilationUnit) {
        this.imports.clear();
        for (int i = 0; i < compilationUnit.body.length; ++i) {
            Tree tree = compilationUnit.body[i];
            if (tree.$tag != 22) continue;
            Tree.ModuleDef moduleDef = (Tree.ModuleDef)tree;
            Tree.Template template = moduleDef.impl;
            Symbol symbol = compilationUnit.body[i].symbol();
            if (!symbol.name.toString().startsWith(CONSOLE_S)) continue;
            this.console = symbol;
            if (template.body.length <= 0) continue;
            this.imports.add(compilationUnit.body[i].symbol());
            Tree tree2 = template.body[template.body.length - 1];
            if (tree2 != Tree.Empty && tree2.isTerm()) {
                template.body[template.body.length - 1] = this.treeGen.Apply(tree2.pos, this.treeGen.Select(tree2.pos, this.treeGen.mkGlobalRef(tree2.pos, this.INTERPRETER()), this.SET_EVALUATION_RESULT()), new Tree[]{tree2, this.treeGen.mkStringLit(tree2.pos, this.show(tree2.getType()))});
            }
            TreeList treeList = new TreeList();
            for (int j = 0; j < template.body.length; ++j) {
                this.fix2(treeList, template.body[j]);
            }
            template.body = treeList.toArray();
        }
    }

    private void fix2(TreeList treeList, Tree tree) {
        treeList.append(tree);
        switch (tree.$tag) {
            case 25: {
                if (!$assertionsDisabled) {
                    throw new AssertionError((Object)String.valueOf(String.valueOf(Debug.show(tree))));
                }
                return;
            }
            case 10: {
                if (!this.mustShow(tree.symbol())) {
                    return;
                }
                treeList.append(this.treeGen.Apply(tree.pos, this.treeGen.Select(tree.pos, this.treeGen.mkGlobalRef(tree.pos, this.INTERPRETER()), this.SHOW_DEFINITION()), new Tree[]{this.treeGen.mkStringLit(tree.pos, this.show(tree.symbol()))}));
                return;
            }
            case 24: {
                if (!this.mustShow(tree.symbol())) {
                    return;
                }
                treeList.append(this.treeGen.Apply(tree.pos, this.treeGen.Select(tree.pos, this.treeGen.mkGlobalRef(tree.pos, this.INTERPRETER()), this.SHOW_DEFINITION()), new Tree[]{this.treeGen.mkStringLit(tree.pos, this.show(tree.symbol()))}));
                return;
            }
            case 22: {
                if (!this.mustShow(tree.symbol())) {
                    return;
                }
                treeList.append(this.treeGen.Apply(tree.pos, this.treeGen.Select(tree.pos, this.treeGen.mkGlobalRef(tree.pos, this.INTERPRETER()), this.SHOW_DEFINITION()), new Tree[]{this.treeGen.mkStringLit(tree.pos, this.show(tree.symbol()))}));
                return;
            }
            case 13: {
                if (!this.mustShow(tree.symbol())) {
                    return;
                }
                treeList.append(this.treeGen.Apply(tree.pos, this.treeGen.Select(tree.pos, this.treeGen.mkGlobalRef(tree.pos, this.INTERPRETER()), this.SHOW_DEFINITION()), new Tree[]{this.treeGen.mkStringLit(tree.pos, this.show(tree.symbol()))}));
                return;
            }
            case 0: {
                if (!this.mustShow(tree.symbol())) {
                    return;
                }
                treeList.append(this.treeGen.Apply(tree.pos, this.treeGen.Select(tree.pos, this.treeGen.mkGlobalRef(tree.pos, this.INTERPRETER()), this.SHOW_DEFINITION()), new Tree[]{this.treeGen.mkStringLit(tree.pos, this.show(tree.symbol()))}));
                return;
            }
            case 1: {
                if (!this.mustShow(tree.symbol())) {
                    return;
                }
                treeList.append(this.treeGen.Apply(tree.pos, this.treeGen.Select(tree.pos, this.treeGen.mkGlobalRef(tree.pos, this.INTERPRETER()), this.SHOW_DEFINITION()), new Tree[]{this.treeGen.mkStringLit(tree.pos, this.show(tree.symbol()))}));
                return;
            }
            case 40: {
                if (!this.mustShow(tree.symbol())) {
                    return;
                }
                treeList.append(this.treeGen.Apply(tree.pos, this.treeGen.Select(tree.pos, this.treeGen.mkGlobalRef(tree.pos, this.INTERPRETER()), this.SHOW_VALUE_DEFINITION()), new Tree[]{this.treeGen.mkStringLit(tree.pos, this.show(tree.symbol())), this.treeGen.Ident(tree.pos, tree.symbol())}));
                return;
            }
        }
    }

    private boolean mustShow(Symbol symbol) {
        return !symbol.isAccessor();
    }

    private String show(Symbol symbol) {
        return new InterpreterPrinter().printSignature(symbol).toString();
    }

    private String show(Type type) {
        return new InterpreterPrinter().printType(type).toString();
    }

    public static Error fail() {
        throw new ApplicationError();
    }

    public static Error fail(String string) {
        throw new ApplicationError(string);
    }

    public static Error fail(String string, Object object) {
        throw new ApplicationError(string, object);
    }

    public static Error fail(Object object) {
        throw new ApplicationError(object);
    }

    public static Error fail(String string, Throwable throwable) {
        throw new ApplicationError(string, throwable);
    }

    public static Error fail(Throwable throwable) {
        throw new ApplicationError(throwable);
    }

    public void error(String string) {
        this.reporter.error(null, string);
    }

    public void warning(String string) {
        this.reporter.warning(null, string);
    }

    public void operation(String string) {
        this.reporter.inform(String.valueOf(String.valueOf("[".concat(String.valueOf(String.valueOf(string))))).concat("]"));
    }

    public boolean log(String string) {
        if (this.log()) {
            this.reporter.report(String.valueOf(String.valueOf(String.valueOf(String.valueOf("[log ".concat(String.valueOf(String.valueOf(this.currentPhase))))).concat("] "))).concat(String.valueOf(String.valueOf(string))));
        }
        return true;
    }

    public boolean log() {
        return this.currentPhase.descriptor.hasLogFlag();
    }

    public void start() {
        this.startTimes.push(new Long(System.currentTimeMillis()));
    }

    public void stop(String string) {
        long l = (Long)this.startTimes.pop();
        this.reporter.inform(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf("[".concat(String.valueOf(String.valueOf(string))))).concat(" in "))).concat(String.valueOf(System.currentTimeMillis() - l)))).concat("ms]"));
    }

    static {
        $assertionsDisabled = !Class.forName("scalac.Global").desiredAssertionStatus();
        String[] stringArray = new String[4];
        TARGET_INT = "int";
        stringArray[0] = "int";
        TARGET_JVM = "jvm";
        stringArray[1] = "jvm";
        TARGET_MSIL = "msil";
        stringArray[2] = "msil";
        TARGET_JVMFROMICODE = "jvmfromicode";
        stringArray[3] = "jvmfromicode";
        TARGETS = stringArray;
        String[] stringArray2 = new String[2];
        PRINTER_TEXT = "text";
        stringArray2[0] = "text";
        PRINTER_HTML = "html";
        stringArray2[1] = "html";
        PRINTERS = stringArray2;
        SHOW_DEFINITION_N = Name.fromString("showDefinition");
        SHOW_VALUE_DEFINITION_N = Name.fromString("showValueDefinition");
        SET_EVALUATION_RESULT_N = Name.fromString("setEvaluationResult");
    }

    private class InterpreterPrinter
    extends SymbolTablePrinter {
        public InterpreterPrinter() {
            super("  ");
        }

        public String getSymbolName(Symbol symbol) {
            int n;
            String string = super.getSymbolName(symbol);
            if (!Global.this.debug && (n = string.indexOf(36)) > 0) {
                string = string.substring(0, n);
            }
            return string;
        }
    }
}

