/*
 * Decompiled with CFR 0.152.
 */
package scala.tools.scalai;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.Map;
import scalac.symtab.Definitions;
import scalac.symtab.Symbol;
import scalac.symtab.Type;
import scalac.util.Debug;

public class JavaMirror {
    private static final Class void_class;
    private static final Class boolean_class;
    private static final Class byte_class;
    private static final Class short_class;
    private static final Class char_class;
    private static final Class int_class;
    private static final Class long_class;
    private static final Class float_class;
    private static final Class double_class;
    private static final Class Object_class;
    private final ClassLoader loader;
    private final Map arrays;
    private final Map classes;
    private final Map fields;
    private final Map methods;
    private final Map constructors;
    private static final /* synthetic */ boolean $assertionsDisabled;

    public JavaMirror(Definitions definitions, ClassLoader classLoader) {
        this.loader = classLoader;
        this.arrays = new HashMap();
        this.classes = new HashMap();
        this.fields = new HashMap();
        this.methods = new HashMap();
        this.constructors = new HashMap();
        this.classes.put(definitions.ANY_CLASS, Object_class);
        this.classes.put(definitions.ANYREF_CLASS, Object_class);
    }

    public Class getArray(Class clazz) {
        Object v;
        if (Proxy.isProxyClass(clazz)) {
            clazz = Object_class;
        }
        if ((v = this.arrays.get(clazz)) != null) {
            return (Class)v;
        }
        Class clazz2 = this.getArray0(clazz);
        this.arrays.put(clazz, clazz2);
        return clazz2;
    }

    private Class getArray0(Class clazz) {
        String string = "[".concat(String.valueOf(String.valueOf(this.getArrayComponentName(clazz))));
        try {
            return Class.forName(string, false, this.loader);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw Debug.abort("no such class", string);
        }
    }

    private String getArrayComponentName(Class clazz) {
        if (clazz.isPrimitive()) {
            if (clazz == boolean_class) {
                return "Z";
            }
            if (clazz == byte_class) {
                return "B";
            }
            if (clazz == short_class) {
                return "S";
            }
            if (clazz == char_class) {
                return "C";
            }
            if (clazz == int_class) {
                return "I";
            }
            if (clazz == long_class) {
                return "J";
            }
            if (clazz == float_class) {
                return "F";
            }
            if (clazz == double_class) {
                return "D";
            }
            throw Debug.abort("unknown primitive class", clazz);
        }
        String string = clazz.getName();
        return clazz.isArray() ? string : String.valueOf(String.valueOf("L".concat(String.valueOf(String.valueOf(string))))).concat(";");
    }

    public Class getClass(Type type) {
        switch (type.$tag) {
            case 11: {
                Type.UnboxedType unboxedType = (Type.UnboxedType)type;
                int n = unboxedType.tag;
                return this.getClass(n);
            }
            case 10: {
                Type.UnboxedArrayType unboxedArrayType = (Type.UnboxedArrayType)type;
                Type type2 = unboxedArrayType.elemtp;
                return this.getArray(this.getClass(type2));
            }
            case 8: {
                Type.TypeRef typeRef = (Type.TypeRef)type;
                Symbol symbol = typeRef.sym;
                return this.getClass(symbol);
            }
        }
        throw Debug.abort("illegal type", type);
    }

    public Class getClass(int n) {
        switch (n) {
            case 18: {
                return void_class;
            }
            case 17: {
                return boolean_class;
            }
            case 10: {
                return byte_class;
            }
            case 12: {
                return short_class;
            }
            case 11: {
                return char_class;
            }
            case 13: {
                return int_class;
            }
            case 14: {
                return long_class;
            }
            case 15: {
                return float_class;
            }
            case 16: {
                return double_class;
            }
        }
        throw Debug.abort("kind = ".concat(String.valueOf(n)));
    }

    public Class getClass(Symbol symbol) {
        Object v = this.classes.get(symbol);
        if (v != null) {
            return (Class)v;
        }
        Class clazz = this.getClass0(symbol);
        if (!$assertionsDisabled && !Debug.log("java mirror: ", symbol, " -> ", clazz)) {
            throw new AssertionError();
        }
        this.classes.put(symbol, clazz);
        return clazz;
    }

    private Class getClass0(Symbol symbol) {
        String string = this.getClassName(symbol, false);
        try {
            return Class.forName(string, false, this.loader);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw Debug.abort("no such class", Debug.show(symbol, string));
        }
    }

    private String getClassName(Symbol symbol, boolean bl) {
        if (!$assertionsDisabled && symbol.kind != 3) {
            throw new AssertionError((Object)String.valueOf(String.valueOf(Debug.show(symbol))));
        }
        String string = String.valueOf(String.valueOf(this.getPrefix(symbol.owner()))).concat(String.valueOf(String.valueOf(symbol.name)));
        if (!bl && !symbol.isJava() && symbol.isModuleClass()) {
            string = String.valueOf(String.valueOf(string)).concat(String.valueOf('$'));
        }
        return string;
    }

    private String getPrefix(Symbol symbol) {
        if (!$assertionsDisabled && symbol.kind != 3) {
            throw new AssertionError((Object)String.valueOf(String.valueOf(Debug.show(symbol))));
        }
        if (symbol.isRoot()) {
            return "";
        }
        String string = this.getClassName(symbol, true);
        return String.valueOf(String.valueOf(string)).concat(String.valueOf(symbol.isClass() ? (char)'$' : '.'));
    }

    public Field getField(Symbol symbol) {
        Object v = this.fields.get(symbol);
        if (v != null) {
            return (Field)v;
        }
        Field field = this.getField0(symbol);
        if (!$assertionsDisabled && !Debug.log("java mirror: ", symbol, " -> ", field)) {
            throw new AssertionError();
        }
        this.fields.put(symbol, field);
        return field;
    }

    private Field getField0(Symbol symbol) {
        if (symbol.isModule()) {
            if (!$assertionsDisabled && symbol.isJava()) {
                throw new AssertionError((Object)String.valueOf(String.valueOf(Debug.show(symbol))));
            }
            Class clazz = this.getClass0(symbol.moduleClass());
            return this.getField0(symbol, clazz, "MODULE$");
        }
        Class clazz = this.getClass(symbol.owner());
        return this.getField0(symbol, clazz, symbol.name.toString());
    }

    private Field getField0(Symbol symbol, Class clazz, String string) {
        try {
            return clazz.getField(string);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            throw Debug.abort("no such field", symbol);
        }
    }

    public Method getMethod(Symbol symbol) {
        Object v = this.methods.get(symbol);
        if (v != null) {
            return (Method)v;
        }
        Method method = this.getMethod0(symbol);
        if (!$assertionsDisabled && !Debug.log("java mirror: ", symbol, " -> ", method)) {
            throw new AssertionError();
        }
        this.methods.put(symbol, method);
        return method;
    }

    private Method getMethod0(Symbol symbol) {
        Class clazz = this.getClass(symbol.owner());
        Class[] classArray = this.getVParamsOf(symbol.type());
        try {
            return clazz.getMethod(symbol.name.toString(), classArray);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw Debug.abort("no such method", symbol);
        }
    }

    public Constructor getConstructor(Symbol symbol) {
        Object v = this.constructors.get(symbol);
        if (v != null) {
            return (Constructor)v;
        }
        Constructor constructor = this.getConstructor0(symbol);
        if (!$assertionsDisabled && !Debug.log("java mirror: ", symbol, " -> ", constructor)) {
            throw new AssertionError();
        }
        this.constructors.put(symbol, constructor);
        return constructor;
    }

    private Constructor getConstructor0(Symbol symbol) {
        Class clazz = this.getClass(symbol.owner());
        Class[] classArray = this.getVParamsOf(symbol.type());
        try {
            return clazz.getConstructor(classArray);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw Debug.abort("no such constructor", symbol);
        }
    }

    public Class[] getVParamsOf(Symbol symbol) {
        return this.getVParamsOf(symbol.type());
    }

    public Class[] getVParamsOf(Type type) {
        if (type.$tag == 3) {
            Type.MethodType methodType = (Type.MethodType)type;
            Symbol[] symbolArray = methodType.vparams;
            return this.getVParams(symbolArray);
        }
        throw Debug.abort("illegal type", type);
    }

    public Class[] getVParams(Symbol[] symbolArray) {
        Class[] classArray = new Class[symbolArray.length];
        for (int i = 0; i < classArray.length; ++i) {
            classArray[i] = this.getClass(symbolArray[i].type());
        }
        return classArray;
    }

    static {
        $assertionsDisabled = !Class.forName("scala.tools.scalai.JavaMirror").desiredAssertionStatus();
        void_class = Void.TYPE;
        boolean_class = Boolean.TYPE;
        byte_class = Byte.TYPE;
        short_class = Short.TYPE;
        char_class = Character.TYPE;
        int_class = Integer.TYPE;
        long_class = Long.TYPE;
        float_class = Float.TYPE;
        double_class = Double.TYPE;
        Object_class = Class.forName("java.lang.Object");
    }
}

