/*
 * Decompiled with CFR 0.152.
 */
package scala.tools.scaladoc;

import ch.epfl.lamp.util.CodePrinter;
import scalac.Global;
import scalac.atree.AConstant;
import scalac.symtab.Symbol;
import scalac.symtab.SymbolTablePrinter;
import scalac.symtab.Type;

public abstract class MySymbolTablePrinter
extends SymbolTablePrinter {
    protected final Global global = Global.instance;

    public MySymbolTablePrinter(CodePrinter codePrinter) {
        super(codePrinter);
    }

    public abstract void printSymbol(Symbol var1, boolean var2);

    public SymbolTablePrinter printSymbolName(Symbol symbol) {
        this.printSymbol(symbol, true);
        this.printSymbolUniqueId(symbol);
        return this;
    }

    public SymbolTablePrinter printDefinedSymbolName(Symbol symbol, boolean bl) {
        this.printSymbol(symbol, bl);
        this.printSymbolUniqueId(symbol);
        return this;
    }

    public SymbolTablePrinter printSeqType(Symbol symbol, Type type, String string) {
        Type type2 = type;
        boolean bl = false;
        if ((symbol.flags & 0x200) != 0 && type2.symbol() == this.global.definitions.SEQ_CLASS && type2.typeArgs().length == 1) {
            type2 = type2.typeArgs()[0];
            bl = true;
        }
        this.printType(type2, string);
        if (bl) {
            this.print("*");
        }
        return this;
    }

    public void defString(Symbol symbol, boolean bl) {
        if (symbol.isRoot()) {
            this.print("Root class");
        } else if (symbol.isClass() || symbol.isModule()) {
            this.printTemplateSignature(symbol, bl);
        } else if (symbol.isType() && !symbol.isParameter()) {
            this.printShortSignature(symbol, bl);
        } else {
            this.printSignature(symbol, bl);
        }
    }

    public SymbolTablePrinter printSignature(Symbol symbol) {
        return this.printSignature(symbol, false);
    }

    public SymbolTablePrinter printSignature(Symbol symbol, boolean bl) {
        return this.printShortSignature(symbol, bl).printSymbolType(symbol, this.getSymbolInnerString(symbol));
    }

    public SymbolTablePrinter printValueParams(Symbol[] symbolArray) {
        this.print('(');
        for (int i = 0; i < symbolArray.length; ++i) {
            if (i > 0) {
                this.print(", ");
            }
            if (symbolArray[i].isDefParameter()) {
                this.print("def ");
            }
            this.defString(symbolArray[i], false);
        }
        return this.print(')');
    }

    public String getSymbolKeywordForDoc(Symbol symbol) {
        String string = this.getSymbolKeyword(symbol);
        if (symbol.isInitializedMethod() && symbol.hasStableFlag()) {
            string = "val";
        }
        return string;
    }

    public SymbolTablePrinter printShortSignature(Symbol symbol, boolean bl) {
        String string = this.getSymbolKeywordForDoc(symbol);
        if (string != null) {
            this.print(string).space();
        }
        if (symbol.variance() > 0) {
            this.print("+");
        } else if (symbol.variance() < 0) {
            this.print("-");
        }
        this.printSymbol(symbol, bl);
        return this.printType(symbol.loBound(), ">:");
    }

    public SymbolTablePrinter printTemplateSignature(Symbol symbol, boolean bl) {
        String string = this.getSymbolKeywordForDoc(symbol);
        if (string != null) {
            this.print(string).space();
        }
        this.getSymbolInnerString(symbol);
        this.printDefinedSymbolName(symbol, bl);
        if (symbol.isClass()) {
            Symbol[] symbolArray = symbol.typeParams();
            if (symbolArray.length != 0 || this.global.debug) {
                this.printTypeParams(symbolArray);
            }
            Symbol[] symbolArray2 = symbol.valueParams();
            this.printValueParams(symbolArray2);
        }
        return this;
    }

    public SymbolTablePrinter printConstantValue(AConstant aConstant) {
        return this;
    }
}

