/*
 * Decompiled with CFR 0.152.
 */
package scalac.transformer;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import scalac.CompilationUnit;
import scalac.Global;
import scalac.Phase;
import scalac.PhaseDescriptor;
import scalac.ast.GenTransformer;
import scalac.ast.Tree;
import scalac.ast.TreeList;
import scalac.backend.Primitives;
import scalac.symtab.Definitions;
import scalac.symtab.Scope;
import scalac.symtab.Symbol;
import scalac.symtab.Type;
import scalac.util.Debug;
import scalac.util.Name;
import scalac.util.Names;

public class TypesAsValuesPhase
extends Phase {
    private final TV_Transformer transformer;
    private final HashMap membersToAdd = new HashMap();
    private final HashMap paramsToAdd = new HashMap();
    private final HashMap typeAccessor = new HashMap();
    private final HashMap instantiator = new HashMap();
    private final HashMap classInitialiser = new HashMap();
    private final HashMap tConstructor = new HashMap();
    private final Definitions defs;
    private final Primitives prims;
    private final Type.MethodType typeAccessorType;
    private final Symbol ARRAY_CONSTRUCTOR;
    private final TEnv EENV;
    private final Map predefTypes;
    private HashMap displayCache;
    private static final /* synthetic */ boolean $assertionsDisabled;

    public TypesAsValuesPhase(Global global, PhaseDescriptor phaseDescriptor) {
        super(global, phaseDescriptor);
        this.defs = this.global.definitions;
        this.prims = this.global.primitives;
        this.typeAccessorType = new Type.MethodType(new Symbol[0], this.defs.TYPE_TYPE());
        this.ARRAY_CONSTRUCTOR = this.defs.ARRAY_CLASS.primaryConstructor();
        this.EENV = new TEnv();
        this.displayCache = new HashMap();
        this.transformer = new TV_Transformer(global);
        this.predefTypes = new HashMap();
        this.predefTypes.put(this.defs.DOUBLE_CLASS, this.defs.RTT_DOUBLE());
        this.predefTypes.put(this.defs.FLOAT_CLASS, this.defs.RTT_FLOAT());
        this.predefTypes.put(this.defs.LONG_CLASS, this.defs.RTT_LONG());
        this.predefTypes.put(this.defs.INT_CLASS, this.defs.RTT_INT());
        this.predefTypes.put(this.defs.SHORT_CLASS, this.defs.RTT_SHORT());
        this.predefTypes.put(this.defs.CHAR_CLASS, this.defs.RTT_CHAR());
        this.predefTypes.put(this.defs.BYTE_CLASS, this.defs.RTT_BYTE());
        this.predefTypes.put(this.defs.BOOLEAN_CLASS, this.defs.RTT_BOOLEAN());
        this.predefTypes.put(this.defs.UNIT_CLASS, this.defs.RTT_UNIT());
        this.predefTypes.put(this.defs.ANY_CLASS, this.defs.RTT_ANY());
        this.predefTypes.put(this.defs.ANYVAL_CLASS, this.defs.RTT_ANYVAL());
        this.predefTypes.put(this.defs.ALLREF_CLASS, this.defs.RTT_ALLREF());
        this.predefTypes.put(this.defs.ALL_CLASS, this.defs.RTT_ALL());
        this.membersToAdd.put(this.defs.ARRAY_CLASS, new NewMember[0]);
        this.paramsToAdd.put(this.ARRAY_CONSTRUCTOR, new Symbol[0]);
        this.displayCache.put(this.defs.OBJECT_CLASS, new Ancestor[][]{{new Ancestor(this.defs.OBJECT_CLASS, -1, -1)}});
    }

    private Symbol getAccessorSym(Symbol symbol) {
        if (!$assertionsDisabled && !symbol.isType()) {
            throw new AssertionError();
        }
        Symbol symbol2 = (Symbol)this.typeAccessor.get(symbol);
        if (symbol2 == null) {
            symbol2 = symbol.owner().newVariable(symbol.pos, symbol.flags, Names.TYPE(symbol));
            symbol2.setInfo(this.defs.TYPE_TYPE());
            this.typeAccessor.put(symbol, symbol2);
        }
        return symbol2;
    }

    private Symbol getInstMethSym(Symbol symbol) {
        Symbol symbol2 = (Symbol)this.instantiator.get(symbol);
        if (symbol2 == null) {
            int n = symbol.pos;
            boolean bl = !this.isNestedClass(symbol);
            Name name = Names.INSTANTIATE(symbol, bl);
            int n2 = symbol.isAbstractType() ? 1 : 0;
            symbol2 = bl ? symbol.newStaticMethod(n, 0, name) : symbol.owner().newMethod(n, n2, name);
            Symbol symbol3 = symbol2.newVParam(n, 0, Name.fromString("types"));
            symbol3.setInfo(this.defs.ARRAY_TYPE(this.defs.TYPE_TYPE()));
            Symbol[] symbolArray = new Symbol[]{symbol3};
            symbol2.setInfo(new Type.MethodType(symbolArray, bl ? this.defs.SCALACLASSTYPE_TYPE() : this.defs.TYPE_TYPE()));
            this.instantiator.put(symbol, symbol2);
        }
        return symbol2;
    }

    private Symbol getTConstructorSym(Symbol symbol) {
        Symbol symbol2 = (Symbol)this.tConstructor.get(symbol);
        if (symbol2 == null) {
            int n = symbol.pos;
            boolean bl = !this.isNestedClass(symbol);
            Name name = Names.TYPECONSTRUCTOR(symbol, bl);
            symbol2 = bl ? symbol.newStaticField(n, 0, name) : symbol.owner().newField(n, 0, name);
            symbol2.setInfo(this.defs.TYPECONSTRUCTOR_TYPE());
            this.tConstructor.put(symbol, symbol2);
        }
        return symbol2;
    }

    private Symbol getClassInitSym(Symbol symbol) {
        Symbol symbol2 = (Symbol)this.classInitialiser.get(symbol);
        if (symbol2 == null) {
            int n = symbol.pos;
            symbol2 = symbol.newStaticMethod(n, 0, Names.CLASS_CONSTRUCTOR);
            symbol2.setInfo(new Type.MethodType(Symbol.EMPTY_ARRAY, this.defs.UNIT_TYPE()));
            this.classInitialiser.put(symbol, symbol2);
        }
        return symbol2;
    }

    private NewMember[] membersToAdd(Symbol symbol) {
        NewMember[] newMemberArray = (NewMember[])this.membersToAdd.get(symbol);
        if (newMemberArray == null) {
            Symbol symbol2;
            Symbol symbol3;
            Symbol symbol4;
            HashSet<Symbol> hashSet = new HashSet<Symbol>();
            ArrayList<NewMember> arrayList = new ArrayList<NewMember>();
            Scope.SymbolIterator symbolIterator = symbol.members().iterator();
            while (symbolIterator.hasNext()) {
                symbol4 = symbolIterator.next();
                if (symbol4.isModule()) {
                    symbol4 = symbol4.moduleClass();
                }
                if (!hashSet.add(symbol4)) continue;
                if (symbol4.isClass()) {
                    symbol3 = this.getTConstructorSym(symbol4);
                    arrayList.add(NewMember.TypeConstructor(symbol4, symbol3));
                    symbol2 = this.getInstMethSym(symbol4);
                    arrayList.add(NewMember.Instantiator(symbol4, symbol2));
                    continue;
                }
                if (!symbol4.isType()) continue;
                symbol3 = this.getInstMethSym(symbol4);
                arrayList.add(NewMember.TypeAccessor(symbol4, symbol3));
            }
            if (!this.isNestedClass(symbol)) {
                symbol4 = this.getTConstructorSym(symbol);
                arrayList.add(NewMember.TypeConstructor(symbol, symbol4));
                symbol3 = this.getClassInitSym(symbol);
                arrayList.add(NewMember.ClassInitialiser(symbol, symbol3, symbol4));
                symbol2 = this.getInstMethSym(symbol);
                arrayList.add(NewMember.Instantiator(symbol, symbol2));
            }
            newMemberArray = arrayList.toArray(new NewMember[arrayList.size()]);
            this.membersToAdd.put(symbol, newMemberArray);
        }
        return newMemberArray;
    }

    private Symbol[] paramsToAdd(Symbol symbol) {
        Symbol[] symbolArray = (Symbol[])this.paramsToAdd.get(symbol);
        if (symbolArray == null) {
            Symbol[] symbolArray2 = symbol.typeParams();
            ArrayList<Symbol> arrayList = new ArrayList<Symbol>();
            for (int i = 0; i < symbolArray2.length; ++i) {
                arrayList.add(this.getAccessorSym(symbolArray2[i]));
            }
            symbolArray = arrayList.toArray(new Symbol[arrayList.size()]);
            this.paramsToAdd.put(symbol, symbolArray);
        }
        return symbolArray;
    }

    private boolean monoPrimitive(Symbol symbol) {
        return symbol.isJava() || symbol == this.ARRAY_CONSTRUCTOR || symbol == this.defs.OBJECT_SYNCHRONIZED || symbol == this.defs.ANY_IS || symbol == this.defs.ANY_AS;
    }

    public Type transformInfo(Symbol symbol, Type type) {
        if (symbol.isClass()) {
            NewMember[] newMemberArray = this.membersToAdd(symbol);
            if (newMemberArray.length == 0) {
                return type;
            }
            Scope scope = new Scope(symbol.members());
            for (int i = 0; i < newMemberArray.length; ++i) {
                scope.enterOrOverload(newMemberArray[i].symbolToAdd());
            }
            return Type.compoundType(type.parents(), scope, symbol);
        }
        if (type.typeParams().length > 0 && !this.monoPrimitive(symbol)) {
            if (type.$tag == 5) {
                Type.PolyType polyType = (Type.PolyType)type;
                if (polyType.result.$tag == 3) {
                    Type.MethodType methodType = (Type.MethodType)polyType.result;
                    Symbol[] symbolArray = polyType.tparams;
                    Symbol[] symbolArray2 = methodType.vparams;
                    Type type2 = methodType.result;
                    LinkedList<Symbol> linkedList = new LinkedList<Symbol>(Arrays.asList(this.paramsToAdd(symbol)));
                    linkedList.addAll(Arrays.asList(symbolArray2));
                    Symbol[] symbolArray3 = linkedList.toArray(new Symbol[linkedList.size()]);
                    return new Type.PolyType(symbolArray, new Type.MethodType(symbolArray3, type2));
                }
            }
            throw Debug.abort("unexpected type: ", type);
        }
        return type;
    }

    private boolean isNestedClass(Symbol symbol) {
        return !symbol.owner().isPackageClass();
    }

    public void apply(CompilationUnit compilationUnit) {
        this.transformer.apply(compilationUnit);
    }

    private void debugPrintDisplay(Symbol symbol, Ancestor[][] ancestorArray) {
        System.out.println("display for ".concat(String.valueOf(String.valueOf(Debug.show(symbol)))));
        for (int i = 0; i < ancestorArray.length; ++i) {
            System.out.print(String.valueOf(String.valueOf("  [".concat(String.valueOf(i)))).concat("] "));
            for (int j = 0; j < ancestorArray[i].length; ++j) {
                if (j > 0) {
                    System.out.print("      ");
                }
                System.out.println(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(" ".concat(String.valueOf(String.valueOf(Debug.show(ancestorArray[i][j].symbol)))))).concat("/par"))).concat(String.valueOf(ancestorArray[i][j].parentIndex)))).concat("/pos"))).concat(String.valueOf(ancestorArray[i][j].position)));
            }
        }
    }

    final /* synthetic */ boolean access$39(Symbol symbol) {
        return this.isNestedClass(symbol);
    }

    final /* synthetic */ boolean access$37(Symbol symbol) {
        return this.monoPrimitive(symbol);
    }

    final /* synthetic */ NewMember[] access$33(Symbol symbol) {
        return this.membersToAdd(symbol);
    }

    final /* synthetic */ Symbol access$40(Symbol symbol) {
        return this.getTConstructorSym(symbol);
    }

    final /* synthetic */ Symbol access$43(Symbol symbol) {
        return this.getInstMethSym(symbol);
    }

    final /* synthetic */ Symbol access$42(Symbol symbol) {
        return this.getAccessorSym(symbol);
    }

    final /* synthetic */ HashMap access$44() {
        return this.displayCache;
    }

    final /* synthetic */ Map access$41() {
        return this.predefTypes;
    }

    final /* synthetic */ TEnv access$34() {
        return this.EENV;
    }

    final /* synthetic */ Symbol access$36() {
        return this.ARRAY_CONSTRUCTOR;
    }

    final /* synthetic */ Primitives access$38() {
        return this.prims;
    }

    final /* synthetic */ Definitions access$35() {
        return this.defs;
    }

    static {
        $assertionsDisabled = !Class.forName("scalac.transformer.TypesAsValuesPhase").desiredAssertionStatus();
    }

    private static class Ancestor {
        public static final Ancestor[] EMPTY_ARRAY = new Ancestor[0];
        public final Symbol symbol;
        public final int parentIndex;
        public final int position;

        public Ancestor(Symbol symbol, int n, int n2) {
            this.symbol = symbol;
            this.parentIndex = n;
            this.position = n2;
        }
    }

    private static class NewMember {
        public static /* synthetic */ NewMember[] $extensions;
        public static /* synthetic */ int $subIDs;
        public static /* synthetic */ boolean[] $castable;
        public static final /* synthetic */ int $subID;
        public final /* synthetic */ int $tag;

        public static /* synthetic */ int $register(NewMember newMember) {
            if ($subIDs == $extensions.length) {
                NewMember[] newMemberArray = new NewMember[$extensions.length * 2];
                System.arraycopy($extensions, 0, newMemberArray, 0, $extensions.length);
                $extensions = newMemberArray;
                for (int i = 0; i < $subIDs; ++i) {
                    $extensions[i].$extend();
                }
            }
            NewMember.$extensions[NewMember.$subIDs] = newMember;
            return $subIDs++;
        }

        public static /* synthetic */ NewMember throw$cast$exception() {
            throw new ClassCastException();
        }

        public /* synthetic */ void $extend() {
            boolean[] blArray = new boolean[$castable.length * 2];
            System.arraycopy($castable, 0, blArray, 0, $castable.length);
            $castable = blArray;
        }

        public /* synthetic */ int $getSubID() {
            return $subID;
        }

        protected /* synthetic */ NewMember(int n) {
            this.$tag = n;
        }

        public Symbol symbolToAdd() {
            switch (this.$tag) {
                case 2: {
                    TypeAccessor typeAccessor = (TypeAccessor)this;
                    Symbol symbol = typeAccessor.accSym;
                    return symbol;
                }
                case 3: {
                    TypeConstructor typeConstructor = (TypeConstructor)this;
                    Symbol symbol = typeConstructor.tcSym;
                    return symbol;
                }
                case 1: {
                    Instantiator instantiator = (Instantiator)this;
                    Symbol symbol = instantiator.insSym;
                    return symbol;
                }
                case 0: {
                    ClassInitialiser classInitialiser = (ClassInitialiser)this;
                    Symbol symbol = classInitialiser.ciSym;
                    return symbol;
                }
            }
            throw Debug.abort("unexpected case");
        }

        public static /* synthetic */ ClassInitialiser ClassInitialiser(Symbol symbol, Symbol symbol2, Symbol symbol3) {
            return new ClassInitialiser(symbol, symbol2, symbol3);
        }

        public static /* synthetic */ Instantiator Instantiator(Symbol symbol, Symbol symbol2) {
            return new Instantiator(symbol, symbol2);
        }

        public static /* synthetic */ TypeAccessor TypeAccessor(Symbol symbol, Symbol symbol2) {
            return new TypeAccessor(symbol, symbol2);
        }

        public static /* synthetic */ TypeConstructor TypeConstructor(Symbol symbol, Symbol symbol2) {
            return new TypeConstructor(symbol, symbol2);
        }

        static {
            $extensions = new NewMember[]{null, null, null, null};
            $castable = new boolean[]{true, false, false, false};
            $subID = NewMember.$register(new NewMember(-1));
        }

        public static class ClassInitialiser
        extends NewMember {
            public /* synthetic */ Symbol memSym;
            public /* synthetic */ Symbol ciSym;
            public /* synthetic */ Symbol tcSym;

            protected /* synthetic */ ClassInitialiser() {
                super(0);
            }

            public /* synthetic */ ClassInitialiser(Symbol symbol, Symbol symbol2, Symbol symbol3) {
                super(0);
                this.memSym = symbol;
                this.ciSym = symbol2;
                this.tcSym = symbol3;
            }
        }

        public static class Instantiator
        extends NewMember {
            public /* synthetic */ Symbol memSym;
            public /* synthetic */ Symbol insSym;

            protected /* synthetic */ Instantiator() {
                super(1);
            }

            public /* synthetic */ Instantiator(Symbol symbol, Symbol symbol2) {
                super(1);
                this.memSym = symbol;
                this.insSym = symbol2;
            }
        }

        public static class TypeConstructor
        extends NewMember {
            public /* synthetic */ Symbol memSym;
            public /* synthetic */ Symbol tcSym;

            protected /* synthetic */ TypeConstructor() {
                super(3);
            }

            public /* synthetic */ TypeConstructor(Symbol symbol, Symbol symbol2) {
                super(3);
                this.memSym = symbol;
                this.tcSym = symbol2;
            }
        }

        public static class TypeAccessor
        extends NewMember {
            public /* synthetic */ Symbol memSym;
            public /* synthetic */ Symbol accSym;

            protected /* synthetic */ TypeAccessor() {
                super(2);
            }

            public /* synthetic */ TypeAccessor(Symbol symbol, Symbol symbol2) {
                super(2);
                this.memSym = symbol;
                this.accSym = symbol2;
            }
        }
    }

    private class TV_Transformer
    extends GenTransformer {
        private Symbol currentOwner;
        private final int VARIANT = -1073741824;
        private static final /* synthetic */ boolean $assertionsDisabled;

        public TV_Transformer(Global global) {
            super(global);
        }

        public Tree transform(Tree tree) {
            switch (tree.$tag) {
                case 10: {
                    Object object;
                    Tree.ClassDef classDef = (Tree.ClassDef)tree;
                    Tree.Template template = classDef.impl;
                    Symbol symbol = tree.symbol();
                    TreeList treeList = new TreeList();
                    NewMember[] newMemberArray = TypesAsValuesPhase.this.access$33(symbol);
                    block13: for (int i = 0; i < newMemberArray.length; ++i) {
                        object = newMemberArray[i];
                        switch (((NewMember)object).$tag) {
                            case 2: {
                                NewMember newMember = (NewMember.TypeAccessor)object;
                                Symbol symbol2 = newMember.memSym;
                                Symbol symbol3 = newMember.accSym;
                                treeList.append(this.typeAccessorBody(symbol2, symbol3));
                                continue block13;
                            }
                            case 3: {
                                NewMember newMember = (NewMember.TypeConstructor)object;
                                Symbol symbol2 = ((NewMember.TypeConstructor)newMember).memSym;
                                Symbol symbol3 = ((NewMember.TypeConstructor)newMember).tcSym;
                                treeList.append(this.tConstructorVal(symbol2, symbol3));
                                continue block13;
                            }
                            case 1: {
                                NewMember newMember = (NewMember.Instantiator)object;
                                Symbol symbol2 = ((NewMember.Instantiator)newMember).memSym;
                                Symbol symbol3 = ((NewMember.Instantiator)newMember).insSym;
                                treeList.append(this.instantiatorBody(symbol2, symbol3));
                                continue block13;
                            }
                            case 0: {
                                NewMember newMember = (NewMember.ClassInitialiser)object;
                                Symbol symbol2 = ((NewMember.ClassInitialiser)newMember).memSym;
                                Symbol symbol3 = ((NewMember.ClassInitialiser)newMember).ciSym;
                                Symbol symbol4 = ((NewMember.ClassInitialiser)newMember).tcSym;
                                treeList.append(this.classInitialiser(symbol2, symbol3, symbol4));
                                continue block13;
                            }
                        }
                    }
                    treeList.append(this.transform(template.body, template.symbol()));
                    object = symbol.primaryConstructor();
                    return this.gen.ClassDef(symbol, this.transform(template.parents, (Symbol)object), template.symbol(), treeList.toArray());
                }
                case 13: {
                    Tree.DefDef defDef = (Tree.DefDef)tree;
                    Tree tree2 = defDef.rhs;
                    Symbol symbol = this.getSymbolFor(tree);
                    if (symbol.name == Names.getType) {
                        tree2 = this.scalaClassType(symbol.pos, symbol.owner().type(), symbol, TypesAsValuesPhase.this.access$34());
                    }
                    return this.gen.DefDef(symbol, this.transform(tree2, symbol));
                }
                case 40: {
                    Tree tree3;
                    Tree.ValDef valDef = (Tree.ValDef)tree;
                    if (valDef.rhs.$tag == 21) {
                        tree3 = (Tree.Literal)valDef.rhs;
                        if (((Tree.Literal)tree3).value.$tag == 11) {
                            Tree tree4 = valDef.tpe;
                            Symbol symbol = this.getSymbolFor(tree);
                            Tree tree5 = this.gen.mkRef(tree.pos, this.typeAsValue(tree.pos, tree4.type, this.currentOwner, TypesAsValuesPhase.this.access$34()), TypesAsValuesPhase.this.access$35().TYPE_DEFAULTVALUE());
                            Tree tree6 = this.gen.mkApply__(tree.pos, tree5);
                            return this.gen.ValDef(symbol, tree6);
                        }
                    }
                    tree3 = valDef.rhs;
                    Symbol symbol = this.getSymbolFor(tree);
                    return this.gen.ValDef(symbol, this.transform(tree3, symbol));
                }
                case 23: {
                    Tree.New new_ = (Tree.New)tree;
                    if (new_.init.$tag != 4) break;
                    Tree.Apply apply = (Tree.Apply)new_.init;
                    if (apply.fun.$tag != 37) break;
                    Tree.TypeApply typeApply = (Tree.TypeApply)apply.fun;
                    Tree tree7 = typeApply.fun;
                    Tree[] treeArray = typeApply.args;
                    Tree[] treeArray2 = apply.args;
                    if (tree7.symbol() == TypesAsValuesPhase.this.access$36()) {
                        // empty if block
                    }
                    return super.transform(tree);
                }
                case 4: {
                    Tree.Apply apply = (Tree.Apply)tree;
                    if (apply.fun.$tag != 37) break;
                    Tree.TypeApply typeApply = (Tree.TypeApply)apply.fun;
                    Tree tree8 = typeApply.fun;
                    Tree[] treeArray = typeApply.args;
                    Tree[] treeArray3 = apply.args;
                    Symbol symbol = tree8.symbol();
                    if (symbol == TypesAsValuesPhase.this.access$35().ANY_IS) {
                        if (!($assertionsDisabled || treeArray.length == 1 && treeArray3.length == 0)) {
                            throw new AssertionError();
                        }
                        Type type = treeArray[0].type;
                        Tree tree9 = this.transform(this.qualifierOf(tree8));
                        return this.isTrivialType(type) ? super.transform(tree) : this.genInstanceTest(tree.pos, tree9, type);
                    }
                    if (symbol == TypesAsValuesPhase.this.access$35().ANY_AS) {
                        if (!($assertionsDisabled || treeArray.length == 1 && treeArray3.length == 0)) {
                            throw new AssertionError();
                        }
                        Type type = treeArray[0].type;
                        Tree tree10 = this.transform(this.qualifierOf(tree8));
                        return this.isTrivialType(type) ? super.transform(tree) : this.genTypeCast(tree.pos, tree10, type);
                    }
                    if (!TypesAsValuesPhase.this.access$37(symbol)) {
                        Tree[] treeArray4 = this.transform(treeArray3);
                        Tree[] treeArray5 = new Tree[treeArray4.length + treeArray.length];
                        for (int i = 0; i < treeArray.length; ++i) {
                            treeArray5[i] = this.typeAsValue(treeArray[i].pos, treeArray[i].type, this.currentOwner, TypesAsValuesPhase.this.access$34());
                        }
                        System.arraycopy(treeArray4, 0, treeArray5, treeArray.length, treeArray4.length);
                        return this.gen.mkApplyTV(tree.pos, this.transform(tree8), treeArray, treeArray5);
                    }
                    return super.transform(tree);
                }
            }
            return super.transform(tree);
        }

        private Tree transform(Tree tree, Symbol symbol) {
            Symbol symbol2 = this.currentOwner;
            this.currentOwner = symbol;
            Tree tree2 = this.transform(tree);
            this.currentOwner = symbol2;
            return tree2;
        }

        private Tree[] transform(Tree[] treeArray, Symbol symbol) {
            Symbol symbol2 = this.currentOwner;
            this.currentOwner = symbol;
            Tree[] treeArray2 = this.transform(treeArray);
            this.currentOwner = symbol2;
            return treeArray2;
        }

        private int level(Symbol symbol) {
            Symbol symbol2 = symbol.parents()[0].symbol();
            if (!$assertionsDisabled && symbol2 == Symbol.NONE) {
                throw new AssertionError((Object)String.valueOf(String.valueOf(symbol)));
            }
            if (symbol2 == TypesAsValuesPhase.this.access$35().ANY_CLASS) {
                return 0;
            }
            return 1 + this.level(symbol2);
        }

        private Tree.DefDef typeAccessorBody(Symbol symbol, Symbol symbol2) {
            Tree tree;
            if (symbol.isAbstractType()) {
                tree = Tree.Empty;
            } else if (symbol.isClass()) {
                tree = this.scalaClassType(symbol.pos, symbol.type(), symbol2, TypesAsValuesPhase.this.access$34());
            } else {
                Symbol[] symbolArray = symbol2.valueParams();
                int n = symbol2.pos;
                HashMap<Symbol, Integer> hashMap = new HashMap<Symbol, Integer>();
                Symbol[] symbolArray2 = symbol.typeParams();
                for (int i = 0; i < symbolArray2.length; ++i) {
                    hashMap.put(symbolArray2[i], new Integer(i));
                }
                17 var9_9 = new 17(hashMap, n, symbolArray, this);
                tree = this.typeAsValue(symbol.pos, symbol.type(), symbol2, var9_9);
            }
            return this.gen.DefDef(symbol2, tree);
        }

        private Tree tConstructorVal(Symbol symbol, Symbol symbol2) {
            return this.gen.ValDef(symbol2, symbol2.isStatic() ? Tree.Empty : this.tConstructorRHS(symbol2.pos, symbol, symbol2));
        }

        private Tree classInitialiser(Symbol symbol, Symbol symbol2, Symbol symbol3) {
            if (symbol3.isStatic()) {
                int n = symbol3.pos;
                Tree tree = this.tConstructorRHS(n, symbol, symbol2);
                Tree.Assign assign = this.gen.Assign(n, this.gen.Ident(n, symbol3), tree);
                return this.gen.DefDef(symbol2, assign);
            }
            return Tree.Empty;
        }

        private Tree tConstructorRHS(int n, Symbol symbol, Symbol symbol2) {
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            Symbol[] symbolArray = symbol.typeParams();
            for (int i = 0; i < symbolArray.length; ++i) {
                if ((symbolArray[i].flags & 0x40000000) != 0) {
                    ++n4;
                    continue;
                }
                if ((symbolArray[i].flags & Integer.MIN_VALUE) != 0) {
                    ++n3;
                    continue;
                }
                ++n2;
            }
            this.computeDisplay(symbol);
            int[] nArray = this.getDisplayCode(this.computeDisplay(symbol));
            Tree[] treeArray = new Tree[]{this.gen.mkIntLit(n, this.level(symbol)), this.gen.mkStringLit(n, TypesAsValuesPhase.this.access$38().getJREClassName(symbol)), TypesAsValuesPhase.this.access$39(symbol) ? this.gen.This(n, symbol.owner()) : this.gen.mkNullLit(n), this.gen.mkIntLit(n, n2), this.gen.mkIntLit(n, n3), this.gen.mkIntLit(n, n4), this.gen.mkBooleanLit(n, symbol.parents()[0].symbol().isJava()), this.mkNewIntLitArray(n, nArray, symbol2)};
            Symbol symbol3 = TypesAsValuesPhase.this.access$35().TYPECONSTRUCTOR_CLASS.primaryConstructor();
            Tree tree = this.gen.mkApply_V(n, this.gen.mkGlobalRef(n, symbol3), treeArray);
            return this.gen.New(n, tree);
        }

        private Tree mkNewIntLitArray(int n, int[] nArray, Symbol symbol) {
            Tree[] treeArray = new Tree[nArray.length];
            for (int i = 0; i < nArray.length; ++i) {
                treeArray[i] = this.gen.mkIntLit(n, nArray[i]);
            }
            return this.gen.mkNewArray(n, TypesAsValuesPhase.this.access$35().INT_TYPE(), treeArray, symbol);
        }

        private Tree.DefDef instantiatorBody(Symbol symbol, Symbol symbol2) {
            Tree tree;
            Tree tree2;
            int n = symbol.pos;
            Symbol[] symbolArray = symbol2.valueParams();
            Tree[] cfr_ignored_0 = new Tree[2];
            Tree.Select select = this.gen.Select(n, this.gen.mkLocalRef(n, TypesAsValuesPhase.this.access$40(symbol)), TypesAsValuesPhase.this.access$35().TYPECONSTRUCTOR_GETINSTANTIATION());
            Tree[] treeArray = new Tree[]{this.gen.mkLocalRef(n, symbolArray[0])};
            Symbol symbol3 = symbol2.newVariable(n, 0, Name.fromString("inst"));
            symbol3.setInfo(TypesAsValuesPhase.this.access$35().SCALACLASSTYPE_TYPE());
            Tree.ValDef valDef = this.gen.ValDef(symbol3, this.gen.mkApply_V(n, select, treeArray));
            Tree tree3 = this.gen.mkApply_V(n, this.gen.Select(n, this.gen.mkLocalRef(n, symbol3), TypesAsValuesPhase.this.access$35().ANY_BANGEQ), new Tree[]{this.gen.mkNullLit(n)});
            Tree tree4 = this.gen.mkLocalRef(n, symbol3);
            HashMap<Symbol, Integer> hashMap = new HashMap<Symbol, Integer>();
            Symbol[] symbolArray2 = symbol.typeParams();
            for (int i = 0; i < symbolArray2.length; ++i) {
                hashMap.put(symbolArray2[i], new Integer(i));
            }
            18 var14_14 = new 18(hashMap, n, symbolArray, this);
            Type[] typeArray = symbol.parents();
            TreeList treeList = new TreeList();
            for (int i = 0; i < typeArray.length; ++i) {
                Type type = typeArray[i];
                if (type.symbol().isJava()) continue;
                treeList.append(this.typeAsValue(n, type, symbol2, var14_14));
            }
            boolean bl = treeList.length() == 0;
            Tree tree5 = bl ? this.gen.mkGlobalRef(n, TypesAsValuesPhase.this.access$35().SCALACLASSTYPE_EMPTYARRAY()) : this.gen.mkNewArray(n, TypesAsValuesPhase.this.access$35().SCALACLASSTYPE_TYPE(), treeList.toArray(), symbol2);
            Tree.Select select2 = this.gen.Select(n, this.gen.mkLocalRef(n, TypesAsValuesPhase.this.access$40(symbol)), TypesAsValuesPhase.this.access$35().TYPECONSTRUCTOR_INSTANTIATE());
            Tree[] treeArray2 = new Tree[]{this.gen.mkLocalRef(n, symbolArray[0]), bl ? tree5 : this.gen.mkNullLit(n)};
            Tree tree6 = this.gen.mkApply_V(n, select2, treeArray2);
            if (!bl) {
                tree2 = this.gen.Select(n, tree6, TypesAsValuesPhase.this.access$35().SCALACLASSTYPE_SETPARENTS());
                tree = this.gen.mkApply_V(n, tree2, new Tree[]{tree5});
            } else {
                tree = tree6;
            }
            tree2 = this.gen.If(n, tree3, tree4, tree, TypesAsValuesPhase.this.access$35().SCALACLASSTYPE_TYPE());
            return this.gen.DefDef(symbol2, this.gen.mkBlock(n, valDef, tree2));
        }

        private Tree genInstanceTest(int n, Tree tree, Type type) {
            Tree tree2 = this.typeAsValue(n, type, this.currentOwner, TypesAsValuesPhase.this.access$34());
            Tree.Select select = this.gen.Select(n, tree2, TypesAsValuesPhase.this.access$35().TYPE_ISINSTANCE());
            return this.gen.mkApply_V(n, select, new Tree[]{tree});
        }

        private Tree genTypeCast(int n, Tree tree, Type type) {
            Tree tree2 = this.typeAsValue(n, type, this.currentOwner, TypesAsValuesPhase.this.access$34());
            Tree.Select select = this.gen.Select(n, tree2, TypesAsValuesPhase.this.access$35().TYPE_CHECKCASTABILITY());
            Tree tree3 = this.gen.mkApply_V(n, select, new Tree[]{tree});
            return this.gen.mkAsInstanceOf(n, tree3, type);
        }

        private boolean isTrivialType(Type type) {
            switch (type.$tag) {
                case 1: {
                    Type.ConstantType constantType = (Type.ConstantType)type;
                    Type type2 = constantType.base;
                    return this.isTrivialType(type2);
                }
                case 8: {
                    Type.TypeRef typeRef = (Type.TypeRef)type;
                    Symbol symbol = typeRef.sym;
                    Type[] typeArray = typeRef.args;
                    return symbol.isStatic() && typeArray.length == 0;
                }
                case 6: {
                    return false;
                }
                case 7: {
                    return false;
                }
                case 0: {
                    return false;
                }
            }
            throw Debug.abort("unexpected type", type);
        }

        private boolean isArrayClass(Symbol symbol) {
            return symbol == TypesAsValuesPhase.this.access$35().ARRAY_CLASS;
        }

        private Tree typeAsValue(int n, Type type, Symbol symbol, TEnv tEnv) {
            switch (type.$tag) {
                case 1: {
                    Type.ConstantType constantType = (Type.ConstantType)type;
                    Type type2 = constantType.base;
                    return this.typeAsValue(n, type2, symbol, tEnv);
                }
                case 8: {
                    Type.TypeRef typeRef = (Type.TypeRef)type;
                    Type type3 = typeRef.pre;
                    Symbol symbol2 = typeRef.sym;
                    Type[] typeArray = typeRef.args;
                    if (tEnv.definesVar(symbol2)) {
                        if (!$assertionsDisabled && typeArray.length != 0) {
                            throw new AssertionError();
                        }
                        return tEnv.treeForVar(symbol2);
                    }
                    if (this.isArrayClass(symbol2)) {
                        if (!$assertionsDisabled && typeArray.length != 1) {
                            throw new AssertionError();
                        }
                        return this.arrayType(n, symbol2, typeArray[0], symbol, tEnv);
                    }
                    if (TypesAsValuesPhase.this.access$41().containsKey(symbol2)) {
                        return this.gen.mkGlobalRef(n, (Symbol)TypesAsValuesPhase.this.access$41().get(symbol2));
                    }
                    if (symbol2.isJava()) {
                        if (!$assertionsDisabled && typeArray.length > 1) {
                            throw new AssertionError((Object)String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(Debug.show(symbol2))).concat(" "))).concat(String.valueOf(typeArray.length)))));
                        }
                        return this.javaType(n, symbol2);
                    }
                    if (!symbol2.owner().isMethod()) {
                        if (symbol == null) {
                            throw new Error("null owner for ".concat(String.valueOf(String.valueOf(Debug.show(type)))));
                        }
                        return this.scalaClassType(n, type, symbol, tEnv);
                    }
                    if (!$assertionsDisabled && this.isValuePrefix(type3)) {
                        throw new AssertionError((Object)String.valueOf(String.valueOf(type)));
                    }
                    return this.gen.mkLocalRef(n, TypesAsValuesPhase.this.access$42(symbol2));
                }
                case 6: {
                    return this.singleType(n, (Type.SingleType)type);
                }
                case 7: {
                    Type.ThisType thisType = (Type.ThisType)type;
                    Symbol symbol3 = thisType.sym;
                    return this.thisType(n, symbol3);
                }
                case 0: {
                    Type.CompoundType compoundType = (Type.CompoundType)type;
                    Type[] typeArray = compoundType.parts;
                    Scope scope = compoundType.members;
                    return this.compoundType(n, typeArray, scope, symbol, tEnv);
                }
            }
            throw Debug.abortIllegalCase(type);
        }

        private Tree arrayType(int n, Symbol symbol, Type type, Symbol symbol2, TEnv tEnv) {
            Tree tree = this.gen.mkPrimaryConstructorGlobalRef(n, TypesAsValuesPhase.this.access$35().JAVAREFARRAYTYPE_CLASS);
            Tree[] treeArray = new Tree[]{this.typeAsValue(n, type, symbol2, tEnv)};
            return this.gen.New(n, this.gen.mkApply_V(tree, treeArray));
        }

        private Tree javaType(int n, Symbol symbol) {
            Tree tree = this.gen.mkPrimaryConstructorGlobalRef(n, TypesAsValuesPhase.this.access$35().JAVACLASSTYPE_CLASS);
            Tree tree2 = this.gen.mkStringLit(n, TypesAsValuesPhase.this.access$38().getJREClassName(symbol));
            Tree[] treeArray = new Tree[]{tree2};
            return this.gen.New(n, this.gen.mkApply_V(tree, treeArray));
        }

        private Tree thisType(int n, Symbol symbol) {
            Tree tree = this.gen.mkPrimaryConstructorGlobalRef(n, TypesAsValuesPhase.this.access$35().SINGLETYPE_CLASS);
            Tree[] treeArray = new Tree[]{this.gen.This(n, symbol)};
            return this.gen.New(n, this.gen.mkApply_V(tree, treeArray));
        }

        private Tree singleType(int n, Type.SingleType singleType) {
            Tree tree = this.gen.mkPrimaryConstructorGlobalRef(n, TypesAsValuesPhase.this.access$35().SINGLETYPE_CLASS);
            Tree[] treeArray = new Tree[]{this.gen.mkQualifier(n, singleType)};
            return this.gen.New(n, this.gen.mkApply_V(tree, treeArray));
        }

        private Tree compoundType(int n, Type[] typeArray, Scope scope, Symbol symbol, TEnv tEnv) {
            Tree[] treeArray = new Tree[typeArray.length];
            for (int i = 0; i < typeArray.length; ++i) {
                treeArray[i] = this.typeAsValue(n, typeArray[i], symbol, tEnv);
            }
            Tree[] treeArray2 = new Tree[]{this.gen.mkNewArray(n, TypesAsValuesPhase.this.access$35().CLASSTYPE_TYPE(), treeArray, symbol), this.gen.mkBooleanLit(n, scope.isEmpty())};
            Tree tree = this.gen.mkPrimaryConstructorGlobalRef(n, TypesAsValuesPhase.this.access$35().COMPOUNDTYPE_CLASS);
            return this.gen.New(n, this.gen.mkApply_V(tree, treeArray2));
        }

        private Tree scalaClassType(int n, Type type, Symbol symbol, TEnv tEnv) {
            if (type.$tag == 8) {
                Type.TypeRef typeRef = (Type.TypeRef)type;
                Type type2 = typeRef.pre;
                Symbol symbol2 = typeRef.sym;
                Type[] typeArray = typeRef.args;
                Symbol symbol3 = TypesAsValuesPhase.this.access$43(symbol2);
                Tree.Ident ident = TypesAsValuesPhase.this.access$39(symbol2) ? this.gen.Select(n, this.gen.mkQualifier(n, type2), symbol3) : this.gen.Ident(n, symbol3);
                Tree[] treeArray = new Tree[typeArray.length];
                int[] nArray = this.typeParamsPermutation(symbol2.typeParams());
                for (int i = 0; i < typeArray.length; ++i) {
                    treeArray[i] = this.typeAsValue(n, typeArray[nArray[i]], symbol, tEnv);
                }
                Tree[] treeArray2 = new Tree[]{this.gen.mkNewArray(n, TypesAsValuesPhase.this.access$35().TYPE_TYPE(), treeArray, symbol)};
                return this.gen.mkApply_V(n, ident, treeArray2);
            }
            throw Debug.abort("unexpected type: ", type);
        }

        private int[] typeParamsPermutation(Symbol[] symbolArray) {
            int[] nArray = new int[symbolArray.length];
            int n = 0;
            for (int i = 0; i < symbolArray.length; ++i) {
                if ((symbolArray[i].flags & 0xC0000000) != 0) continue;
                nArray[n++] = i;
            }
            for (int i = 0; i < symbolArray.length; ++i) {
                if ((symbolArray[i].flags & Integer.MIN_VALUE) == 0) continue;
                nArray[n++] = i;
            }
            for (int i = 0; i < symbolArray.length; ++i) {
                if ((symbolArray[i].flags & 0x40000000) == 0) continue;
                nArray[n++] = i;
            }
            if (!$assertionsDisabled && n != nArray.length) {
                throw new AssertionError();
            }
            return nArray;
        }

        private Tree qualifierOf(Tree tree) {
            if (tree.$tag == 27) {
                Tree.Select select = (Tree.Select)tree;
                Tree tree2 = select.qualifier;
                return tree2;
            }
            throw Debug.abort("cannot extract qualifier from ", tree);
        }

        private boolean isValuePrefix(Type type) {
            switch (type.$tag) {
                case 7: {
                    Type.ThisType thisType = (Type.ThisType)type;
                    Symbol symbol = thisType.sym;
                    return !symbol.isPackage() && !symbol.isNone();
                }
                case 14: {
                    return false;
                }
            }
            return true;
        }

        private Ancestor[][] computeDisplay0(Symbol symbol) {
            Ancestor[][] ancestorArray;
            Symbol[] symbolArray = this.scalaParents(symbol);
            int n = this.level(symbol);
            ArrayList[] arrayListArray = new ArrayList[n + 1];
            for (int i = 0; i < arrayListArray.length; ++i) {
                arrayListArray[i] = new ArrayList();
            }
            arrayListArray[n].add(new Ancestor(symbol, -1, -1));
            for (int i = 0; i < symbolArray.length; ++i) {
                ancestorArray = symbolArray[i];
                if (!$assertionsDisabled && ancestorArray == Symbol.NONE) {
                    throw new AssertionError();
                }
                Ancestor[][] ancestorArray2 = this.computeDisplay((Symbol)ancestorArray);
                if (!$assertionsDisabled && ancestorArray2.length > arrayListArray.length) {
                    throw new AssertionError();
                }
                for (int j = 0; j < ancestorArray2.length; ++j) {
                    ArrayList arrayList = arrayListArray[j];
                    Ancestor[] ancestorArray3 = ancestorArray2[j];
                    for (int k = 0; k < ancestorArray3.length; ++k) {
                        Symbol symbol2 = ancestorArray3[k].symbol;
                        Iterator iterator = ((AbstractList)arrayList).iterator();
                        boolean bl = false;
                        while (!bl && iterator.hasNext()) {
                            Ancestor ancestor = (Ancestor)iterator.next();
                            if (ancestor.symbol != symbol2) continue;
                            bl = true;
                        }
                        if (bl) continue;
                        arrayList.add(new Ancestor(symbol2, i, k));
                    }
                }
            }
            ancestorArray = new Ancestor[n + 1][];
            for (int i = 0; i < ancestorArray.length; ++i) {
                ancestorArray[i] = arrayListArray[i].toArray(new Ancestor[arrayListArray[i].size()]);
            }
            return ancestorArray;
        }

        private Ancestor[][] computeDisplay(Symbol symbol) {
            Ancestor[][] ancestorArray = (Ancestor[][])TypesAsValuesPhase.this.access$44().get(symbol);
            if (ancestorArray == null) {
                ancestorArray = this.computeDisplay0(symbol);
                TypesAsValuesPhase.this.access$44().put(symbol, ancestorArray);
            }
            return ancestorArray;
        }

        private Symbol[] scalaParents(Symbol symbol) {
            Type[] typeArray = symbol.parents();
            ArrayList<Symbol> arrayList = new ArrayList<Symbol>();
            for (int i = 0; i < typeArray.length; ++i) {
                Symbol symbol2 = typeArray[i].symbol();
                if (symbol2.isJava()) continue;
                arrayList.add(symbol2);
            }
            return arrayList.toArray(new Symbol[arrayList.size()]);
        }

        private int[] getDisplayCode(Ancestor[][] ancestorArray) {
            Object[] objectArray;
            ArrayList arrayList = new ArrayList();
            int n = 0;
            for (int i = 0; i < ancestorArray.length; ++i) {
                objectArray = ancestorArray[i];
                ArrayList<int> arrayList2 = new ArrayList<int>(objectArray.length);
                for (int j = 0; j < objectArray.length; ++j) {
                    if (objectArray[j].parentIndex <= 0) continue;
                    arrayList2.add(objectArray[j]);
                }
                arrayList.add(arrayList2);
                n += 1 + 2 * arrayList2.size();
            }
            objectArray = new int[n];
            int n2 = 0;
            Iterator iterator = ((AbstractList)arrayList).iterator();
            while (iterator.hasNext()) {
                ArrayList arrayList3 = (ArrayList)iterator.next();
                objectArray[n2++] = arrayList3.size();
                Iterator iterator2 = ((AbstractList)arrayList3).iterator();
                while (iterator2.hasNext()) {
                    Ancestor ancestor = (Ancestor)iterator2.next();
                    objectArray[n2++] = ancestor.parentIndex;
                    objectArray[n2++] = ancestor.position;
                }
            }
            if (!$assertionsDisabled && n2 != n) {
                throw new AssertionError();
            }
            return objectArray;
        }

        static {
            $assertionsDisabled = !Class.forName("scalac.transformer.TypesAsValuesPhase").desiredAssertionStatus();
        }

        static class 18
        extends TEnv {
            final /* synthetic */ HashMap val$varMap;
            final /* synthetic */ int val$pos;
            final /* synthetic */ Symbol[] val$vparams;
            final /* synthetic */ TV_Transformer this$1;

            public boolean definesVar(Symbol symbol) {
                return this.val$varMap.containsKey(symbol);
            }

            public Tree treeForVar(Symbol symbol) {
                int n = (Integer)this.val$varMap.get(symbol);
                Tree tree = this.this$1.gen.mkLocalRef(this.val$pos, this.val$vparams[0]);
                return this.this$1.gen.mkArrayGet(this.val$pos, tree, n);
            }

            18(HashMap hashMap, int n, Symbol[] symbolArray, TV_Transformer tV_Transformer) {
                this.val$varMap = hashMap;
                this.val$pos = n;
                this.val$vparams = symbolArray;
                this.this$1 = tV_Transformer;
            }
        }

        static class 17
        extends TEnv {
            final /* synthetic */ HashMap val$varMap;
            final /* synthetic */ int val$pos;
            final /* synthetic */ Symbol[] val$vparams;
            final /* synthetic */ TV_Transformer this$1;

            public boolean definesVar(Symbol symbol) {
                return this.val$varMap.containsKey(symbol);
            }

            public Tree treeForVar(Symbol symbol) {
                int n = (Integer)this.val$varMap.get(symbol);
                Tree tree = this.this$1.gen.mkLocalRef(this.val$pos, this.val$vparams[0]);
                return this.this$1.gen.mkArrayGet(this.val$pos, tree, n);
            }

            17(HashMap hashMap, int n, Symbol[] symbolArray, TV_Transformer tV_Transformer) {
                this.val$varMap = hashMap;
                this.val$pos = n;
                this.val$vparams = symbolArray;
                this.this$1 = tV_Transformer;
            }
        }
    }

    private static class TEnv {
        public boolean definesVar(Symbol symbol) {
            return false;
        }

        public Tree treeForVar(Symbol symbol) {
            throw Debug.abort("no tree for variable ".concat(String.valueOf(String.valueOf(symbol))));
        }
    }
}

