/*
 * Decompiled with CFR 0.152.
 */
package scalac.symtab.classfile;

import scalac.atree.AConstant;
import scalac.symtab.Definitions;
import scalac.symtab.Symbol;
import scalac.symtab.Type;
import scalac.symtab.classfile.JavaTypeFactory;
import scalac.util.Debug;
import scalac.util.Name;

public class JavaTypeCreator
implements JavaTypeFactory {
    protected final Definitions definitions;
    protected final Type ANY_TYPE;
    protected final Type DOUBLE_TYPE;
    protected final Type FLOAT_TYPE;
    protected final Type LONG_TYPE;
    protected final Type INT_TYPE;
    protected final Type CHAR_TYPE;
    protected final Type SHORT_TYPE;
    protected final Type BYTE_TYPE;
    protected final Type BOOLEAN_TYPE;
    protected final Type UNIT_TYPE;
    protected final Type OBJECT_TYPE;
    protected final Type STRING_TYPE;
    protected final Type ARRAY_TYPE;

    public JavaTypeCreator(Definitions definitions) {
        this.definitions = definitions;
        this.ANY_TYPE = this.classType(definitions.ANY_CLASS);
        this.DOUBLE_TYPE = this.classType(definitions.DOUBLE_CLASS);
        this.FLOAT_TYPE = this.classType(definitions.FLOAT_CLASS);
        this.LONG_TYPE = this.classType(definitions.LONG_CLASS);
        this.INT_TYPE = this.classType(definitions.INT_CLASS);
        this.CHAR_TYPE = this.classType(definitions.CHAR_CLASS);
        this.SHORT_TYPE = this.classType(definitions.SHORT_CLASS);
        this.BYTE_TYPE = this.classType(definitions.BYTE_CLASS);
        this.BOOLEAN_TYPE = this.classType(definitions.BOOLEAN_CLASS);
        this.UNIT_TYPE = this.classType(definitions.UNIT_CLASS);
        this.OBJECT_TYPE = this.classType(definitions.OBJECT_CLASS);
        this.STRING_TYPE = this.classType(definitions.STRING_CLASS);
        this.ARRAY_TYPE = this.classType(definitions.ARRAY_CLASS);
    }

    public Type anyType() {
        return this.ANY_TYPE;
    }

    public Type byteType() {
        return this.BYTE_TYPE;
    }

    public Type shortType() {
        return this.SHORT_TYPE;
    }

    public Type charType() {
        return this.CHAR_TYPE;
    }

    public Type intType() {
        return this.INT_TYPE;
    }

    public Type longType() {
        return this.LONG_TYPE;
    }

    public Type floatType() {
        return this.FLOAT_TYPE;
    }

    public Type doubleType() {
        return this.DOUBLE_TYPE;
    }

    public Type booleanType() {
        return this.BOOLEAN_TYPE;
    }

    public Type voidType() {
        return this.UNIT_TYPE;
    }

    public Type objectType() {
        return this.OBJECT_TYPE;
    }

    public Type stringType() {
        return this.STRING_TYPE;
    }

    public Type classType(String string) {
        if (string.equals("java.lang.Object")) {
            return this.objectType();
        }
        if (string.equals("java.lang.String")) {
            return this.stringType();
        }
        return this.classType(this.definitions.getClass(string));
    }

    public Type classType(Symbol symbol) {
        return symbol.staticType();
    }

    public Type arrayType(Type type) {
        return Type.appliedType(this.ARRAY_TYPE, new Type[]{type});
    }

    public Type methodType(Type[] typeArray, Type type, Type[] typeArray2) {
        Symbol[] symbolArray = new Symbol[typeArray.length];
        for (int i = 0; i < symbolArray.length; ++i) {
            symbolArray[i] = Symbol.NONE.newTerm(0, 32768, Name.fromString("x".concat(String.valueOf(i))));
            symbolArray[i].setInfo(this.objToAny(typeArray[i]));
        }
        return new Type.MethodType(symbolArray, type);
    }

    private Type objToAny(Type type) {
        return type.isSameAs(this.OBJECT_TYPE) ? this.ANY_TYPE : type;
    }

    public Type packageType(Name name) {
        return null;
    }

    public Type constantType(AConstant aConstant) {
        return Type.constantType(aConstant);
    }

    public Type typeOfValue(Object object) {
        if (object instanceof Character) {
            return this.charType();
        }
        if (object instanceof Integer) {
            return this.intType();
        }
        if (object instanceof Long) {
            return this.longType();
        }
        if (object instanceof Float) {
            return this.floatType();
        }
        if (object instanceof Double) {
            return this.doubleType();
        }
        if (object instanceof String) {
            return this.stringType();
        }
        if (object instanceof Boolean) {
            return this.booleanType();
        }
        throw Debug.abort("unknown constant type", object.getClass());
    }
}

