/*
 * Decompiled with CFR 0.152.
 */
package scalac.symtab;

import java.io.IOException;
import scalac.Global;
import scalac.Phase;
import scalac.symtab.Symbol;
import scalac.symtab.Type;
import scalac.util.Debug;

public abstract class SymbolLoader
extends Type.LazyType {
    public final Global global;
    private static final /* synthetic */ boolean $assertionsDisabled;

    public SymbolLoader(Global global) {
        this.global = global;
    }

    public final void complete(Symbol symbol) {
        Symbol symbol2 = this.getRootSymbol(symbol);
        try {
            Phase phase = this.global.currentPhase;
            this.global.currentPhase = this.global.PHASE.ANALYZER.phase();
            this.global.timer.start();
            String string = this.doComplete(symbol2);
            this.global.timer.stop("loaded ".concat(String.valueOf(String.valueOf(string))));
            this.global.currentPhase = phase;
            this.checkValidity(symbol2, string);
        }
        catch (IOException iOException) {
            this.global.timer.drop();
            if (this.global.debug) {
                iOException.printStackTrace();
            }
            String string = "error while loading ".concat(String.valueOf(String.valueOf(symbol)));
            String string2 = iOException.getMessage();
            string = string2 != null ? String.valueOf(String.valueOf(String.valueOf(String.valueOf(string)).concat(", "))).concat(String.valueOf(String.valueOf(string2))) : "i/o ".concat(String.valueOf(String.valueOf(string)));
            this.global.error(string);
        }
        this.initializeRoot(symbol2);
    }

    protected abstract String doComplete(Symbol var1) throws IOException;

    private Symbol getRootSymbol(Symbol symbol) {
        if (symbol.isConstructor()) {
            return this.getRootSymbol(symbol.constructorClass());
        }
        if (symbol.isModuleClass()) {
            return this.getRootSymbol(symbol.sourceModule());
        }
        if (symbol.isModule() && symbol.linkedClass() != null) {
            return symbol.linkedClass();
        }
        if (!($assertionsDisabled || symbol.isClassType() || symbol.isModule())) {
            throw new AssertionError((Object)String.valueOf(String.valueOf(Debug.show(symbol))));
        }
        return symbol;
    }

    private void checkValidity(Symbol symbol, String string) {
        String string2;
        if (symbol.rawInfo() != this) {
            return;
        }
        if (!symbol.isClassType() || symbol.linkedModule() == null) {
            string2 = "does not define ".concat(String.valueOf(String.valueOf(symbol)));
        } else {
            if (symbol.linkedModule().moduleClass().rawInfo() != this) {
                return;
            }
            string2 = String.valueOf(String.valueOf(String.valueOf(String.valueOf("defines neither ".concat(String.valueOf(String.valueOf(symbol))))).concat(" nor "))).concat(String.valueOf(String.valueOf(symbol.linkedModule())));
        }
        this.global.error(String.valueOf(String.valueOf(String.valueOf(String.valueOf(string)).concat(" "))).concat(String.valueOf(String.valueOf(string2))));
    }

    private void initializeRoot(Symbol symbol) {
        if (symbol.isClassType()) {
            this.initializeClass(symbol);
            if (symbol.linkedModule() != null) {
                this.initializeRoot(symbol.linkedModule());
            }
        } else {
            this.initializeSymbol(symbol);
            if (symbol.isModule()) {
                this.initializeClass(symbol.moduleClass());
            }
        }
    }

    private void initializeClass(Symbol symbol) {
        this.initializeSymbol(symbol);
        this.initializeSymbol(symbol.allConstructors());
    }

    private void initializeSymbol(Symbol symbol) {
        if (symbol.rawInfo() != this) {
            return;
        }
        symbol.setInfo(symbol.isModule() ? Type.NoType : Type.ErrorType);
        if (symbol.isConstructor()) {
            symbol.flags |= 4;
        }
    }

    static {
        $assertionsDisabled = !Class.forName("scalac.symtab.SymbolLoader").desiredAssertionStatus();
    }
}

