/*
 * Decompiled with CFR 0.152.
 */
package scalac.atree;

import scalac.Global;
import scalac.atree.ACode;
import scalac.atree.AConstant;
import scalac.atree.AFunction;
import scalac.atree.AInvokeStyle;
import scalac.atree.ALocation;
import scalac.atree.APrimitive;
import scalac.atree.ATypeKind;
import scalac.symtab.Definitions;
import scalac.symtab.Symbol;
import scalac.symtab.Type;
import scalac.util.Debug;
import scalac.util.Name;
import scalac.util.TermName;

public class ATreeTyper {
    public final Global global;
    private final Definitions definitions;
    private static final /* synthetic */ boolean $assertionsDisabled;

    public ATreeTyper(Global global, Definitions definitions) {
        this.global = global;
        this.definitions = definitions;
    }

    public Type[] type(ACode[] aCodeArray) {
        Type[] typeArray = new Type[aCodeArray.length];
        for (int i = 0; i < typeArray.length; ++i) {
            typeArray[i] = this.type(aCodeArray[i]);
        }
        return typeArray;
    }

    public Type type(ACode aCode) {
        switch (aCode.$tag) {
            case 15: {
                return this.definitions.void_TYPE();
            }
            case 13: {
                ACode.This this_ = (ACode.This)aCode;
                Symbol symbol = this_.clasz;
                return symbol.thisType();
            }
            case 2: {
                ACode.Constant constant = (ACode.Constant)aCode;
                AConstant aConstant = constant.constant;
                return this.type(aConstant);
            }
            case 8: {
                ACode.Load load = (ACode.Load)aCode;
                ALocation aLocation = load.location;
                return this.type(aLocation);
            }
            case 10: {
                return Type.NoType;
            }
            case 0: {
                ACode.Apply apply = (ACode.Apply)aCode;
                AFunction aFunction = apply.function;
                Type[] typeArray = apply.targs;
                return this.apply(this.type(aFunction), typeArray).resultType();
            }
            case 6: {
                ACode.IsAs isAs = (ACode.IsAs)aCode;
                Type type = isAs.type;
                boolean bl = isAs.cast;
                return bl ? type : this.definitions.boolean_TYPE();
            }
            case 5: {
                ACode.If if_ = (ACode.If)aCode;
                ACode aCode2 = if_.success;
                ACode aCode3 = if_.failure;
                return Type.lub(new Type[]{this.type(aCode2), this.type(aCode3)});
            }
            case 11: {
                ACode.Switch switch_ = (ACode.Switch)aCode;
                ACode[] aCodeArray = switch_.bodies;
                return Type.lub(this.type(aCodeArray));
            }
            case 12: {
                ACode.Synchronized synchronized_ = (ACode.Synchronized)aCode;
                ACode aCode4 = synchronized_.value;
                return this.type(aCode4);
            }
            case 1: {
                ACode.Block block = (ACode.Block)aCode;
                ACode aCode5 = block.value;
                return this.type(aCode5);
            }
            case 7: {
                ACode.Label label = (ACode.Label)aCode;
                Symbol symbol = label.label;
                return symbol.type().resultType();
            }
            case 4: {
                return Type.NoType;
            }
            case 9: {
                return Type.NoType;
            }
            case 14: {
                return Type.NoType;
            }
            case 3: {
                return Type.NoType;
            }
        }
        throw Debug.abort("unknown case", aCode);
    }

    public Type type(ALocation aLocation) {
        switch (aLocation.$tag) {
            case 3: {
                ALocation.Module module = (ALocation.Module)aLocation;
                Symbol symbol = module.module;
                return symbol.thisType();
            }
            case 1: {
                ALocation.Field field = (ALocation.Field)aLocation;
                if (field.object.$tag == 15) {
                    Symbol symbol = field.field;
                    return symbol.owner().thisType().memberStabilizedType(symbol);
                }
                ACode aCode = field.object;
                Symbol symbol = field.field;
                return this.type(aCode).memberStabilizedType(symbol);
            }
            case 2: {
                ALocation.Local local = (ALocation.Local)aLocation;
                Symbol symbol = local.local;
                return symbol.type();
            }
            case 0: {
                ALocation.ArrayItem arrayItem = (ALocation.ArrayItem)aLocation;
                ACode aCode = arrayItem.array;
                return this.getArrayElementType(this.type(aCode));
            }
        }
        throw Debug.abort("unknown case", aLocation);
    }

    public Type type(AFunction aFunction) {
        switch (aFunction.$tag) {
            case 0: {
                AFunction.Method method = (AFunction.Method)aFunction;
                if (method.object.$tag == 15) {
                    Symbol symbol = method.method;
                    AInvokeStyle aInvokeStyle = method.style;
                    Type type = symbol.owner().thisType().memberStabilizedType(symbol);
                    if (aInvokeStyle == AInvokeStyle.New) {
                        if (!$assertionsDisabled && !symbol.isInitializer()) {
                            throw new AssertionError((Object)String.valueOf(String.valueOf(aFunction)));
                        }
                        Symbol[] symbolArray = symbol.owner().typeParams();
                        if (symbolArray.length != 0) {
                            type = Type.PolyType(symbolArray, type);
                        }
                    }
                    return type;
                }
                ACode aCode = method.object;
                Symbol symbol = method.method;
                return this.type(aCode).memberStabilizedType(symbol);
            }
            case 2: {
                AFunction.Primitive primitive = (AFunction.Primitive)aFunction;
                APrimitive aPrimitive = primitive.primitive;
                return this.type(aPrimitive);
            }
            case 1: {
                AFunction.NewArray newArray = (AFunction.NewArray)aFunction;
                Type type = newArray.element;
                return this.definitions.array_TYPE(type);
            }
        }
        throw Debug.abort("unknown case", aFunction);
    }

    public Type type(APrimitive aPrimitive) {
        switch (aPrimitive.$tag) {
            case 5: {
                APrimitive.Negation negation = (APrimitive.Negation)aPrimitive;
                ATypeKind aTypeKind = negation.kind;
                Type type = this.type(aTypeKind);
                return this.getMethodType(type, type);
            }
            case 8: {
                APrimitive.Test test = (APrimitive.Test)aPrimitive;
                if (test.zero) {
                    ATypeKind aTypeKind = test.kind;
                    Type type = this.type(aTypeKind);
                    return this.getMethodType(type, this.type(ATypeKind.BOOL));
                }
                if (test.zero) break;
                ATypeKind aTypeKind = test.kind;
                Type type = this.type(aTypeKind);
                return this.getMethodType(type, type, this.type(ATypeKind.BOOL));
            }
            case 2: {
                APrimitive.Comparison comparison = (APrimitive.Comparison)aPrimitive;
                ATypeKind aTypeKind = comparison.kind;
                Type type = this.type(aTypeKind);
                return this.getMethodType(type, type, this.type(ATypeKind.I4));
            }
            case 0: {
                APrimitive.Arithmetic arithmetic = (APrimitive.Arithmetic)aPrimitive;
                ATypeKind aTypeKind = arithmetic.kind;
                Type type = this.type(aTypeKind);
                return this.getMethodType(type, type, type);
            }
            case 4: {
                APrimitive.Logical logical = (APrimitive.Logical)aPrimitive;
                ATypeKind aTypeKind = logical.kind;
                Type type = this.type(aTypeKind);
                return this.getMethodType(type, type, type);
            }
            case 6: {
                APrimitive.Shift shift = (APrimitive.Shift)aPrimitive;
                ATypeKind aTypeKind = shift.kind;
                Type type = this.type(aTypeKind);
                return this.getMethodType(type, this.type(ATypeKind.I4), type);
            }
            case 3: {
                APrimitive.Conversion conversion = (APrimitive.Conversion)aPrimitive;
                ATypeKind aTypeKind = conversion.src;
                ATypeKind aTypeKind2 = conversion.dst;
                return this.getMethodType(this.type(aTypeKind), this.type(aTypeKind2));
            }
            case 1: {
                APrimitive.ArrayLength arrayLength = (APrimitive.ArrayLength)aPrimitive;
                ATypeKind aTypeKind = arrayLength.kind;
                Type type = this.definitions.array_TYPE(this.type(aTypeKind));
                return this.getMethodType(type, this.type(ATypeKind.I4));
            }
            case 7: {
                APrimitive.StringConcat stringConcat = (APrimitive.StringConcat)aPrimitive;
                ATypeKind aTypeKind = stringConcat.lf;
                ATypeKind aTypeKind3 = stringConcat.rg;
                return this.getMethodType(this.type(aTypeKind), this.type(aTypeKind3), this.type(ATypeKind.STR));
            }
        }
        throw Debug.abort("unknown case", aPrimitive);
    }

    public Type type(AConstant aConstant) {
        Type type = this.basetype(aConstant);
        if (this.global.currentPhase.id > this.global.PHASE.ERASURE.id()) {
            return type;
        }
        return Type.ConstantType(type, aConstant);
    }

    public Type basetype(AConstant aConstant) {
        switch (aConstant.$tag) {
            case 10: {
                return this.definitions.void_TYPE();
            }
            case 0: {
                return this.definitions.boolean_TYPE();
            }
            case 1: {
                return this.definitions.byte_TYPE();
            }
            case 7: {
                return this.definitions.short_TYPE();
            }
            case 2: {
                return this.definitions.char_TYPE();
            }
            case 5: {
                return this.definitions.int_TYPE();
            }
            case 6: {
                return this.definitions.long_TYPE();
            }
            case 4: {
                return this.definitions.float_TYPE();
            }
            case 3: {
                return this.definitions.double_TYPE();
            }
            case 8: {
                return this.definitions.STRING_TYPE();
            }
            case 9: {
                return this.definitions.ALLREF_TYPE();
            }
            case 11: {
                return this.definitions.ALL_TYPE();
            }
        }
        throw Debug.abort("unknown case", aConstant);
    }

    public Type type(ATypeKind aTypeKind) {
        switch (aTypeKind.$tag) {
            case 14: {
                return this.definitions.void_TYPE();
            }
            case 0: {
                return this.definitions.boolean_TYPE();
            }
            case 11: {
                return this.definitions.char_TYPE();
            }
            case 1: {
                return this.definitions.byte_TYPE();
            }
            case 2: {
                return this.definitions.short_TYPE();
            }
            case 3: {
                return this.definitions.int_TYPE();
            }
            case 4: {
                return this.definitions.long_TYPE();
            }
            case 6: {
                return this.definitions.float_TYPE();
            }
            case 7: {
                return this.definitions.double_TYPE();
            }
            case 8: {
                return this.definitions.ANYREF_TYPE();
            }
            case 9: {
                return this.definitions.STRING_TYPE();
            }
            case 5: {
                return this.definitions.ALLREF_TYPE();
            }
            case 15: {
                return this.definitions.ALL_TYPE();
            }
        }
        throw Debug.abort("unknown case", aTypeKind);
    }

    public Type[] computeType(ACode[] aCodeArray) {
        return this.type(aCodeArray);
    }

    public Type computeType(ACode aCode) {
        return this.type(aCode);
    }

    public Type computeType(ALocation aLocation) {
        return this.type(aLocation);
    }

    public Type computeType(AFunction aFunction) {
        return this.type(aFunction);
    }

    public Type computeType(APrimitive aPrimitive) {
        return this.type(aPrimitive);
    }

    public Type computeType(AConstant aConstant) {
        return this.type(aConstant);
    }

    public Type computeType(ATypeKind aTypeKind) {
        return this.type(aTypeKind);
    }

    private Type apply(Type type, Type[] typeArray) {
        if (type.$tag == 5) {
            Type.PolyType polyType = (Type.PolyType)type;
            Symbol[] symbolArray = polyType.tparams;
            Type type2 = polyType.result;
            return type2.subst(symbolArray, typeArray);
        }
        if (!$assertionsDisabled && typeArray.length != 0) {
            throw new AssertionError((Object)String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(type)).concat(" -- "))).concat(String.valueOf(String.valueOf(Debug.show(typeArray)))))));
        }
        return type;
    }

    public Type getArrayElementType(Type type) {
        switch (type.$tag) {
            case 8: {
                Type.TypeRef typeRef = (Type.TypeRef)type;
                Symbol symbol = typeRef.sym;
                Type[] typeArray = typeRef.args;
                if (!($assertionsDisabled || symbol == this.definitions.ARRAY_CLASS && typeArray.length == 1)) {
                    throw new AssertionError((Object)String.valueOf(String.valueOf(type)));
                }
                return typeArray[0];
            }
            case 10: {
                Type.UnboxedArrayType unboxedArrayType = (Type.UnboxedArrayType)type;
                Type type2 = unboxedArrayType.elemtp;
                return type2;
            }
        }
        throw Debug.abort("non-array type", type);
    }

    private Type getMethodType(Type type, Type type2) {
        return this.getMethodType(new Type[]{type}, type2);
    }

    private Type getMethodType(Type type, Type type2, Type type3) {
        return this.getMethodType(new Type[]{type, type2}, type3);
    }

    private Type getMethodType(Type[] typeArray, Type type) {
        Symbol[] symbolArray = new Symbol[typeArray.length];
        for (int i = 0; i < symbolArray.length; ++i) {
            TermName termName = Name.fromString("v".concat(String.valueOf(i)));
            symbolArray[i] = Symbol.NONE.newTerm(0, 32768, termName);
            symbolArray[i].setType(typeArray[i]);
        }
        return Type.MethodType(symbolArray, type);
    }

    static {
        $assertionsDisabled = !Class.forName("scalac.atree.ATreeTyper").desiredAssertionStatus();
    }
}

