/*
 * Decompiled with CFR 0.152.
 */
package scalac;

import java.util.ArrayList;
import java.util.List;
import scalac.PhaseDescriptor;

public abstract class CompilerPhases {
    public final PhaseDescriptor INITIAL;
    public final PhaseDescriptor PARSER;
    public final PhaseDescriptor NAMER;
    public final PhaseDescriptor ANALYZER;
    public final PhaseDescriptor REFCHECK;
    public final PhaseDescriptor UNCURRY;
    public final PhaseDescriptor TRANSMATCH;
    public final PhaseDescriptor LAMBDALIFT;
    public final PhaseDescriptor ADDACCESSORS;
    public final PhaseDescriptor EXPLICITOUTER;
    public final PhaseDescriptor ADDCONSTRUCTORS;
    public final PhaseDescriptor TYPESASVALUES;
    public final PhaseDescriptor TAILCALL;
    public final PhaseDescriptor WHOLEPROG;
    public final PhaseDescriptor ADDINTERFACES;
    public final PhaseDescriptor EXPANDMIXIN;
    public final PhaseDescriptor MAKEBOXINGEXPLICIT;
    public final PhaseDescriptor ERASURE;
    public final PhaseDescriptor ICODE;
    public final PhaseDescriptor CODEGEN;
    public final PhaseDescriptor TERMINAL;
    private final List phases = new ArrayList();
    private static final /* synthetic */ boolean $assertionsDisabled;

    protected abstract Class PARSER_PHASE();

    protected abstract Class NAMER_PHASE();

    protected abstract Class ANALYZER_PHASE();

    protected abstract Class REFCHECK_PHASE();

    protected abstract Class UNCURRY_PHASE();

    protected abstract Class TRANSMATCH_PHASE();

    protected Class LAMBDALIFT_PHASE() {
        return Class.forName("scalac.transformer.LambdaLiftPhase");
    }

    protected Class EXPLICITOUTER_PHASE() {
        return Class.forName("scalac.transformer.ExplicitOuterClassesPhase");
    }

    protected Class ADDACCESSORS_PHASE() {
        return Class.forName("scalac.transformer.AddAccessorsPhase");
    }

    protected Class ADDCONSTRUCTORS_PHASE() {
        return Class.forName("scalac.transformer.AddConstructorsPhase");
    }

    protected Class TYPESASVALUES_PHASE() {
        return Class.forName("scalac.transformer.TypesAsValuesPhase");
    }

    protected Class TAILCALL_PHASE() {
        return Class.forName("scalac.transformer.TailCallPhase");
    }

    protected abstract Class WHOLEPROG_PHASE();

    protected Class ADDINTERFACES_PHASE() {
        return Class.forName("scalac.transformer.AddInterfacesPhase");
    }

    protected Class EXPANDMIXIN_PHASE() {
        return Class.forName("scalac.transformer.ExpandMixinsPhase");
    }

    protected Class ERASURE_PHASE() {
        return Class.forName("scalac.transformer.ErasurePhase");
    }

    protected abstract Class ICODE_PHASE();

    public CompilerPhases() {
        this.INITIAL = new PhaseDescriptor("initial", "initializing compiler", "initializing compiler", Class.forName("scalac.util.EmptyPhase"));
        PhaseDescriptor[] phaseDescriptorArray = new PhaseDescriptor[]{this.INITIAL, this.PARSER = new PhaseDescriptor("parse", "parse source files", "parsed", this.PARSER_PHASE()), this.NAMER = new PhaseDescriptor("namer", "create symbols", "symbols created", this.NAMER_PHASE()), this.ANALYZER = new PhaseDescriptor("analyze", "name and type analysis", "type checking", this.ANALYZER_PHASE()), this.REFCHECK = new PhaseDescriptor("refcheck", "reference checking", "reference checking", this.REFCHECK_PHASE()), this.UNCURRY = new PhaseDescriptor("uncurry", "uncurry function types and applications", "uncurried", this.UNCURRY_PHASE()), this.TRANSMATCH = new PhaseDescriptor("transmatch", "translate match expressions", "translated pattern matching", this.TRANSMATCH_PHASE()), this.LAMBDALIFT = new PhaseDescriptor("lambdalift", "lambda lifter", "lambda lifting", this.LAMBDALIFT_PHASE()), this.TYPESASVALUES = new PhaseDescriptor("typesasvalues", "represent types as values", "represented types as values", this.TYPESASVALUES_PHASE()), this.ADDACCESSORS = new PhaseDescriptor("addaccessors", "add accessors for constructor arguments", "added accessors", this.ADDACCESSORS_PHASE()), this.EXPLICITOUTER = new PhaseDescriptor("explicitouterclasses", "make links from inner classes to enclosing one explicit", "made outer links explicit", this.EXPLICITOUTER_PHASE()), this.ADDCONSTRUCTORS = new PhaseDescriptor("addconstructors", "add explicit constructor for each class", "added constructors", this.ADDCONSTRUCTORS_PHASE()), this.TAILCALL = new PhaseDescriptor("tailcall", "add tail-calls", "added tail-calls", this.TAILCALL_PHASE()), this.WHOLEPROG = new PhaseDescriptor("wholeprog", "perform whole program analysis", "find monomorphic callsites and performs inlining", this.WHOLEPROG_PHASE()), this.ADDINTERFACES = new PhaseDescriptor("addinterfaces", "add one interface per class", "added interfaces", this.ADDINTERFACES_PHASE()), this.EXPANDMIXIN = new PhaseDescriptor("expandmixins", "expand mixins by code copying", "expanded mixins", this.EXPANDMIXIN_PHASE()), this.MAKEBOXINGEXPLICIT = new PhaseDescriptor("boxing", "makes boxing explicit", "made boxing explicit", Class.forName("scalac.transformer.MakeBoxingExplicitPhase")), this.ERASURE = new PhaseDescriptor("erasure", "type eraser", "erased types", this.ERASURE_PHASE()), this.ICODE = new PhaseDescriptor("icode", "generate icode", "generated icode", this.ICODE_PHASE()), this.CODEGEN = new PhaseDescriptor("codegen", "enable code generation", "code generation enabled", Class.forName("scalac.util.EmptyPhase")), this.TERMINAL = new PhaseDescriptor("terminal", "compilation terminated", "compilation terminated", Class.forName("scalac.util.EmptyPhase"))};
        for (int i = 0; i < phaseDescriptorArray.length; ++i) {
            this.phases.add(phaseDescriptorArray[i]);
        }
    }

    public PhaseDescriptor[] phases() {
        PhaseDescriptor[] phaseDescriptorArray = new PhaseDescriptor[this.phases.size()];
        this.phases.toArray(phaseDescriptorArray);
        return phaseDescriptorArray;
    }

    public void freeze() {
        PhaseDescriptor[] phaseDescriptorArray = this.phases();
        PhaseDescriptor.freeze(phaseDescriptorArray);
    }

    public int insertBefore(PhaseDescriptor phaseDescriptor, PhaseDescriptor phaseDescriptor2) {
        int n = this.phases.indexOf(phaseDescriptor2);
        if (!$assertionsDisabled && n < 0) {
            throw new AssertionError((Object)String.valueOf(String.valueOf("could not find phase ".concat(String.valueOf(String.valueOf(phaseDescriptor2))))));
        }
        this.phases.add(n, phaseDescriptor);
        return n;
    }

    public int insertAfter(PhaseDescriptor phaseDescriptor, PhaseDescriptor phaseDescriptor2) {
        int n = this.phases.indexOf(phaseDescriptor2);
        if (!$assertionsDisabled && n < 0) {
            throw new AssertionError((Object)String.valueOf(String.valueOf("could not find phase ".concat(String.valueOf(String.valueOf(phaseDescriptor2))))));
        }
        this.phases.add(n + 1, phaseDescriptor);
        return n + 1;
    }

    static {
        $assertionsDisabled = !Class.forName("scalac.CompilerPhases").desiredAssertionStatus();
    }
}

