/*
 * Decompiled with CFR 0.152.
 */
package scala.tools.scalai;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.PushbackReader;
import java.io.StringReader;
import java.util.ArrayList;
import scala.runtime.InterpreterSupport;
import scala.tools.scalac.Global$class;
import scala.tools.scalai.EvaluatorResult;
import scala.tools.scalai.Interpreter;
import scala.tools.scalai.InterpreterCommand;
import scala.tools.scalai.InterpreterPrinter;
import scala.tools.scalai.Main;
import scalac.Global;
import scalac.util.Debug;
import scalac.util.PrefixMatcher;
import scalac.util.Strings;

public class InterpreterShell {
    public static final String PRODUCT = Main.PRODUCT;
    public static final String VERSION = Main.VERSION;
    public static final String COPYRIGHT = "(c) 2002-04, LAMP/EPFL";
    private static final int QUIT = 0;
    private static final int LOAD = 1;
    private static final int USE = 2;
    private static final int GC = 3;
    private static final int MEMORY = 4;
    private static final int SHOWVER = 5;
    private static final int HELP = 6;
    private final boolean interactive;
    private final boolean nologo;
    private final boolean emacs;
    private final BufferedReader reader;
    private final PrintWriter writer;
    private final PrefixMatcher matcher;
    private final Global global;
    private final Interpreter interpreter;
    private final InterpreterPrinter printer;
    private String[] lfiles;
    private String[] ufiles;

    public InterpreterShell(InterpreterCommand interpreterCommand) {
        this(interpreterCommand, new BufferedReader(new InputStreamReader(System.in)), new PrintWriter(System.out, true));
    }

    public InterpreterShell(InterpreterCommand interpreterCommand, BufferedReader bufferedReader, PrintWriter printWriter) {
        this.interactive = interpreterCommand.interactive.value;
        this.nologo = interpreterCommand.nologo.value;
        this.emacs = interpreterCommand.emacs.value;
        this.reader = bufferedReader;
        this.writer = printWriter;
        this.matcher = this.matcher();
        this.global = new Global$class(interpreterCommand, true);
        this.interpreter = new Interpreter(this.global);
        this.printer = new InterpreterPrinter(this.interpreter, printWriter);
        this.lfiles = new String[0];
        this.ufiles = new String[0];
    }

    public void main(String[] stringArray, String string, String string2, String[] stringArray2) {
        if (this.interactive && !this.nologo) {
            this.showBanner();
        }
        if (stringArray.length > 0) {
            this.lfiles = stringArray;
            this.load(stringArray);
        }
        if (this.global.reporter.errors() == 0 && string != null) {
            this.eval(string);
        }
        if (this.global.reporter.errors() == 0 && string2 != null) {
            this.call(string2, stringArray2);
        }
        if (this.interactive) {
            this.loop();
        }
    }

    public void loop() {
        InterpreterSupport.setDefinitionPrinter((InterpreterSupport.DefinitionPrinter)this.printer);
        while (this.handle(this.read())) {
        }
        InterpreterSupport.setDefinitionPrinter(null);
    }

    public boolean handle(String string) {
        if (string == null) {
            return this.exec(0);
        }
        String string2 = string.trim();
        if (string2.startsWith(":")) {
            return this.exec(string2);
        }
        this.eval(string);
        return true;
    }

    public String read() {
        this.writer.print("> ");
        this.writer.flush();
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        while (!bl) {
            String string;
            try {
                string = this.reader.readLine();
            }
            catch (IOException iOException) {
                this.writer.println();
                this.error(iOException.toString());
                System.exit(1);
                throw Debug.abort(iOException);
            }
            if (string == null) {
                this.writer.println();
                break;
            }
            if (this.emacs && string.equals("emacs:end")) break;
            if (!this.emacs) {
                int n = Strings.lastChar(string = Strings.trimTrailing(string));
                boolean bl2 = bl = ",;:({=|\\".indexOf(n) < 0;
                if (n == 92) {
                    string = string.substring(0, string.length() - 1);
                }
            }
            stringBuffer.append(string).append('\n');
            if (this.emacs || bl) continue;
            this.writer.print("| ");
            this.writer.flush();
        }
        return stringBuffer.length() == 0 ? null : stringBuffer.toString();
    }

    public void showBanner() {
        this.writer.println("  __ __  _      _");
        this.writer.println(" (_ /   /_||   /_|   INTERPRETER");
        this.writer.println("___)\\__/  ||__/  |   (c) 2002-04, LAMP/EPFL");
        this.writer.println(" ");
        this.writer.println(" version: ".concat(String.valueOf(String.valueOf(VERSION))));
        this.writer.println(" type :? to get a list of all interpreter commands");
        this.writer.println(" ");
    }

    public boolean exec(String string) {
        int n = string.indexOf(32);
        n = n < 0 ? string.length() : n;
        String string2 = string.substring(0, n);
        PrefixMatcher.Entry[] entryArray = this.matcher.lookup(string2);
        if (entryArray.length != 1) {
            this.error(this.matcher.getErrorMessage(string2, entryArray, "command"));
            return true;
        }
        try {
            String[] stringArray = this.readArguments(string.substring(n));
            return this.exec((Integer)entryArray[0].value, stringArray);
        }
        catch (IOException iOException) {
            this.error(iOException.getMessage());
            return true;
        }
    }

    public boolean exec(int n) {
        return this.exec(n, new String[0]);
    }

    public boolean exec(int n, String[] stringArray) {
        switch (n) {
            case 0: {
                this.writer.println(String.valueOf(String.valueOf("[Leaving ".concat(String.valueOf(String.valueOf(PRODUCT))))).concat("]"));
                return false;
            }
            case 1: {
                if (stringArray.length != 0) {
                    this.lfiles = stringArray;
                }
                this.load(this.lfiles);
                return true;
            }
            case 2: {
                if (stringArray.length != 0) {
                    this.ufiles = stringArray;
                }
                return this.exec(this.ufiles);
            }
            case 3: {
                System.gc();
                return true;
            }
            case 4: {
                Runtime runtime = Runtime.getRuntime();
                this.writer.println("total memory: ".concat(String.valueOf(runtime.totalMemory())));
                this.writer.println("free memory : ".concat(String.valueOf(runtime.freeMemory())));
                return true;
            }
            case 5: {
                this.writer.println(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(PRODUCT)).concat(" "))).concat(String.valueOf(String.valueOf(VERSION))))).concat(" -- "))).concat(COPYRIGHT));
                return true;
            }
            case 6: {
                this.writer.println("interpreter commands:");
                this.writer.println(Strings.format(this.matcher.getHelpStrings(" ", "\t  ")));
                return true;
            }
        }
        throw Debug.abort("unknown command ".concat(String.valueOf(n)));
    }

    public boolean exec(String[] stringArray) {
        block2: for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            StringBuffer stringBuffer = new StringBuffer();
            StringBuffer stringBuffer2 = new StringBuffer();
            try {
                BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
                while (true) {
                    String string2;
                    if ((string2 = bufferedReader.readLine()) == null || string2.trim().startsWith(":")) {
                        String string3 = stringBuffer2.toString();
                        if (string3.trim().length() > 0) {
                            this.eval(string, string3);
                        }
                        if (string2 == null) continue block2;
                        if (!this.exec(string2.trim())) {
                            return false;
                        }
                        stringBuffer.append('\n');
                        stringBuffer2.setLength(0);
                        stringBuffer2.append(stringBuffer);
                        continue;
                    }
                    stringBuffer.append('\n');
                    stringBuffer2.append(string2).append('\n');
                }
            }
            catch (IOException iOException) {
                this.error(iOException.getMessage());
            }
        }
        return true;
    }

    public void call(String string, String[] stringArray) {
        this.show(this.interpreter.invoke(string, stringArray), false);
    }

    public void load(String string) {
        this.show(this.interpreter.interpret(string, false), false);
    }

    public void load(String[] stringArray) {
        this.show(this.interpreter.interpret(stringArray, false), false);
    }

    public void eval(String string) {
        this.show(this.interpreter.interpret(string, true), true);
    }

    public void eval(String string, String string2) {
        this.show(this.interpreter.interpret(string, string2, true), true);
    }

    public void eval(String[] stringArray) {
        this.show(this.interpreter.interpret(stringArray, true), true);
    }

    public void show(EvaluatorResult evaluatorResult, boolean bl) {
        this.printer.showResult(evaluatorResult, bl);
    }

    private PrefixMatcher matcher() {
        PrefixMatcher prefixMatcher = new PrefixMatcher();
        prefixMatcher.insert(":quit", new Integer(0), "Quit interpreter");
        prefixMatcher.insert(":load", new Integer(1), "<files>", "Load files (or repeat last load if no files are given)");
        prefixMatcher.insert(":use", new Integer(2), "<files>", "Use files (or repeat last use if no files are given)");
        prefixMatcher.insert(":gc", new Integer(3), "Run garbage collector");
        prefixMatcher.insert(":memory", new Integer(4), "Print out memory usage");
        prefixMatcher.insert(":help", new Integer(6), "Print out this command summary");
        prefixMatcher.insert(":version", new Integer(5), "Print out product version");
        prefixMatcher.insert(":?", new Integer(6), "Same as :help");
        return prefixMatcher;
    }

    private void error(String string) {
        this.writer.println("error: ".concat(String.valueOf(String.valueOf(string))));
    }

    private String[] readArguments(String string) throws IOException {
        return this.readArguments(new PushbackReader(new StringReader(string)));
    }

    private String[] readArguments(PushbackReader pushbackReader) throws IOException {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n;
        while ((n = pushbackReader.read()) != -1) {
            if (Character.isWhitespace((char)n)) continue;
            pushbackReader.unread(n);
            arrayList.add(this.readArgument(pushbackReader));
        }
        return arrayList.toArray(new String[0]);
    }

    private String readArgument(PushbackReader pushbackReader) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        while (true) {
            int n = this.read(pushbackReader, stringBuffer2);
            switch (n) {
                case 34: {
                    stringBuffer.append(this.readString(pushbackReader, stringBuffer2));
                    break;
                }
                case 92: {
                    stringBuffer.append(this.readBackslashed(pushbackReader, stringBuffer2));
                    break;
                }
                default: {
                    if (!Character.isWhitespace((char)n)) {
                        stringBuffer.append((char)n);
                        break;
                    }
                    pushbackReader.unread(n);
                }
                case -1: {
                    return stringBuffer.toString();
                }
            }
            stringBuffer2.delete(0, stringBuffer2.length());
        }
    }

    private String readBackslashed(PushbackReader pushbackReader, StringBuffer stringBuffer) throws IOException {
        int n = this.read(pushbackReader, stringBuffer);
        switch (n) {
            case 32: {
                return " ";
            }
            case 34: {
                return "\"";
            }
            case 92: {
                return "\\";
            }
        }
        return stringBuffer.toString();
    }

    private String readString(PushbackReader pushbackReader, StringBuffer stringBuffer) throws IOException {
        StringBuffer stringBuffer2 = new StringBuffer();
        StringBuffer stringBuffer3 = new StringBuffer();
        while (true) {
            int n = this.read(pushbackReader, stringBuffer3, String.valueOf(String.valueOf("unterminated string '".concat(String.valueOf(String.valueOf(stringBuffer))))).concat("'"));
            switch (n) {
                case 34: {
                    stringBuffer.append((char)n);
                    return stringBuffer2.toString();
                }
                case 92: {
                    stringBuffer2.append(this.readEscape(pushbackReader, stringBuffer3));
                    break;
                }
                default: {
                    stringBuffer2.append((char)n);
                }
            }
            stringBuffer.append(stringBuffer3.toString());
            stringBuffer3.delete(0, stringBuffer3.length());
        }
    }

    private char readEscape(PushbackReader pushbackReader, StringBuffer stringBuffer) throws IOException {
        int n = this.read(pushbackReader, stringBuffer, String.valueOf(String.valueOf("unterminated escape sequence '".concat(String.valueOf(String.valueOf(stringBuffer))))).concat("'"));
        switch (n) {
            case 98: {
                return '\b';
            }
            case 116: {
                return '\t';
            }
            case 110: {
                return '\n';
            }
            case 102: {
                return '\f';
            }
            case 114: {
                return '\r';
            }
            case 34: {
                return '\"';
            }
            case 39: {
                return '\'';
            }
            case 92: {
                return '\\';
            }
            case 117: {
                return this.readUnicode(pushbackReader, stringBuffer);
            }
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: {
                return this.readOctal(pushbackReader, stringBuffer, n);
            }
        }
        throw new IOException(String.valueOf(String.valueOf("illegal escape sequence '".concat(String.valueOf(String.valueOf(stringBuffer))))).concat("'"));
    }

    private char readUnicode(PushbackReader pushbackReader, StringBuffer stringBuffer) throws IOException {
        int n = 0;
        boolean bl = false;
        block5: for (int i = 0; i < 4; ++i) {
            int n2 = this.read(pushbackReader, stringBuffer, String.valueOf(String.valueOf("unterminated Unicode escape sequence '".concat(String.valueOf(String.valueOf(stringBuffer))))).concat("'"));
            switch (n2) {
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: {
                    n = (n << 4) + (n2 - 48);
                    continue block5;
                }
                case 65: 
                case 66: 
                case 67: 
                case 68: 
                case 69: 
                case 70: {
                    n = (n << 4) + (n2 - 65 + 10);
                    continue block5;
                }
                case 97: 
                case 98: 
                case 99: 
                case 100: 
                case 101: 
                case 102: {
                    n = (n << 4) + (n2 - 97 + 10);
                    continue block5;
                }
                default: {
                    bl = true;
                }
            }
        }
        if (bl) {
            throw new IOException(String.valueOf(String.valueOf("illegal Unicode escape sequence '".concat(String.valueOf(String.valueOf(stringBuffer))))).concat("'"));
        }
        return (char)n;
    }

    private char readOctal(PushbackReader pushbackReader, StringBuffer stringBuffer, int n) throws IOException {
        int n2 = n - 48;
        while (n2 < 32) {
            int n3 = this.read(pushbackReader, stringBuffer);
            if (n3 < 48 || 55 < n3) {
                pushbackReader.unread(n3);
                break;
            }
            n2 = (n2 << 3) + (n3 - 48);
        }
        return (char)n2;
    }

    private int read(PushbackReader pushbackReader, StringBuffer stringBuffer, String string) throws IOException {
        int n = this.read(pushbackReader, stringBuffer);
        if (n == -1) {
            throw new IOException(string);
        }
        return (char)n;
    }

    private int read(PushbackReader pushbackReader, StringBuffer stringBuffer) throws IOException {
        int n = pushbackReader.read();
        if (n != -1) {
            stringBuffer.append((char)n);
        }
        return n;
    }
}

