/*
 * Decompiled with CFR 0.152.
 */
package scala.tools.scalai;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;

public class EvaluatorException
extends RuntimeException {
    private final List stack = new ArrayList();
    private Throwable cause;
    private StackTraceElement[] trace;
    private int entry;

    public void reset(Throwable throwable) {
        this.stack.clear();
        this.cause = throwable;
        this.trace = throwable.getStackTrace();
        this.entry = 0;
    }

    public Throwable getCause() {
        return this.cause;
    }

    public void addScalaCall(String string) {
        this.stack.add(string);
    }

    public void addScalaEntryPoint() {
        this.trace = this.getCurrentTrace();
        while (this.traceAtStartsWith(this.entry, "scalai.")) {
            ++this.entry;
        }
        while (this.traceAtStartsWith(this.entry, "$Proxy")) {
            ++this.entry;
        }
    }

    public void addScalaLeavePoint(String string, String string2) {
        int n;
        for (n = this.entry; n < this.trace.length && !this.traceAtEquals(n, string, string2); ++n) {
        }
        if (n < this.trace.length) {
            while (this.traceAtStartsWith(n - 1, "java.lang.reflect.")) {
                --n;
            }
            while (this.traceAtStartsWith(n - 1, "sun.reflect.")) {
                --n;
            }
        }
        for (int i = this.entry; i < n; ++i) {
            this.stack.add(this.trace[i]);
        }
        if (n == this.trace.length) {
            this.stack.add("...");
        }
        this.trace = null;
        this.entry = 0;
    }

    public Object[] getScalaStackTrace() {
        return this.stack.toArray();
    }

    public String getScalaErrorMessage(boolean bl) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        Throwable throwable = this.getCause();
        printWriter.print(throwable.toString());
        if (bl) {
            printWriter.println();
            for (int i = 0; i < this.stack.size(); ++i) {
                printWriter.print("        at ");
                printWriter.println(this.stack.get(i));
            }
            Throwable throwable2 = throwable.getCause();
            if (throwable2 != null) {
                printWriter.print("Caused by ");
                throwable2.printStackTrace(printWriter);
            }
        }
        printWriter.close();
        return stringWriter.toString();
    }

    private boolean traceAtEquals(int n, String string, String string2) {
        if (n < 0 || this.trace.length <= n) {
            return false;
        }
        if (!this.trace[n].getClassName().equals(string)) {
            return false;
        }
        return string2 == null || this.trace[n].getMethodName().equals(string2);
    }

    private boolean traceAtStartsWith(int n, String string) {
        if (n < 0 || this.trace.length <= n) {
            return false;
        }
        return this.trace[n].getClassName().startsWith(string);
    }

    private StackTraceElement[] getCurrentTrace() {
        return new RuntimeException().getStackTrace();
    }
}

