/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.lamp.fjbg;

import ch.epfl.lamp.fjbg.FJBGContext;
import ch.epfl.lamp.fjbg.JAttribute;
import ch.epfl.lamp.fjbg.JClass;
import ch.epfl.lamp.fjbg.JCode;
import ch.epfl.lamp.fjbg.JConstantPool;
import ch.epfl.lamp.fjbg.JType;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;

public abstract class JFieldOrMethod {
    protected boolean frozen = false;
    protected final FJBGContext context;
    protected final JClass owner;
    protected final int accessFlags;
    protected final String name;
    protected final JType type;
    protected final int nameIndex;
    protected final int signatureIndex;
    protected final List attributes;
    static final /* synthetic */ boolean $assertionsDisabled;

    protected JFieldOrMethod(FJBGContext context, JClass owner, int accessFlags, String name, JType type) {
        this.context = context;
        this.owner = owner;
        this.accessFlags = accessFlags;
        this.name = name;
        this.type = type;
        this.attributes = new LinkedList();
        JConstantPool pool = owner.getConstantPool();
        this.nameIndex = pool.addUtf8(name);
        this.signatureIndex = pool.addUtf8(type.getSignature());
    }

    protected JFieldOrMethod(FJBGContext context, JClass owner, DataInputStream stream) throws IOException {
        this.context = context;
        this.owner = owner;
        this.accessFlags = stream.readShort();
        this.nameIndex = stream.readShort();
        this.name = owner.pool.lookupUtf8(this.nameIndex);
        this.signatureIndex = stream.readShort();
        this.type = JType.parseSignature(owner.pool.lookupUtf8(this.signatureIndex));
        this.attributes = JAttribute.readFrom(context, owner, this, stream);
    }

    public void freeze() throws JCode.OffsetTooBigException {
        if (!$assertionsDisabled && this.frozen) {
            throw new AssertionError();
        }
        this.frozen = true;
    }

    public JClass getOwner() {
        return this.owner;
    }

    public String getName() {
        return this.name;
    }

    public JType getType() {
        return this.type;
    }

    public int getAccessFlags() {
        return this.accessFlags;
    }

    public boolean isPublic() {
        return (this.accessFlags & 1) != 0;
    }

    public boolean isPrivate() {
        return (this.accessFlags & 2) != 0;
    }

    public boolean isProtected() {
        return (this.accessFlags & 4) != 0;
    }

    public boolean isStatic() {
        return (this.accessFlags & 8) != 0;
    }

    public boolean isFinal() {
        return (this.accessFlags & 0x10) != 0;
    }

    public boolean isSuper() {
        return (this.accessFlags & 0x20) != 0;
    }

    public boolean isVolatile() {
        return (this.accessFlags & 0x40) != 0;
    }

    public boolean isTransient() {
        return (this.accessFlags & 0x80) != 0;
    }

    public boolean isNative() {
        return (this.accessFlags & 0x100) != 0;
    }

    public boolean isInterface() {
        return (this.accessFlags & 0x200) != 0;
    }

    public boolean isAbstract() {
        return (this.accessFlags & 0x400) != 0;
    }

    public boolean isStrict() {
        return (this.accessFlags & 0x800) != 0;
    }

    public void addAttribute(JAttribute attr) {
        if (!$assertionsDisabled && this.frozen) {
            throw new AssertionError();
        }
        this.attributes.add(attr);
    }

    public List getAttributes() {
        return this.attributes;
    }

    public void writeTo(DataOutputStream stream) throws IOException {
        if (!this.frozen) {
            try {
                this.freeze();
            }
            catch (JCode.OffsetTooBigException e) {
                throw new Error(e);
            }
        }
        stream.writeShort(this.accessFlags);
        stream.writeShort(this.nameIndex);
        stream.writeShort(this.signatureIndex);
        JAttribute.writeTo(this.getAttributes(), stream);
    }

    static {
        $assertionsDisabled = !JFieldOrMethod.class.desiredAssertionStatus();
    }
}

