/*
 * Decompiled with CFR 0.152.
 */
package com.zerog.ia.download.downloaders;

import com.zerog.ia.download.WebInstallerApplet;
import com.zerog.ia.download.downloaders.FileDownloader;
import com.zerog.ia.download.downloaders.macexecutils.MacFileRunner;
import com.zerog.ia.download.downloaders.macosx.ExecuteMacOSXInstaller;
import com.zerog.ia.download.outputListeners.ExecutorListener;
import com.zerog.ia.download.utility.Gestalt;
import java.io.File;
import java.util.Vector;
import netscape.security.PrivilegeManager;

public class FileExecutor {
    Vector executorListenerList = new Vector(2, 1);
    FileDownloader download;
    File fileToExecute;

    public FileExecutor(File file, FileDownloader fileDownloader) {
        this.fileToExecute = file;
        this.download = fileDownloader;
    }

    public void start() throws Exception {
        Object object;
        try {
            this.download.notifyOutputDiagnosticMessage("execute: Trying to run " + this.fileToExecute.toString());
            if (Gestalt.isNetscapeSecurityModelAvailable()) {
                PrivilegeManager.enablePrivilege((String)Gestalt.NETSCAPE_EXEC_ACCESS);
            }
            if (Gestalt.getPlatform() == Gestalt.WINDOWS_PLATFORM) {
                Runtime.getRuntime().exec(this.fileToExecute.getPath());
            } else if (Gestalt.getPlatform() == Gestalt.MAC_OS_PLATFORM) {
                object = new MacFileRunner(this.fileToExecute, this.download);
                ((MacFileRunner)object).runMacFile();
            } else if (Gestalt.getPlatform() == Gestalt.MAC_OS_X_PLATFORM) {
                ExecuteMacOSXInstaller.execute(this.fileToExecute);
            } else if (((WebInstallerApplet)this.download.getContext()).getPlatforms().getRunningOnPlatform().isUnix) {
                Runtime.getRuntime().exec("chmod 777 " + this.fileToExecute.getPath());
                Runtime.getRuntime().exec("sh " + this.fileToExecute.getPath());
            }
        }
        catch (Exception exception) {
            this.download.notifySetFriendlyErrorMessage("File '" + this.fileToExecute.toString() + "' could not be run.  You may still run the installer yourself outside of the browser by executing the file directly at the aforementioned location.");
            throw exception;
        }
        object = this.executorListenerList.elements();
        while (object.hasMoreElements()) {
            ((ExecutorListener)object.nextElement()).startingExecution();
        }
    }

    public void addExecutorListener(ExecutorListener executorListener) {
        this.executorListenerList.addElement(executorListener);
    }

    public boolean removeExecutorListener(ExecutorListener executorListener) {
        return this.executorListenerList.removeElement(executorListener);
    }
}

