/*
 * Decompiled with CFR 0.152.
 */
package scala.tools.nsc.classpath;

import java.io.Serializable;
import java.net.URI;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.ProviderNotFoundException;
import java.util.Collections;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.StrictOptimizedSeqOps;
import scala.collection.immutable.$colon$colon;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.internal.JDK9Reflectors;
import scala.runtime.Nothing$;
import scala.tools.nsc.CloseableRegistry;
import scala.tools.nsc.classpath.CtSymClassPath;
import scala.tools.nsc.classpath.FileBasedCache;
import scala.tools.nsc.classpath.FilteringJrtClassPath;
import scala.tools.nsc.classpath.JrtClassPath;
import scala.tools.nsc.util.ClassPath;
import scala.util.Properties$;
import scala.util.PropertiesTrait;
import scala.util.control.NonFatal$;

public final class JrtClassPath$ {
    public static final JrtClassPath$ MODULE$ = new JrtClassPath$();
    private static final FileBasedCache<Option<String>, JrtClassPath> jrtClassPathCache = new FileBasedCache();
    private static final FileBasedCache<String, CtSymClassPath> ctSymClassPathCache = new FileBasedCache();

    private FileBasedCache<Option<String>, JrtClassPath> jrtClassPathCache() {
        return jrtClassPathCache;
    }

    private FileBasedCache<String, CtSymClassPath> ctSymClassPathCache() {
        return ctSymClassPathCache;
    }

    /*
     * WARNING - void declaration
     */
    public List<ClassPath> apply(Option<String> release, Option<String> systemPath, Option<List<String>> unsafe, CloseableRegistry closeableRegistry) {
        String version;
        if (!PropertiesTrait.isJavaAtLeast$((PropertiesTrait)Properties$.MODULE$, "9")) {
            return Nil$.MODULE$;
        }
        int currentMajorVersion = JDK9Reflectors.runtimeVersionMajor(JDK9Reflectors.runtimeVersion());
        if (release instanceof Some && Integer.parseInt(version = (String)((Some)release).value()) < currentMajorVersion) {
            List pkgs;
            List<ClassPath> ct = this.createCt(version, closeableRegistry);
            if (unsafe instanceof Some && (pkgs = (List)((Some)unsafe).value()).nonEmpty()) {
                void appended_elem;
                List<JrtClassPath> list = this.createJrt(systemPath, closeableRegistry);
                if (((Object)Nil$.MODULE$).equals(list)) {
                    return ct;
                }
                FilteringJrtClassPath filteringJrtClassPath = new FilteringJrtClassPath((JrtClassPath)list.head(), pkgs);
                if (ct == null) {
                    throw null;
                }
                return (List)StrictOptimizedSeqOps.appended$(ct, (Object)appended_elem);
            }
            return ct;
        }
        return this.createJrt(systemPath, closeableRegistry);
    }

    private List<ClassPath> createCt(String v, CloseableRegistry closeableRegistry) {
        Nil$ nil$;
        try {
            Path ctSym = Paths.get(PropertiesTrait.javaHome$(Properties$.MODULE$), new String[0]).resolve("lib").resolve("ct.sym");
            if (!Files.notExists(ctSym, new LinkOption[0])) {
                Nil$ $colon$colon_this = Nil$.MODULE$;
                Object var6_4 = null;
                CtSymClassPath classPath = this.ctSymClassPathCache().getOrCreate(v, new $colon$colon<Nothing$>((Nothing$)((Object)ctSym), $colon$colon_this), (Function0<CtSymClassPath> & Serializable)() -> new CtSymClassPath(ctSym, Integer.parseInt(v)), closeableRegistry, true);
                return new $colon$colon<Nothing$>((Nothing$)((Object)classPath), Nil$.MODULE$);
            }
            nil$ = Nil$.MODULE$;
        }
        catch (Throwable throwable) {
            if (throwable != null && !NonFatal$.MODULE$.unapply(throwable).isEmpty()) {
                return Nil$.MODULE$;
            }
            throw throwable;
        }
        return nil$;
    }

    private List<JrtClassPath> createJrt(Option<String> systemPath, CloseableRegistry closeableRegistry) {
        try {
            JrtClassPath classPath = this.jrtClassPathCache().getOrCreate(systemPath, Nil$.MODULE$, (Function0<JrtClassPath> & Serializable)() -> {
                FileSystem fileSystem;
                if (systemPath instanceof Some) {
                    String javaHome = (String)((Some)systemPath).value();
                    fileSystem = FileSystems.newFileSystem(URI.create("jrt:/"), Collections.singletonMap("java.home", javaHome));
                } else if (None$.MODULE$.equals(systemPath)) {
                    fileSystem = FileSystems.getFileSystem(URI.create("jrt:/"));
                } else {
                    throw new MatchError(systemPath);
                }
                FileSystem fs = fileSystem;
                return new JrtClassPath(fs, systemPath.isDefined());
            }, closeableRegistry, false);
            return new $colon$colon<Nothing$>((Nothing$)((Object)classPath), Nil$.MODULE$);
        }
        catch (Throwable throwable) {
            if (throwable instanceof ProviderNotFoundException ? true : throwable instanceof FileSystemNotFoundException) {
                return Nil$.MODULE$;
            }
            throw throwable;
        }
    }

    private JrtClassPath$() {
    }
}

